-- Create the location weighted version of the annual results by summing the results of the previous table,
--  Add the results to the measure impacts table.
SET search_path TO "MC_results_database";
DELETE FROM meas_impacts_wtd WHERE "BldgType" = 'Res';
INSERT INTO meas_impacts_wtd
SELECT
"EnergyImpactID",
'DEER2020'::VARCHAR as "Version",
'D20v0'::VARCHAR as "VersionSource",
date_trunc('second', now()) as "LastMod",
"PA",
'Res'::VARCHAR as "BldgType",
"BldgVint",
"BldgLoc",
"BldgHVAC",
"NormUnit",
(Sum("NumUnit") / Sum(wt_bldg))::numeric(15,1) AS "NumUnit",
(Sum("MeasArea") / Sum(wt_bldg))::numeric(15,0) AS "MeasArea",
"ScaleBasis",
(Sum("APreWBkWh") / Sum(wt_bldg))::numeric(15,1) as "APreWBkWh",
(Sum("APreWBkW") / Sum(wt_bldg))::numeric(15,3) as "APreWBkW",
(Sum("APreWBtherm") / Sum(wt_bldg))::numeric(15,2) as "APreWBtherm",
(Sum("AStdWBkWh") / Sum(wt_bldg))::numeric(15,1) as "AStdWBkWh",
(Sum("AStdWBkW") / Sum(wt_bldg))::numeric(15,3) as "AStdWBkW",
(Sum("AStdWBtherm") / Sum(wt_bldg))::numeric(15,2) as "AStdWBtherm"
from meas_impacts_tmp3
GROUP BY
"EnergyImpactID",
"PA",
"BldgVint",
"BldgLoc",
"BldgHVAC",
"NormUnit",
"ScaleBasis"
ORDER BY 
"EnergyImpactID",
"PA",
"BldgVint",
"BldgHVAC";
/*
ALTER TABLE "meas_impacts_wtd"
ALTER COLUMN "EnergyImpactID" SET NOT NULL,
ALTER COLUMN "PA" SET NOT NULL,
ALTER COLUMN "BldgType" SET NOT NULL,
ALTER COLUMN "BldgVint" SET NOT NULL,
ALTER COLUMN "BldgLoc" SET NOT NULL,
ALTER COLUMN "BldgHVAC" SET NOT NULL,
ADD PRIMARY KEY ("EnergyImpactID", "PA", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC");
*/