-- Sum the vintage weight multiplied version of the annual results created in the previous step, 
--  Also, add the New vintage results from the measure impacts table as the final vintage.
--  Note: results from this query form the starting point for the final results table, to be augmented with 
--        additional results from subsequent queries.
SET search_path TO "MC_results_database";
DROP TABLE IF EXISTS meas_impacts_wtd;
CREATE TABLE meas_impacts_wtd AS 
SELECT
"EnergyImpactID",
'DEER2020'::VARCHAR as "Version",
'D20v0'::VARCHAR as "VersionSource",
date_trunc('second', now()) as "LastMod",
"PA",
"BldgType"::VARCHAR,
era as "BldgVint",
"BldgLoc"::VARCHAR,
"BldgHVAC"::VARCHAR,
"NormUnit",
(Sum("NumUnit") / Sum(wt_vint))::numeric(15,5) AS "NumUnit",
(Sum("MeasArea") / Sum(wt_vint))::numeric(15,1) AS "MeasArea",
'None'::VARCHAR as "ScaleBasis",
(Sum("APreWBkWh") / Sum(wt_vint))::numeric(15,5) as "APreWBkWh",
(Sum("APreWBkW") / Sum(wt_vint))::numeric(15,5) as "APreWBkW",
(Sum("APreWBtherm") / Sum(wt_vint))::numeric(15,5) as "APreWBtherm",
(Sum("AStdWBkWh") / Sum(wt_vint))::numeric(15,5) as "AStdWBkWh",
(Sum("AStdWBkW") / Sum(wt_vint))::numeric(15,5) as "AStdWBkW",
(Sum("AStdWBtherm") / Sum(wt_vint))::numeric(15,5) as "AStdWBtherm"
from meas_impacts_tmp
GROUP BY
"EnergyImpactID",
"PA",
"BldgType",
era,
"BldgLoc",
"BldgHVAC",
"NormUnit"

UNION
SELECT
"EnergyImpactID",
"Version",
"VersionSource",
"LastMod",
"PA",
meas_impacts."BldgType",
'New'::VARCHAR as "BldgVint",
meas_impacts."BldgLoc",
meas_impacts."BldgHVAC",
"NormUnit",
"NumUnit",
"MeasArea",
'None'::VARCHAR as "ScaleBasis",
"APreWBkWh",
"APreWBkW49" as "APreWBkW",
"APreWBtherm",
"AStdWBkWh",
"AStdWBkW49" as "AStdWBkW",
"AStdWBtherm"
FROM meas_impacts
WHERE meas_impacts."BldgVint" in ('2020','MH15')

ORDER BY 
"EnergyImpactID",
"PA",
"BldgType",
"BldgVint",
"BldgLoc",
"BldgHVAC";

ALTER TABLE "meas_impacts_wtd"
ALTER COLUMN "EnergyImpactID" SET NOT NULL,
ALTER COLUMN "PA" SET NOT NULL,
ALTER COLUMN "BldgType" SET NOT NULL,
ALTER COLUMN "BldgVint" SET NOT NULL,
ALTER COLUMN "BldgLoc" SET NOT NULL,
ALTER COLUMN "BldgHVAC" SET NOT NULL,
ADD PRIMARY KEY ("EnergyImpactID", "PA", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC");
