#plotly dash related imports
import dash
import dash_core_components as dcc
import dash_bootstrap_components as dbc
import dash_html_components as html
from dash.dependencies import Input, Output, State
import plotly.graph_objs as go
import plotly.offline as pyo
import pandas as pd

from dash_extensions import Download
from dash_extensions.snippets import send_data_frame

#loadshapes related imports
import sqlalchemy
import artemis.analysis.lopeshape as ls
import artemis.analysis.visualize_dash as vs


#connect to DEER db
engine = sqlalchemy.create_engine("postgresql://sptviewer:deereddev@cpucexante.cwuiixjcexyp.us-east-1.rds.amazonaws.com:5432/sg_test")
# SQL query to select the entire table "LoadShapeElec_2022"
query = '''
        SELECT "LoadShapeElecID", "TechID", "IsProposed", "StartDate", "ExpiryDate", "ClaimSpec", "FilingSpec", "LastModComment", "LastMod", "LastModBy", "Created", "CreatedComment", "CreatedBy", "Sector", "BldgType", "BldgLoc", "BldgVint", "BldgHVAC", "Version", "VersionSource", "kWMaxDayJanHr01", "kWAvgWkdayJanHr01", "kWAvgWkendJanHr01", "kWMaxDayJanHr02", "kWAvgWkdayJanHr02", "kWAvgWkendJanHr02", "kWMaxDayJanHr03", "kWAvgWkdayJanHr03", "kWAvgWkendJanHr03", "kWMaxDayJanHr04", "kWAvgWkdayJanHr04", "kWAvgWkendJanHr04", "kWMaxDayJanHr05", "kWAvgWkdayJanHr05", "kWAvgWkendJanHr05", "kWMaxDayJanHr06", "kWAvgWkdayJanHr06", "kWAvgWkendJanHr06", "kWMaxDayJanHr07", "kWAvgWkdayJanHr07", "kWAvgWkendJanHr07", "kWMaxDayJanHr08", "kWAvgWkdayJanHr08", "kWAvgWkendJanHr08", "kWMaxDayJanHr09", "kWAvgWkdayJanHr09", "kWAvgWkendJanHr09", "kWMaxDayJanHr10", "kWAvgWkdayJanHr10", "kWAvgWkendJanHr10", "kWMaxDayJanHr11", "kWAvgWkdayJanHr11", "kWAvgWkendJanHr11", "kWMaxDayJanHr12", "kWAvgWkdayJanHr12", "kWAvgWkendJanHr12", "kWMaxDayJanHr13", "kWAvgWkdayJanHr13", "kWAvgWkendJanHr13", "kWMaxDayJanHr14", "kWAvgWkdayJanHr14", "kWAvgWkendJanHr14", "kWMaxDayJanHr15", "kWAvgWkdayJanHr15", "kWAvgWkendJanHr15", "kWMaxDayJanHr16", "kWAvgWkdayJanHr16", "kWAvgWkendJanHr16", "kWMaxDayJanHr17", "kWAvgWkdayJanHr17", "kWAvgWkendJanHr17", "kWMaxDayJanHr18", "kWAvgWkdayJanHr18", "kWAvgWkendJanHr18", "kWMaxDayJanHr19", "kWAvgWkdayJanHr19", "kWAvgWkendJanHr19", "kWMaxDayJanHr20", "kWAvgWkdayJanHr20", "kWAvgWkendJanHr20", "kWMaxDayJanHr21", "kWAvgWkdayJanHr21", "kWAvgWkendJanHr21", "kWMaxDayJanHr22", "kWAvgWkdayJanHr22", "kWAvgWkendJanHr22", "kWMaxDayJanHr23", "kWAvgWkdayJanHr23", "kWAvgWkendJanHr23", "kWMaxDayJanHr24", "kWAvgWkdayJanHr24", "kWAvgWkendJanHr24", "kWMaxDayFebHr01", "kWAvgWkdayFebHr01", "kWAvgWkendFebHr01", "kWMaxDayFebHr02", "kWAvgWkdayFebHr02", "kWAvgWkendFebHr02", "kWMaxDayFebHr03", "kWAvgWkdayFebHr03", "kWAvgWkendFebHr03", "kWMaxDayFebHr04", "kWAvgWkdayFebHr04", "kWAvgWkendFebHr04", "kWMaxDayFebHr05", "kWAvgWkdayFebHr05", "kWAvgWkendFebHr05", "kWMaxDayFebHr06", "kWAvgWkdayFebHr06", "kWAvgWkendFebHr06", "kWMaxDayFebHr07", "kWAvgWkdayFebHr07", "kWAvgWkendFebHr07", "kWMaxDayFebHr08", "kWAvgWkdayFebHr08", "kWAvgWkendFebHr08", "kWMaxDayFebHr09", "kWAvgWkdayFebHr09", "kWAvgWkendFebHr09", "kWMaxDayFebHr10", "kWAvgWkdayFebHr10", "kWAvgWkendFebHr10", "kWMaxDayFebHr11", "kWAvgWkdayFebHr11", "kWAvgWkendFebHr11", "kWMaxDayFebHr12", "kWAvgWkdayFebHr12", "kWAvgWkendFebHr12", "kWMaxDayFebHr13", "kWAvgWkdayFebHr13", "kWAvgWkendFebHr13", "kWMaxDayFebHr14", "kWAvgWkdayFebHr14", "kWAvgWkendFebHr14", "kWMaxDayFebHr15", "kWAvgWkdayFebHr15", "kWAvgWkendFebHr15", "kWMaxDayFebHr16", "kWAvgWkdayFebHr16", "kWAvgWkendFebHr16", "kWMaxDayFebHr17", "kWAvgWkdayFebHr17", "kWAvgWkendFebHr17", "kWMaxDayFebHr18", "kWAvgWkdayFebHr18", "kWAvgWkendFebHr18", "kWMaxDayFebHr19", "kWAvgWkdayFebHr19", "kWAvgWkendFebHr19", "kWMaxDayFebHr20", "kWAvgWkdayFebHr20", "kWAvgWkendFebHr20", "kWMaxDayFebHr21", "kWAvgWkdayFebHr21", "kWAvgWkendFebHr21", "kWMaxDayFebHr22", "kWAvgWkdayFebHr22", "kWAvgWkendFebHr22", "kWMaxDayFebHr23", "kWAvgWkdayFebHr23", "kWAvgWkendFebHr23", "kWMaxDayFebHr24", "kWAvgWkdayFebHr24", "kWAvgWkendFebHr24", "kWMaxDayMarHr01", "kWAvgWkdayMarHr01", "kWAvgWkendMarHr01", "kWMaxDayMarHr02", "kWAvgWkdayMarHr02", "kWAvgWkendMarHr02", "kWMaxDayMarHr03", "kWAvgWkdayMarHr03", "kWAvgWkendMarHr03", "kWMaxDayMarHr04", "kWAvgWkdayMarHr04", "kWAvgWkendMarHr04", "kWMaxDayMarHr05", "kWAvgWkdayMarHr05", "kWAvgWkendMarHr05", "kWMaxDayMarHr06", "kWAvgWkdayMarHr06", "kWAvgWkendMarHr06", "kWMaxDayMarHr07", "kWAvgWkdayMarHr07", "kWAvgWkendMarHr07", "kWMaxDayMarHr08", "kWAvgWkdayMarHr08", "kWAvgWkendMarHr08", "kWMaxDayMarHr09", "kWAvgWkdayMarHr09", "kWAvgWkendMarHr09", "kWMaxDayMarHr10", "kWAvgWkdayMarHr10", "kWAvgWkendMarHr10", "kWMaxDayMarHr11", "kWAvgWkdayMarHr11", "kWAvgWkendMarHr11", "kWMaxDayMarHr12", "kWAvgWkdayMarHr12", "kWAvgWkendMarHr12", "kWMaxDayMarHr13", "kWAvgWkdayMarHr13", "kWAvgWkendMarHr13", "kWMaxDayMarHr14", "kWAvgWkdayMarHr14", "kWAvgWkendMarHr14", "kWMaxDayMarHr15", "kWAvgWkdayMarHr15", "kWAvgWkendMarHr15", "kWMaxDayMarHr16", "kWAvgWkdayMarHr16", "kWAvgWkendMarHr16", "kWMaxDayMarHr17", "kWAvgWkdayMarHr17", "kWAvgWkendMarHr17", "kWMaxDayMarHr18", "kWAvgWkdayMarHr18", "kWAvgWkendMarHr18", "kWMaxDayMarHr19", "kWAvgWkdayMarHr19", "kWAvgWkendMarHr19", "kWMaxDayMarHr20", "kWAvgWkdayMarHr20", "kWAvgWkendMarHr20", "kWMaxDayMarHr21", "kWAvgWkdayMarHr21", "kWAvgWkendMarHr21", "kWMaxDayMarHr22", "kWAvgWkdayMarHr22", "kWAvgWkendMarHr22", "kWMaxDayMarHr23", "kWAvgWkdayMarHr23", "kWAvgWkendMarHr23", "kWMaxDayMarHr24", "kWAvgWkdayMarHr24", "kWAvgWkendMarHr24", "kWMaxDayAprHr01", "kWAvgWkdayAprHr01", "kWAvgWkendAprHr01", "kWMaxDayAprHr02", "kWAvgWkdayAprHr02", "kWAvgWkendAprHr02", "kWMaxDayAprHr03", "kWAvgWkdayAprHr03", "kWAvgWkendAprHr03", "kWMaxDayAprHr04", "kWAvgWkdayAprHr04", "kWAvgWkendAprHr04", "kWMaxDayAprHr05", "kWAvgWkdayAprHr05", "kWAvgWkendAprHr05", "kWMaxDayAprHr06", "kWAvgWkdayAprHr06", "kWAvgWkendAprHr06", "kWMaxDayAprHr07", "kWAvgWkdayAprHr07", "kWAvgWkendAprHr07", "kWMaxDayAprHr08", "kWAvgWkdayAprHr08", "kWAvgWkendAprHr08", "kWMaxDayAprHr09", "kWAvgWkdayAprHr09", "kWAvgWkendAprHr09", "kWMaxDayAprHr10", "kWAvgWkdayAprHr10", "kWAvgWkendAprHr10", "kWMaxDayAprHr11", "kWAvgWkdayAprHr11", "kWAvgWkendAprHr11", "kWMaxDayAprHr12", "kWAvgWkdayAprHr12", "kWAvgWkendAprHr12", "kWMaxDayAprHr13", "kWAvgWkdayAprHr13", "kWAvgWkendAprHr13", "kWMaxDayAprHr14", "kWAvgWkdayAprHr14", "kWAvgWkendAprHr14", "kWMaxDayAprHr15", "kWAvgWkdayAprHr15", "kWAvgWkendAprHr15", "kWMaxDayAprHr16", "kWAvgWkdayAprHr16", "kWAvgWkendAprHr16", "kWMaxDayAprHr17", "kWAvgWkdayAprHr17", "kWAvgWkendAprHr17", "kWMaxDayAprHr18", "kWAvgWkdayAprHr18", "kWAvgWkendAprHr18", "kWMaxDayAprHr19", "kWAvgWkdayAprHr19", "kWAvgWkendAprHr19", "kWMaxDayAprHr20", "kWAvgWkdayAprHr20", "kWAvgWkendAprHr20", "kWMaxDayAprHr21", "kWAvgWkdayAprHr21", "kWAvgWkendAprHr21", "kWMaxDayAprHr22", "kWAvgWkdayAprHr22", "kWAvgWkendAprHr22", "kWMaxDayAprHr23", "kWAvgWkdayAprHr23", "kWAvgWkendAprHr23", "kWMaxDayAprHr24", "kWAvgWkdayAprHr24", "kWAvgWkendAprHr24", "kWMaxDayMayHr01", "kWAvgWkdayMayHr01", "kWAvgWkendMayHr01", "kWMaxDayMayHr02", "kWAvgWkdayMayHr02", "kWAvgWkendMayHr02", "kWMaxDayMayHr03", "kWAvgWkdayMayHr03", "kWAvgWkendMayHr03", "kWMaxDayMayHr04", "kWAvgWkdayMayHr04", "kWAvgWkendMayHr04", "kWMaxDayMayHr05", "kWAvgWkdayMayHr05", "kWAvgWkendMayHr05", "kWMaxDayMayHr06", "kWAvgWkdayMayHr06", "kWAvgWkendMayHr06", "kWMaxDayMayHr07", "kWAvgWkdayMayHr07", "kWAvgWkendMayHr07", "kWMaxDayMayHr08", "kWAvgWkdayMayHr08", "kWAvgWkendMayHr08", "kWMaxDayMayHr09", "kWAvgWkdayMayHr09", "kWAvgWkendMayHr09", "kWMaxDayMayHr10", "kWAvgWkdayMayHr10", "kWAvgWkendMayHr10", "kWMaxDayMayHr11", "kWAvgWkdayMayHr11", "kWAvgWkendMayHr11", "kWMaxDayMayHr12", "kWAvgWkdayMayHr12", "kWAvgWkendMayHr12", "kWMaxDayMayHr13", "kWAvgWkdayMayHr13", "kWAvgWkendMayHr13", "kWMaxDayMayHr14", "kWAvgWkdayMayHr14", "kWAvgWkendMayHr14", "kWMaxDayMayHr15", "kWAvgWkdayMayHr15", "kWAvgWkendMayHr15", "kWMaxDayMayHr16", "kWAvgWkdayMayHr16", "kWAvgWkendMayHr16", "kWMaxDayMayHr17", "kWAvgWkdayMayHr17", "kWAvgWkendMayHr17", "kWMaxDayMayHr18", "kWAvgWkdayMayHr18", "kWAvgWkendMayHr18", "kWMaxDayMayHr19", "kWAvgWkdayMayHr19", "kWAvgWkendMayHr19", "kWMaxDayMayHr20", "kWAvgWkdayMayHr20", "kWAvgWkendMayHr20", "kWMaxDayMayHr21", "kWAvgWkdayMayHr21", "kWAvgWkendMayHr21", "kWMaxDayMayHr22", "kWAvgWkdayMayHr22", "kWAvgWkendMayHr22", "kWMaxDayMayHr23", "kWAvgWkdayMayHr23", "kWAvgWkendMayHr23", "kWMaxDayMayHr24", "kWAvgWkdayMayHr24", "kWAvgWkendMayHr24", "kWMaxDayJunHr01", "kWAvgWkdayJunHr01", "kWAvgWkendJunHr01", "kWMaxDayJunHr02", "kWAvgWkdayJunHr02", "kWAvgWkendJunHr02", "kWMaxDayJunHr03", "kWAvgWkdayJunHr03", "kWAvgWkendJunHr03", "kWMaxDayJunHr04", "kWAvgWkdayJunHr04", "kWAvgWkendJunHr04", "kWMaxDayJunHr05", "kWAvgWkdayJunHr05", "kWAvgWkendJunHr05", "kWMaxDayJunHr06", "kWAvgWkdayJunHr06", "kWAvgWkendJunHr06", "kWMaxDayJunHr07", "kWAvgWkdayJunHr07", "kWAvgWkendJunHr07", "kWMaxDayJunHr08", "kWAvgWkdayJunHr08", "kWAvgWkendJunHr08", "kWMaxDayJunHr09", "kWAvgWkdayJunHr09", "kWAvgWkendJunHr09", "kWMaxDayJunHr10", "kWAvgWkdayJunHr10", "kWAvgWkendJunHr10", "kWMaxDayJunHr11", "kWAvgWkdayJunHr11", "kWAvgWkendJunHr11", "kWMaxDayJunHr12", "kWAvgWkdayJunHr12", "kWAvgWkendJunHr12", "kWMaxDayJunHr13", "kWAvgWkdayJunHr13", "kWAvgWkendJunHr13", "kWMaxDayJunHr14", "kWAvgWkdayJunHr14", "kWAvgWkendJunHr14", "kWMaxDayJunHr15", "kWAvgWkdayJunHr15", "kWAvgWkendJunHr15", "kWMaxDayJunHr16", "kWAvgWkdayJunHr16", "kWAvgWkendJunHr16", "kWMaxDayJunHr17", "kWAvgWkdayJunHr17", "kWAvgWkendJunHr17", "kWMaxDayJunHr18", "kWAvgWkdayJunHr18", "kWAvgWkendJunHr18", "kWMaxDayJunHr19", "kWAvgWkdayJunHr19", "kWAvgWkendJunHr19", "kWMaxDayJunHr20", "kWAvgWkdayJunHr20", "kWAvgWkendJunHr20", "kWMaxDayJunHr21", "kWAvgWkdayJunHr21", "kWAvgWkendJunHr21", "kWMaxDayJunHr22", "kWAvgWkdayJunHr22", "kWAvgWkendJunHr22", "kWMaxDayJunHr23", "kWAvgWkdayJunHr23", "kWAvgWkendJunHr23", "kWMaxDayJunHr24", "kWAvgWkdayJunHr24", "kWAvgWkendJunHr24", "kWMaxDayJulHr01", "kWAvgWkdayJulHr01", "kWAvgWkendJulHr01", "kWMaxDayJulHr02", "kWAvgWkdayJulHr02", "kWAvgWkendJulHr02", "kWMaxDayJulHr03", "kWAvgWkdayJulHr03", "kWAvgWkendJulHr03", "kWMaxDayJulHr04", "kWAvgWkdayJulHr04", "kWAvgWkendJulHr04", "kWMaxDayJulHr05", "kWAvgWkdayJulHr05", "kWAvgWkendJulHr05", "kWMaxDayJulHr06", "kWAvgWkdayJulHr06", "kWAvgWkendJulHr06", "kWMaxDayJulHr07", "kWAvgWkdayJulHr07", "kWAvgWkendJulHr07", "kWMaxDayJulHr08", "kWAvgWkdayJulHr08", "kWAvgWkendJulHr08", "kWMaxDayJulHr09", "kWAvgWkdayJulHr09", "kWAvgWkendJulHr09", "kWMaxDayJulHr10", "kWAvgWkdayJulHr10", "kWAvgWkendJulHr10", "kWMaxDayJulHr11", "kWAvgWkdayJulHr11", "kWAvgWkendJulHr11", "kWMaxDayJulHr12", "kWAvgWkdayJulHr12", "kWAvgWkendJulHr12", "kWMaxDayJulHr13", "kWAvgWkdayJulHr13", "kWAvgWkendJulHr13", "kWMaxDayJulHr14", "kWAvgWkdayJulHr14", "kWAvgWkendJulHr14", "kWMaxDayJulHr15", "kWAvgWkdayJulHr15", "kWAvgWkendJulHr15", "kWMaxDayJulHr16", "kWAvgWkdayJulHr16", "kWAvgWkendJulHr16", "kWMaxDayJulHr17", "kWAvgWkdayJulHr17", "kWAvgWkendJulHr17", "kWMaxDayJulHr18", "kWAvgWkdayJulHr18", "kWAvgWkendJulHr18", "kWMaxDayJulHr19", "kWAvgWkdayJulHr19", "kWAvgWkendJulHr19", "kWMaxDayJulHr20", "kWAvgWkdayJulHr20", "kWAvgWkendJulHr20", "kWMaxDayJulHr21", "kWAvgWkdayJulHr21", "kWAvgWkendJulHr21", "kWMaxDayJulHr22", "kWAvgWkdayJulHr22", "kWAvgWkendJulHr22", "kWMaxDayJulHr23", "kWAvgWkdayJulHr23", "kWAvgWkendJulHr23", "kWMaxDayJulHr24", "kWAvgWkdayJulHr24", "kWAvgWkendJulHr24", "kWMaxDayAugHr01", "kWAvgWkdayAugHr01", "kWAvgWkendAugHr01", "kWMaxDayAugHr02", "kWAvgWkdayAugHr02", "kWAvgWkendAugHr02", "kWMaxDayAugHr03", "kWAvgWkdayAugHr03", "kWAvgWkendAugHr03", "kWMaxDayAugHr04", "kWAvgWkdayAugHr04", "kWAvgWkendAugHr04", "kWMaxDayAugHr05", "kWAvgWkdayAugHr05", "kWAvgWkendAugHr05", "kWMaxDayAugHr06", "kWAvgWkdayAugHr06", "kWAvgWkendAugHr06", "kWMaxDayAugHr07", "kWAvgWkdayAugHr07", "kWAvgWkendAugHr07", "kWMaxDayAugHr08", "kWAvgWkdayAugHr08", "kWAvgWkendAugHr08", "kWMaxDayAugHr09", "kWAvgWkdayAugHr09", "kWAvgWkendAugHr09", "kWMaxDayAugHr10", "kWAvgWkdayAugHr10", "kWAvgWkendAugHr10", "kWMaxDayAugHr11", "kWAvgWkdayAugHr11", "kWAvgWkendAugHr11", "kWMaxDayAugHr12", "kWAvgWkdayAugHr12", "kWAvgWkendAugHr12", "kWMaxDayAugHr13", "kWAvgWkdayAugHr13", "kWAvgWkendAugHr13", "kWMaxDayAugHr14", "kWAvgWkdayAugHr14", "kWAvgWkendAugHr14", "kWMaxDayAugHr15", "kWAvgWkdayAugHr15", "kWAvgWkendAugHr15", "kWMaxDayAugHr16", "kWAvgWkdayAugHr16", "kWAvgWkendAugHr16", "kWMaxDayAugHr17", "kWAvgWkdayAugHr17", "kWAvgWkendAugHr17", "kWMaxDayAugHr18", "kWAvgWkdayAugHr18", "kWAvgWkendAugHr18", "kWMaxDayAugHr19", "kWAvgWkdayAugHr19", "kWAvgWkendAugHr19", "kWMaxDayAugHr20", "kWAvgWkdayAugHr20", "kWAvgWkendAugHr20", "kWMaxDayAugHr21", "kWAvgWkdayAugHr21", "kWAvgWkendAugHr21", "kWMaxDayAugHr22", "kWAvgWkdayAugHr22", "kWAvgWkendAugHr22", "kWMaxDayAugHr23", "kWAvgWkdayAugHr23", "kWAvgWkendAugHr23", "kWMaxDayAugHr24", "kWAvgWkdayAugHr24", "kWAvgWkendAugHr24", "kWMaxDaySepHr01", "kWAvgWkdaySepHr01", "kWAvgWkendSepHr01", "kWMaxDaySepHr02", "kWAvgWkdaySepHr02", "kWAvgWkendSepHr02", "kWMaxDaySepHr03", "kWAvgWkdaySepHr03", "kWAvgWkendSepHr03", "kWMaxDaySepHr04", "kWAvgWkdaySepHr04", "kWAvgWkendSepHr04", "kWMaxDaySepHr05", "kWAvgWkdaySepHr05", "kWAvgWkendSepHr05", "kWMaxDaySepHr06", "kWAvgWkdaySepHr06", "kWAvgWkendSepHr06", "kWMaxDaySepHr07", "kWAvgWkdaySepHr07", "kWAvgWkendSepHr07", "kWMaxDaySepHr08", "kWAvgWkdaySepHr08", "kWAvgWkendSepHr08", "kWMaxDaySepHr09", "kWAvgWkdaySepHr09", "kWAvgWkendSepHr09", "kWMaxDaySepHr10", "kWAvgWkdaySepHr10", "kWAvgWkendSepHr10", "kWMaxDaySepHr11", "kWAvgWkdaySepHr11", "kWAvgWkendSepHr11", "kWMaxDaySepHr12", "kWAvgWkdaySepHr12", "kWAvgWkendSepHr12", "kWMaxDaySepHr13", "kWAvgWkdaySepHr13", "kWAvgWkendSepHr13", "kWMaxDaySepHr14", "kWAvgWkdaySepHr14", "kWAvgWkendSepHr14", "kWMaxDaySepHr15", "kWAvgWkdaySepHr15", "kWAvgWkendSepHr15", "kWMaxDaySepHr16", "kWAvgWkdaySepHr16", "kWAvgWkendSepHr16", "kWMaxDaySepHr17", "kWAvgWkdaySepHr17", "kWAvgWkendSepHr17", "kWMaxDaySepHr18", "kWAvgWkdaySepHr18", "kWAvgWkendSepHr18", "kWMaxDaySepHr19", "kWAvgWkdaySepHr19", "kWAvgWkendSepHr19", "kWMaxDaySepHr20", "kWAvgWkdaySepHr20", "kWAvgWkendSepHr20", "kWMaxDaySepHr21", "kWAvgWkdaySepHr21", "kWAvgWkendSepHr21", "kWMaxDaySepHr22", "kWAvgWkdaySepHr22", "kWAvgWkendSepHr22", "kWMaxDaySepHr23", "kWAvgWkdaySepHr23", "kWAvgWkendSepHr23", "kWMaxDaySepHr24", "kWAvgWkdaySepHr24", "kWAvgWkendSepHr24", "kWMaxDayOctHr01", "kWAvgWkdayOctHr01", "kWAvgWkendOctHr01", "kWMaxDayOctHr02", "kWAvgWkdayOctHr02", "kWAvgWkendOctHr02", "kWMaxDayOctHr03", "kWAvgWkdayOctHr03", "kWAvgWkendOctHr03", "kWMaxDayOctHr04", "kWAvgWkdayOctHr04", "kWAvgWkendOctHr04", "kWMaxDayOctHr05", "kWAvgWkdayOctHr05", "kWAvgWkendOctHr05", "kWMaxDayOctHr06", "kWAvgWkdayOctHr06", "kWAvgWkendOctHr06", "kWMaxDayOctHr07", "kWAvgWkdayOctHr07", "kWAvgWkendOctHr07", "kWMaxDayOctHr08", "kWAvgWkdayOctHr08", "kWAvgWkendOctHr08", "kWMaxDayOctHr09", "kWAvgWkdayOctHr09", "kWAvgWkendOctHr09", "kWMaxDayOctHr10", "kWAvgWkdayOctHr10", "kWAvgWkendOctHr10", "kWMaxDayOctHr11", "kWAvgWkdayOctHr11", "kWAvgWkendOctHr11", "kWMaxDayOctHr12", "kWAvgWkdayOctHr12", "kWAvgWkendOctHr12", "kWMaxDayOctHr13", "kWAvgWkdayOctHr13", "kWAvgWkendOctHr13", "kWMaxDayOctHr14", "kWAvgWkdayOctHr14", "kWAvgWkendOctHr14", "kWMaxDayOctHr15", "kWAvgWkdayOctHr15", "kWAvgWkendOctHr15", "kWMaxDayOctHr16", "kWAvgWkdayOctHr16", "kWAvgWkendOctHr16", "kWMaxDayOctHr17", "kWAvgWkdayOctHr17", "kWAvgWkendOctHr17", "kWMaxDayOctHr18", "kWAvgWkdayOctHr18", "kWAvgWkendOctHr18", "kWMaxDayOctHr19", "kWAvgWkdayOctHr19", "kWAvgWkendOctHr19", "kWMaxDayOctHr20", "kWAvgWkdayOctHr20", "kWAvgWkendOctHr20", "kWMaxDayOctHr21", "kWAvgWkdayOctHr21", "kWAvgWkendOctHr21", "kWMaxDayOctHr22", "kWAvgWkdayOctHr22", "kWAvgWkendOctHr22", "kWMaxDayOctHr23", "kWAvgWkdayOctHr23", "kWAvgWkendOctHr23", "kWMaxDayOctHr24", "kWAvgWkdayOctHr24", "kWAvgWkendOctHr24", "kWMaxDayNovHr01", "kWAvgWkdayNovHr01", "kWAvgWkendNovHr01", "kWMaxDayNovHr02", "kWAvgWkdayNovHr02", "kWAvgWkendNovHr02", "kWMaxDayNovHr03", "kWAvgWkdayNovHr03", "kWAvgWkendNovHr03", "kWMaxDayNovHr04", "kWAvgWkdayNovHr04", "kWAvgWkendNovHr04", "kWMaxDayNovHr05", "kWAvgWkdayNovHr05", "kWAvgWkendNovHr05", "kWMaxDayNovHr06", "kWAvgWkdayNovHr06", "kWAvgWkendNovHr06", "kWMaxDayNovHr07", "kWAvgWkdayNovHr07", "kWAvgWkendNovHr07", "kWMaxDayNovHr08", "kWAvgWkdayNovHr08", "kWAvgWkendNovHr08", "kWMaxDayNovHr09", "kWAvgWkdayNovHr09", "kWAvgWkendNovHr09", "kWMaxDayNovHr10", "kWAvgWkdayNovHr10", "kWAvgWkendNovHr10", "kWMaxDayNovHr11", "kWAvgWkdayNovHr11", "kWAvgWkendNovHr11", "kWMaxDayNovHr12", "kWAvgWkdayNovHr12", "kWAvgWkendNovHr12", "kWMaxDayNovHr13", "kWAvgWkdayNovHr13", "kWAvgWkendNovHr13", "kWMaxDayNovHr14", "kWAvgWkdayNovHr14", "kWAvgWkendNovHr14", "kWMaxDayNovHr15", "kWAvgWkdayNovHr15", "kWAvgWkendNovHr15", "kWMaxDayNovHr16", "kWAvgWkdayNovHr16", "kWAvgWkendNovHr16", "kWMaxDayNovHr17", "kWAvgWkdayNovHr17", "kWAvgWkendNovHr17", "kWMaxDayNovHr18", "kWAvgWkdayNovHr18", "kWAvgWkendNovHr18", "kWMaxDayNovHr19", "kWAvgWkdayNovHr19", "kWAvgWkendNovHr19", "kWMaxDayNovHr20", "kWAvgWkdayNovHr20", "kWAvgWkendNovHr20", "kWMaxDayNovHr21", "kWAvgWkdayNovHr21", "kWAvgWkendNovHr21", "kWMaxDayNovHr22", "kWAvgWkdayNovHr22", "kWAvgWkendNovHr22", "kWMaxDayNovHr23", "kWAvgWkdayNovHr23", "kWAvgWkendNovHr23", "kWMaxDayNovHr24", "kWAvgWkdayNovHr24", "kWAvgWkendNovHr24", "kWMaxDayDecHr01", "kWAvgWkdayDecHr01", "kWAvgWkendDecHr01", "kWMaxDayDecHr02", "kWAvgWkdayDecHr02", "kWAvgWkendDecHr02", "kWMaxDayDecHr03", "kWAvgWkdayDecHr03", "kWAvgWkendDecHr03", "kWMaxDayDecHr04", "kWAvgWkdayDecHr04", "kWAvgWkendDecHr04", "kWMaxDayDecHr05", "kWAvgWkdayDecHr05", "kWAvgWkendDecHr05", "kWMaxDayDecHr06", "kWAvgWkdayDecHr06", "kWAvgWkendDecHr06", "kWMaxDayDecHr07", "kWAvgWkdayDecHr07", "kWAvgWkendDecHr07", "kWMaxDayDecHr08", "kWAvgWkdayDecHr08", "kWAvgWkendDecHr08", "kWMaxDayDecHr09", "kWAvgWkdayDecHr09", "kWAvgWkendDecHr09", "kWMaxDayDecHr10", "kWAvgWkdayDecHr10", "kWAvgWkendDecHr10", "kWMaxDayDecHr11", "kWAvgWkdayDecHr11", "kWAvgWkendDecHr11", "kWMaxDayDecHr12", "kWAvgWkdayDecHr12", "kWAvgWkendDecHr12", "kWMaxDayDecHr13", "kWAvgWkdayDecHr13", "kWAvgWkendDecHr13", "kWMaxDayDecHr14", "kWAvgWkdayDecHr14", "kWAvgWkendDecHr14", "kWMaxDayDecHr15", "kWAvgWkdayDecHr15", "kWAvgWkendDecHr15", "kWMaxDayDecHr16", "kWAvgWkdayDecHr16", "kWAvgWkendDecHr16", "kWMaxDayDecHr17", "kWAvgWkdayDecHr17", "kWAvgWkendDecHr17", "kWMaxDayDecHr18", "kWAvgWkdayDecHr18", "kWAvgWkendDecHr18", "kWMaxDayDecHr19", "kWAvgWkdayDecHr19", "kWAvgWkendDecHr19", "kWMaxDayDecHr20", "kWAvgWkdayDecHr20", "kWAvgWkendDecHr20", "kWMaxDayDecHr21", "kWAvgWkdayDecHr21", "kWAvgWkendDecHr21", "kWMaxDayDecHr22", "kWAvgWkdayDecHr22", "kWAvgWkendDecHr22", "kWMaxDayDecHr23", "kWAvgWkdayDecHr23", "kWAvgWkendDecHr23", "kWMaxDayDecHr24", "kWAvgWkdayDecHr24", "kWAvgWkendDecHr24", "kWWkendWkdayRatioJan", "kWWkendWkdayRatioFeb", "kWWkendWkdayRatioMar", "kWWkendWkdayRatioApr", "kWWkendWkdayRatioMay", "kWWkendWkdayRatioJun", "kWWkendWkdayRatioJul", "kWWkendWkdayRatioAug", "kWWkendWkdayRatioSep", "kWWkendWkdayRatioOct", "kWWkendWkdayRatioNov", "kWWkendWkdayRatioDec", "kWpctJan", "kWpctFeb", "kWpctMar", "kWpctApr", "kWpctMay", "kWpctJun", "kWpctJul", "kWpctAug", "kWpctSep", "kWpctOct", "kWpctNov", "kWpctDec", "kWPDAFJan", "kWPDAFFeb", "kWPDAFMar", "kWPDAFApr", "kWPDAFMay", "kWPDAFJun", "kWPDAFJul", "kWPDAFAug", "kWPDAFSep", "kWPDAFOct", "kWPDAFNov", "kWPDAFDec"
        FROM costeff."LoadShapeElec_2022";
        '''
df = pd.read_sql(query, engine)

#transform back to cdls
sql_cdls, sql_ratios, sql_md = ls.sql_to_cdls(df, field_id='LoadShapeElecID')
cdls_md = sql_cdls.merge(sql_md, on=['ID'])
ratios_md = sql_ratios.merge(sql_md, on=['ID'])


#produce lists for dropdowns
#only start with TechID and Shape Options
techid_list = list(cdls_md["TechID"].unique())
techid_options = [{'label':i, 'value':i} for i in techid_list]


shape_options = [{'label':'peak','value':'Peak'},{'label':'avg wkday','value':'Avg'},{'label':'avg wkend','value':'End'}]

bldgtype_def = {"Asm" : "Assembly",
	"EPr" : "Education - Primary School",
	"ESe" : "Education - Secondary School",
	"ECC" : "Education - Community College",
	"EUn" : "Education - University",
	"Gro" : "Grocery",
	"Hsp" : "Health/Medical - Hospital",
	"Nrs" : "Health/Medical - Nursing Home",
	"Htl" : "Lodging - Hotel",
	"Mtl" : "Lodging - Motel",
	"MBT" : "Manufacturing - Bio/Tech",
	"MLI" : "Manufacturing - Light Industrial",
	"OfL" : "Office - Large",
	"OfS" : "Office - Small",
	"RSD" : "Restaurant - Sit-Down",
	"RFF" : "Restaurant - Fast-Food",
	"Rt3" : "Retail - Multistory Large",
	"RtL" : "Retail - Single-Story Large",
	"RtS" : "Retail - Small",
	"SCn" : "Storage - Conditioned",
	"SUn" : "Storage - Unconditioned",
	"WRf" : "Warehouse - Refrigerated",
	"SFm" : "Residential - Single Family",
	"MFm" : "Residential - Multifamily",
	"SMo" : "Residential - Single-Wide Mobile",
	"DMo" : "Residential - Double-Wide Mobile",
	"ERC" : "Education - Relocatable Classroom",
	"EUD" : "Education - University Dormitory",
	"HGR" : "Hotel Guest Room",
	"Any" : "Any"
	}



app = dash.Dash(external_stylesheets=[dbc.themes.BOOTSTRAP],
				prevent_initial_callbacks=True)
#construct app layout
# bootstrap use : external_stylesheets=[dbc.themes.BOOTSTRAP]

app.layout = html.Div([

				html.H3('Generalized Load Shape / Load Shape Factor Viewer', #style={'font-family': 'arial'}
						),

				html.Div(
					    [
					        dbc.Button(
					            "Show/Hide Dropdowns",
					            id="collapse-button",
					            className="mr-1",
					            color="primary",
					            outline=True
					        ),
					        dbc.Collapse(
					            dbc.Card(

					            dbc.CardBody(

					            	[

			html.Div([

				dbc.Alert(
					"Tech ID and shape confirmed. Please pick building type and DEER version, then press 'Confirm ... and view load shape' to view load shape.",
					id="submit_techid_alert",
					dismissable=True,
					is_open=False,
					color="info",
					duration=10000
					),

				dbc.Alert(
					"Load Shapes displayed.",
					id="submit_4_ls_alert",
					dismissable=True,
					is_open=False,
					color="success"
					)

				]),


			html.Div([

					html.H4('Step 1: select TechID / load shape', style={'text-decoration':'underline'}),
					html.H5('Step 1a: select for comparison group 1 (set A)'),
					html.H6('Select TechID for set A', style={'paddingRight':'200px'}),
					dcc.Dropdown(id='techid_dropdown_1',
								 options=techid_options,
								 placeholder='Select a Tech ID',
								 #value='MsrNResSpltPkgAC-65to134-S12.5', #default techID
								 ),

					html.H6('Select type of load shape to view for set A:', style={'paddingRight':'50px'}),
					dcc.Dropdown(id='shape_dropdown_1',
								 options=shape_options,
								 placeholder='Select Peak, Weekday or Weekend',
								 #value='Peak'
								 ),
					html.H5('Step 1b: select for comparison group 2 (set B)', style={'paddingTop':'20px'}),
					html.H6('Select TechID for set B', style={'paddingRight':'200px'}),
					dcc.Dropdown(id='techid_dropdown_2',
								 options=techid_options,
								 placeholder='Select a Tech ID',
								 #value='MsrNResSpltPkgAC-65to134-S12.5', #default techID
								 ),

					html.H6('Select type of load shape to view for set B:', style={'paddingRight':'50px'}),
					dcc.Dropdown(id='shape_dropdown_2',
								 options=shape_options,
								 placeholder='Select Peak, Weekday or Weekend',
								 #value='Peak'
								 ),


					html.Div([ 
							dbc.Button(id='submit_techid',
								n_clicks=0,
								children='confirm TechID and produce building types',
								#style={'fontSize':15}
								color="primary",
								className="mr-1"
								)
							], style={'paddingTop':'10px', 'textAlign':'center'}), #submit button to confirm techID, obtain bldgtype
					
						], style={'display':'inline-block', 'verticalAlign':'top', 'width':'40%'}),

				html.Div([

						html.H4('Step 2: select Building Type / DEER ver.', style={'text-decoration':'underline'}),
						html.H5('Step 2a: select for comparison group 1 (set A)', ),
						html.H6('Select a building type (set A)',
								 id='bldgtype_picker_string1',
								 #style={'font-family': 'arial',}
								 ),
						dcc.Dropdown(id='bldgtype_dropdown_1',
									 options=[],
									 value='Choose a techID / shape first'),

						html.H6('Select a DEER version (set A)',),
						dcc.Dropdown(id='deer_ver_picker_1',
									 options=[],
									 value='Choose a techID / shape first'),

						html.H5('Step 2b: select for comparison group 2 (set B)', style={'paddingTop':'20px'}),
						html.H6('Select a building type (set B)',
								 id='bldgtype_picker_string2',
								 #style={'font-family': 'arial',}
								 ),
						dcc.Dropdown(id='bldgtype_dropdown_2',
									 options=[],
									 value='Choose a techID / shape first'),

						html.H6('Select a DEER version (set A)',),
						dcc.Dropdown(id='deer_ver_picker_2',
									 options=[],
									 value='Choose a techID / shape first'),
						html.Div([

							dbc.Button(id='submit_4_ls',
									n_clicks=0,
									children='Confirm building type and view load shape',
									#style={'fontSize':15}
									color="primary",
									className="mr-1"
									) #submit button for confirming all parameters
							], style={'paddingTop':'10px', 'textAlign':'center'}),
						

					

						], style={'display':'inline-block', 'width':'40%', 'paddingLeft':'30px'}),


					            				] 



					            			)



					            		),
					            id="collapse",
					            is_open=True
					        ),
					    ]
						),

				

				# html.Div([

				# 		html.H3('Step 3: Confirm', style={'font-family': 'arial', 'text-decoration':'underline'}),
				# 		], style={'display':'inline-block', 'textAlign':'center', 'width':'30%'}),

				
				# html.H3('Step 4: View Load shapes', style={'font-family': 'arial', 'text-decoration':'underline', 'textAlign':'center'}),
				dcc.Tabs([

					dcc.Tab(label='Hourly Loads', 
							#style={'font-family': 'arial'}, 
							children=[

						dbc.Spinner(
								children=[

									dcc.Graph(id='main_graph_1',
									  		  figure={'data':[],  # ok to ignore {'x':[],'y':[]}?
									  		  		   'layout':{'title':'Select From Dropdowns first'}
									  		  		  },
									  		  style={'height':'800px', 'width':'1500px', 'margin':'auto'}

						 						)

										],
								color='primary',
								size='lg'
									),

						dbc.Button(
									children='download selected hourly load shape data',
									id='tab1_dl_button',
									color='primary',
									className='mr-1',
									n_clicks=0
									),
						Download(id="download1")

						
						 ]),

					dcc.Tab(label='Monthly Loads %', 
							#style={'font-family': 'arial'}, 
							children=[

						dbc.Spinner(
								children=[

									dcc.Graph(id='main_graph_2',
											  figure={'data':[],
											  		  'layout':{'title':'Select From Dropdowns first'}
											  		  },
											  style={'height':'800px','width':'1500px','margin':'auto'}
									 		 )


										 ],
								color='primary',
								size='lg'
									),

						dbc.Button(
									children='download selected monthly factor data',
									id='tab2_dl_button',
									color='primary',
									className='mr-1',
									n_clicks=0
									),
						Download(id="download2")

						
						]),

					dcc.Tab(label='Peak day to Weekday ratio', 
							#style={'font-family': 'arial',}, 
							children=[

						dbc.Spinner(
								children=[

									dcc.Graph(id='main_graph_3',
											  figure={'data':[],
											  		  'layout':{'title':'Select From Dropdowns first'}
											  		  },
											  style={'height':'800px','width':'1500px','margin':'auto'}
									 		 )

										 ],
								color='primary',
								size='lg'
									)

					

						

						]),

					dcc.Tab(label='Weekend to Weekday ratio', 
							#style={'font-family': 'arial',}, 
							children=[

						dbc.Spinner(
								children=[

									dcc.Graph(id='main_graph_4',
											  figure={'data':[],
											  		  'layout':{'title':'Select From Dropdowns first'}
											  		  },
											  style={'height':'800px','width':'1500px','margin':'auto'}
											 )

										 ],
								color='primary',
								size='lg'
									)

						
						

						])








					], style={'paddingTop':'15px', #'font-family': 'arial'

								}

						)

				

				



])



@app.callback(Output('submit_techid_alert', 'is_open'),
			[Input('submit_techid','n_clicks')],
			[State('submit_techid_alert','is_open')])
def toggle_alert1(n, is_open):
	if n:
		return not is_open
	return is_open

# @app.callback(Output('submit_4_ls_alert', 'is_open'),
# 			[Input('submit_4_ls','n_clicks')],
# 			[State('submit_4_ls_alert','is_open')])
# def toggle_alert2(n, is_open):
# 	if n:
# 		return not is_open 
# 	return is_open



@app.callback(
    Output("collapse", "is_open"),
    [Input("collapse-button", "n_clicks")],
    [State("collapse", "is_open")],
)
def toggle_collapse(n, is_open):
    if n:
        return not is_open
    return is_open

############## SET A callbacks ##############

#function to filter to correct building type
@app.callback(Output('bldgtype_dropdown_1', 'options'),
				[Input('submit_techid','n_clicks')],
				[State('techid_dropdown_1', 'value')])
def update_bldgtype(n_clicks, techid):
	cond_techid = cdls_md["TechID"]==techid
	bldgtype_list = list(cdls_md[cond_techid]["BldgType"].unique())
	bldgtype_options = [{'label':bldgtype_def[i], 'value':i} for i in bldgtype_list] 

	return bldgtype_options

#function to filter to correct DEER versuib
@app.callback(Output('deer_ver_picker_1', 'options'),
				[Input('submit_techid','n_clicks')],
				[State('techid_dropdown_1', 'value')])
def update_deerver(n_clicks, techid):
	cond_techid = cdls_md["TechID"]==techid
	deer_ver_list = list(cdls_md[cond_techid]["Version"].unique())
	deer_ver_options = [{'label':i, 'value':i} for i in deer_ver_list]

	return deer_ver_options

#function to update the display string for selecting building type
@app.callback(Output('bldgtype_picker_string1', 'children'),
				[Input('submit_techid','n_clicks')],
				[State('techid_dropdown_1', 'value')])
def update_bldgtype_string(n_clicks, techid):

	return f"Select a building type for techID: {techid} (set A)"



############## SET B callbacks ##############

#function to filter to correct building type
@app.callback(Output('bldgtype_dropdown_2', 'options'),
				[Input('submit_techid','n_clicks')],
				[State('techid_dropdown_2', 'value')])
def update_bldgtype(n_clicks, techid):
	cond_techid = cdls_md["TechID"]==techid
	bldgtype_list = list(cdls_md[cond_techid]["BldgType"].unique())
	bldgtype_options = [{'label':bldgtype_def[i], 'value':i} for i in bldgtype_list] 

	return bldgtype_options

#function to filter to correct DEER versuib
@app.callback(Output('deer_ver_picker_2', 'options'),
				[Input('submit_techid','n_clicks')],
				[State('techid_dropdown_2', 'value')])
def update_deerver(n_clicks, techid):
	cond_techid = cdls_md["TechID"]==techid
	deer_ver_list = list(cdls_md[cond_techid]["Version"].unique())
	deer_ver_options = [{'label':i, 'value':i} for i in deer_ver_list]

	return deer_ver_options

#function to update the display string for selecting building type
@app.callback(Output('bldgtype_picker_string2', 'children'),
				[Input('submit_techid','n_clicks')],
				[State('techid_dropdown_2', 'value')])
def update_bldgtype_string(n_clicks, techid):

	return f"Select a building type for techID: {techid} (set B)"










#function to update plot with hourly load shape based on selected techID, shape, bldgtype, DEER ver
#plot1
# @app.callback(Output('main_graph_1','figure'),
# 			[Input('submit_4_ls', 'n_clicks')],
# 			[State('techid_dropdown_1','value'),
# 			 State('shape_dropdown_1','value'),
# 			 State('bldgtype_dropdown_1','value'),
# 			 State('deer_ver_picker_1','value')])
# def update_plot1(n_clicks, techid, shape, bldgtype, deerver):

# 	shape_choice = {"Peak": 0, "Avg": 1, "End":2}

# 	cdls_md_filtered, ratios_md_filtered = vs.datafilter(cdls_md, ratios_md, techid, deerver, bldgtype)
# 	seasons_hourly, monthly_ratios = vs.prepare_plots(cdls_md_filtered, ratios_md_filtered, shape_choice[shape], "test version")


# 	fig = vs.plot_detail_single(seasons_hourly, techid, bldgtype_def[bldgtype])


# 	return fig

#plot1 hourly plots
@app.callback(Output('main_graph_1','figure'),
			[Input('submit_4_ls', 'n_clicks')],
			[State('techid_dropdown_1','value'),
			 State('shape_dropdown_1','value'),
			 State('bldgtype_dropdown_1','value'),
			 State('deer_ver_picker_1','value'),
			 State('techid_dropdown_2','value'),
			 State('shape_dropdown_2','value'),
			 State('bldgtype_dropdown_2','value'),
			 State('deer_ver_picker_2','value')])
def update_plot1(n_clicks, techid1, shape1, bldgtype1, deerver1, techid2, shape2, bldgtype2, deerver2):

	shape_choice = {"Peak": 0, "Avg": 1, "End":2}

	shape_display = {"Peak": "Peak Day", "Avg": "Average Weekday", 'End': "Average Weekend"}

	cdls_md_filtered_1, ratios_md_filtered_1 = vs.datafilter(cdls_md, ratios_md, techid1, deerver1, bldgtype1)
	cdls_md_filtered_2, ratios_md_filtered_2 = vs.datafilter(cdls_md, ratios_md, techid2, deerver2, bldgtype2)
	seasons_hourly_1, monthly_ratios_1 = vs.prepare_plots(cdls_md_filtered_1, ratios_md_filtered_1, shape_choice[shape1], "A")
	seasons_hourly_2, monthly_ratios_2 = vs.prepare_plots(cdls_md_filtered_2, ratios_md_filtered_2, shape_choice[shape2], "B")


	#fig = vs.plot_detail_single(seasons_hourly, techid, bldgtype_def[bldgtype])
	fig = vs.plot_detail(seasons_hourly_1, seasons_hourly_2, 
						 techid1, techid2, 
						 bldgtype_def[bldgtype1], bldgtype_def[bldgtype2], 
						 shape_display[shape1], shape_display[shape2], 
						 deerver1, deerver2)

	return fig

#download plot1 data
@app.callback(Output("download1", "data"),
			  [Input("tab1_dl_button", "n_clicks")],
			  [State('techid_dropdown_1','value'),
			 State('shape_dropdown_1','value'),
			 State('bldgtype_dropdown_1','value'),
			 State('deer_ver_picker_1','value'),
			 State('techid_dropdown_2','value'),
			 State('shape_dropdown_2','value'),
			 State('bldgtype_dropdown_2','value'),
			 State('deer_ver_picker_2','value')])
def dl_plot1(n_clicks, techid1, shape1, bldgtype1, deerver1, techid2, shape2, bldgtype2, deerver2):
	shape_choice = {"Peak": 0, "Avg": 1, "End":2}
	shape_display = {"Peak": "Peak Day", "Avg": "Average Weekday", 'End': "Average Weekend"}

	cdls_md_filtered_1, ratios_md_filtered_1 = vs.datafilter(cdls_md, ratios_md, techid1, deerver1, bldgtype1)
	cdls_md_filtered_2, ratios_md_filtered_2 = vs.datafilter(cdls_md, ratios_md, techid2, deerver2, bldgtype2)

	df = pd.concat([cdls_md_filtered_1, cdls_md_filtered_2])

	return send_data_frame(df.to_excel, "hourly_shape.xlsx", index=False)






#plot2 monthly factors
@app.callback(Output('main_graph_2','figure'),
			[Input('submit_4_ls', 'n_clicks')],
			[State('techid_dropdown_1','value'),
			 State('shape_dropdown_1','value'),
			 State('bldgtype_dropdown_1','value'),
			 State('deer_ver_picker_1','value'),
			 State('techid_dropdown_2','value'),
			 State('shape_dropdown_2','value'),
			 State('bldgtype_dropdown_2','value'),
			 State('deer_ver_picker_2','value')])
def update_plot2(n_clicks, techid1, shape1, bldgtype1, deerver1, techid2, shape2, bldgtype2, deerver2):

	shape_choice = {"Peak": 0, "Avg": 1, "End":2}

	cdls_md_filtered_1, ratios_md_filtered_1 = vs.datafilter(cdls_md, ratios_md, techid1, deerver1, bldgtype1)
	cdls_md_filtered_2, ratios_md_filtered_2 = vs.datafilter(cdls_md, ratios_md, techid2, deerver2, bldgtype2)
	seasons_hourly_1, monthly_ratios_1 = vs.prepare_plots(cdls_md_filtered_1, ratios_md_filtered_1, shape_choice[shape1], "A")
	seasons_hourly_2, monthly_ratios_2 = vs.prepare_plots(cdls_md_filtered_2, ratios_md_filtered_2, shape_choice[shape2], "B")

	fig_monthly, fig_pkwd_ratio, figure_wdwe_ratio = vs.plot_monthly_factors(monthly_ratios_1, monthly_ratios_2, 
																			 techid1, techid2, 
																			 bldgtype_def[bldgtype1], bldgtype_def[bldgtype2], 
																			 deerver1, deerver2)

	return fig_monthly


	

#download plot2 data (monthly factors)
@app.callback(Output("download2", "data"),
			[Input('tab2_dl_button', 'n_clicks')],
			[State('techid_dropdown_1','value'),
			 State('shape_dropdown_1','value'),
			 State('bldgtype_dropdown_1','value'),
			 State('deer_ver_picker_1','value'),
			 State('techid_dropdown_2','value'),
			 State('shape_dropdown_2','value'),
			 State('bldgtype_dropdown_2','value'),
			 State('deer_ver_picker_2','value')])
def dl_plot2(n_clicks, techid1, shape1, bldgtype1, deerver1, techid2, shape2, bldgtype2, deerver2):

	shape_choice = {"Peak": 0, "Avg": 1, "End":2}

	cdls_md_filtered_1, ratios_md_filtered_1 = vs.datafilter(cdls_md, ratios_md, techid1, deerver1, bldgtype1)
	cdls_md_filtered_2, ratios_md_filtered_2 = vs.datafilter(cdls_md, ratios_md, techid2, deerver2, bldgtype2)
	seasons_hourly_1, monthly_ratios_1 = vs.prepare_plots(cdls_md_filtered_1, ratios_md_filtered_1, shape_choice[shape1], "A")
	seasons_hourly_2, monthly_ratios_2 = vs.prepare_plots(cdls_md_filtered_2, ratios_md_filtered_2, shape_choice[shape2], "B")

	df = pd.concat([ratios_md_filtered_1, ratios_md_filtered_2])

	return send_data_frame(df.to_excel, "monthly_factors.xlsx", index=False)


#plot3 peak day to weekday ratio
@app.callback(Output('main_graph_3','figure'),
			[Input('submit_4_ls', 'n_clicks')],
			[State('techid_dropdown_1','value'),
			 State('shape_dropdown_1','value'),
			 State('bldgtype_dropdown_1','value'),
			 State('deer_ver_picker_1','value'),
			 State('techid_dropdown_2','value'),
			 State('shape_dropdown_2','value'),
			 State('bldgtype_dropdown_2','value'),
			 State('deer_ver_picker_2','value')])
def update_plot3(n_clicks, techid1, shape1, bldgtype1, deerver1, techid2, shape2, bldgtype2, deerver2):

	shape_choice = {"Peak": 0, "Avg": 1, "End":2}

	cdls_md_filtered_1, ratios_md_filtered_1 = vs.datafilter(cdls_md, ratios_md, techid1, deerver1, bldgtype1)
	cdls_md_filtered_2, ratios_md_filtered_2 = vs.datafilter(cdls_md, ratios_md, techid2, deerver2, bldgtype2)
	seasons_hourly_1, monthly_ratios_1 = vs.prepare_plots(cdls_md_filtered_1, ratios_md_filtered_1, shape_choice[shape1], "A")
	seasons_hourly_2, monthly_ratios_2 = vs.prepare_plots(cdls_md_filtered_2, ratios_md_filtered_2, shape_choice[shape2], "B")

	fig_monthly, fig_pkwd_ratio, figure_wdwe_ratio = vs.plot_monthly_factors(monthly_ratios_1, monthly_ratios_2, 
																			 techid1, techid2, 
																			 bldgtype_def[bldgtype1], bldgtype_def[bldgtype2], 
																			 deerver1, deerver2)

	return fig_pkwd_ratio


#plot4 Weekend to weekday ratio
@app.callback(Output('main_graph_4','figure'),
			[Input('submit_4_ls', 'n_clicks')],
			[State('techid_dropdown_1','value'),
			 State('shape_dropdown_1','value'),
			 State('bldgtype_dropdown_1','value'),
			 State('deer_ver_picker_1','value'),
			 State('techid_dropdown_2','value'),
			 State('shape_dropdown_2','value'),
			 State('bldgtype_dropdown_2','value'),
			 State('deer_ver_picker_2','value')])
def update_plot4(n_clicks, techid1, shape1, bldgtype1, deerver1, techid2, shape2, bldgtype2, deerver2):

	shape_choice = {"Peak": 0, "Avg": 1, "End":2}

	cdls_md_filtered_1, ratios_md_filtered_1 = vs.datafilter(cdls_md, ratios_md, techid1, deerver1, bldgtype1)
	cdls_md_filtered_2, ratios_md_filtered_2 = vs.datafilter(cdls_md, ratios_md, techid2, deerver2, bldgtype2)
	seasons_hourly_1, monthly_ratios_1 = vs.prepare_plots(cdls_md_filtered_1, ratios_md_filtered_1, shape_choice[shape1], "A")
	seasons_hourly_2, monthly_ratios_2 = vs.prepare_plots(cdls_md_filtered_2, ratios_md_filtered_2, shape_choice[shape2], "B")

	fig_monthly, fig_pkwd_ratio, figure_wdwe_ratio = vs.plot_monthly_factors(monthly_ratios_1, monthly_ratios_2, 
																			 techid1, techid2, 
																			 bldgtype_def[bldgtype1], bldgtype_def[bldgtype2], 
																			 deerver1, deerver2)

	return figure_wdwe_ratio

if __name__ == '__main__':
	app.run_server(debug=False)
