/*
Navicat PGSQL Data Transfer

Source Server         : Local PostgresQL
Source Server Version : 90004
Source Host           : localhost:5432
Source Database       : deer_spt
Source Schema         : tech

Target Server Type    : PGSQL
Target Server Version : 90004
File Encoding         : 65001

Date: 2011-11-29 20:25:04
*/


-- ----------------------------
-- Sequence structure for "tech"."ParamLists_ID_seq"
-- ----------------------------
DROP SEQUENCE "tech"."ParamLists_ID_seq";
CREATE SEQUENCE "tech"."ParamLists_ID_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 119
 CACHE 1;

-- ----------------------------
-- Sequence structure for "tech"."TypeDefn_ID_seq"
-- ----------------------------
DROP SEQUENCE "tech"."TypeDefn_ID_seq";
CREATE SEQUENCE "tech"."TypeDefn_ID_seq"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9223372036854775807
 START 1
 CACHE 1;

-- ----------------------------
-- Table structure for "tech"."NormUnit"
-- ----------------------------
DROP TABLE "tech"."NormUnit";
CREATE TABLE "tech"."NormUnit" (
"Index" int4 NOT NULL,
"Code" varchar(32) NOT NULL,
"Description" varchar(255),
"Comment" varchar(255),
"Status" varchar(64)
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "tech"."NormUnit" IS 'Normalizing Units for Energy Impacts and Technology Costs';

-- ----------------------------
-- Records of NormUnit
-- ----------------------------
INSERT INTO "tech"."NormUnit" VALUES ('26', 'Area-100win', '100 sqft window', 'Legacy: used in DEER2005 only', 'Legacy');
INSERT INTO "tech"."NormUnit" VALUES ('22', 'Area-1kFP', '1,000 sqft footprint', 'Legacy: used in DEER2005 only', 'Legacy');
INSERT INTO "tech"."NormUnit" VALUES ('23', 'Area-1kH', '1,000 sqft house', 'Legacy: used in DEER2005 only', 'Legacy');
INSERT INTO "tech"."NormUnit" VALUES ('24', 'Area-1kR', '1,000 sqft roof', 'Legacy: used in DEER2005 only', 'Legacy');
INSERT INTO "tech"."NormUnit" VALUES ('25', 'Area-1kW', '1,000 sqft wall (exc. windows)', 'Legacy: used in DEER2005 only', 'Legacy');
INSERT INTO "tech"."NormUnit" VALUES ('21', 'Area-Acre', 'per Acre', '1/640 of a square mile, example technology: Irrigation Systems', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('1', 'Area-ft2', 'area (ft2) of technology', 'refers to the area of the technology, not the associated building area e.g. shell measures (windows, wall insulation, floor insulation), ', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('0', 'Area-ft2-BA', 'Building area (ft2) ', 'building floor area associated with measure', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('2', 'Building', 'per building associated with the technology', 'non-residential', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('3', 'Cap-kBTUh', 'input capacity (kBTUh)', 'per 1000 BTU per hour rated input capacity (heating equipment, smaller capacity, such as residential furnaces)', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('4', 'Cap-kW', 'input capacity (kW)', 'per kilowatt capacity (electric heating equipment)', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('5', 'Cap-MBTUh', 'input capacity (MBTUh)', 'per 1 Million BTU per hour rated input capacity (large capacity heating equipment, such as commercial boilers)', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('6', 'Cap-Tons', 'cooling capacity (tons)', 'per ton of rated cooling equipment (large and small)', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('15', 'Ctrl-kW', 'kW Controlled', 'example measures: occupancy sensors, daylighting measures', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('7', 'Each', 'each unit equipment or technology', 'e.g. appliance measures (refrigerator, dishwasher, etc.)', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('8', 'Fixture', 'each lighting or plumbing fixture', 'lighting fixture or refrigeration display case fixture', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('9', 'Flow-CFM', 'CFM air flow', 'applies to some air flow measures', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('10', 'Flow-GPM', 'gallons per minute', 'applies to some water flow measures', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('11', 'Household', 'house or household', 'savings are per dwelling unit (residential)', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('12', 'Installation', 'per technology installation ', 'e.g. direct-install packaged HVAC equipment installation', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('18', 'kWh', 'per annual kWh consumption', 'custom measures only', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('13', 'Lamp', 'per lamp', 'per CFL lamp or per linear fluorescent lamp replacement', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('14', 'Len-ft', 'length (feet)', 'example measures: refrig case fixture length; strip curtains', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('16', 'Rated-HP', 'nameplate HP', 'motor measures', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('17', 'SurfArea-ft2', 'surface area (ft2)', 'example measures: pipe insulation, duct insulation', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('20', 'tbd', 'tbd', 'temporary assigments only, not valid for tracking data submittal', 'Standard');
INSERT INTO "tech"."NormUnit" VALUES ('19', 'therm', 'per annual therm consumption', 'custom measures only', 'Standard');

-- ----------------------------
-- Table structure for "tech"."ParamDefn"
-- ----------------------------
DROP TABLE "tech"."ParamDefn";
CREATE TABLE "tech"."ParamDefn" (
"Code" varchar(64) NOT NULL,
"Description" varchar(255) NOT NULL,
"Units" varchar(32),
"Required" bool,
"ValueType" varchar(16) NOT NULL,
"ValMin" float4,
"ValMax" float4,
"List" varchar(64),
"RuleValue" bool,
"ID" int4 NOT NULL
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "tech"."ParamDefn" IS 'technology parameter definition';

-- ----------------------------
-- Records of ParamDefn
-- ----------------------------
INSERT INTO "tech"."ParamDefn" VALUES ('Active_Power', 'computer monitor energy consumption during active mode', 'kWh', 't', 'Float', '10', '40', '', 't', '1');
INSERT INTO "tech"."ParamDefn" VALUES ('Bin_Size', 'Nominal size of commerical holding bin', '', 'f', 'List', null, null, 'Bin Size', 't', '2');
INSERT INTO "tech"."ParamDefn" VALUES ('Ballast_Factor', 'Ballast Factor', '', 't', 'Float', '0', '2', '', 'f', '3');
INSERT INTO "tech"."ParamDefn" VALUES ('Ballast_Type', 'Ballast Type', '', 't', 'List', null, null, 'LF Ballast Type', 'f', '4');
INSERT INTO "tech"."ParamDefn" VALUES ('Condender_UA', 'Heat flow rate of condenser', 'UA', 't', 'Float', '200', '700', '', 't', '5');
INSERT INTO "tech"."ParamDefn" VALUES ('Condenser_Relief', 'includes Condenser Relief', '', 't', 'Boolean', null, null, '', 't', '6');
INSERT INTO "tech"."ParamDefn" VALUES ('Condenser_Type', 'Cooling Equipment Condenser Type', '', 't', 'List', null, null, 'Condenser Type', 'f', '7');
INSERT INTO "tech"."ParamDefn" VALUES ('Condensing', 'Condensing or Non-Condensing Boiler', '', 't', 'Boolean', null, null, '', 't', '8');
INSERT INTO "tech"."ParamDefn" VALUES ('CookEff', 'Cooking efficiency ', '', 'f', 'Float', '0.1', '0.999', '', 't', '9');
INSERT INTO "tech"."ParamDefn" VALUES ('Dirty_Coils', 'condenser coils are dirty', '', 't', 'Boolean', null, null, '', 't', '10');
INSERT INTO "tech"."ParamDefn" VALUES ('Draft_Type', 'Draft Type of Boiler', '', 't', 'List', null, null, 'Boiler Draft Type', 't', '11');
INSERT INTO "tech"."ParamDefn" VALUES ('dxAC_Capacity_Range', 'Capacity range for DX cooling equipment', 'kBTU/hr', 't', 'List', null, null, 'dxAC Cap', 'f', '12');
INSERT INTO "tech"."ParamDefn" VALUES ('Chiller_Capacity_Range', 'Capacity range for chillers', 'tons', 't', 'List', null, null, 'Chiller Cap', 'f', '13');
INSERT INTO "tech"."ParamDefn" VALUES ('Economizer', 'Includes an economizer on a residential AC or HP', '', 't', 'Boolean', null, null, '', 't', '14');
INSERT INTO "tech"."ParamDefn" VALUES ('EER', 'Energy Efficiency Ratio', 'BTU/Whr', 't', 'Float', '7', '30', '', 'f', '15');
INSERT INTO "tech"."ParamDefn" VALUES ('EER_wNEHS', 'rated EER for system with non-electric heat source', 'BTU/Whr', 't', 'Float', '7', '30', '', 't', '16');
INSERT INTO "tech"."ParamDefn" VALUES ('EFLH', 'annual Equivalent Full Load Hours', 'hours', 't', 'Integer', '2000', '8760', '', 't', '17');
INSERT INTO "tech"."ParamDefn" VALUES ('Energy_Factor', 'rated energy efficiency value', '%', 't', 'Float', '0.25', '0.999', '', 't', '18');
INSERT INTO "tech"."ParamDefn" VALUES ('Energy_Star_5', 'Computer is / is not Energy Star 5.0', '', 't', 'Boolean', null, null, '', 't', '19');
INSERT INTO "tech"."ParamDefn" VALUES ('Energy_Star_Category', 'computer categories: A, B, C, or D', '', 't', 'List', null, null, 'ES_computer', 't', '20');
INSERT INTO "tech"."ParamDefn" VALUES ('Energy_Star_Rated', 'Is the appliance energy star rated', '', 't', 'Boolean', null, null, '', 't', '21');
INSERT INTO "tech"."ParamDefn" VALUES ('Energy_Star_Rating', 'consumer electronics rating', '', 't', 'Float', '4', '5.2', '', 't', '22');
INSERT INTO "tech"."ParamDefn" VALUES ('Energy_Star_Tier', 'Energy Star Tier', '', 't', 'Integer', '1', '3', '', 't', '23');
INSERT INTO "tech"."ParamDefn" VALUES ('Evaporator_UA', 'Heat flow rate of evaporator', 'UA', 't', 'Float', '300', '3000', '', 't', '24');
INSERT INTO "tech"."ParamDefn" VALUES ('Exit_Lamp_Type', 'Exit Lamp Type', '', 't', 'List', null, null, 'Exit Lamp Type', 'f', '25');
INSERT INTO "tech"."ParamDefn" VALUES ('Fan_Control', 'Air Circulation Fan Control', '', 't', 'List', null, null, 'Fan Control', 't', '26');
INSERT INTO "tech"."ParamDefn" VALUES ('Fan_Size', 'The diameter of the fan blades', 'inches', 'f', 'Integer', '12', '60', '', 'f', '27');
INSERT INTO "tech"."ParamDefn" VALUES ('Fixture_Watts', 'Total Fixture Watts', 'Watts', 't', 'Integer', '1', '5000', '', 't', '28');
INSERT INTO "tech"."ParamDefn" VALUES ('Fluid', 'Type of fluid in a pumping system', '', 't', 'List', null, null, 'Fluid', 't', '29');
INSERT INTO "tech"."ParamDefn" VALUES ('GP_Motor_ID', 'Technology ID for Group: Motor, Type: General Purpose', 'rated HP', 't', 'List', null, null, 'GP Motor ID', 'f', '30');
INSERT INTO "tech"."ParamDefn" VALUES ('HSPF', 'Heating seasonal performance factor', 'BTU/Whr', 'f', 'Float', '6.5', '9', '', 't', '31');
INSERT INTO "tech"."ParamDefn" VALUES ('Ice_Harvest_Rate', 'Ice Harvest Rate per 24 hours', 'lbs/day', 't', 'Integer', '100', '2000', '', 't', '32');
INSERT INTO "tech"."ParamDefn" VALUES ('Idle_Energy_Rate', 'Power draw when the oven is in "Idle"', 'W', 'f', 'Float', '100', '100000', '', 't', '33');
INSERT INTO "tech"."ParamDefn" VALUES ('Idle_Power_Density', 'Power density of a food holding cabinet', 'W/ft3', 't', 'Integer', '5', '50', '', 't', '34');
INSERT INTO "tech"."ParamDefn" VALUES ('Includes_AntiSweat', 'includes anti-sweat heaters', '', 't', 'Boolean', null, null, '', 't', '35');
INSERT INTO "tech"."ParamDefn" VALUES ('JITB_HB_Model', 'Model of Jack in the Box Holding Bin', '', 'f', 'List', null, null, 'JITBHB-Model', 't', '36');
INSERT INTO "tech"."ParamDefn" VALUES ('Lamp_Diameter', 'Linear fluorescent lamp diameter in eights of an inch', '', 't', 'List', null, null, 'LF Diameter', 'f', '37');
INSERT INTO "tech"."ParamDefn" VALUES ('Lamp_Length', 'Linear fluorescent lamp length', 'inches', 't', 'Integer', '12', '96', '', 'f', '38');
INSERT INTO "tech"."ParamDefn" VALUES ('Lamp_Watts', 'Nominal Watts per lamp', 'Watts', 't', 'Integer', '1', '5000', '', 't', '39');
INSERT INTO "tech"."ParamDefn" VALUES ('LampsBallast', 'Number of Lamps per Ballast', '', 't', 'Integer', '1', '8', '', 'f', '40');
INSERT INTO "tech"."ParamDefn" VALUES ('LampsFixture', 'Number of Lamps per Fixture', '', 't', 'Integer', '1', '8', '', 'f', '41');
INSERT INTO "tech"."ParamDefn" VALUES ('Leakage_Percent', 'Leakage as a percent of total airflow', '', 't', 'Float', '0', '100', '', 't', '42');
INSERT INTO "tech"."ParamDefn" VALUES ('LF_Lamp_Type', 'Linear fluorescent lamp type', '', 'f', 'List', null, null, 'LF Lamp Type', 'f', '43');
INSERT INTO "tech"."ParamDefn" VALUES ('Loop_Temp_Ctrl', 'Liquid Circulation Loop Temperature Control Strategy', '', 't', 'List', null, null, 'Loop Temp Ctrl', 't', '44');
INSERT INTO "tech"."ParamDefn" VALUES ('Max_Annual_kWH', 'Maximum electrical consumption per year', 'kWh', 't', 'Integer', '110', '1000', '', 't', '45');
INSERT INTO "tech"."ParamDefn" VALUES ('Modified_Energy_Factor', 'measure of appliance energy efficiency', '', 't', 'Float', '0.25', '2', '', 't', '46');
INSERT INTO "tech"."ParamDefn" VALUES ('Motor_Efficiency', 'Rated efficiency of the motor', '', 't', 'Float', '0.5', '0.999', '', 't', '47');
INSERT INTO "tech"."ParamDefn" VALUES ('Motor_Horsepower', 'rated Horsepower of motor', 'HP', 't', 'Float', '0.1', '2000', '', 't', '48');
INSERT INTO "tech"."ParamDefn" VALUES ('Night_Covers', 'Night time covers over open display cases', '', 't', 'Boolean', null, null, '', 't', '49');
INSERT INTO "tech"."ParamDefn" VALUES ('Number_of_Units', 'Number of units (display case doors, fryers, etc)', '', 'f', 'Integer', '0', '20', '', 't', '50');
INSERT INTO "tech"."ParamDefn" VALUES ('Offmode_Power', 'computer monitor energy consumption during off mode', 'kWh', 't', 'Float', '0.25', '2', '', 't', '51');
INSERT INTO "tech"."ParamDefn" VALUES ('Open_247', 'Store is open all hours of the year', '', 't', 'Boolean', null, null, '', 't', '52');
INSERT INTO "tech"."ParamDefn" VALUES ('Operating_Hours', 'Annual equivalent full load operating hours', 'hours', 't', 'Integer', '0', '8760', '', 't', '53');
INSERT INTO "tech"."ParamDefn" VALUES ('Percent_Improved', 'Improvement over 2008 DEER ', 'percentage', 't', 'Float', '0.15', '0.35', '', 't', '54');
INSERT INTO "tech"."ParamDefn" VALUES ('Pipe_Diameter', 'Diameter of Pipe', 'inches', 't', 'List', null, null, 'Pipe Diameter', 't', '55');
INSERT INTO "tech"."ParamDefn" VALUES ('Pressure', 'Operating Steam Pressure', 'PSI', 't', 'List', null, null, 'Pressure', 't', '56');
INSERT INTO "tech"."ParamDefn" VALUES ('Pump_Control', 'Liquid Circulation Loop Pump Control', '', 't', 'List', null, null, 'Pump Control', 't', '57');
INSERT INTO "tech"."ParamDefn" VALUES ('Pump_Efficiency', 'Gallons per watt-hour ', 'gal/Watt-hour', 't', 'Float', null, null, '', 't', '58');
INSERT INTO "tech"."ParamDefn" VALUES ('Refg_Compressor_EER', 'EER of the refrigerated display case compressor', 'BTU/Whr', 'f', 'Float', '7', '15', '', 't', '59');
INSERT INTO "tech"."ParamDefn" VALUES ('Refg_Condenser_Type', 'Type of grocery display case condenser ', '', 't', 'List', null, null, 'RefgCond', 't', '60');
INSERT INTO "tech"."ParamDefn" VALUES ('Refg_Operating_Temp', 'Display Case Operating Temperature', '', 't', 'List', null, null, 'Refg OpTemp', 't', '61');
INSERT INTO "tech"."ParamDefn" VALUES ('Refrigerant_Charge_State', 'Charge state of DX refrigerant system', '', 't', 'List', null, null, 'Refg Charge', 't', '62');
INSERT INTO "tech"."ParamDefn" VALUES ('Refrigerant_Type', 'Type of refrigerant', '', 'f', 'List', null, null, 'Refrigerant', 't', '63');
INSERT INTO "tech"."ParamDefn" VALUES ('Replacement_Qualified', 'New Construction or Replacement Qualified', '', 't', 'Boolean', null, null, '', 'f', '64');
INSERT INTO "tech"."ParamDefn" VALUES ('Screen_Size', 'computer monitor screen size', 'inches', 't', 'Integer', '12', '60', '', 't', '65');
INSERT INTO "tech"."ParamDefn" VALUES ('SEER', 'Seasonal Energy Efficiency Ratio', 'BTU/Whr', 't', 'Float', '7', '30', '', 't', '66');
INSERT INTO "tech"."ParamDefn" VALUES ('Sens_Peak_EER', 'sensible peak EER, used for hot, dry climates only', 'BTU/Whr', 't', 'Float', '7', '30', '', 't', '67');
INSERT INTO "tech"."ParamDefn" VALUES ('Sens_Peak_EER_opt', 'sensible peak EER, used for hot, dry climates only', 'BTU/Whr', 'f', 'Float', '7', '30', '', 't', '68');
INSERT INTO "tech"."ParamDefn" VALUES ('Sleepmode_Power', 'computer monitor energy consumption during sleep mode', 'kWh', 't', 'Float', '0.25', '2', '', 't', '69');
INSERT INTO "tech"."ParamDefn" VALUES ('Solar_Power', 'replaces grid electricity with solar power', '', 'f', 'Boolean', null, null, '', 't', '70');
INSERT INTO "tech"."ParamDefn" VALUES ('Hours_per_day', 'nominal daily operating hours ', 'hours', 't', 'Integer', '1', '24', '', 't', '71');
INSERT INTO "tech"."ParamDefn" VALUES ('Total_Display_Area', 'display case area including projected area through end walls', 'ft2', 't', 'Float', '15', '50', '', 't', '72');
INSERT INTO "tech"."ParamDefn" VALUES ('Variable_Flow', 'Variable Flow (liquid or air system)', '', 't', 'Boolean', null, null, '', 't', '73');
INSERT INTO "tech"."ParamDefn" VALUES ('VSD', 'includes variable speed drive mechanism', '', 't', 'Boolean', null, null, '', 't', '74');
INSERT INTO "tech"."ParamDefn" VALUES ('kWton', 'kW per ton of cooling capacity', '', 't', 'Float', '0', '2', '', 't', '75');
INSERT INTO "tech"."ParamDefn" VALUES ('RValue', 'Component Rated R-Value', '', 't', 'Float', '0', '100', '', 't', '76');
INSERT INTO "tech"."ParamDefn" VALUES ('Boiler_Capacity_Range', 'Capacity range for commercial boilers', 'kBTUh', 't', 'List', null, null, 'Boiler Cap', 'f', '77');
INSERT INTO "tech"."ParamDefn" VALUES ('Fuel_Type', 'Fuel type for heating equipment', '', 't', 'List', null, null, 'Fuel', 'f', '78');
INSERT INTO "tech"."ParamDefn" VALUES ('Loop_Capacity', 'Total loop capacity flow rate', 'Gal/min', 'f', 'Float', '0', '100000', '', 't', '79');
INSERT INTO "tech"."ParamDefn" VALUES ('COP', 'Coefficient of Performance', '', 't', 'Float', '0', '10', '', 't', '80');
INSERT INTO "tech"."ParamDefn" VALUES ('IPLV', 'Integrated Part Load Value', '', 'f', 'Float', '0', '10', '', 't', '81');
INSERT INTO "tech"."ParamDefn" VALUES ('Et', 'Thermal Efficiency', '', 't', 'Float', '0', '1', '', 't', '82');
INSERT INTO "tech"."ParamDefn" VALUES ('AFUE', 'Annual Fuel Utilization Efficiency', '', 't', 'Float', '0', '1', '', 't', '83');
INSERT INTO "tech"."ParamDefn" VALUES ('Motor_Enclosure', 'Motory Enclosure Type', '', 't', 'List', null, null, 'Motor Enclosure', 't', '84');
INSERT INTO "tech"."ParamDefn" VALUES ('Motor_HP', 'Motor Rated HP', 'HP', 't', 'List', null, null, 'Motor HP', 't', '85');
INSERT INTO "tech"."ParamDefn" VALUES ('Motor_Poles', 'Number of motor poles', '', 't', 'List', null, null, 'Motor Poles', 't', '86');
INSERT INTO "tech"."ParamDefn" VALUES ('Motor_Eff_Level', 'Motor Effeciency Level', '', 't', 'List', null, null, 'Motor Eff Level', 't', '87');
INSERT INTO "tech"."ParamDefn" VALUES ('Motor_Voltage', 'Motor Voltage Level', '', 't', 'List', null, null, 'Motor Voltage', 't', '88');
INSERT INTO "tech"."ParamDefn" VALUES ('ASD_Efficiency', 'Adjustable Speed Drive efficiency', '', 't', 'Float', '0', '1', '', 't', '89');
INSERT INTO "tech"."ParamDefn" VALUES ('Rated_Gallons', 'Rated volume in gallons', 'gallons', 't', 'List', null, null, 'DHW Gallons', 't', '90');
INSERT INTO "tech"."ParamDefn" VALUES ('Input_Rating', 'kBTU input rating for DHW tank', 'kBTUh', 't', 'Float', '20000', '200000', '', 't', '91');
INSERT INTO "tech"."ParamDefn" VALUES ('EF_Rating', 'Energy Factor rating', '', 't', 'Float', '0.5', '1', '', 't', '92');
INSERT INTO "tech"."ParamDefn" VALUES ('Blr_Standby_Loss', 'stand by loss of boiler', '', 't', 'Float', '0', '1e+007', '', 't', '93');
INSERT INTO "tech"."ParamDefn" VALUES ('ASD_Type', 'Adjustable Speed Drive Type', '', 't', 'List', null, null, 'ASD Type', 't', '94');
INSERT INTO "tech"."ParamDefn" VALUES ('NEMA_Design_Code', 'NEMA Design Code', '', 't', 'List', null, null, 'NEMA Code', 't', '95');
INSERT INTO "tech"."ParamDefn" VALUES ('RTU_Htg_Cap_Range', 'Heating capacity for packaged AC units', 'kBTUh', 'f', 'Float', '0', '1e+007', '', 't', '96');
INSERT INTO "tech"."ParamDefn" VALUES ('EER_Level', 'High or Low EER', 'BTU/Whr', 'f', 'List', null, null, 'EER Lvl', 't', '97');
INSERT INTO "tech"."ParamDefn" VALUES ('IPLV_wNEHS', 'Integrated Part Load Value', '', 'f', 'Float', '0', '10', '', 'f', '98');
INSERT INTO "tech"."ParamDefn" VALUES ('EER_opt', 'Energy Efficiency Ratio', 'BTU/Whr', 'f', 'Float', '7', '30', '', 'f', '99');
INSERT INTO "tech"."ParamDefn" VALUES ('COP47', 'Coefficient of Performance at 47F outdoor temperature', 'BTU/Whr', 't', 'Float', '0', '10', '', 't', '100');
INSERT INTO "tech"."ParamDefn" VALUES ('COP17_opt', 'Coefficient of Performance at 17F outdoor temperature', 'BTU/Whr', 'f', 'Float', '0', '10', '', 't', '101');
INSERT INTO "tech"."ParamDefn" VALUES ('COP_opt', 'Coefficient of Performance', '', 'f', 'Float', '0', '10', '', 't', '102');
INSERT INTO "tech"."ParamDefn" VALUES ('Engage_LtgID', 'Engage Lighting ID', '', 'f', 'Integer', '100000', '100000', '', 'f', '103');
INSERT INTO "tech"."ParamDefn" VALUES ('LF_Fixt_Type', 'Linear Fluorescent Fixture Type', '', 'f', 'List', null, null, 'LF Fixture Type', 't', '104');
INSERT INTO "tech"."ParamDefn" VALUES ('HID_Lamp_Type', 'HID Lamp Type', '', 'f', 'List', null, null, 'HID Lamp Type', 'f', '105');
INSERT INTO "tech"."ParamDefn" VALUES ('HID_Ballast_Type', 'HID Ballast Type', '', 'f', 'List', null, null, 'HID Ballast Type', 'f', '106');
INSERT INTO "tech"."ParamDefn" VALUES ('Exit_Ballast_Type', 'Exit Fixture Ballast Type', '', 'f', 'List', null, null, 'Exit Ballast Type', 'f', '107');
INSERT INTO "tech"."ParamDefn" VALUES ('Fryer_Size', 'Nominal size of commercial deep fryer', 'inches', 't', 'Float', '10', '20', '', 't', '108');
INSERT INTO "tech"."ParamDefn" VALUES ('Days_Per_Week', 'number of days per week of operation', 'days', 't', 'Integer', '1', '7', '', 't', '109');
INSERT INTO "tech"."ParamDefn" VALUES ('Fraction_of_ES_Rating', 'Fraction of Energy Star Rating', '', 't', 'Float', '0', '2', '', 't', '110');
INSERT INTO "tech"."ParamDefn" VALUES ('CEE_Tier', 'Efficiency Defined by the Cortsortium of Energy Efficiency (CEE)', '', 't', 'List', null, null, 'CEE Tier', 't', '111');
INSERT INTO "tech"."ParamDefn" VALUES ('Energy_Star_Tiers', 'Energy Star Tiers', '', 't', 'List', null, null, 'Energy Star Tier', 't', '112');
INSERT INTO "tech"."ParamDefn" VALUES ('CodeFixtID', 'Code Fixture ID', '', 'f', 'List', null, null, '', 'f', '113');
INSERT INTO "tech"."ParamDefn" VALUES ('Regulated', 'Code-Regulated Fixture', '', 't', 'Boolean', null, null, '', 'f', '114');
INSERT INTO "tech"."ParamDefn" VALUES ('ActivePower', 'Power consumption during active mode', 'Watts', 'f', 'Float', null, null, '', 'f', '115');
INSERT INTO "tech"."ParamDefn" VALUES ('Absorptance', 'surface absorptance after initial period', '', 'f', 'Float', null, null, '', 'f', '116');
INSERT INTO "tech"."ParamDefn" VALUES ('Emmisivity', 'surface emmisivity after initial period', '', 'f', 'Float', null, null, '', 'f', '117');
INSERT INTO "tech"."ParamDefn" VALUES ('CFL_Ballast_Type', '', '', 'f', 'List', null, null, '', 'f', '118');
INSERT INTO "tech"."ParamDefn" VALUES ('CFL_Base_Type', '', '', 'f', 'List', null, null, '', 'f', '119');
INSERT INTO "tech"."ParamDefn" VALUES ('CFM_Capacity', 'Air Compressor rated value', 'CFM', 'f', 'Float', null, null, '', 'f', '120');
INSERT INTO "tech"."ParamDefn" VALUES ('CondCoilUA', 'condenser coil heat transfer coefficient', 'BTU/hr-F', 'f', 'Float', null, null, '', 'f', '121');
INSERT INTO "tech"."ParamDefn" VALUES ('Control_Method', '', '', 'f', 'List', null, null, '', 'f', '122');
INSERT INTO "tech"."ParamDefn" VALUES ('Dimmable', 'lamp is dimmable', '', 'f', 'Boolean', null, null, '', 'f', '123');
INSERT INTO "tech"."ParamDefn" VALUES ('Drive_Efficiency', '', '', 'f', 'Float', null, null, '', 'f', '124');
INSERT INTO "tech"."ParamDefn" VALUES ('Drive_HP', 'rated HP of drive', 'HP', 'f', 'Float', null, null, '', 'f', '125');
INSERT INTO "tech"."ParamDefn" VALUES ('EnergyStarCategory', '', '', 'f', 'List', null, null, '', 'f', '126');
INSERT INTO "tech"."ParamDefn" VALUES ('EnergyStarLevel', '', '', 'f', 'List', null, null, '', 'f', '127');
INSERT INTO "tech"."ParamDefn" VALUES ('EnStar_Rated', 'Energy Star rated', '', 'f', 'Boolean', null, null, '', 'f', '128');
INSERT INTO "tech"."ParamDefn" VALUES ('Evaporator_Fan_Type', '', '', 'f', 'List', null, null, '', 'f', '129');
INSERT INTO "tech"."ParamDefn" VALUES ('EvapUA', 'evaporator heat transfer coefficient', 'BTU/hr-F', 'f', 'Float', null, null, '', 'f', '130');
INSERT INTO "tech"."ParamDefn" VALUES ('Faction_of_ES_Rating', '', '', 'f', 'Float', null, null, '', 'f', '131');
INSERT INTO "tech"."ParamDefn" VALUES ('Freezer_Location', '', '', 'f', 'List', null, null, '', 'f', '132');
INSERT INTO "tech"."ParamDefn" VALUES ('GPM', '', '', 'f', 'Float', null, null, '', 'f', '133');
INSERT INTO "tech"."ParamDefn" VALUES ('IceMaker', '', '', 'f', 'Boolean', null, null, '', 'f', '134');
INSERT INTO "tech"."ParamDefn" VALUES ('IHR', '', '', 'f', 'Float', null, null, '', 'f', '135');
INSERT INTO "tech"."ParamDefn" VALUES ('Input_Range', '', '', 'f', 'List', null, null, '', 'f', '136');
INSERT INTO "tech"."ParamDefn" VALUES ('Lamp_3way', '', '', 'f', 'Boolean', null, null, '', 'f', '137');
INSERT INTO "tech"."ParamDefn" VALUES ('Lamp_Design', '', '', 'f', 'List', null, null, '', 'f', '138');
INSERT INTO "tech"."ParamDefn" VALUES ('Lamp_Rated_Hours', '', '', 'f', 'Float', null, null, '', 'f', '139');
INSERT INTO "tech"."ParamDefn" VALUES ('Lubrication', '', '', 'f', 'List', null, null, '', 'f', '140');
INSERT INTO "tech"."ParamDefn" VALUES ('MaxConsumption', '', '', 'f', 'Float', null, null, '', 'f', '141');
INSERT INTO "tech"."ParamDefn" VALUES ('Number_of_Stages', '', '', 'f', 'Integer', null, null, '', 'f', '142');
INSERT INTO "tech"."ParamDefn" VALUES ('OffModePower', '', '', 'f', 'Float', null, null, '', 'f', '143');
INSERT INTO "tech"."ParamDefn" VALUES ('Operating_Pressure', '', '', 'f', 'Float', null, null, '', 'f', '144');
INSERT INTO "tech"."ParamDefn" VALUES ('Rated_kWhyr', '', '', 'f', 'Float', null, null, '', 'f', '145');
INSERT INTO "tech"."ParamDefn" VALUES ('RefgCompEff', '', '', 'f', 'Float', null, null, '', 'f', '146');
INSERT INTO "tech"."ParamDefn" VALUES ('RefgCondFanMtr', '', '', 'f', 'List', null, null, '', 'f', '147');
INSERT INTO "tech"."ParamDefn" VALUES ('RefgCondType', '', '', 'f', 'List', null, null, '', 'f', '148');
INSERT INTO "tech"."ParamDefn" VALUES ('RefgEvapFanMtr', '', '', 'f', 'List', null, null, '', 'f', '149');
INSERT INTO "tech"."ParamDefn" VALUES ('Refrig_Operating_Temp', '', '', 'f', 'Float', null, null, '', 'f', '150');
INSERT INTO "tech"."ParamDefn" VALUES ('ScreenSize', '', '', 'f', 'List', null, null, '', 'f', '151');
INSERT INTO "tech"."ParamDefn" VALUES ('ScrewIn_Base_Type', '', '', 'f', 'List', null, null, '', 'f', '152');
INSERT INTO "tech"."ParamDefn" VALUES ('SHGC', '', '', 'f', 'Float', null, null, '', 'f', '153');
INSERT INTO "tech"."ParamDefn" VALUES ('SHGC_Multiplier', '', '', 'f', 'Float', null, null, '', 'f', '154');
INSERT INTO "tech"."ParamDefn" VALUES ('SingleMulti_Deck', '', '', 'f', 'List', null, null, '', 'f', '155');
INSERT INTO "tech"."ParamDefn" VALUES ('SleepModePower', '', '', 'f', 'List', null, null, '', 'f', '156');
INSERT INTO "tech"."ParamDefn" VALUES ('Total_Head', '', '', 'f', 'Float', null, null, '', 'f', '157');
INSERT INTO "tech"."ParamDefn" VALUES ('UFactor', '', '', 'f', 'Float', null, null, '', 'f', '158');
INSERT INTO "tech"."ParamDefn" VALUES ('VerticalCaseType', '', '', 'f', 'List', null, null, '', 'f', '159');
INSERT INTO "tech"."ParamDefn" VALUES ('VisTrans', '', '', 'f', 'Float', null, null, '', 'f', '160');
INSERT INTO "tech"."ParamDefn" VALUES ('Volume', 'appliance rated volume', 'ft3', 'f', 'Float', '1', '100', '', 'f', '161');
INSERT INTO "tech"."ParamDefn" VALUES ('VisTrans_Mult', 'multiplier on Visu', '', 'f', 'Float', null, null, '', 'f', '162');
INSERT INTO "tech"."ParamDefn" VALUES ('Manufacturer', '', '', 'f', 'Text', null, null, '', 'f', '163');
INSERT INTO "tech"."ParamDefn" VALUES ('Model_Number', '', '', 'f', 'Text', null, null, '', 'f', '164');
INSERT INTO "tech"."ParamDefn" VALUES ('Scale_Basis_Type', '', '', 'f', 'Text', null, null, '', 'f', '165');
INSERT INTO "tech"."ParamDefn" VALUES ('Scale_Basis_Value', '', '', 'f', 'Float', '0', '10000', '', 'f', '166');
INSERT INTO "tech"."ParamDefn" VALUES ('WinCode', '', '', 't', 'Text', null, null, '', 'f', '167');
INSERT INTO "tech"."ParamDefn" VALUES ('Defrost', 'Freezer - manual or automatic', '', 'f', 'List', null, null, 'Freezer Defrost', 'f', '168');
INSERT INTO "tech"."ParamDefn" VALUES ('CoolingEIR', '', '', 'f', 'Float', '0', '1', '', 'f', '169');
INSERT INTO "tech"."ParamDefn" VALUES ('DHW_Fuel', 'Fuel type for hot water source', '', 't', 'List', null, null, 'Fuel', 'f', '170');
INSERT INTO "tech"."ParamDefn" VALUES ('Dryer_Fuel', 'Fuel type for associated clothes dryer', '', 't', 'List', null, null, 'Fuel', 'f', '171');
INSERT INTO "tech"."ParamDefn" VALUES ('CW_Capacity', '', '', 't', 'List', null, null, '', 'f', '172');
INSERT INTO "tech"."ParamDefn" VALUES ('DW_Capacity', '', '', 't', 'List', null, null, '', 'f', '173');
INSERT INTO "tech"."ParamDefn" VALUES ('MEF', '', '', 't', 'Float', null, null, '', 'f', '174');

-- ----------------------------
-- Table structure for "tech"."ParamList"
-- ----------------------------
DROP TABLE "tech"."ParamList";
CREATE TABLE "tech"."ParamList" (
"List" varchar(32) NOT NULL,
"Code" varchar(32) NOT NULL,
"Description" varchar(255) NOT NULL
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "tech"."ParamList" IS 'Parameters lists for all non-numeric parameter values';

-- ----------------------------
-- Records of ParamList
-- ----------------------------
INSERT INTO "tech"."ParamList" VALUES ('ASD Type', 'elec', 'Electrical Adjustable Speed Drive');
INSERT INTO "tech"."ParamList" VALUES ('ASD Type', 'mech', 'Mechanical Adjustable Speed Drive');
INSERT INTO "tech"."ParamList" VALUES ('Bin Size', '3q', 'holding cabinets (10-16 cu feet)');
INSERT INTO "tech"."ParamList" VALUES ('Bin Size', 'full', 'holding cabinets only (>16 cu feet)');
INSERT INTO "tech"."ParamList" VALUES ('Bin Size', 'half', 'holding cabinets (<10 cu. feet)');
INSERT INTO "tech"."ParamList" VALUES ('Boiler Cap', '300to2500k', 'greater than or equal to 300 and less than 2500 kBTUh');
INSERT INTO "tech"."ParamList" VALUES ('Boiler Cap', 'gt2500k', 'greater than or equal to 2500 kBTUh');
INSERT INTO "tech"."ParamList" VALUES ('Boiler Cap', 'lt300k', 'less than 300 kBTUh');
INSERT INTO "tech"."ParamList" VALUES ('Boiler Draft Type', 'Atm', 'Atmospheric');
INSERT INTO "tech"."ParamList" VALUES ('Boiler Draft Type', 'fDraft', 'Forced Draft');
INSERT INTO "tech"."ParamList" VALUES ('CEE Tier', 'CT0', 'Baseline appliance');
INSERT INTO "tech"."ParamList" VALUES ('CEE Tier', 'CT1', 'Efficiency Tier 1 for CEE appliances');
INSERT INTO "tech"."ParamList" VALUES ('CEE Tier', 'CT2', 'Efficiency Tier 2 for CEE appliances');
INSERT INTO "tech"."ParamList" VALUES ('CEE Tier', 'CT3', 'Efficiency Tier 3 for CEE appliances');
INSERT INTO "tech"."ParamList" VALUES ('Chiller Cap', '150to300t', 'greater than or equal to 150 tons and less than 300 tons');
INSERT INTO "tech"."ParamList" VALUES ('Chiller Cap', 'ge300t', 'greater than or equal to 300 tons');
INSERT INTO "tech"."ParamList" VALUES ('Chiller Cap', 'lt150t', 'less than 150 tons');
INSERT INTO "tech"."ParamList" VALUES ('Condenser Type', 'Air', 'Air-cooled Condenser');
INSERT INTO "tech"."ParamList" VALUES ('Condenser Type', 'Evap', 'Evaporatively-cooled Condenser');
INSERT INTO "tech"."ParamList" VALUES ('Condenser Type', 'Water', 'Water-cooled Condenser');
INSERT INTO "tech"."ParamList" VALUES ('DHW Gallons', '30gal', 'Nominal 30 gallon capacity');
INSERT INTO "tech"."ParamList" VALUES ('DHW Gallons', '40gal', 'Nominal 40 gallon capacity');
INSERT INTO "tech"."ParamList" VALUES ('DHW Gallons', '50gal', 'Nominal 50 gallon capacity');
INSERT INTO "tech"."ParamList" VALUES ('DHW Gallons', '60gal', 'Nominal 60 gallon capacity');
INSERT INTO "tech"."ParamList" VALUES ('DHW Gallons', '75gal', 'Nominal 75 gallon capacity');
INSERT INTO "tech"."ParamList" VALUES ('DHW Gallons', 'lt2', 'less then 2 gallons');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', '135to239k', '135-239 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', '14to20k', '14.0-19.9 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', '17to65k', '17-64 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', '240to759', '240-759 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', '65to134k', '65-134 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', '65to75k', '65-75 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', '6to8k', '6.0-7.9 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', '76to134k', '76-134 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', '7to15k', '7-15 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', '8to14k', '8.0-13.9 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', 'gt135k', '>=135 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', 'gt15k', '>15 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', 'gt20k', '>= 20.0 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', 'gt760k', '>=760 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', 'lt17k', '<17 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', 'lt65k', '<65 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', 'lt6k', '< 6.0 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('dxAC Cap', 'lt7k', '<7 kBtuh');
INSERT INTO "tech"."ParamList" VALUES ('EER Lvl', 'ge12.0', 'greater than or equal to 12.0');
INSERT INTO "tech"."ParamList" VALUES ('EER Lvl', 'ge12.19', 'greater than or equal to 12.19');
INSERT INTO "tech"."ParamList" VALUES ('EER Lvl', 'ge12.5', 'greater than or equal to 12.5');
INSERT INTO "tech"."ParamList" VALUES ('EER Lvl', 'ge12.7', 'greater than or equal to 12.7');
INSERT INTO "tech"."ParamList" VALUES ('EER Lvl', 'lt12.0', 'less than 12.0');
INSERT INTO "tech"."ParamList" VALUES ('EER Lvl', 'lt12.19', 'less than 12.19');
INSERT INTO "tech"."ParamList" VALUES ('EER Lvl', 'lt12.5', 'less than 12.5');
INSERT INTO "tech"."ParamList" VALUES ('EER Lvl', 'lt12.7', 'less than 12.7');
INSERT INTO "tech"."ParamList" VALUES ('Energy Star Tier', 'ES1', 'Energy Star Tier 1');
INSERT INTO "tech"."ParamList" VALUES ('Energy Star Tier', 'ES2', 'Energy Star Tier 2');
INSERT INTO "tech"."ParamList" VALUES ('Energy Star Tier', 'ES3', 'Energy Star Tier 3');
INSERT INTO "tech"."ParamList" VALUES ('ES_Computer', 'A', 'Computers which are not in category B, C, or D');
INSERT INTO "tech"."ParamList" VALUES ('ES_Computer', 'B', '2 physical cores and >2GB memory');
INSERT INTO "tech"."ParamList" VALUES ('ES_Computer', 'C', '>2 physical cores PLUS >2GB memory or a GPU');
INSERT INTO "tech"."ParamList" VALUES ('ES_Computer', 'D', '4 physical core PLUS >4GB memory or a fancy GPU');
INSERT INTO "tech"."ParamList" VALUES ('Exit Ballast Type', 'El', 'Electronic');
INSERT INTO "tech"."ParamList" VALUES ('Exit Ballast Type', 'Mag', 'Standard Magnetic');
INSERT INTO "tech"."ParamList" VALUES ('Exit Ballast Type', 'na', 'not applicable');
INSERT INTO "tech"."ParamList" VALUES ('Exit Lamp Type', 'CFL', 'Compact Fluorescent');
INSERT INTO "tech"."ParamList" VALUES ('Exit Lamp Type', 'Hal_IR', 'Halogen Infrared');
INSERT INTO "tech"."ParamList" VALUES ('Exit Lamp Type', 'Incand', 'Incandescent');
INSERT INTO "tech"."ParamList" VALUES ('Exit Lamp Type', 'LED', 'LED');
INSERT INTO "tech"."ParamList" VALUES ('Exit Lamp Type', 'T5', 'T-5');
INSERT INTO "tech"."ParamList" VALUES ('Fan Control', '2Spd', 'Two-Speed Fan');
INSERT INTO "tech"."ParamList" VALUES ('Fan Control', 'AFV', 'Air Foil Fan with Inlet Vanes');
INSERT INTO "tech"."ParamList" VALUES ('Fan Control', 'Const', 'Constant Volume Fan');
INSERT INTO "tech"."ParamList" VALUES ('Fan Control', 'EASD', 'Electrical Adjustable Speed Drive');
INSERT INTO "tech"."ParamList" VALUES ('Fan Control', 'FCD', 'Forward Curved Fan with Discharge Dampers');
INSERT INTO "tech"."ParamList" VALUES ('Fan Control', 'FCV', 'Forward Curved Fan with Inlet Vanes');
INSERT INTO "tech"."ParamList" VALUES ('Fan Control', 'MASD', 'Mechanical Adjustable Speed Drive');
INSERT INTO "tech"."ParamList" VALUES ('Fluid', 'CHW', 'Chilled Water');
INSERT INTO "tech"."ParamList" VALUES ('Fluid', 'CW', 'Condenser Water');
INSERT INTO "tech"."ParamList" VALUES ('Fluid', 'HW', 'Hot Water');
INSERT INTO "tech"."ParamList" VALUES ('Fluid', 'Sludge', 'Activated Sludge');
INSERT INTO "tech"."ParamList" VALUES ('Fluid', 'W', 'Potable Water');
INSERT INTO "tech"."ParamList" VALUES ('Fluid', 'WW', 'Waste Water');
INSERT INTO "tech"."ParamList" VALUES ('Freezer Defrost', 'Auto', 'Automatic defrost');
INSERT INTO "tech"."ParamList" VALUES ('Freezer Defrost', 'Man', 'Manual defrost');
INSERT INTO "tech"."ParamList" VALUES ('Fuel', 'Elec', 'Electric');
INSERT INTO "tech"."ParamList" VALUES ('Fuel', 'Gas', 'Natural Gas');
INSERT INTO "tech"."ParamList" VALUES ('GP Motor ID', 'tbd', 'techid for general purpose motors');
INSERT INTO "tech"."ParamList" VALUES ('HID Ballast Type', 'Mag', 'Mag-CWA');
INSERT INTO "tech"."ParamList" VALUES ('HID Ballast Type', 'Rea', 'Reactor');
INSERT INTO "tech"."ParamList" VALUES ('HID Lamp Type', 'HPS', 'High Pressure Sodium');
INSERT INTO "tech"."ParamList" VALUES ('HID Lamp Type', 'MH', 'Metal Halide');
INSERT INTO "tech"."ParamList" VALUES ('HID Lamp Type', 'MV', 'Mercury Vapor');
INSERT INTO "tech"."ParamList" VALUES ('HID Lamp Type', 'PSMH', 'Pulse Start Metal Halide');
INSERT INTO "tech"."ParamList" VALUES ('JITBHB-Model', 'PC20', 'Prince Castle Model # DHB4SS-20 ');
INSERT INTO "tech"."ParamList" VALUES ('JITBHB-Model', 'PC33', 'Prince Castle Model # DHB4SS-33');
INSERT INTO "tech"."ParamList" VALUES ('Lamp Design', 'A', 'A-lamp');
INSERT INTO "tech"."ParamList" VALUES ('Lamp Design', 'Glb', 'Globe');
INSERT INTO "tech"."ParamList" VALUES ('Lamp Design', 'RefP', 'Reflector-PAR');
INSERT INTO "tech"."ParamList" VALUES ('Lamp Design', 'RefR', 'Reflector-R');
INSERT INTO "tech"."ParamList" VALUES ('Lamp Design', 'Twst', 'Twist');
INSERT INTO "tech"."ParamList" VALUES ('Lamp Design', 'U', 'U-Tube');
INSERT INTO "tech"."ParamList" VALUES ('LF Ballast Type', 'Elec-Prem', 'Premium Electronic');
INSERT INTO "tech"."ParamList" VALUES ('LF Ballast Type', 'Electronic', 'Standard Electronic');
INSERT INTO "tech"."ParamList" VALUES ('LF Ballast Type', 'Mag-ES', 'Magnetic Energy Saver');
INSERT INTO "tech"."ParamList" VALUES ('LF Ballast Type', 'Mag-ES/STD', 'Magnetic Energy Saver/Standard');
INSERT INTO "tech"."ParamList" VALUES ('LF Ballast Type', 'Mag-Hyb', 'Magnetic Hybrid');
INSERT INTO "tech"."ParamList" VALUES ('LF Ballast Type', 'Mag-STD', 'Magnetic Standard');
INSERT INTO "tech"."ParamList" VALUES ('LF Diameter', 'T12', 'T-12');
INSERT INTO "tech"."ParamList" VALUES ('LF Diameter', 'T5', 'T-5');
INSERT INTO "tech"."ParamList" VALUES ('LF Diameter', 'T8', 'T-8');
INSERT INTO "tech"."ParamList" VALUES ('LF Fixture Type', 'RCT', 'Recessed Covered Trough');
INSERT INTO "tech"."ParamList" VALUES ('LF Fixture Type', 'ROT', 'Recessed Open Trough');
INSERT INTO "tech"."ParamList" VALUES ('LF Fixture Type', 'SCT', 'Suspended Covered Trough');
INSERT INTO "tech"."ParamList" VALUES ('LF Fixture Type', 'SOT', 'Suspended Open Trough');
INSERT INTO "tech"."ParamList" VALUES ('LF Lamp Type', '1st Gen', 'First Generation');
INSERT INTO "tech"."ParamList" VALUES ('LF Lamp Type', '2nd Gen', 'Second Generation');
INSERT INTO "tech"."ParamList" VALUES ('LF Lamp Type', '3rd Gen', 'Third Generation');
INSERT INTO "tech"."ParamList" VALUES ('LF Lamp Type', 'ES', 'Energy Saver');
INSERT INTO "tech"."ParamList" VALUES ('LF Lamp Type', 'ES HO', 'Energy Saver - High Output');
INSERT INTO "tech"."ParamList" VALUES ('LF Lamp Type', 'ES IS', 'Energy Saver - Instant Start');
INSERT INTO "tech"."ParamList" VALUES ('LF Lamp Type', 'ES VHO', 'Energy Saver - Very High Output');
INSERT INTO "tech"."ParamList" VALUES ('LF Lamp Type', 'Std', 'Standard Wattage');
INSERT INTO "tech"."ParamList" VALUES ('LF Lamp Type', 'Std HO', 'Standard Wattage - High Output');
INSERT INTO "tech"."ParamList" VALUES ('LF Lamp Type', 'Std IS', 'Standard Wattage - Instant-Start');
INSERT INTO "tech"."ParamList" VALUES ('LF Lamp Type', 'Std VHO', 'Standard Wattage - Very High Output');
INSERT INTO "tech"."ParamList" VALUES ('Loop Temp Ctrl', 'Const', 'Constant temperature');
INSERT INTO "tech"."ParamList" VALUES ('Loop Temp Ctrl', 'LdReset', 'Reset based on highest demand coil');
INSERT INTO "tech"."ParamList" VALUES ('Loop Temp Ctrl', 'OAReset', 'Reset based on outside drybulb');
INSERT INTO "tech"."ParamList" VALUES ('Motor Eff Level', 'CustAvg', 'default customer average efficiency level');
INSERT INTO "tech"."ParamList" VALUES ('Motor Eff Level', 'EPACT', 'EPACT level prior to Oct 19 2010');
INSERT INTO "tech"."ParamList" VALUES ('Motor Eff Level', 'meas', 'user entered based on measurements');
INSERT INTO "tech"."ParamList" VALUES ('Motor Eff Level', 'NEMAp', 'NEMA Premium Efficiency');
INSERT INTO "tech"."ParamList" VALUES ('Motor Enclosure', 'Closed', 'Totally enclosed fan-cooled');
INSERT INTO "tech"."ParamList" VALUES ('Motor Enclosure', 'Open', 'Open drip-proof');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '1.5HP', '1.5 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '100HP', '100 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '10HP', '10 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '125HP', '125 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '150HP', '150 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '15HP', '15 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '1HP', '1.0 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '200HP', '200 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '20HP', '20 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '250HP', '250 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '25HP', '25 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '2HP', '2.0 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '300HP', '300 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '30HP', '30 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '350HP', '350 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '3HP', '3.0 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '400HP', '400 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '450HP', '450 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '500HP', '500 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '50HP', '50 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '5HP', '5.0 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '60HP', '60 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '7.5HP', '7.5 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor HP', '75HP', '75 Nearest Rated HP');
INSERT INTO "tech"."ParamList" VALUES ('Motor Poles', '2-pole', '2-pole');
INSERT INTO "tech"."ParamList" VALUES ('Motor Poles', '4-pole', '4-pole');
INSERT INTO "tech"."ParamList" VALUES ('Motor Poles', '6-pole', '6-pole');
INSERT INTO "tech"."ParamList" VALUES ('Motor Poles', '8-pole', '8-pole');
INSERT INTO "tech"."ParamList" VALUES ('Motor Voltage', 'gt600V', '601-5000 volts AC');
INSERT INTO "tech"."ParamList" VALUES ('Motor Voltage', 'lte600V', '<= 600 volts AC');
INSERT INTO "tech"."ParamList" VALUES ('NEMA Code', 'A', 'Nema Design Code: A');
INSERT INTO "tech"."ParamList" VALUES ('NEMA Code', 'B', 'Nema Design Code: B');
INSERT INTO "tech"."ParamList" VALUES ('NEMA Code', 'C', 'Nema Design Code: C');
INSERT INTO "tech"."ParamList" VALUES ('NEMA Code', 'D', 'Nema Design Code: D');
INSERT INTO "tech"."ParamList" VALUES ('Pipe Diameter', 'gte1in', '>= 1 inch');
INSERT INTO "tech"."ParamList" VALUES ('Pipe Diameter', 'lt1in', '< 1 inch');
INSERT INTO "tech"."ParamList" VALUES ('Pressure', 'gt15psi', '> 15 psi');
INSERT INTO "tech"."ParamList" VALUES ('Pressure', 'lte15psi', '<= 15 psi');
INSERT INTO "tech"."ParamList" VALUES ('Pump Control', '2speed', 'Pump has 2-speed motor control');
INSERT INTO "tech"."ParamList" VALUES ('Pump Control', 'Constant', 'Pump is constant speed');
INSERT INTO "tech"."ParamList" VALUES ('Pump Control', 'RideCurve', 'Riding Curve, Pump output decreases as coils close');
INSERT INTO "tech"."ParamList" VALUES ('Pump Control', 'VSD', 'Pump has VSD control');
INSERT INTO "tech"."ParamList" VALUES ('Refg Charge', 'highOvr', 'High overcharge');
INSERT INTO "tech"."ParamList" VALUES ('Refg Charge', 'highUnd', 'High undercharge');
INSERT INTO "tech"."ParamList" VALUES ('Refg Charge', 'lowOvr', 'Low overcharge');
INSERT INTO "tech"."ParamList" VALUES ('Refg Charge', 'lowUnd', 'Low undercharge');
INSERT INTO "tech"."ParamList" VALUES ('Refg Charge', 'std', 'Standard (to specification)');
INSERT INTO "tech"."ParamList" VALUES ('Refg Charge', 'TypOff', 'Typical off-charge');
INSERT INTO "tech"."ParamList" VALUES ('Refg Charge', 'typOvr', 'Typical overcharge');
INSERT INTO "tech"."ParamList" VALUES ('Refg Charge', 'typUnd', 'Typical undercharge');
INSERT INTO "tech"."ParamList" VALUES ('Refg OpTemp', 'IceCrm', 'Rated at -15F, any temp below 0F');
INSERT INTO "tech"."ParamList" VALUES ('Refg OpTemp', 'Low', 'Rated at 0F, temp 0F to 32F');
INSERT INTO "tech"."ParamList" VALUES ('Refg OpTemp', 'Medium', 'Rated at 38F, any temp over 32F');
INSERT INTO "tech"."ParamList" VALUES ('RefgCond', 'Remote', 'Remote Condenser');
INSERT INTO "tech"."ParamList" VALUES ('RefgCond', 'Self', 'Self-contained');
INSERT INTO "tech"."ParamList" VALUES ('Refrigerant', 'mix', 'Mix of refrigerant types');
INSERT INTO "tech"."ParamList" VALUES ('Refrigerant', 'R22', 'R-22');
INSERT INTO "tech"."ParamList" VALUES ('Refrigerant', 'R410', 'R-410');
INSERT INTO "tech"."ParamList" VALUES ('Screw-In Base Type', 'Can', 'Candelabra');
INSERT INTO "tech"."ParamList" VALUES ('Screw-In Base Type', 'Med', 'Medium');

-- ----------------------------
-- Table structure for "tech"."ParamValType"
-- ----------------------------
DROP TABLE "tech"."ParamValType";
CREATE TABLE "tech"."ParamValType" (
"Code" varchar(16) NOT NULL,
"Description" varchar(255) NOT NULL
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "tech"."ParamValType" IS 'options used in ParamDefn table';

-- ----------------------------
-- Records of ParamValType
-- ----------------------------
INSERT INTO "tech"."ParamValType" VALUES ('Boolean', 'True or False');
INSERT INTO "tech"."ParamValType" VALUES ('Float', 'numeric value');
INSERT INTO "tech"."ParamValType" VALUES ('Integer', 'positive whole values only');
INSERT INTO "tech"."ParamValType" VALUES ('List', 'values are from a list');
INSERT INTO "tech"."ParamValType" VALUES ('Text', 'text input');

-- ----------------------------
-- Table structure for "tech"."TechGroup"
-- ----------------------------
DROP TABLE "tech"."TechGroup";
CREATE TABLE "tech"."TechGroup" (
"Name" varchar(255) NOT NULL,
"Code" varchar(32) NOT NULL,
"Comment" varchar(255),
"State" varchar(32),
"Index" int2 NOT NULL,
"NumMeas" int2,
"NumTechs" int2
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "tech"."TechGroup" IS 'organizes technology types';

-- ----------------------------
-- Records of TechGroup
-- ----------------------------
INSERT INTO "tech"."TechGroup" VALUES ('Air Compressor', 'AirComp', '', 'Standard', '1', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Anaerobic Digestor', 'AnDigestor', '', 'Standard', '2', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Building Shell (Opaque)', 'BldgShell', '', 'Standard', '3', '18', '18');
INSERT INTO "tech"."TechGroup" VALUES ('Liquid Chilling Equipment', 'Chiller', '', 'Standard', '4', '18', '102');
INSERT INTO "tech"."TechGroup" VALUES ('Cleaning Equipment', 'Clean_equip', '', 'Standard', '5', '20', '38');
INSERT INTO "tech"."TechGroup" VALUES ('Cooking Equipment', 'Cook_equip', '', 'Standard', '6', '0', '3');
INSERT INTO "tech"."TechGroup" VALUES ('dX AC Equipment', 'dxAC_equip', '', 'Standard', '7', '70', '250');
INSERT INTO "tech"."TechGroup" VALUES ('dx HP Equipment', 'dxHP_equip', '', 'Standard', '8', '24', '116');
INSERT INTO "tech"."TechGroup" VALUES ('Business and Consumer Electronics', 'Electronics', '', 'Standard', '9', '0', '24');
INSERT INTO "tech"."TechGroup" VALUES ('Evaporative Cooling Equipment', 'EvapCool_eq', '', 'Proposed', '10', '5', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Facultative Pond Aerator', 'FacPondAer', '', 'Standard', '11', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Fenestration', 'Fenest', '', 'Standard', '12', '30', '5');
INSERT INTO "tech"."TechGroup" VALUES ('Food Service', 'FoodService', '', 'Standard', '13', '0', '12');
INSERT INTO "tech"."TechGroup" VALUES ('Heat Rejection Equipment', 'HeatReject', '', 'Standard', '14', '4', '0');
INSERT INTO "tech"."TechGroup" VALUES ('HVAC Air Distribution', 'HV_AirDist', '', 'Standard', '15', '19', '9');
INSERT INTO "tech"."TechGroup" VALUES ('HVAC Technology', 'HV_Tech', '', 'Standard', '16', '4', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Irrigation Equipment', 'Irrigation', '', 'Standard', '17', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Liquid Circulation', 'LiquidCirc', '', 'Standard', '18', '11', '18');
INSERT INTO "tech"."TechGroup" VALUES ('Lighting - Plug-in', 'Ltg_PlugIn', '', 'Standard', '19', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Lighting - Screw-in Lamp', 'Ltg_ScrewIn', '', 'Standard', '20', '148', '338');
INSERT INTO "tech"."TechGroup" VALUES ('Lighting - Hard-wired fixture', 'Ltg_Wired', '', 'Standard', '21', '305', '525');
INSERT INTO "tech"."TechGroup" VALUES ('Motor', 'Motor', '', 'Standard', '22', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('General Purpose Motor', 'Motor_gen', '', 'Standard', '23', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Motor Speed Control (Non-HVAC)', 'Motor_Spd', '', 'Standard', '24', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Pump System', 'PumpSystem', '', 'Standard', '25', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Self-Contained Refrigeration', 'Ref_SelfCon', '', 'Standard', '26', '0', '14');
INSERT INTO "tech"."TechGroup" VALUES ('Refrigerated Storage', 'Ref_Storage', '', 'Standard', '27', '33', '34');
INSERT INTO "tech"."TechGroup" VALUES ('Rod Beam Pump', 'RodPumps', '', 'Standard', '28', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Space Heating Equipment', 'SpaceHtg_eq', '', 'Proposed', '29', '6', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Steam Circulation', 'SteamCirc', '', 'Standard', '30', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Steam Heating Equipment', 'SteamHtg_eq', '', 'Standard', '31', '6', '9');
INSERT INTO "tech"."TechGroup" VALUES ('Vertical Transportation', 'VertTrans', '', 'Standard', '32', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Plumbing Fixture', 'WaterFixt', '', 'Standard', '33', '0', '0');
INSERT INTO "tech"."TechGroup" VALUES ('Water Heating Equipment', 'WaterHtg_eq', '', 'Standard', '34', '62', '47');

-- ----------------------------
-- Table structure for "tech"."TechID2Param"
-- ----------------------------
DROP TABLE "tech"."TechID2Param";
CREATE TABLE "tech"."TechID2Param" (
"TechID" int4 NOT NULL,
"ParamID" int4 NOT NULL,
"ParamVal" varchar(32)
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "tech"."TechID2Param" IS 'Connect Parameter IDs and Parameter Values to technologies';

-- ----------------------------
-- Records of TechID2Param
-- ----------------------------
INSERT INTO "tech"."TechID2Param" VALUES ('1', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('1', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('1', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1', '66', '8.3');
INSERT INTO "tech"."TechID2Param" VALUES ('1', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('2', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('2', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('2', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('2', '66', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('2', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('2', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('2', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('2', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('2', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('3', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('3', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('3', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('3', '66', '9.7');
INSERT INTO "tech"."TechID2Param" VALUES ('3', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('3', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('3', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('3', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('3', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('4', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('4', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('4', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('4', '66', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('4', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('4', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('4', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('4', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('4', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('5', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('5', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('5', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('5', '66', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('5', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('5', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('5', '99', '<12.19');
INSERT INTO "tech"."TechID2Param" VALUES ('5', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('5', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('6', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('6', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('6', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('6', '66', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('6', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('6', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('6', '99', '>12.19');
INSERT INTO "tech"."TechID2Param" VALUES ('6', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('6', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('7', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('7', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('7', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('7', '66', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('7', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('7', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('7', '99', '<12.5');
INSERT INTO "tech"."TechID2Param" VALUES ('7', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('7', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('8', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('8', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('8', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('8', '66', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('8', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('8', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('8', '99', '>12.5');
INSERT INTO "tech"."TechID2Param" VALUES ('8', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('8', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('9', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('9', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('9', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('9', '66', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('9', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('9', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('9', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('9', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('9', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('10', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('10', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('10', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('10', '66', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('10', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('10', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('10', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('10', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('10', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('11', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('11', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('11', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('11', '66', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('11', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('11', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('11', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('11', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('11', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('12', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('12', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('12', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('12', '66', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('12', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('12', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('12', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('12', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('12', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('13', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('13', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('13', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('13', '66', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('13', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('13', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('13', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('13', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('13', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('14', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('14', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('14', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('14', '66', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('14', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('14', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('14', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('14', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('14', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('15', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('15', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('15', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('15', '66', '17.4');
INSERT INTO "tech"."TechID2Param" VALUES ('15', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('15', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('15', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('15', '163', '');
INSERT INTO "tech"."TechID2Param" VALUES ('15', '164', '');
INSERT INTO "tech"."TechID2Param" VALUES ('16', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('16', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('16', '16', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('16', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('16', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('16', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('16', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('17', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('17', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('17', '16', '8.9');
INSERT INTO "tech"."TechID2Param" VALUES ('17', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('17', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('17', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('17', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('18', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('18', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('18', '16', '9.1');
INSERT INTO "tech"."TechID2Param" VALUES ('18', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('18', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('18', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('18', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('19', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('19', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('19', '16', '10.1');
INSERT INTO "tech"."TechID2Param" VALUES ('19', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('19', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('19', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('19', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('20', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('20', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('20', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('20', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('20', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('20', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('20', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('21', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('21', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('21', '16', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('21', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('21', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('21', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('21', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('22', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('22', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('22', '16', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('22', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('22', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('22', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('22', '98', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('23', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('23', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('23', '16', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('23', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('23', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('23', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('23', '98', '12.4');
INSERT INTO "tech"."TechID2Param" VALUES ('24', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('24', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('24', '16', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('24', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('24', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('24', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('24', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('25', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('25', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('25', '16', '8.9');
INSERT INTO "tech"."TechID2Param" VALUES ('25', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('25', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('25', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('25', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('26', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('26', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('26', '16', '9.1');
INSERT INTO "tech"."TechID2Param" VALUES ('26', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('26', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('26', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('26', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('27', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('27', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('27', '16', '10.1');
INSERT INTO "tech"."TechID2Param" VALUES ('27', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('27', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('27', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('27', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('28', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('28', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('28', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('28', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('28', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('28', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('28', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('29', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('29', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('29', '16', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('29', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('29', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('29', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('29', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('30', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('30', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('30', '16', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('30', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('30', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('30', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('30', '98', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('31', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('31', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('31', '16', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('31', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('31', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('31', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('31', '98', '12.4');
INSERT INTO "tech"."TechID2Param" VALUES ('32', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('32', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('32', '16', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('32', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('32', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('32', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('32', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('33', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('33', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('33', '16', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('33', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('33', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('33', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('33', '98', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('34', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('34', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('34', '16', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('34', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('34', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('34', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('34', '98', '12.4');
INSERT INTO "tech"."TechID2Param" VALUES ('35', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('35', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('35', '16', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('35', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('35', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('35', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('35', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('36', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('36', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('36', '16', '8.3');
INSERT INTO "tech"."TechID2Param" VALUES ('36', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('36', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('36', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('36', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('37', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('37', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('37', '16', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('37', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('37', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('37', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('37', '98', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('38', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('38', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('38', '16', '9.8');
INSERT INTO "tech"."TechID2Param" VALUES ('38', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('38', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('38', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('38', '98', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('39', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('39', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('39', '16', '10.5');
INSERT INTO "tech"."TechID2Param" VALUES ('39', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('39', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('39', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('39', '98', '10.9');
INSERT INTO "tech"."TechID2Param" VALUES ('40', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('40', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('40', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('40', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('40', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('40', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('40', '98', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('41', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('41', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('41', '16', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('41', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('41', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('41', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('41', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('42', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('42', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('42', '16', '9.8');
INSERT INTO "tech"."TechID2Param" VALUES ('42', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('42', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('42', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('42', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('43', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('43', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('43', '16', '10.5');
INSERT INTO "tech"."TechID2Param" VALUES ('43', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('43', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('43', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('43', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('44', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('44', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('44', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('44', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('44', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('44', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('44', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('45', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('45', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('45', '16', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('45', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('45', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('45', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('45', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('46', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('46', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('46', '16', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('46', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('46', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('46', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('46', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('47', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('47', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('47', '16', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('47', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('47', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('47', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('47', '98', '9.2');
INSERT INTO "tech"."TechID2Param" VALUES ('48', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('48', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('48', '16', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('48', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('48', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('48', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('48', '98', '9.2');
INSERT INTO "tech"."TechID2Param" VALUES ('49', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('49', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('49', '16', '9.7');
INSERT INTO "tech"."TechID2Param" VALUES ('49', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('49', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('49', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('49', '98', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('50', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('50', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('50', '16', '10.2');
INSERT INTO "tech"."TechID2Param" VALUES ('50', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('50', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('50', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('50', '98', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('51', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('51', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('51', '16', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('51', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('51', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('51', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('51', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('52', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('52', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('52', '16', '12.1');
INSERT INTO "tech"."TechID2Param" VALUES ('52', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('52', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('52', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('52', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('53', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('53', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('53', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('53', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('53', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('53', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('53', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('54', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('54', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('54', '16', '10.3');
INSERT INTO "tech"."TechID2Param" VALUES ('54', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('54', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('54', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('54', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('55', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('55', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('55', '16', '11.3');
INSERT INTO "tech"."TechID2Param" VALUES ('55', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('55', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('55', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('55', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('56', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('56', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('56', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('56', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('56', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('56', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('56', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('57', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('57', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('57', '16', '10.3');
INSERT INTO "tech"."TechID2Param" VALUES ('57', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('57', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('57', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('57', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('58', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('58', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('58', '16', '11.3');
INSERT INTO "tech"."TechID2Param" VALUES ('58', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('58', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('58', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('58', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('59', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('59', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('59', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('59', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('59', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('59', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('59', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('60', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('60', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('60', '16', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('60', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('60', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('60', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('60', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('61', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('61', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('61', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('61', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('61', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('61', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('61', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('62', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('62', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('62', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('62', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('62', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('62', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('62', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('63', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('63', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('63', '16', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('63', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('63', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('63', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('63', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('64', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('64', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('64', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('64', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('64', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('64', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('64', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('65', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('65', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('65', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('65', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('65', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('65', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('65', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('66', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('66', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('66', '16', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('66', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('66', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('66', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('66', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('67', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('67', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('67', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('67', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('67', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('67', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('67', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('68', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('68', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('68', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('68', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('68', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('68', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('68', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('69', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('69', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('69', '16', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('69', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('69', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('69', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('69', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('70', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('70', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('70', '16', '12.1');
INSERT INTO "tech"."TechID2Param" VALUES ('70', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('70', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('70', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('70', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('71', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('71', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('71', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('71', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('71', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('71', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('71', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('72', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('72', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('72', '16', '10.3');
INSERT INTO "tech"."TechID2Param" VALUES ('72', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('72', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('72', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('72', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('73', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('73', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('73', '16', '11.3');
INSERT INTO "tech"."TechID2Param" VALUES ('73', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('73', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('73', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('73', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('74', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('74', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('74', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('74', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('74', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('74', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('74', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('75', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('75', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('75', '16', '10.3');
INSERT INTO "tech"."TechID2Param" VALUES ('75', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('75', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('75', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('75', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('76', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('76', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('76', '16', '11.3');
INSERT INTO "tech"."TechID2Param" VALUES ('76', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('76', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('76', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('76', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('77', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('77', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('77', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('77', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('77', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('77', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('77', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('78', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('78', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('78', '16', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('78', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('78', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('78', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('78', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('79', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('79', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('79', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('79', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('79', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('79', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('79', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('80', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('80', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('80', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('80', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('80', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('80', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('80', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('81', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('81', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('81', '16', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('81', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('81', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('81', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('81', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('82', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('82', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('82', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('82', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('82', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('82', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('82', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('83', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('83', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('83', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('83', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('83', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('83', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('83', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('84', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('84', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('84', '16', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('84', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('84', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('84', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('84', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('85', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('85', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('85', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('85', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('85', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('85', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('85', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('86', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('86', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('86', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('86', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('86', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('86', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('86', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('87', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('87', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('87', '63', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('87', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('87', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('88', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('88', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('88', '63', '12.1');
INSERT INTO "tech"."TechID2Param" VALUES ('88', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('88', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('89', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('89', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('89', '63', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('89', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('89', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('90', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('90', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('90', '63', '10.3');
INSERT INTO "tech"."TechID2Param" VALUES ('90', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('90', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('91', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('91', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('91', '63', '11.3');
INSERT INTO "tech"."TechID2Param" VALUES ('91', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('91', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('92', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('92', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('92', '63', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('92', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('92', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('93', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('93', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('93', '63', '10.3');
INSERT INTO "tech"."TechID2Param" VALUES ('93', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('93', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('94', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('94', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('94', '63', '11.3');
INSERT INTO "tech"."TechID2Param" VALUES ('94', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('94', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('95', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('95', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('95', '63', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('95', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('95', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('96', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('96', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('96', '63', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('96', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('96', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('97', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('97', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('97', '63', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('97', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('97', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('98', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('98', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('98', '63', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('98', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('98', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('99', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('99', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('99', '63', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('99', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('99', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('100', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('100', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('100', '63', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('100', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('100', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('101', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('101', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('101', '63', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('101', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('101', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('102', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('102', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('102', '63', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('102', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('102', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('103', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('103', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('103', '63', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('103', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('103', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('104', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('104', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('104', '63', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('104', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('104', '96', '');
INSERT INTO "tech"."TechID2Param" VALUES ('105', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('105', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('105', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('105', '66', '8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('105', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('105', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('106', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('106', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('106', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('106', '66', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('106', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('106', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('107', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('107', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('107', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('107', '66', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('107', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('107', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('108', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('108', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('108', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('108', '66', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('108', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('108', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('109', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('109', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('109', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('109', '66', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('109', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('109', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('110', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('110', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('110', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('110', '66', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('110', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('110', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('111', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('111', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('111', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('111', '66', '14.5');
INSERT INTO "tech"."TechID2Param" VALUES ('111', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('111', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('112', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('112', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('112', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('112', '66', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('112', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('112', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('113', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('113', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('113', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('113', '66', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('113', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('113', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('114', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('114', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('114', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('114', '66', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('114', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('114', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('115', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('115', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('115', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('115', '66', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('115', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('115', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('116', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('116', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('116', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('116', '66', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('116', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('116', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('117', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('117', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('117', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('117', '66', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('117', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('117', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('118', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('118', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('118', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('118', '66', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('118', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('118', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('119', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('119', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('119', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('119', '66', '17.1');
INSERT INTO "tech"."TechID2Param" VALUES ('119', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('119', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('120', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('120', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('120', '16', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('120', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('120', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('120', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('121', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('121', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('121', '16', '8.9');
INSERT INTO "tech"."TechID2Param" VALUES ('121', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('121', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('121', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('122', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('122', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('122', '16', '9.1');
INSERT INTO "tech"."TechID2Param" VALUES ('122', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('122', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('122', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('123', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('123', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('123', '16', '10.1');
INSERT INTO "tech"."TechID2Param" VALUES ('123', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('123', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('123', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('124', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('124', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('124', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('124', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('124', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('124', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('125', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('125', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('125', '16', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('125', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('125', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('125', '98', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('126', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('126', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('126', '16', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('126', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('126', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('126', '98', '12.4');
INSERT INTO "tech"."TechID2Param" VALUES ('127', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('127', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('127', '16', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('127', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('127', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('127', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('128', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('128', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('128', '16', '8.9');
INSERT INTO "tech"."TechID2Param" VALUES ('128', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('128', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('128', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('129', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('129', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('129', '16', '9.1');
INSERT INTO "tech"."TechID2Param" VALUES ('129', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('129', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('129', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('130', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('130', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('130', '16', '10.1');
INSERT INTO "tech"."TechID2Param" VALUES ('130', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('130', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('130', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('131', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('131', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('131', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('131', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('131', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('131', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('132', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('132', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('132', '16', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('132', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('132', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('132', '98', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('133', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('133', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('133', '16', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('133', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('133', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('133', '98', '12.4');
INSERT INTO "tech"."TechID2Param" VALUES ('134', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('134', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('134', '16', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('134', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('134', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('134', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('135', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('135', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('135', '16', '8.3');
INSERT INTO "tech"."TechID2Param" VALUES ('135', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('135', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('135', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('136', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('136', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('136', '16', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('136', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('136', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('136', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('137', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('137', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('137', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('137', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('137', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('137', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('138', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('138', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('138', '16', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('138', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('138', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('138', '98', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('139', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('139', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('139', '16', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('139', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('139', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('139', '98', '12.4');
INSERT INTO "tech"."TechID2Param" VALUES ('140', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('140', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('140', '16', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('140', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('140', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('140', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('141', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('141', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('141', '16', '8.3');
INSERT INTO "tech"."TechID2Param" VALUES ('141', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('141', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('141', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('142', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('142', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('142', '16', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('142', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('142', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('142', '98', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('143', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('143', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('143', '16', '9.8');
INSERT INTO "tech"."TechID2Param" VALUES ('143', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('143', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('143', '98', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('144', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('144', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('144', '16', '10.5');
INSERT INTO "tech"."TechID2Param" VALUES ('144', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('144', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('144', '98', '10.9');
INSERT INTO "tech"."TechID2Param" VALUES ('145', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('145', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('145', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('145', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('145', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('145', '98', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('146', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('146', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('146', '16', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('146', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('146', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('146', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('147', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('147', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('147', '16', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('147', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('147', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('147', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('148', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('148', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('148', '16', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('148', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('148', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('148', '98', '9.2');
INSERT INTO "tech"."TechID2Param" VALUES ('149', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('149', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('149', '16', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('149', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('149', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('149', '98', '9.2');
INSERT INTO "tech"."TechID2Param" VALUES ('150', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('150', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('150', '16', '9.7');
INSERT INTO "tech"."TechID2Param" VALUES ('150', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('150', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('150', '98', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('151', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('151', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('151', '16', '10.2');
INSERT INTO "tech"."TechID2Param" VALUES ('151', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('151', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('151', '98', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('152', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('152', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('152', '16', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('152', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('152', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('152', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('153', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('153', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('153', '16', '12.1');
INSERT INTO "tech"."TechID2Param" VALUES ('153', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('153', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('153', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('154', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('154', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('154', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('154', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('154', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('154', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('155', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('155', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('155', '16', '10.3');
INSERT INTO "tech"."TechID2Param" VALUES ('155', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('155', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('155', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('156', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('156', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('156', '16', '11.3');
INSERT INTO "tech"."TechID2Param" VALUES ('156', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('156', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('156', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('157', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('157', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('157', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('157', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('157', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('157', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('158', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('158', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('158', '16', '10.3');
INSERT INTO "tech"."TechID2Param" VALUES ('158', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('158', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('158', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('159', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('159', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('159', '16', '11.3');
INSERT INTO "tech"."TechID2Param" VALUES ('159', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('159', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('159', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('160', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('160', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('160', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('160', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('160', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('160', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('161', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('161', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('161', '16', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('161', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('161', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('161', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('162', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('162', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('162', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('162', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('162', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('162', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('163', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('163', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('163', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('163', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('163', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('163', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('164', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('164', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('164', '16', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('164', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('164', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('164', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('165', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('165', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('165', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('165', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('165', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('165', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('166', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('166', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('166', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('166', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('166', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('166', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('167', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('167', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('167', '16', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('167', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('167', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('167', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('168', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('168', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('168', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('168', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('168', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('168', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('169', '7', 'Evap');
INSERT INTO "tech"."TechID2Param" VALUES ('169', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('169', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('169', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('169', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('169', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('170', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('170', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('170', '16', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('170', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('170', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('170', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('171', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('171', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('171', '16', '12.1');
INSERT INTO "tech"."TechID2Param" VALUES ('171', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('171', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('171', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('172', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('172', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('172', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('172', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('172', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('172', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('173', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('173', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('173', '16', '10.3');
INSERT INTO "tech"."TechID2Param" VALUES ('173', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('173', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('173', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('174', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('174', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('174', '16', '11.3');
INSERT INTO "tech"."TechID2Param" VALUES ('174', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('174', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('174', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('175', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('175', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('175', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('175', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('175', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('175', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('176', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('176', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('176', '16', '10.3');
INSERT INTO "tech"."TechID2Param" VALUES ('176', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('176', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('176', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('177', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('177', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('177', '16', '11.3');
INSERT INTO "tech"."TechID2Param" VALUES ('177', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('177', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('177', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('178', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('178', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('178', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('178', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('178', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('178', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('179', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('179', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('179', '16', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('179', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('179', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('179', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('180', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('180', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('180', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('180', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('180', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('180', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('181', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('181', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('181', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('181', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('181', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('181', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('182', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('182', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('182', '16', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('182', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('182', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('182', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('183', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('183', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('183', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('183', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('183', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('183', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('184', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('184', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('184', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('184', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('184', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('184', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('185', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('185', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('185', '16', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('185', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('185', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('185', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('186', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('186', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('186', '16', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('186', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('186', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('186', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('187', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('187', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('187', '16', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('187', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('187', '68', '');
INSERT INTO "tech"."TechID2Param" VALUES ('187', '98', '');
INSERT INTO "tech"."TechID2Param" VALUES ('188', '10', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('188', '62', 'highOvr');
INSERT INTO "tech"."TechID2Param" VALUES ('188', '169', '0.418');
INSERT INTO "tech"."TechID2Param" VALUES ('189', '10', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('189', '62', 'typOvr');
INSERT INTO "tech"."TechID2Param" VALUES ('189', '169', '0.36');
INSERT INTO "tech"."TechID2Param" VALUES ('190', '10', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('190', '62', 'highUnd');
INSERT INTO "tech"."TechID2Param" VALUES ('190', '169', '0.36');
INSERT INTO "tech"."TechID2Param" VALUES ('191', '10', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('191', '62', 'typUnd');
INSERT INTO "tech"."TechID2Param" VALUES ('191', '169', '0.346');
INSERT INTO "tech"."TechID2Param" VALUES ('192', '10', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('192', '62', 'std');
INSERT INTO "tech"."TechID2Param" VALUES ('192', '169', '0.31');
INSERT INTO "tech"."TechID2Param" VALUES ('193', '12', 'lt6k');
INSERT INTO "tech"."TechID2Param" VALUES ('193', '15', '9.7');
INSERT INTO "tech"."TechID2Param" VALUES ('193', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('194', '12', 'lt6k');
INSERT INTO "tech"."TechID2Param" VALUES ('194', '15', '9.7');
INSERT INTO "tech"."TechID2Param" VALUES ('194', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('195', '12', 'lt6k');
INSERT INTO "tech"."TechID2Param" VALUES ('195', '15', '10.7');
INSERT INTO "tech"."TechID2Param" VALUES ('195', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('196', '12', 'lt6k');
INSERT INTO "tech"."TechID2Param" VALUES ('196', '15', '10.7');
INSERT INTO "tech"."TechID2Param" VALUES ('196', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('197', '12', 'lt6k');
INSERT INTO "tech"."TechID2Param" VALUES ('197', '15', '11.2');
INSERT INTO "tech"."TechID2Param" VALUES ('197', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('198', '12', 'lt6k');
INSERT INTO "tech"."TechID2Param" VALUES ('198', '15', '11.2');
INSERT INTO "tech"."TechID2Param" VALUES ('198', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('199', '12', 'lt6k');
INSERT INTO "tech"."TechID2Param" VALUES ('199', '15', '11.6');
INSERT INTO "tech"."TechID2Param" VALUES ('199', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('200', '12', 'lt6k');
INSERT INTO "tech"."TechID2Param" VALUES ('200', '15', '11.6');
INSERT INTO "tech"."TechID2Param" VALUES ('200', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('201', '12', '6to8k');
INSERT INTO "tech"."TechID2Param" VALUES ('201', '15', '9.7');
INSERT INTO "tech"."TechID2Param" VALUES ('201', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('202', '12', '6to8k');
INSERT INTO "tech"."TechID2Param" VALUES ('202', '15', '9.7');
INSERT INTO "tech"."TechID2Param" VALUES ('202', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('203', '12', '6to8k');
INSERT INTO "tech"."TechID2Param" VALUES ('203', '15', '10.7');
INSERT INTO "tech"."TechID2Param" VALUES ('203', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('204', '12', '6to8k');
INSERT INTO "tech"."TechID2Param" VALUES ('204', '15', '10.7');
INSERT INTO "tech"."TechID2Param" VALUES ('204', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('205', '12', '6to8k');
INSERT INTO "tech"."TechID2Param" VALUES ('205', '15', '11.2');
INSERT INTO "tech"."TechID2Param" VALUES ('205', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('206', '12', '6to8k');
INSERT INTO "tech"."TechID2Param" VALUES ('206', '15', '11.2');
INSERT INTO "tech"."TechID2Param" VALUES ('206', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('207', '12', '6to8k');
INSERT INTO "tech"."TechID2Param" VALUES ('207', '15', '11.6');
INSERT INTO "tech"."TechID2Param" VALUES ('207', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('208', '12', '6to8k');
INSERT INTO "tech"."TechID2Param" VALUES ('208', '15', '11.6');
INSERT INTO "tech"."TechID2Param" VALUES ('208', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('209', '12', '8to14k');
INSERT INTO "tech"."TechID2Param" VALUES ('209', '15', '9.8');
INSERT INTO "tech"."TechID2Param" VALUES ('209', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('210', '12', '8to14k');
INSERT INTO "tech"."TechID2Param" VALUES ('210', '15', '9.8');
INSERT INTO "tech"."TechID2Param" VALUES ('210', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('211', '12', '8to14k');
INSERT INTO "tech"."TechID2Param" VALUES ('211', '15', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('211', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('212', '12', '8to14k');
INSERT INTO "tech"."TechID2Param" VALUES ('212', '15', '10.8');
INSERT INTO "tech"."TechID2Param" VALUES ('212', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('213', '12', '8to14k');
INSERT INTO "tech"."TechID2Param" VALUES ('213', '15', '11.3');
INSERT INTO "tech"."TechID2Param" VALUES ('213', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('214', '12', '8to14k');
INSERT INTO "tech"."TechID2Param" VALUES ('214', '15', '11.3');
INSERT INTO "tech"."TechID2Param" VALUES ('214', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('215', '12', '8to14k');
INSERT INTO "tech"."TechID2Param" VALUES ('215', '15', '11.8');
INSERT INTO "tech"."TechID2Param" VALUES ('215', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('216', '12', '8to14k');
INSERT INTO "tech"."TechID2Param" VALUES ('216', '15', '11.8');
INSERT INTO "tech"."TechID2Param" VALUES ('216', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('217', '12', '14to20k');
INSERT INTO "tech"."TechID2Param" VALUES ('217', '15', '9.7');
INSERT INTO "tech"."TechID2Param" VALUES ('217', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('218', '12', '14to20k');
INSERT INTO "tech"."TechID2Param" VALUES ('218', '15', '9.7');
INSERT INTO "tech"."TechID2Param" VALUES ('218', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('219', '12', '14to20k');
INSERT INTO "tech"."TechID2Param" VALUES ('219', '15', '10.7');
INSERT INTO "tech"."TechID2Param" VALUES ('219', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('220', '12', '14to20k');
INSERT INTO "tech"."TechID2Param" VALUES ('220', '15', '10.7');
INSERT INTO "tech"."TechID2Param" VALUES ('220', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('221', '12', '14to20k');
INSERT INTO "tech"."TechID2Param" VALUES ('221', '15', '11.2');
INSERT INTO "tech"."TechID2Param" VALUES ('221', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('222', '12', '14to20k');
INSERT INTO "tech"."TechID2Param" VALUES ('222', '15', '11.2');
INSERT INTO "tech"."TechID2Param" VALUES ('222', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('223', '12', '14to20k');
INSERT INTO "tech"."TechID2Param" VALUES ('223', '15', '11.6');
INSERT INTO "tech"."TechID2Param" VALUES ('223', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('224', '12', '14to20k');
INSERT INTO "tech"."TechID2Param" VALUES ('224', '15', '11.6');
INSERT INTO "tech"."TechID2Param" VALUES ('224', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('225', '12', 'gt20k');
INSERT INTO "tech"."TechID2Param" VALUES ('225', '15', '8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('225', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('226', '12', 'gt20k');
INSERT INTO "tech"."TechID2Param" VALUES ('226', '15', '8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('226', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('227', '12', 'gt20k');
INSERT INTO "tech"."TechID2Param" VALUES ('227', '15', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('227', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('228', '12', 'gt20k');
INSERT INTO "tech"."TechID2Param" VALUES ('228', '15', '9.4');
INSERT INTO "tech"."TechID2Param" VALUES ('228', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('229', '12', 'gt20k');
INSERT INTO "tech"."TechID2Param" VALUES ('229', '15', '9.8');
INSERT INTO "tech"."TechID2Param" VALUES ('229', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('230', '12', 'gt20k');
INSERT INTO "tech"."TechID2Param" VALUES ('230', '15', '9.8');
INSERT INTO "tech"."TechID2Param" VALUES ('230', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('231', '12', 'gt20k');
INSERT INTO "tech"."TechID2Param" VALUES ('231', '15', '10.2');
INSERT INTO "tech"."TechID2Param" VALUES ('231', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('232', '12', 'gt20k');
INSERT INTO "tech"."TechID2Param" VALUES ('232', '15', '10.2');
INSERT INTO "tech"."TechID2Param" VALUES ('232', '21', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('233', '12', 'lt7k');
INSERT INTO "tech"."TechID2Param" VALUES ('233', '15', '8.88');
INSERT INTO "tech"."TechID2Param" VALUES ('233', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('234', '12', 'lt7k');
INSERT INTO "tech"."TechID2Param" VALUES ('234', '15', '11.009');
INSERT INTO "tech"."TechID2Param" VALUES ('234', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('235', '12', 'lt7k');
INSERT INTO "tech"."TechID2Param" VALUES ('235', '15', '13.2108');
INSERT INTO "tech"."TechID2Param" VALUES ('235', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('236', '12', '7to15k');
INSERT INTO "tech"."TechID2Param" VALUES ('236', '15', '8.24');
INSERT INTO "tech"."TechID2Param" VALUES ('236', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('237', '12', '7to15k');
INSERT INTO "tech"."TechID2Param" VALUES ('237', '15', '10.157');
INSERT INTO "tech"."TechID2Param" VALUES ('237', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('238', '12', '7to15k');
INSERT INTO "tech"."TechID2Param" VALUES ('238', '15', '12.1884');
INSERT INTO "tech"."TechID2Param" VALUES ('238', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('239', '12', 'gt15k');
INSERT INTO "tech"."TechID2Param" VALUES ('239', '15', '7.6');
INSERT INTO "tech"."TechID2Param" VALUES ('239', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('240', '12', 'gt15k');
INSERT INTO "tech"."TechID2Param" VALUES ('240', '15', '9.305');
INSERT INTO "tech"."TechID2Param" VALUES ('240', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('241', '12', 'gt15k');
INSERT INTO "tech"."TechID2Param" VALUES ('241', '15', '11.166');
INSERT INTO "tech"."TechID2Param" VALUES ('241', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('242', '12', 'lt7k');
INSERT INTO "tech"."TechID2Param" VALUES ('242', '15', '8.88');
INSERT INTO "tech"."TechID2Param" VALUES ('242', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('243', '12', 'lt7k');
INSERT INTO "tech"."TechID2Param" VALUES ('243', '15', '9.409');
INSERT INTO "tech"."TechID2Param" VALUES ('243', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('244', '12', 'lt7k');
INSERT INTO "tech"."TechID2Param" VALUES ('244', '15', '11.2908');
INSERT INTO "tech"."TechID2Param" VALUES ('244', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('245', '12', '7to15k');
INSERT INTO "tech"."TechID2Param" VALUES ('245', '15', '8.24');
INSERT INTO "tech"."TechID2Param" VALUES ('245', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('246', '12', '7to15k');
INSERT INTO "tech"."TechID2Param" VALUES ('246', '15', '8.557');
INSERT INTO "tech"."TechID2Param" VALUES ('246', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('247', '12', '7to15k');
INSERT INTO "tech"."TechID2Param" VALUES ('247', '15', '10.2684');
INSERT INTO "tech"."TechID2Param" VALUES ('247', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('248', '12', 'gt15k');
INSERT INTO "tech"."TechID2Param" VALUES ('248', '15', '7.6');
INSERT INTO "tech"."TechID2Param" VALUES ('248', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('249', '12', 'gt15k');
INSERT INTO "tech"."TechID2Param" VALUES ('249', '15', '7.705');
INSERT INTO "tech"."TechID2Param" VALUES ('249', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('250', '12', 'gt15k');
INSERT INTO "tech"."TechID2Param" VALUES ('250', '15', '9.246');
INSERT INTO "tech"."TechID2Param" VALUES ('250', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('251', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('251', '31', '4.6');
INSERT INTO "tech"."TechID2Param" VALUES ('251', '66', '8.3');
INSERT INTO "tech"."TechID2Param" VALUES ('251', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('251', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('252', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('252', '31', '5.6');
INSERT INTO "tech"."TechID2Param" VALUES ('252', '66', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('252', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('252', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('253', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('253', '31', '6.6');
INSERT INTO "tech"."TechID2Param" VALUES ('253', '66', '9.7');
INSERT INTO "tech"."TechID2Param" VALUES ('253', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('253', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('254', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('254', '31', '6.8');
INSERT INTO "tech"."TechID2Param" VALUES ('254', '66', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('254', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('254', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('255', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('255', '31', '7.4');
INSERT INTO "tech"."TechID2Param" VALUES ('255', '66', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('255', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('255', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('256', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('256', '31', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('256', '66', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('256', '99', '');
INSERT INTO "tech"."TechID2Param" VALUES ('256', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('257', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('257', '31', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('257', '66', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('257', '99', '11.6');
INSERT INTO "tech"."TechID2Param" VALUES ('257', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('258', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('258', '31', '');
INSERT INTO "tech"."TechID2Param" VALUES ('258', '66', '14.5');
INSERT INTO "tech"."TechID2Param" VALUES ('258', '99', '11.8');
INSERT INTO "tech"."TechID2Param" VALUES ('258', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('259', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('259', '31', '');
INSERT INTO "tech"."TechID2Param" VALUES ('259', '66', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('259', '99', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('259', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('260', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('260', '15', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('260', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('260', '100', '2.25');
INSERT INTO "tech"."TechID2Param" VALUES ('260', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('261', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('261', '15', '8.9');
INSERT INTO "tech"."TechID2Param" VALUES ('261', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('261', '100', '2.6');
INSERT INTO "tech"."TechID2Param" VALUES ('261', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('262', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('262', '15', '8.9');
INSERT INTO "tech"."TechID2Param" VALUES ('262', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('262', '100', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('262', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('263', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('263', '15', '10.1');
INSERT INTO "tech"."TechID2Param" VALUES ('263', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('263', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('263', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('264', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('264', '15', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('264', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('264', '100', '3.3');
INSERT INTO "tech"."TechID2Param" VALUES ('264', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('265', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('265', '15', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('265', '81', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('265', '100', '3.4');
INSERT INTO "tech"."TechID2Param" VALUES ('265', '101', '2.4');
INSERT INTO "tech"."TechID2Param" VALUES ('266', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('266', '15', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('266', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('266', '100', '2.25');
INSERT INTO "tech"."TechID2Param" VALUES ('266', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('267', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('267', '15', '8.9');
INSERT INTO "tech"."TechID2Param" VALUES ('267', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('267', '100', '2.6');
INSERT INTO "tech"."TechID2Param" VALUES ('267', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('268', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('268', '15', '8.9');
INSERT INTO "tech"."TechID2Param" VALUES ('268', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('268', '100', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('268', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('269', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('269', '15', '10.1');
INSERT INTO "tech"."TechID2Param" VALUES ('269', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('269', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('269', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('270', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('270', '15', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('270', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('270', '100', '3.3');
INSERT INTO "tech"."TechID2Param" VALUES ('270', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('271', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('271', '15', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('271', '81', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('271', '100', '3.4');
INSERT INTO "tech"."TechID2Param" VALUES ('271', '101', '2.4');
INSERT INTO "tech"."TechID2Param" VALUES ('272', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('272', '15', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('272', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('272', '100', '2.25');
INSERT INTO "tech"."TechID2Param" VALUES ('272', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('273', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('273', '15', '8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('273', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('273', '100', '2.6');
INSERT INTO "tech"."TechID2Param" VALUES ('273', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('274', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('274', '15', '8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('274', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('274', '100', '2.9');
INSERT INTO "tech"."TechID2Param" VALUES ('274', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('275', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('275', '15', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('275', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('275', '100', '3.1');
INSERT INTO "tech"."TechID2Param" VALUES ('275', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('276', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('276', '15', '10.6');
INSERT INTO "tech"."TechID2Param" VALUES ('276', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('276', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('276', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('277', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('277', '15', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('277', '81', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('277', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('277', '101', '2.1');
INSERT INTO "tech"."TechID2Param" VALUES ('278', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('278', '15', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('278', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('278', '100', '2.25');
INSERT INTO "tech"."TechID2Param" VALUES ('278', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('279', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('279', '15', '8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('279', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('279', '100', '2.6');
INSERT INTO "tech"."TechID2Param" VALUES ('279', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('280', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('280', '15', '8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('280', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('280', '100', '2.9');
INSERT INTO "tech"."TechID2Param" VALUES ('280', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('281', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('281', '15', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('281', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('281', '100', '3.1');
INSERT INTO "tech"."TechID2Param" VALUES ('281', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('282', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('282', '15', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('282', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('282', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('282', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('283', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('283', '15', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('283', '81', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('283', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('283', '101', '2.1');
INSERT INTO "tech"."TechID2Param" VALUES ('284', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('284', '15', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('284', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('284', '100', '2.25');
INSERT INTO "tech"."TechID2Param" VALUES ('284', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('285', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('285', '15', '8.2');
INSERT INTO "tech"."TechID2Param" VALUES ('285', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('285', '100', '2.6');
INSERT INTO "tech"."TechID2Param" VALUES ('285', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('286', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('286', '15', '8.2');
INSERT INTO "tech"."TechID2Param" VALUES ('286', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('286', '100', '2.9');
INSERT INTO "tech"."TechID2Param" VALUES ('286', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('287', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('287', '15', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('287', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('287', '100', '3.1');
INSERT INTO "tech"."TechID2Param" VALUES ('287', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('288', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('288', '15', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('288', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('288', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('288', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('289', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('289', '15', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('289', '81', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('289', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('289', '101', '2.1');
INSERT INTO "tech"."TechID2Param" VALUES ('290', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('290', '31', '4.7');
INSERT INTO "tech"."TechID2Param" VALUES ('290', '66', '8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('290', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('290', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('291', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('291', '31', '5.7');
INSERT INTO "tech"."TechID2Param" VALUES ('291', '66', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('291', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('291', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('292', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('292', '31', '6.8');
INSERT INTO "tech"."TechID2Param" VALUES ('292', '66', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('292', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('292', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('293', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('293', '31', '7.4');
INSERT INTO "tech"."TechID2Param" VALUES ('293', '66', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('293', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('293', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('294', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('294', '31', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('294', '66', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('294', '97', '');
INSERT INTO "tech"."TechID2Param" VALUES ('294', '102', '');
INSERT INTO "tech"."TechID2Param" VALUES ('295', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('295', '31', 'ge8.6');
INSERT INTO "tech"."TechID2Param" VALUES ('295', '66', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('295', '97', 'gt12.19');
INSERT INTO "tech"."TechID2Param" VALUES ('295', '102', 'ge3.52');
INSERT INTO "tech"."TechID2Param" VALUES ('296', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('296', '31', 'ge8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('296', '66', '14.5');
INSERT INTO "tech"."TechID2Param" VALUES ('296', '97', 'gt12.0');
INSERT INTO "tech"."TechID2Param" VALUES ('296', '102', 'ge3.52');
INSERT INTO "tech"."TechID2Param" VALUES ('297', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('297', '31', 'ge8.8');
INSERT INTO "tech"."TechID2Param" VALUES ('297', '66', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('297', '97', 'gt12.7');
INSERT INTO "tech"."TechID2Param" VALUES ('297', '102', 'ge3.74');
INSERT INTO "tech"."TechID2Param" VALUES ('298', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('298', '31', 'ge8.8');
INSERT INTO "tech"."TechID2Param" VALUES ('298', '66', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('298', '97', 'gt12.7');
INSERT INTO "tech"."TechID2Param" VALUES ('298', '102', 'ge3.74');
INSERT INTO "tech"."TechID2Param" VALUES ('299', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('299', '31', 'ge8.8');
INSERT INTO "tech"."TechID2Param" VALUES ('299', '66', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('299', '97', 'gt12.7');
INSERT INTO "tech"."TechID2Param" VALUES ('299', '102', 'ge3.74');
INSERT INTO "tech"."TechID2Param" VALUES ('300', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('300', '31', 'ge8.8');
INSERT INTO "tech"."TechID2Param" VALUES ('300', '66', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('300', '97', 'gt12.7');
INSERT INTO "tech"."TechID2Param" VALUES ('300', '102', 'ge3.74');
INSERT INTO "tech"."TechID2Param" VALUES ('301', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('301', '31', 'ge8.8');
INSERT INTO "tech"."TechID2Param" VALUES ('301', '66', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('301', '97', 'gt12.7');
INSERT INTO "tech"."TechID2Param" VALUES ('301', '102', 'ge3.74');
INSERT INTO "tech"."TechID2Param" VALUES ('302', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('302', '31', 'ge8.8');
INSERT INTO "tech"."TechID2Param" VALUES ('302', '66', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('302', '97', 'gt12.7');
INSERT INTO "tech"."TechID2Param" VALUES ('302', '102', 'ge3.74');
INSERT INTO "tech"."TechID2Param" VALUES ('303', '12', 'lt65k');
INSERT INTO "tech"."TechID2Param" VALUES ('303', '31', 'ge8.8');
INSERT INTO "tech"."TechID2Param" VALUES ('303', '66', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('303', '97', 'gt12.7');
INSERT INTO "tech"."TechID2Param" VALUES ('303', '102', 'ge3.74');
INSERT INTO "tech"."TechID2Param" VALUES ('304', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('304', '15', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('304', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('304', '100', '2.25');
INSERT INTO "tech"."TechID2Param" VALUES ('304', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('305', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('305', '15', '8.9');
INSERT INTO "tech"."TechID2Param" VALUES ('305', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('305', '100', '2.6');
INSERT INTO "tech"."TechID2Param" VALUES ('305', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('306', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('306', '15', '8.9');
INSERT INTO "tech"."TechID2Param" VALUES ('306', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('306', '100', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('306', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('307', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('307', '15', '10.1');
INSERT INTO "tech"."TechID2Param" VALUES ('307', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('307', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('307', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('308', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('308', '15', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('308', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('308', '100', '3.3');
INSERT INTO "tech"."TechID2Param" VALUES ('308', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('309', '12', '65to75k');
INSERT INTO "tech"."TechID2Param" VALUES ('309', '15', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('309', '81', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('309', '100', '3.4');
INSERT INTO "tech"."TechID2Param" VALUES ('309', '101', '2.4');
INSERT INTO "tech"."TechID2Param" VALUES ('310', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('310', '15', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('310', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('310', '100', '2.25');
INSERT INTO "tech"."TechID2Param" VALUES ('310', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('311', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('311', '15', '8.9');
INSERT INTO "tech"."TechID2Param" VALUES ('311', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('311', '100', '2.6');
INSERT INTO "tech"."TechID2Param" VALUES ('311', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('312', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('312', '15', '8.9');
INSERT INTO "tech"."TechID2Param" VALUES ('312', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('312', '100', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('312', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('313', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('313', '15', '10.1');
INSERT INTO "tech"."TechID2Param" VALUES ('313', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('313', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('313', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('314', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('314', '15', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('314', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('314', '100', '3.3');
INSERT INTO "tech"."TechID2Param" VALUES ('314', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('315', '12', '76to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('315', '15', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('315', '81', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('315', '100', '3.4');
INSERT INTO "tech"."TechID2Param" VALUES ('315', '101', '2.4');
INSERT INTO "tech"."TechID2Param" VALUES ('316', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('316', '15', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('316', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('316', '100', '2.25');
INSERT INTO "tech"."TechID2Param" VALUES ('316', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('317', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('317', '15', '8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('317', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('317', '100', '2.6');
INSERT INTO "tech"."TechID2Param" VALUES ('317', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('318', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('318', '15', '8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('318', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('318', '100', '2.9');
INSERT INTO "tech"."TechID2Param" VALUES ('318', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('319', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('319', '15', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('319', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('319', '100', '3.1');
INSERT INTO "tech"."TechID2Param" VALUES ('319', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('320', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('320', '15', '10.6');
INSERT INTO "tech"."TechID2Param" VALUES ('320', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('320', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('320', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('321', '12', '135to239k');
INSERT INTO "tech"."TechID2Param" VALUES ('321', '15', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('321', '81', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('321', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('321', '101', '2.1');
INSERT INTO "tech"."TechID2Param" VALUES ('322', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('322', '15', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('322', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('322', '100', '2.25');
INSERT INTO "tech"."TechID2Param" VALUES ('322', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('323', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('323', '15', '8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('323', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('323', '100', '2.6');
INSERT INTO "tech"."TechID2Param" VALUES ('323', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('324', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('324', '15', '8.5');
INSERT INTO "tech"."TechID2Param" VALUES ('324', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('324', '100', '2.9');
INSERT INTO "tech"."TechID2Param" VALUES ('324', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('325', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('325', '15', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('325', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('325', '100', '3.1');
INSERT INTO "tech"."TechID2Param" VALUES ('325', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('326', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('326', '15', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('326', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('326', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('326', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('327', '12', '240to759');
INSERT INTO "tech"."TechID2Param" VALUES ('327', '15', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('327', '81', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('327', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('327', '101', '2.1');
INSERT INTO "tech"."TechID2Param" VALUES ('328', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('328', '15', '7.7');
INSERT INTO "tech"."TechID2Param" VALUES ('328', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('328', '100', '2.25');
INSERT INTO "tech"."TechID2Param" VALUES ('328', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('329', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('329', '15', '8.2');
INSERT INTO "tech"."TechID2Param" VALUES ('329', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('329', '100', '2.6');
INSERT INTO "tech"."TechID2Param" VALUES ('329', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('330', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('330', '15', '8.2');
INSERT INTO "tech"."TechID2Param" VALUES ('330', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('330', '100', '2.9');
INSERT INTO "tech"."TechID2Param" VALUES ('330', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('331', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('331', '15', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('331', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('331', '100', '3.1');
INSERT INTO "tech"."TechID2Param" VALUES ('331', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('332', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('332', '15', '9.5');
INSERT INTO "tech"."TechID2Param" VALUES ('332', '81', '');
INSERT INTO "tech"."TechID2Param" VALUES ('332', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('332', '101', '');
INSERT INTO "tech"."TechID2Param" VALUES ('333', '12', 'gt760k');
INSERT INTO "tech"."TechID2Param" VALUES ('333', '15', '11.5');
INSERT INTO "tech"."TechID2Param" VALUES ('333', '81', '11.9');
INSERT INTO "tech"."TechID2Param" VALUES ('333', '100', '3.2');
INSERT INTO "tech"."TechID2Param" VALUES ('333', '101', '2.1');
INSERT INTO "tech"."TechID2Param" VALUES ('334', '12', 'lt17k');
INSERT INTO "tech"."TechID2Param" VALUES ('334', '15', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('334', '80', '3.3');
INSERT INTO "tech"."TechID2Param" VALUES ('335', '12', 'lt17k');
INSERT INTO "tech"."TechID2Param" VALUES ('335', '15', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('335', '80', '3.8');
INSERT INTO "tech"."TechID2Param" VALUES ('336', '12', 'lt17k');
INSERT INTO "tech"."TechID2Param" VALUES ('336', '15', '11.2');
INSERT INTO "tech"."TechID2Param" VALUES ('336', '80', '4.2');
INSERT INTO "tech"."TechID2Param" VALUES ('337', '12', 'lt17k');
INSERT INTO "tech"."TechID2Param" VALUES ('337', '15', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('337', '80', '4.6');
INSERT INTO "tech"."TechID2Param" VALUES ('338', '12', '17to65k');
INSERT INTO "tech"."TechID2Param" VALUES ('338', '15', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('338', '80', '3.3');
INSERT INTO "tech"."TechID2Param" VALUES ('339', '12', '17to65k');
INSERT INTO "tech"."TechID2Param" VALUES ('339', '15', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('339', '80', '3.8');
INSERT INTO "tech"."TechID2Param" VALUES ('340', '12', '17to65k');
INSERT INTO "tech"."TechID2Param" VALUES ('340', '15', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('340', '80', '4.2');
INSERT INTO "tech"."TechID2Param" VALUES ('341', '12', '17to65k');
INSERT INTO "tech"."TechID2Param" VALUES ('341', '15', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('341', '80', '4.6');
INSERT INTO "tech"."TechID2Param" VALUES ('342', '12', '65to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('342', '15', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('342', '80', '3.3');
INSERT INTO "tech"."TechID2Param" VALUES ('343', '12', '65to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('343', '15', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('343', '80', '3.8');
INSERT INTO "tech"."TechID2Param" VALUES ('344', '12', '65to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('344', '15', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('344', '80', '4.2');
INSERT INTO "tech"."TechID2Param" VALUES ('345', '12', '65to134k');
INSERT INTO "tech"."TechID2Param" VALUES ('345', '15', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('345', '80', '4.6');
INSERT INTO "tech"."TechID2Param" VALUES ('346', '12', 'gt135k');
INSERT INTO "tech"."TechID2Param" VALUES ('346', '15', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('346', '80', '3.3');
INSERT INTO "tech"."TechID2Param" VALUES ('347', '12', 'gt135k');
INSERT INTO "tech"."TechID2Param" VALUES ('347', '15', '9.3');
INSERT INTO "tech"."TechID2Param" VALUES ('347', '80', '3.8');
INSERT INTO "tech"."TechID2Param" VALUES ('348', '12', 'gt135k');
INSERT INTO "tech"."TechID2Param" VALUES ('348', '15', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('348', '80', '4.2');
INSERT INTO "tech"."TechID2Param" VALUES ('349', '12', 'lt7k');
INSERT INTO "tech"."TechID2Param" VALUES ('349', '15', '8.88');
INSERT INTO "tech"."TechID2Param" VALUES ('349', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('349', '80', '2.718');
INSERT INTO "tech"."TechID2Param" VALUES ('350', '12', 'lt7k');
INSERT INTO "tech"."TechID2Param" VALUES ('350', '15', '10.809');
INSERT INTO "tech"."TechID2Param" VALUES ('350', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('350', '80', '3.018');
INSERT INTO "tech"."TechID2Param" VALUES ('351', '12', 'lt7k');
INSERT INTO "tech"."TechID2Param" VALUES ('351', '15', '12.9708');
INSERT INTO "tech"."TechID2Param" VALUES ('351', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('351', '80', '3.6216');
INSERT INTO "tech"."TechID2Param" VALUES ('352', '12', '7to15k');
INSERT INTO "tech"."TechID2Param" VALUES ('352', '15', '8.24');
INSERT INTO "tech"."TechID2Param" VALUES ('352', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('352', '80', '2.614');
INSERT INTO "tech"."TechID2Param" VALUES ('353', '12', '7to15k');
INSERT INTO "tech"."TechID2Param" VALUES ('353', '15', '9.957');
INSERT INTO "tech"."TechID2Param" VALUES ('353', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('353', '80', '2.914');
INSERT INTO "tech"."TechID2Param" VALUES ('354', '12', '7to15k');
INSERT INTO "tech"."TechID2Param" VALUES ('354', '15', '11.9484');
INSERT INTO "tech"."TechID2Param" VALUES ('354', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('354', '80', '3.4968');
INSERT INTO "tech"."TechID2Param" VALUES ('355', '12', 'gt15k');
INSERT INTO "tech"."TechID2Param" VALUES ('355', '15', '7.6');
INSERT INTO "tech"."TechID2Param" VALUES ('355', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('355', '80', '2.51');
INSERT INTO "tech"."TechID2Param" VALUES ('356', '12', 'gt15k');
INSERT INTO "tech"."TechID2Param" VALUES ('356', '15', '9.105');
INSERT INTO "tech"."TechID2Param" VALUES ('356', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('356', '80', '2.81');
INSERT INTO "tech"."TechID2Param" VALUES ('357', '12', 'gt15k');
INSERT INTO "tech"."TechID2Param" VALUES ('357', '15', '10.926');
INSERT INTO "tech"."TechID2Param" VALUES ('357', '64', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('357', '80', '3.372');
INSERT INTO "tech"."TechID2Param" VALUES ('358', '12', 'lt7k');
INSERT INTO "tech"."TechID2Param" VALUES ('358', '15', '8.88');
INSERT INTO "tech"."TechID2Param" VALUES ('358', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('358', '80', '2.718');
INSERT INTO "tech"."TechID2Param" VALUES ('359', '12', 'lt7k');
INSERT INTO "tech"."TechID2Param" VALUES ('359', '15', '9.309');
INSERT INTO "tech"."TechID2Param" VALUES ('359', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('359', '80', '2.718');
INSERT INTO "tech"."TechID2Param" VALUES ('360', '12', 'lt7k');
INSERT INTO "tech"."TechID2Param" VALUES ('360', '15', '11.1708');
INSERT INTO "tech"."TechID2Param" VALUES ('360', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('360', '80', '3.2616');
INSERT INTO "tech"."TechID2Param" VALUES ('361', '12', '7to15k');
INSERT INTO "tech"."TechID2Param" VALUES ('361', '15', '8.24');
INSERT INTO "tech"."TechID2Param" VALUES ('361', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('361', '80', '2.614');
INSERT INTO "tech"."TechID2Param" VALUES ('362', '12', '7to15k');
INSERT INTO "tech"."TechID2Param" VALUES ('362', '15', '8.457');
INSERT INTO "tech"."TechID2Param" VALUES ('362', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('362', '80', '2.614');
INSERT INTO "tech"."TechID2Param" VALUES ('363', '12', '7to15k');
INSERT INTO "tech"."TechID2Param" VALUES ('363', '15', '10.1484');
INSERT INTO "tech"."TechID2Param" VALUES ('363', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('363', '80', '3.1368');
INSERT INTO "tech"."TechID2Param" VALUES ('364', '12', 'gt15k');
INSERT INTO "tech"."TechID2Param" VALUES ('364', '15', '7.6');
INSERT INTO "tech"."TechID2Param" VALUES ('364', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('364', '80', '2.51');
INSERT INTO "tech"."TechID2Param" VALUES ('365', '12', 'gt15k');
INSERT INTO "tech"."TechID2Param" VALUES ('365', '15', '7.605');
INSERT INTO "tech"."TechID2Param" VALUES ('365', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('365', '80', '2.51');
INSERT INTO "tech"."TechID2Param" VALUES ('366', '12', 'gt15k');
INSERT INTO "tech"."TechID2Param" VALUES ('366', '15', '9.126');
INSERT INTO "tech"."TechID2Param" VALUES ('366', '64', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('366', '80', '3.012');
INSERT INTO "tech"."TechID2Param" VALUES ('367', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('367', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('367', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('367', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('367', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('367', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('368', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('368', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('368', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('368', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('368', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('368', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('369', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('369', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('369', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('369', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('369', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('369', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('370', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('370', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('370', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('370', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('370', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('370', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('371', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('371', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('371', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('371', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('371', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('371', '75', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('372', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('372', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('372', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('372', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('372', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('372', '75', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('373', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('373', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('373', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('373', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('373', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('373', '75', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('374', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('374', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('374', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('374', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('374', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('374', '75', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('375', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('375', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('375', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('375', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('375', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('375', '75', '0.56');
INSERT INTO "tech"."TechID2Param" VALUES ('376', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('376', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('376', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('376', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('376', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('376', '75', '0.56');
INSERT INTO "tech"."TechID2Param" VALUES ('377', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('377', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('377', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('377', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('377', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('377', '75', '0.56');
INSERT INTO "tech"."TechID2Param" VALUES ('378', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('378', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('378', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('378', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('378', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('378', '75', '0.56');
INSERT INTO "tech"."TechID2Param" VALUES ('379', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('379', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('379', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('379', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('379', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('379', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('380', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('380', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('380', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('380', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('380', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('380', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('381', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('381', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('381', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('381', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('381', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('381', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('382', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('382', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('382', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('382', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('382', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('382', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('383', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('383', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('383', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('383', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('383', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('383', '75', '0.634');
INSERT INTO "tech"."TechID2Param" VALUES ('384', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('384', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('384', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('384', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('384', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('384', '75', '0.634');
INSERT INTO "tech"."TechID2Param" VALUES ('385', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('385', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('385', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('385', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('385', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('385', '75', '0.634');
INSERT INTO "tech"."TechID2Param" VALUES ('386', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('386', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('386', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('386', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('386', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('386', '75', '0.634');
INSERT INTO "tech"."TechID2Param" VALUES ('387', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('387', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('387', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('387', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('387', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('387', '75', '0.5072');
INSERT INTO "tech"."TechID2Param" VALUES ('388', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('388', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('388', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('388', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('388', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('388', '75', '0.5072');
INSERT INTO "tech"."TechID2Param" VALUES ('389', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('389', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('389', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('389', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('389', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('389', '75', '0.5072');
INSERT INTO "tech"."TechID2Param" VALUES ('390', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('390', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('390', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('390', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('390', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('390', '75', '0.5072');
INSERT INTO "tech"."TechID2Param" VALUES ('391', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('391', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('391', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('391', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('391', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('391', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('392', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('392', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('392', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('392', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('392', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('392', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('393', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('393', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('393', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('393', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('393', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('393', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('394', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('394', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('394', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('394', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('394', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('394', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('395', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('395', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('395', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('395', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('395', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('395', '75', '0.576');
INSERT INTO "tech"."TechID2Param" VALUES ('396', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('396', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('396', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('396', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('396', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('396', '75', '0.576');
INSERT INTO "tech"."TechID2Param" VALUES ('397', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('397', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('397', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('397', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('397', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('397', '75', '0.576');
INSERT INTO "tech"."TechID2Param" VALUES ('398', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('398', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('398', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('398', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('398', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('398', '75', '0.576');
INSERT INTO "tech"."TechID2Param" VALUES ('399', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('399', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('399', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('399', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('399', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('399', '75', '0.4608');
INSERT INTO "tech"."TechID2Param" VALUES ('400', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('400', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('400', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('400', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('400', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('400', '75', '0.4608');
INSERT INTO "tech"."TechID2Param" VALUES ('401', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('401', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('401', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('401', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('401', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('401', '75', '0.4608');
INSERT INTO "tech"."TechID2Param" VALUES ('402', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('402', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('402', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('402', '63', '');
INSERT INTO "tech"."TechID2Param" VALUES ('402', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('402', '75', '0.4608');
INSERT INTO "tech"."TechID2Param" VALUES ('403', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('403', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('403', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('403', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('403', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('404', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('404', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('404', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('404', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('404', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('405', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('405', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('405', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('405', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('405', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('406', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('406', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('406', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('406', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('406', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('407', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('407', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('407', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('407', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('407', '75', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('408', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('408', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('408', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('408', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('408', '75', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('409', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('409', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('409', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('409', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('409', '75', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('410', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('410', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('410', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('410', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('410', '75', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('411', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('411', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('411', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('411', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('411', '75', '0.56');
INSERT INTO "tech"."TechID2Param" VALUES ('412', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('412', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('412', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('412', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('412', '75', '0.56');
INSERT INTO "tech"."TechID2Param" VALUES ('413', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('413', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('413', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('413', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('413', '75', '0.56');
INSERT INTO "tech"."TechID2Param" VALUES ('414', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('414', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('414', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('414', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('414', '75', '0.56');
INSERT INTO "tech"."TechID2Param" VALUES ('415', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('415', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('415', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('415', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('415', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('416', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('416', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('416', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('416', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('416', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('417', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('417', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('417', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('417', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('417', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('418', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('418', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('418', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('418', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('418', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('419', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('419', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('419', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('419', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('419', '75', '0.634');
INSERT INTO "tech"."TechID2Param" VALUES ('420', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('420', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('420', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('420', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('420', '75', '0.634');
INSERT INTO "tech"."TechID2Param" VALUES ('421', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('421', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('421', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('421', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('421', '75', '0.634');
INSERT INTO "tech"."TechID2Param" VALUES ('422', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('422', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('422', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('422', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('422', '75', '0.634');
INSERT INTO "tech"."TechID2Param" VALUES ('423', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('423', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('423', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('423', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('423', '75', '0.5072');
INSERT INTO "tech"."TechID2Param" VALUES ('424', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('424', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('424', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('424', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('424', '75', '0.5072');
INSERT INTO "tech"."TechID2Param" VALUES ('425', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('425', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('425', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('425', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('425', '75', '0.5072');
INSERT INTO "tech"."TechID2Param" VALUES ('426', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('426', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('426', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('426', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('426', '75', '0.5072');
INSERT INTO "tech"."TechID2Param" VALUES ('427', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('427', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('427', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('427', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('427', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('428', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('428', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('428', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('428', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('428', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('429', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('429', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('429', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('429', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('429', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('430', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('430', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('430', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('430', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('430', '75', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('431', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('431', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('431', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('431', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('431', '75', '0.576');
INSERT INTO "tech"."TechID2Param" VALUES ('432', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('432', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('432', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('432', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('432', '75', '0.576');
INSERT INTO "tech"."TechID2Param" VALUES ('433', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('433', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('433', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('433', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('433', '75', '0.576');
INSERT INTO "tech"."TechID2Param" VALUES ('434', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('434', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('434', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('434', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('434', '75', '0.576');
INSERT INTO "tech"."TechID2Param" VALUES ('435', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('435', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('435', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('435', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('435', '75', '0.4608');
INSERT INTO "tech"."TechID2Param" VALUES ('436', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('436', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('436', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('436', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('436', '75', '0.4608');
INSERT INTO "tech"."TechID2Param" VALUES ('437', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('437', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('437', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('437', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('437', '75', '0.4608');
INSERT INTO "tech"."TechID2Param" VALUES ('438', '6', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('438', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('438', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('438', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('438', '75', '0.4608');
INSERT INTO "tech"."TechID2Param" VALUES ('439', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('439', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('439', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('439', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('439', '75', '1.30259215839521');
INSERT INTO "tech"."TechID2Param" VALUES ('440', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('440', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('440', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('440', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('440', '75', '1.30259215839521');
INSERT INTO "tech"."TechID2Param" VALUES ('441', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('441', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('441', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('441', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('441', '75', '1.25607100988109');
INSERT INTO "tech"."TechID2Param" VALUES ('442', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('442', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('442', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('442', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('442', '75', '1.25607100988109');
INSERT INTO "tech"."TechID2Param" VALUES ('443', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('443', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('443', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('443', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('443', '75', '1.00485680790487');
INSERT INTO "tech"."TechID2Param" VALUES ('444', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('444', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('444', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('444', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('444', '75', '1.00485680790487');
INSERT INTO "tech"."TechID2Param" VALUES ('445', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('445', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('445', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('445', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('445', '75', '1.30259215839521');
INSERT INTO "tech"."TechID2Param" VALUES ('446', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('446', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('446', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('446', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('446', '75', '1.30259215839521');
INSERT INTO "tech"."TechID2Param" VALUES ('447', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('447', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('447', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('447', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('447', '75', '1.25607100988109');
INSERT INTO "tech"."TechID2Param" VALUES ('448', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('448', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('448', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('448', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('448', '75', '1.25607100988109');
INSERT INTO "tech"."TechID2Param" VALUES ('449', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('449', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('449', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('449', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('449', '75', '1.00485680790487');
INSERT INTO "tech"."TechID2Param" VALUES ('450', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('450', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('450', '13', '150to300t');
INSERT INTO "tech"."TechID2Param" VALUES ('450', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('450', '75', '1.00485680790487');
INSERT INTO "tech"."TechID2Param" VALUES ('451', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('451', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('451', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('451', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('451', '75', '1.30259215839521');
INSERT INTO "tech"."TechID2Param" VALUES ('452', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('452', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('452', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('452', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('452', '75', '1.30259215839521');
INSERT INTO "tech"."TechID2Param" VALUES ('453', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('453', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('453', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('453', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('453', '75', '1.25607100988109');
INSERT INTO "tech"."TechID2Param" VALUES ('454', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('454', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('454', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('454', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('454', '75', '1.25607100988109');
INSERT INTO "tech"."TechID2Param" VALUES ('455', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('455', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('455', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('455', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('455', '75', '1.00485680790487');
INSERT INTO "tech"."TechID2Param" VALUES ('456', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('456', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('456', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('456', '74', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('456', '75', '1.00485680790487');
INSERT INTO "tech"."TechID2Param" VALUES ('457', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('457', '13', 'ALL');
INSERT INTO "tech"."TechID2Param" VALUES ('457', '75', '1.008');
INSERT INTO "tech"."TechID2Param" VALUES ('458', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('458', '13', 'ALL');
INSERT INTO "tech"."TechID2Param" VALUES ('458', '75', '1.26');
INSERT INTO "tech"."TechID2Param" VALUES ('459', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('459', '13', 'ALL');
INSERT INTO "tech"."TechID2Param" VALUES ('459', '75', '0.672');
INSERT INTO "tech"."TechID2Param" VALUES ('460', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('460', '13', 'ALL');
INSERT INTO "tech"."TechID2Param" VALUES ('460', '75', '0.837');
INSERT INTO "tech"."TechID2Param" VALUES ('461', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('461', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('461', '13', 'ALL');
INSERT INTO "tech"."TechID2Param" VALUES ('461', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('461', '75', '1.008');
INSERT INTO "tech"."TechID2Param" VALUES ('462', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('462', '7', 'Air');
INSERT INTO "tech"."TechID2Param" VALUES ('462', '13', 'ALL');
INSERT INTO "tech"."TechID2Param" VALUES ('462', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('462', '75', '1.26');
INSERT INTO "tech"."TechID2Param" VALUES ('463', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('463', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('463', '13', '150to299t');
INSERT INTO "tech"."TechID2Param" VALUES ('463', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('463', '75', '0.574');
INSERT INTO "tech"."TechID2Param" VALUES ('464', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('464', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('464', '13', '150to299t');
INSERT INTO "tech"."TechID2Param" VALUES ('464', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('464', '75', '0.718');
INSERT INTO "tech"."TechID2Param" VALUES ('465', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('465', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('465', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('465', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('465', '75', '0.511');
INSERT INTO "tech"."TechID2Param" VALUES ('466', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('466', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('466', '13', 'ge300t');
INSERT INTO "tech"."TechID2Param" VALUES ('466', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('466', '75', '0.639');
INSERT INTO "tech"."TechID2Param" VALUES ('467', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('467', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('467', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('467', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('467', '75', '0.632');
INSERT INTO "tech"."TechID2Param" VALUES ('468', '6', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('468', '7', 'Water');
INSERT INTO "tech"."TechID2Param" VALUES ('468', '13', 'lt150t');
INSERT INTO "tech"."TechID2Param" VALUES ('468', '74', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('468', '75', '0.79');
INSERT INTO "tech"."TechID2Param" VALUES ('469', '44', 'Fixed');
INSERT INTO "tech"."TechID2Param" VALUES ('469', '48', 'lt2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('469', '57', 'Constant');
INSERT INTO "tech"."TechID2Param" VALUES ('469', '73', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('469', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('470', '44', 'OA Reset');
INSERT INTO "tech"."TechID2Param" VALUES ('470', '48', 'lt2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('470', '57', 'Constant');
INSERT INTO "tech"."TechID2Param" VALUES ('470', '73', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('470', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('471', '44', 'Load Reset');
INSERT INTO "tech"."TechID2Param" VALUES ('471', '48', 'lt2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('471', '57', 'Constant');
INSERT INTO "tech"."TechID2Param" VALUES ('471', '73', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('471', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('472', '44', 'Fixed');
INSERT INTO "tech"."TechID2Param" VALUES ('472', '48', 'ge2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('472', '57', 'Constant');
INSERT INTO "tech"."TechID2Param" VALUES ('472', '73', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('472', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('473', '44', 'OA Reset');
INSERT INTO "tech"."TechID2Param" VALUES ('473', '48', 'ge2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('473', '57', 'Constant');
INSERT INTO "tech"."TechID2Param" VALUES ('473', '73', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('473', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('474', '44', 'Load Reset');
INSERT INTO "tech"."TechID2Param" VALUES ('474', '48', 'ge2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('474', '57', 'Constant');
INSERT INTO "tech"."TechID2Param" VALUES ('474', '73', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('474', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('475', '44', 'Fixed');
INSERT INTO "tech"."TechID2Param" VALUES ('475', '48', 'lt2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('475', '57', 'RideCurve');
INSERT INTO "tech"."TechID2Param" VALUES ('475', '73', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('475', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('476', '44', 'OA Reset');
INSERT INTO "tech"."TechID2Param" VALUES ('476', '48', 'lt2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('476', '57', 'RideCurve');
INSERT INTO "tech"."TechID2Param" VALUES ('476', '73', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('476', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('477', '44', 'Load Reset');
INSERT INTO "tech"."TechID2Param" VALUES ('477', '48', 'lt2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('477', '57', 'RideCurve');
INSERT INTO "tech"."TechID2Param" VALUES ('477', '73', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('477', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('478', '44', 'Fixed');
INSERT INTO "tech"."TechID2Param" VALUES ('478', '48', 'ge2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('478', '57', 'RideCurve');
INSERT INTO "tech"."TechID2Param" VALUES ('478', '73', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('478', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('479', '44', 'OA Reset');
INSERT INTO "tech"."TechID2Param" VALUES ('479', '48', 'ge2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('479', '57', 'RideCurve');
INSERT INTO "tech"."TechID2Param" VALUES ('479', '73', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('479', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('480', '44', 'Load Reset');
INSERT INTO "tech"."TechID2Param" VALUES ('480', '48', 'ge2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('480', '57', 'RideCurve');
INSERT INTO "tech"."TechID2Param" VALUES ('480', '73', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('480', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('481', '44', 'Fixed');
INSERT INTO "tech"."TechID2Param" VALUES ('481', '48', 'lt2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('481', '57', 'VSD');
INSERT INTO "tech"."TechID2Param" VALUES ('481', '73', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('481', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('482', '44', 'OA Reset');
INSERT INTO "tech"."TechID2Param" VALUES ('482', '48', 'lt2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('482', '57', 'VSD');
INSERT INTO "tech"."TechID2Param" VALUES ('482', '73', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('482', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('483', '44', 'Load Reset');
INSERT INTO "tech"."TechID2Param" VALUES ('483', '48', 'lt2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('483', '57', 'VSD');
INSERT INTO "tech"."TechID2Param" VALUES ('483', '73', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('483', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('484', '44', 'Fixed');
INSERT INTO "tech"."TechID2Param" VALUES ('484', '48', 'ge2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('484', '57', 'VSD');
INSERT INTO "tech"."TechID2Param" VALUES ('484', '73', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('484', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('485', '44', 'OA Reset');
INSERT INTO "tech"."TechID2Param" VALUES ('485', '48', 'ge2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('485', '57', 'VSD');
INSERT INTO "tech"."TechID2Param" VALUES ('485', '73', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('485', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('486', '44', 'Load Reset');
INSERT INTO "tech"."TechID2Param" VALUES ('486', '48', 'ge2hp');
INSERT INTO "tech"."TechID2Param" VALUES ('486', '57', 'VSD');
INSERT INTO "tech"."TechID2Param" VALUES ('486', '73', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('486', '79', '');
INSERT INTO "tech"."TechID2Param" VALUES ('487', '42', '0.12');
INSERT INTO "tech"."TechID2Param" VALUES ('488', '42', '0.15');
INSERT INTO "tech"."TechID2Param" VALUES ('489', '42', '0.24');
INSERT INTO "tech"."TechID2Param" VALUES ('490', '42', '0.4');
INSERT INTO "tech"."TechID2Param" VALUES ('491', '42', '0.25');
INSERT INTO "tech"."TechID2Param" VALUES ('492', '42', '0.35');
INSERT INTO "tech"."TechID2Param" VALUES ('493', '42', '0.18');
INSERT INTO "tech"."TechID2Param" VALUES ('494', '42', '0.4');
INSERT INTO "tech"."TechID2Param" VALUES ('495', '42', '0.28');
INSERT INTO "tech"."TechID2Param" VALUES ('496', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('496', '11', 'Atm');
INSERT INTO "tech"."TechID2Param" VALUES ('496', '77', 'lt300k');
INSERT INTO "tech"."TechID2Param" VALUES ('496', '83', '0.845');
INSERT INTO "tech"."TechID2Param" VALUES ('497', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('497', '11', 'Atm');
INSERT INTO "tech"."TechID2Param" VALUES ('497', '77', 'lt300k');
INSERT INTO "tech"."TechID2Param" VALUES ('497', '83', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('498', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('498', '11', 'fDraft');
INSERT INTO "tech"."TechID2Param" VALUES ('498', '77', 'lt300k');
INSERT INTO "tech"."TechID2Param" VALUES ('498', '83', '0.845');
INSERT INTO "tech"."TechID2Param" VALUES ('499', '8', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('499', '11', 'fDraft');
INSERT INTO "tech"."TechID2Param" VALUES ('499', '77', 'lt300k');
INSERT INTO "tech"."TechID2Param" VALUES ('499', '83', '0.94');
INSERT INTO "tech"."TechID2Param" VALUES ('500', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('500', '11', 'Atm');
INSERT INTO "tech"."TechID2Param" VALUES ('500', '77', '300to2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('500', '82', '0.85');
INSERT INTO "tech"."TechID2Param" VALUES ('501', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('501', '11', 'Atm');
INSERT INTO "tech"."TechID2Param" VALUES ('501', '77', '300to2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('501', '82', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('502', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('502', '11', 'fDraft');
INSERT INTO "tech"."TechID2Param" VALUES ('502', '77', '300to2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('502', '82', '0.85');
INSERT INTO "tech"."TechID2Param" VALUES ('503', '8', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('503', '11', 'fDraft');
INSERT INTO "tech"."TechID2Param" VALUES ('503', '77', '300to2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('503', '82', '0.94');
INSERT INTO "tech"."TechID2Param" VALUES ('504', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('504', '11', 'Atm');
INSERT INTO "tech"."TechID2Param" VALUES ('504', '77', 'gt2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('504', '82', '0.85');
INSERT INTO "tech"."TechID2Param" VALUES ('505', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('505', '11', 'fDraft');
INSERT INTO "tech"."TechID2Param" VALUES ('505', '77', 'gt2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('505', '82', '0.85');
INSERT INTO "tech"."TechID2Param" VALUES ('506', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('506', '11', 'Atm');
INSERT INTO "tech"."TechID2Param" VALUES ('506', '77', 'gt2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('506', '82', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('507', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('507', '90', '30gal');
INSERT INTO "tech"."TechID2Param" VALUES ('507', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('507', '92', '0.95');
INSERT INTO "tech"."TechID2Param" VALUES ('508', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('508', '90', '40gal');
INSERT INTO "tech"."TechID2Param" VALUES ('508', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('508', '92', '0.94');
INSERT INTO "tech"."TechID2Param" VALUES ('509', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('509', '90', '50gal');
INSERT INTO "tech"."TechID2Param" VALUES ('509', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('509', '92', '0.93');
INSERT INTO "tech"."TechID2Param" VALUES ('510', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('510', '90', '60gal');
INSERT INTO "tech"."TechID2Param" VALUES ('510', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('510', '92', '0.92');
INSERT INTO "tech"."TechID2Param" VALUES ('511', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('511', '90', '75gal');
INSERT INTO "tech"."TechID2Param" VALUES ('511', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('511', '92', '0.91');
INSERT INTO "tech"."TechID2Param" VALUES ('512', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('512', '90', '30gal');
INSERT INTO "tech"."TechID2Param" VALUES ('512', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('512', '92', '0.89');
INSERT INTO "tech"."TechID2Param" VALUES ('513', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('513', '90', '40gal');
INSERT INTO "tech"."TechID2Param" VALUES ('513', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('513', '92', '0.88');
INSERT INTO "tech"."TechID2Param" VALUES ('514', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('514', '90', '50gal');
INSERT INTO "tech"."TechID2Param" VALUES ('514', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('514', '92', '0.86');
INSERT INTO "tech"."TechID2Param" VALUES ('515', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('515', '90', '60gal');
INSERT INTO "tech"."TechID2Param" VALUES ('515', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('515', '92', '0.85');
INSERT INTO "tech"."TechID2Param" VALUES ('516', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('516', '90', '75gal');
INSERT INTO "tech"."TechID2Param" VALUES ('516', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('516', '92', '0.83');
INSERT INTO "tech"."TechID2Param" VALUES ('517', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('517', '90', '30gal');
INSERT INTO "tech"."TechID2Param" VALUES ('517', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('517', '92', '0.62');
INSERT INTO "tech"."TechID2Param" VALUES ('518', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('518', '90', '30gal');
INSERT INTO "tech"."TechID2Param" VALUES ('518', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('518', '92', '0.65');
INSERT INTO "tech"."TechID2Param" VALUES ('519', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('519', '90', '30gal');
INSERT INTO "tech"."TechID2Param" VALUES ('519', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('519', '92', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('520', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('520', '90', '40gal');
INSERT INTO "tech"."TechID2Param" VALUES ('520', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('520', '92', '0.62');
INSERT INTO "tech"."TechID2Param" VALUES ('521', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('521', '90', '40gal');
INSERT INTO "tech"."TechID2Param" VALUES ('521', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('521', '92', '0.67');
INSERT INTO "tech"."TechID2Param" VALUES ('522', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('522', '90', '40gal');
INSERT INTO "tech"."TechID2Param" VALUES ('522', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('522', '92', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('523', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('523', '90', '50gal');
INSERT INTO "tech"."TechID2Param" VALUES ('523', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('523', '92', '0.62');
INSERT INTO "tech"."TechID2Param" VALUES ('524', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('524', '90', '50gal');
INSERT INTO "tech"."TechID2Param" VALUES ('524', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('524', '92', '0.67');
INSERT INTO "tech"."TechID2Param" VALUES ('525', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('525', '90', '50gal');
INSERT INTO "tech"."TechID2Param" VALUES ('525', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('525', '92', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('526', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('526', '90', '60gal');
INSERT INTO "tech"."TechID2Param" VALUES ('526', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('526', '92', '0.62');
INSERT INTO "tech"."TechID2Param" VALUES ('527', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('527', '90', '60gal');
INSERT INTO "tech"."TechID2Param" VALUES ('527', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('527', '92', '0.66');
INSERT INTO "tech"."TechID2Param" VALUES ('528', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('528', '90', '60gal');
INSERT INTO "tech"."TechID2Param" VALUES ('528', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('528', '92', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('529', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('529', '90', '75gal');
INSERT INTO "tech"."TechID2Param" VALUES ('529', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('529', '92', '0.62');
INSERT INTO "tech"."TechID2Param" VALUES ('530', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('530', '90', '75gal');
INSERT INTO "tech"."TechID2Param" VALUES ('530', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('530', '92', '0.66');
INSERT INTO "tech"."TechID2Param" VALUES ('531', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('531', '90', '75gal');
INSERT INTO "tech"."TechID2Param" VALUES ('531', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('531', '92', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('532', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('532', '90', '30gal');
INSERT INTO "tech"."TechID2Param" VALUES ('532', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('532', '92', '0.61');
INSERT INTO "tech"."TechID2Param" VALUES ('533', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('533', '90', '40gal');
INSERT INTO "tech"."TechID2Param" VALUES ('533', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('533', '92', '0.59');
INSERT INTO "tech"."TechID2Param" VALUES ('534', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('534', '90', '50gal');
INSERT INTO "tech"."TechID2Param" VALUES ('534', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('534', '92', '0.57');
INSERT INTO "tech"."TechID2Param" VALUES ('535', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('535', '90', '60gal');
INSERT INTO "tech"."TechID2Param" VALUES ('535', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('535', '92', '0.56');
INSERT INTO "tech"."TechID2Param" VALUES ('536', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('536', '90', '75gal');
INSERT INTO "tech"."TechID2Param" VALUES ('536', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('536', '92', '0.53');
INSERT INTO "tech"."TechID2Param" VALUES ('537', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('537', '90', '30gal');
INSERT INTO "tech"."TechID2Param" VALUES ('537', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('537', '92', '0.57');
INSERT INTO "tech"."TechID2Param" VALUES ('538', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('538', '90', '40gal');
INSERT INTO "tech"."TechID2Param" VALUES ('538', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('538', '92', '0.57');
INSERT INTO "tech"."TechID2Param" VALUES ('539', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('539', '90', '75gal');
INSERT INTO "tech"."TechID2Param" VALUES ('539', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('539', '92', '0.48');
INSERT INTO "tech"."TechID2Param" VALUES ('540', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('540', '90', 'lt2');
INSERT INTO "tech"."TechID2Param" VALUES ('540', '91', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('540', '92', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('541', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('541', '82', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('541', '93', '0.0056');
INSERT INTO "tech"."TechID2Param" VALUES ('541', '136', '');
INSERT INTO "tech"."TechID2Param" VALUES ('542', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('542', '82', '0.86');
INSERT INTO "tech"."TechID2Param" VALUES ('542', '93', '0.0057');
INSERT INTO "tech"."TechID2Param" VALUES ('542', '136', '');
INSERT INTO "tech"."TechID2Param" VALUES ('543', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('543', '11', 'Atm');
INSERT INTO "tech"."TechID2Param" VALUES ('543', '77', 'lt300k');
INSERT INTO "tech"."TechID2Param" VALUES ('543', '83', '0.82');
INSERT INTO "tech"."TechID2Param" VALUES ('544', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('544', '11', 'Atm');
INSERT INTO "tech"."TechID2Param" VALUES ('544', '77', 'lt300k');
INSERT INTO "tech"."TechID2Param" VALUES ('544', '83', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('545', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('545', '11', 'fDraft');
INSERT INTO "tech"."TechID2Param" VALUES ('545', '77', 'lt300k');
INSERT INTO "tech"."TechID2Param" VALUES ('545', '83', '0.82');
INSERT INTO "tech"."TechID2Param" VALUES ('546', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('546', '11', 'Atm');
INSERT INTO "tech"."TechID2Param" VALUES ('546', '77', '300to2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('546', '82', '0.85');
INSERT INTO "tech"."TechID2Param" VALUES ('547', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('547', '11', 'fDraft');
INSERT INTO "tech"."TechID2Param" VALUES ('547', '77', '300to2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('547', '82', '0.85');
INSERT INTO "tech"."TechID2Param" VALUES ('548', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('548', '11', 'Atm');
INSERT INTO "tech"."TechID2Param" VALUES ('548', '77', '300to2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('548', '82', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('549', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('549', '11', 'Atm');
INSERT INTO "tech"."TechID2Param" VALUES ('549', '77', 'gt2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('549', '82', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('550', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('550', '11', 'fDraft');
INSERT INTO "tech"."TechID2Param" VALUES ('550', '77', 'gt2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('550', '82', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('551', '8', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('551', '11', 'Atm');
INSERT INTO "tech"."TechID2Param" VALUES ('551', '77', 'gt2500k');
INSERT INTO "tech"."TechID2Param" VALUES ('551', '82', '0.75');
INSERT INTO "tech"."TechID2Param" VALUES ('552', '153', '0.3');
INSERT INTO "tech"."TechID2Param" VALUES ('552', '158', '0.35');
INSERT INTO "tech"."TechID2Param" VALUES ('552', '160', '0.54');
INSERT INTO "tech"."TechID2Param" VALUES ('552', '167', '2001');
INSERT INTO "tech"."TechID2Param" VALUES ('553', '153', '0.3');
INSERT INTO "tech"."TechID2Param" VALUES ('553', '158', '0.35');
INSERT INTO "tech"."TechID2Param" VALUES ('553', '160', '0.54');
INSERT INTO "tech"."TechID2Param" VALUES ('553', '167', '2001');
INSERT INTO "tech"."TechID2Param" VALUES ('554', '154', '0.82');
INSERT INTO "tech"."TechID2Param" VALUES ('554', '162', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('555', '154', '0.6');
INSERT INTO "tech"."TechID2Param" VALUES ('555', '162', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('556', '154', '0.35');
INSERT INTO "tech"."TechID2Param" VALUES ('556', '162', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('557', '76', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('558', '76', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('559', '76', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('560', '76', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('561', '76', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('562', '76', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('563', '76', '38');
INSERT INTO "tech"."TechID2Param" VALUES ('564', '76', '49');
INSERT INTO "tech"."TechID2Param" VALUES ('565', '76', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('566', '76', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('567', '76', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('568', '76', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('569', '76', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('570', '76', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('571', '76', '38');
INSERT INTO "tech"."TechID2Param" VALUES ('572', '76', '49');
INSERT INTO "tech"."TechID2Param" VALUES ('573', '76', 'R-0');
INSERT INTO "tech"."TechID2Param" VALUES ('574', '76', 'R-11');
INSERT INTO "tech"."TechID2Param" VALUES ('575', '128', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('575', '132', 'Bottom');
INSERT INTO "tech"."TechID2Param" VALUES ('575', '134', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('575', '145', '487');
INSERT INTO "tech"."TechID2Param" VALUES ('575', '161', '16.5to25ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('576', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('576', '132', 'Bottom');
INSERT INTO "tech"."TechID2Param" VALUES ('576', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('576', '145', '573');
INSERT INTO "tech"."TechID2Param" VALUES ('576', '161', '16.5to25ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('577', '128', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('577', '132', 'Bottom');
INSERT INTO "tech"."TechID2Param" VALUES ('577', '134', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('577', '145', '447');
INSERT INTO "tech"."TechID2Param" VALUES ('577', '161', '8to16.5ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('578', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('578', '132', 'Bottom');
INSERT INTO "tech"."TechID2Param" VALUES ('578', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('578', '145', '518');
INSERT INTO "tech"."TechID2Param" VALUES ('578', '161', '8to16.5ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('579', '128', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('579', '132', 'Side');
INSERT INTO "tech"."TechID2Param" VALUES ('579', '134', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('579', '145', '565');
INSERT INTO "tech"."TechID2Param" VALUES ('579', '161', '23to31ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('580', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('580', '132', 'Side');
INSERT INTO "tech"."TechID2Param" VALUES ('580', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('580', '145', '665');
INSERT INTO "tech"."TechID2Param" VALUES ('580', '161', '23to31ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('581', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('581', '132', 'Side');
INSERT INTO "tech"."TechID2Param" VALUES ('581', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('581', '145', '921');
INSERT INTO "tech"."TechID2Param" VALUES ('581', '161', '23to31ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('582', '128', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('582', '132', 'Side');
INSERT INTO "tech"."TechID2Param" VALUES ('582', '134', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('582', '145', '620');
INSERT INTO "tech"."TechID2Param" VALUES ('582', '161', '23to31ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('583', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('583', '132', 'Side');
INSERT INTO "tech"."TechID2Param" VALUES ('583', '134', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('583', '145', '730');
INSERT INTO "tech"."TechID2Param" VALUES ('583', '161', '23to31ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('584', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('584', '132', 'Side');
INSERT INTO "tech"."TechID2Param" VALUES ('584', '134', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('584', '145', '821');
INSERT INTO "tech"."TechID2Param" VALUES ('584', '161', '23to31ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('585', '128', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('585', '132', 'Side');
INSERT INTO "tech"."TechID2Param" VALUES ('585', '134', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('585', '145', '528');
INSERT INTO "tech"."TechID2Param" VALUES ('585', '161', '15to23ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('586', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('586', '132', 'Side');
INSERT INTO "tech"."TechID2Param" VALUES ('586', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('586', '145', '620');
INSERT INTO "tech"."TechID2Param" VALUES ('586', '161', '15to23ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('587', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('587', '132', 'Side');
INSERT INTO "tech"."TechID2Param" VALUES ('587', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('587', '145', '703');
INSERT INTO "tech"."TechID2Param" VALUES ('587', '161', '15to23ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('588', '128', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('588', '132', 'Side');
INSERT INTO "tech"."TechID2Param" VALUES ('588', '134', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('588', '145', '543');
INSERT INTO "tech"."TechID2Param" VALUES ('588', '161', '15to23ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('589', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('589', '132', 'Side');
INSERT INTO "tech"."TechID2Param" VALUES ('589', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('589', '145', '639');
INSERT INTO "tech"."TechID2Param" VALUES ('589', '161', '15to23ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('590', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('590', '132', 'Side');
INSERT INTO "tech"."TechID2Param" VALUES ('590', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('590', '145', '835');
INSERT INTO "tech"."TechID2Param" VALUES ('590', '161', '15to23ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('591', '128', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('591', '132', 'Top');
INSERT INTO "tech"."TechID2Param" VALUES ('591', '134', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('591', '145', '452');
INSERT INTO "tech"."TechID2Param" VALUES ('591', '161', '20to25ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('592', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('592', '132', 'Top');
INSERT INTO "tech"."TechID2Param" VALUES ('592', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('592', '145', '532');
INSERT INTO "tech"."TechID2Param" VALUES ('592', '161', '20to25ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('593', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('593', '132', 'Top');
INSERT INTO "tech"."TechID2Param" VALUES ('593', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('593', '145', '697');
INSERT INTO "tech"."TechID2Param" VALUES ('593', '161', '20to25ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('594', '128', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('594', '132', 'Top');
INSERT INTO "tech"."TechID2Param" VALUES ('594', '134', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('594', '145', '399');
INSERT INTO "tech"."TechID2Param" VALUES ('594', '161', '15to20ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('595', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('595', '132', 'Top');
INSERT INTO "tech"."TechID2Param" VALUES ('595', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('595', '145', '469');
INSERT INTO "tech"."TechID2Param" VALUES ('595', '161', '15to20ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('596', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('596', '132', 'Top');
INSERT INTO "tech"."TechID2Param" VALUES ('596', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('596', '145', '652');
INSERT INTO "tech"."TechID2Param" VALUES ('596', '161', '15to20ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('597', '128', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('597', '132', 'Top');
INSERT INTO "tech"."TechID2Param" VALUES ('597', '134', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('597', '145', '357');
INSERT INTO "tech"."TechID2Param" VALUES ('597', '161', '10to15ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('598', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('598', '132', 'Top');
INSERT INTO "tech"."TechID2Param" VALUES ('598', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('598', '145', '420');
INSERT INTO "tech"."TechID2Param" VALUES ('598', '161', '10to15ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('599', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('599', '132', 'Top');
INSERT INTO "tech"."TechID2Param" VALUES ('599', '134', '');
INSERT INTO "tech"."TechID2Param" VALUES ('599', '145', '621');
INSERT INTO "tech"."TechID2Param" VALUES ('599', '161', '10to15ft3');
INSERT INTO "tech"."TechID2Param" VALUES ('600', '128', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('600', '145', '368');
INSERT INTO "tech"."TechID2Param" VALUES ('600', '161', '');
INSERT INTO "tech"."TechID2Param" VALUES ('600', '168', 'man');
INSERT INTO "tech"."TechID2Param" VALUES ('601', '128', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('601', '145', '642');
INSERT INTO "tech"."TechID2Param" VALUES ('601', '161', '');
INSERT INTO "tech"."TechID2Param" VALUES ('601', '168', 'auto');
INSERT INTO "tech"."TechID2Param" VALUES ('602', '128', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('602', '145', '409');
INSERT INTO "tech"."TechID2Param" VALUES ('602', '161', '');
INSERT INTO "tech"."TechID2Param" VALUES ('602', '168', 'man');
INSERT INTO "tech"."TechID2Param" VALUES ('603', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('603', '145', '409');
INSERT INTO "tech"."TechID2Param" VALUES ('603', '161', '');
INSERT INTO "tech"."TechID2Param" VALUES ('603', '168', 'man');
INSERT INTO "tech"."TechID2Param" VALUES ('604', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('604', '145', '713');
INSERT INTO "tech"."TechID2Param" VALUES ('604', '161', '');
INSERT INTO "tech"."TechID2Param" VALUES ('604', '168', 'auto');
INSERT INTO "tech"."TechID2Param" VALUES ('605', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('605', '145', '708');
INSERT INTO "tech"."TechID2Param" VALUES ('605', '161', '');
INSERT INTO "tech"."TechID2Param" VALUES ('605', '168', 'man');
INSERT INTO "tech"."TechID2Param" VALUES ('606', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('606', '145', '700');
INSERT INTO "tech"."TechID2Param" VALUES ('606', '161', '');
INSERT INTO "tech"."TechID2Param" VALUES ('606', '168', 'man');
INSERT INTO "tech"."TechID2Param" VALUES ('607', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('607', '145', '849');
INSERT INTO "tech"."TechID2Param" VALUES ('607', '161', '');
INSERT INTO "tech"."TechID2Param" VALUES ('607', '168', 'auto');
INSERT INTO "tech"."TechID2Param" VALUES ('608', '128', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('608', '145', '454');
INSERT INTO "tech"."TechID2Param" VALUES ('608', '161', '');
INSERT INTO "tech"."TechID2Param" VALUES ('608', '168', 'man');
INSERT INTO "tech"."TechID2Param" VALUES ('609', '9', '0.7');
INSERT INTO "tech"."TechID2Param" VALUES ('609', '33', '2300');
INSERT INTO "tech"."TechID2Param" VALUES ('610', '71', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('610', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('610', '109', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('611', '71', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('611', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('611', '109', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('612', '36', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('612', '71', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('612', '109', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('613', '36', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('613', '71', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('613', '109', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('614', '36', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('614', '71', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('614', '109', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('615', '36', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('615', '71', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('615', '109', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('616', '71', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('616', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('616', '109', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('617', '71', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('617', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('617', '109', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('618', '2', 'half');
INSERT INTO "tech"."TechID2Param" VALUES ('618', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('618', '131', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('619', '2', 'half');
INSERT INTO "tech"."TechID2Param" VALUES ('619', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('619', '131', '0.5');
INSERT INTO "tech"."TechID2Param" VALUES ('620', '2', '3q');
INSERT INTO "tech"."TechID2Param" VALUES ('620', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('620', '131', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('621', '2', '3q');
INSERT INTO "tech"."TechID2Param" VALUES ('621', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('621', '131', '0.5');
INSERT INTO "tech"."TechID2Param" VALUES ('622', '2', 'full');
INSERT INTO "tech"."TechID2Param" VALUES ('622', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('622', '131', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('623', '2', 'full');
INSERT INTO "tech"."TechID2Param" VALUES ('623', '21', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('623', '131', '0.5');
INSERT INTO "tech"."TechID2Param" VALUES ('624', '23', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('624', '135', '101to200');
INSERT INTO "tech"."TechID2Param" VALUES ('625', '23', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('625', '135', '201to300');
INSERT INTO "tech"."TechID2Param" VALUES ('626', '23', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('626', '135', '301to400');
INSERT INTO "tech"."TechID2Param" VALUES ('627', '23', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('627', '135', '401to500');
INSERT INTO "tech"."TechID2Param" VALUES ('628', '23', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('628', '135', '501to1000');
INSERT INTO "tech"."TechID2Param" VALUES ('629', '23', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('629', '135', '1001to1500');
INSERT INTO "tech"."TechID2Param" VALUES ('630', '23', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('630', '135', 'gt1500');
INSERT INTO "tech"."TechID2Param" VALUES ('631', '23', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('631', '135', '101to200');
INSERT INTO "tech"."TechID2Param" VALUES ('632', '23', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('632', '135', '201to300');
INSERT INTO "tech"."TechID2Param" VALUES ('633', '23', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('633', '135', '301to400');
INSERT INTO "tech"."TechID2Param" VALUES ('634', '23', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('634', '135', '401to500');
INSERT INTO "tech"."TechID2Param" VALUES ('635', '23', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('635', '135', '501to1000');
INSERT INTO "tech"."TechID2Param" VALUES ('636', '23', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('636', '135', '1001to1500');
INSERT INTO "tech"."TechID2Param" VALUES ('637', '23', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('637', '135', 'gt1500');
INSERT INTO "tech"."TechID2Param" VALUES ('638', '23', 'CT2');
INSERT INTO "tech"."TechID2Param" VALUES ('638', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('638', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('638', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('638', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('639', '23', 'CT3');
INSERT INTO "tech"."TechID2Param" VALUES ('639', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('639', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('639', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('639', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('640', '23', 'CT2');
INSERT INTO "tech"."TechID2Param" VALUES ('640', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('640', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('640', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('640', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('641', '23', 'CT3');
INSERT INTO "tech"."TechID2Param" VALUES ('641', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('641', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('641', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('641', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('642', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('642', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('642', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('642', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('642', '174', '1.26');
INSERT INTO "tech"."TechID2Param" VALUES ('643', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('643', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('643', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('643', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('643', '174', '1.26');
INSERT INTO "tech"."TechID2Param" VALUES ('644', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('644', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('644', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('644', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('644', '174', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('645', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('645', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('645', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('645', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('645', '174', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('646', '23', 'CT2');
INSERT INTO "tech"."TechID2Param" VALUES ('646', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('646', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('646', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('646', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('647', '23', 'CT3');
INSERT INTO "tech"."TechID2Param" VALUES ('647', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('647', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('647', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('647', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('648', '23', 'CT2');
INSERT INTO "tech"."TechID2Param" VALUES ('648', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('648', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('648', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('648', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('649', '23', 'CT3');
INSERT INTO "tech"."TechID2Param" VALUES ('649', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('649', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('649', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('649', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('650', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('650', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('650', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('650', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('650', '174', '1.26');
INSERT INTO "tech"."TechID2Param" VALUES ('651', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('651', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('651', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('651', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('651', '174', '1.26');
INSERT INTO "tech"."TechID2Param" VALUES ('652', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('652', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('652', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('652', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('652', '174', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('653', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('653', '170', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('653', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('653', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('653', '174', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('654', '23', 'CT2');
INSERT INTO "tech"."TechID2Param" VALUES ('654', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('654', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('654', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('654', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('655', '23', 'CT3');
INSERT INTO "tech"."TechID2Param" VALUES ('655', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('655', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('655', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('655', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('656', '23', 'CT2');
INSERT INTO "tech"."TechID2Param" VALUES ('656', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('656', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('656', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('656', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('657', '23', 'CT3');
INSERT INTO "tech"."TechID2Param" VALUES ('657', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('657', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('657', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('657', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('658', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('658', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('658', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('658', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('658', '174', '1.26');
INSERT INTO "tech"."TechID2Param" VALUES ('659', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('659', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('659', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('659', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('659', '174', '1.26');
INSERT INTO "tech"."TechID2Param" VALUES ('660', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('660', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('660', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('660', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('660', '174', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('661', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('661', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('661', '171', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('661', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('661', '174', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('662', '23', 'CT2');
INSERT INTO "tech"."TechID2Param" VALUES ('662', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('662', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('662', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('662', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('663', '23', 'CT3');
INSERT INTO "tech"."TechID2Param" VALUES ('663', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('663', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('663', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('663', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('664', '23', 'CT2');
INSERT INTO "tech"."TechID2Param" VALUES ('664', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('664', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('664', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('664', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('665', '23', 'CT3');
INSERT INTO "tech"."TechID2Param" VALUES ('665', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('665', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('665', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('665', '174', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('666', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('666', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('666', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('666', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('666', '174', '1.26');
INSERT INTO "tech"."TechID2Param" VALUES ('667', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('667', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('667', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('667', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('667', '174', '1.26');
INSERT INTO "tech"."TechID2Param" VALUES ('668', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('668', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('668', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('668', '172', '3.5');
INSERT INTO "tech"."TechID2Param" VALUES ('668', '174', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('669', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('669', '170', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('669', '171', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('669', '172', '2.65');
INSERT INTO "tech"."TechID2Param" VALUES ('669', '174', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('670', '18', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('670', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('670', '111', 'ES1');
INSERT INTO "tech"."TechID2Param" VALUES ('670', '173', '160');
INSERT INTO "tech"."TechID2Param" VALUES ('671', '18', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('671', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('671', '111', 'ES2');
INSERT INTO "tech"."TechID2Param" VALUES ('671', '173', '160');
INSERT INTO "tech"."TechID2Param" VALUES ('672', '18', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('672', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('672', '111', 'ES1');
INSERT INTO "tech"."TechID2Param" VALUES ('672', '173', '160');
INSERT INTO "tech"."TechID2Param" VALUES ('673', '18', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('673', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('673', '111', 'ES2');
INSERT INTO "tech"."TechID2Param" VALUES ('673', '173', '160');
INSERT INTO "tech"."TechID2Param" VALUES ('674', '18', '0.45');
INSERT INTO "tech"."TechID2Param" VALUES ('674', '78', 'Gas');
INSERT INTO "tech"."TechID2Param" VALUES ('674', '111', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('674', '173', '160');
INSERT INTO "tech"."TechID2Param" VALUES ('675', '18', '0.45');
INSERT INTO "tech"."TechID2Param" VALUES ('675', '78', 'Elec');
INSERT INTO "tech"."TechID2Param" VALUES ('675', '111', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('675', '173', '160');
INSERT INTO "tech"."TechID2Param" VALUES ('676', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('676', '127', '4.1');
INSERT INTO "tech"."TechID2Param" VALUES ('676', '151', '10to25.4');
INSERT INTO "tech"."TechID2Param" VALUES ('677', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('677', '127', '5.1');
INSERT INTO "tech"."TechID2Param" VALUES ('677', '151', '10to25.4');
INSERT INTO "tech"."TechID2Param" VALUES ('678', '23', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('678', '127', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('678', '151', '10to25.4');
INSERT INTO "tech"."TechID2Param" VALUES ('679', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('679', '127', '4.1');
INSERT INTO "tech"."TechID2Param" VALUES ('679', '151', '25.5to35');
INSERT INTO "tech"."TechID2Param" VALUES ('680', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('680', '127', '5.1');
INSERT INTO "tech"."TechID2Param" VALUES ('680', '151', '25.5to35');
INSERT INTO "tech"."TechID2Param" VALUES ('681', '23', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('681', '127', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('681', '151', '25.5to35');
INSERT INTO "tech"."TechID2Param" VALUES ('682', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('682', '127', '4.1');
INSERT INTO "tech"."TechID2Param" VALUES ('682', '151', '36to39');
INSERT INTO "tech"."TechID2Param" VALUES ('683', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('683', '127', '5.1');
INSERT INTO "tech"."TechID2Param" VALUES ('683', '151', '36to39');
INSERT INTO "tech"."TechID2Param" VALUES ('684', '23', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('684', '127', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('684', '151', '36to39');
INSERT INTO "tech"."TechID2Param" VALUES ('685', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('685', '127', '4.1');
INSERT INTO "tech"."TechID2Param" VALUES ('685', '151', '40to42');
INSERT INTO "tech"."TechID2Param" VALUES ('686', '23', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('686', '127', '5.1');
INSERT INTO "tech"."TechID2Param" VALUES ('686', '151', '40to42');
INSERT INTO "tech"."TechID2Param" VALUES ('687', '23', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('687', '127', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('687', '151', 'gt42');
INSERT INTO "tech"."TechID2Param" VALUES ('688', '19', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('688', '126', 'A');
INSERT INTO "tech"."TechID2Param" VALUES ('688', '141', 'le118');
INSERT INTO "tech"."TechID2Param" VALUES ('689', '19', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('689', '126', 'A');
INSERT INTO "tech"."TechID2Param" VALUES ('689', '141', 'gt119 ');
INSERT INTO "tech"."TechID2Param" VALUES ('690', '19', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('690', '126', 'A');
INSERT INTO "tech"."TechID2Param" VALUES ('690', '141', 'gt148');
INSERT INTO "tech"."TechID2Param" VALUES ('691', '19', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('691', '126', 'B');
INSERT INTO "tech"."TechID2Param" VALUES ('691', '141', 'le140');
INSERT INTO "tech"."TechID2Param" VALUES ('692', '19', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('692', '126', 'B');
INSERT INTO "tech"."TechID2Param" VALUES ('692', '141', 'gt141');
INSERT INTO "tech"."TechID2Param" VALUES ('693', '19', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('693', '126', 'B');
INSERT INTO "tech"."TechID2Param" VALUES ('693', '141', 'gt175');
INSERT INTO "tech"."TechID2Param" VALUES ('694', '19', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('694', '126', 'C');
INSERT INTO "tech"."TechID2Param" VALUES ('694', '141', 'le167');
INSERT INTO "tech"."TechID2Param" VALUES ('695', '19', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('695', '126', 'C');
INSERT INTO "tech"."TechID2Param" VALUES ('695', '141', 'gt168');
INSERT INTO "tech"."TechID2Param" VALUES ('696', '19', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('696', '126', 'C');
INSERT INTO "tech"."TechID2Param" VALUES ('696', '141', 'gt209');
INSERT INTO "tech"."TechID2Param" VALUES ('697', '19', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('697', '126', 'D');
INSERT INTO "tech"."TechID2Param" VALUES ('697', '141', 'le187');
INSERT INTO "tech"."TechID2Param" VALUES ('698', '19', 'Y');
INSERT INTO "tech"."TechID2Param" VALUES ('698', '126', 'D');
INSERT INTO "tech"."TechID2Param" VALUES ('698', '141', 'gt188');
INSERT INTO "tech"."TechID2Param" VALUES ('699', '19', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('699', '126', 'D');
INSERT INTO "tech"."TechID2Param" VALUES ('699', '141', 'gt234');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '28', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '38', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '103', '10001');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('700', '166', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '28', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '38', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '103', '10002');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('701', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '28', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '103', '10003');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('702', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '28', '56');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '103', '10004');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('703', '166', '56');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '28', '62');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '103', '10005');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('704', '166', '62');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '3', '0.93');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '28', '62');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '39', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '103', '10006');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('705', '166', '62');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '3', '0.93');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '28', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '39', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '103', '10007');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('706', '166', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '28', '112');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '103', '10008');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('707', '166', '112');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '28', '146');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '103', '10009');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('708', '166', '146');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '28', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '103', '10010');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('709', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '3', '0.92');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '28', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '103', '10011');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('710', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '28', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '103', '10012');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('711', '166', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '28', '58');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '103', '10013');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('712', '166', '58');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '3', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '28', '116');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '103', '10014');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('713', '166', '116');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '28', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '103', '10015');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('714', '166', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '28', '37');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '103', '10016');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('715', '166', '37');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '28', '37');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '103', '10017');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('716', '166', '37');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '28', '41');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '103', '10018');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('717', '166', '41');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '28', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '103', '10019');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('718', '166', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '28', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '103', '10020');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('719', '166', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '28', '70');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '103', '10021');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('720', '166', '70');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '28', '66');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '103', '10022');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('721', '166', '66');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '28', '73');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '103', '10023');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('722', '166', '73');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '28', '74');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '103', '10024');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('723', '166', '74');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '28', '81');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '103', '10025');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('724', '166', '81');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '28', '114');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '103', '10026');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('725', '166', '114');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '28', '115');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '103', '10027');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('726', '166', '115');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '28', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '103', '10028');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('727', '166', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '28', '127');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '103', '10029');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('728', '166', '127');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '28', '148');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '103', '10030');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('729', '166', '148');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '28', '162');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '103', '10031');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('730', '166', '162');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '28', '198');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '103', '10032');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('731', '166', '198');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '28', '342');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '103', '10033');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('732', '166', '342');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '28', '135');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '38', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '103', '10034');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('733', '166', '135');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '28', '215');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '38', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '103', '10035');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('734', '166', '215');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '28', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '103', '10036');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('735', '166', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '28', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '103', '10037');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('736', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '3', '0.95');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '28', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '103', '10038');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('737', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '3', '0.92');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '28', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '103', '10039');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('738', '166', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '3', '0.92');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '28', '37');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '103', '10040');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('739', '166', '37');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '3', '0.92');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '28', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '103', '10041');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('740', '166', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '28', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '103', '10042');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('741', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '4', 'Mag-Hyb');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '28', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '103', '10043');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('742', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '4', 'Mag-Hyb');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '28', '41');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '103', '10044');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('743', '166', '41');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '28', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '103', '10045');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('744', '166', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '28', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '103', '10046');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('745', '166', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '28', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '43', 'ES IS');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '103', '10047');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('746', '166', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '28', '44');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '103', '10048');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('747', '166', '44');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '28', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '103', '10049');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('748', '166', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '28', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '103', '10050');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('749', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '3', '0.85');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '28', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '103', '10051');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('750', '166', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '28', '135');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '39', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '43', 'Std VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '103', '10052');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('751', '166', '135');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '3', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '28', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '39', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '103', '10053');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('752', '166', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '28', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '103', '10054');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('753', '166', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '28', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '103', '10055');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('754', '166', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '3', '0.92');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '28', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '103', '10056');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('755', '166', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '28', '74');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '103', '10057');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('756', '166', '74');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '28', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '103', '10058');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('757', '166', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '28', '92');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '103', '10059');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('758', '166', '92');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '28', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '103', '10060');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('759', '166', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '28', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '103', '10061');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('760', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '28', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '103', '10062');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('761', '166', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '28', '148');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '103', '10063');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('762', '166', '148');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '28', '186');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '103', '10064');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('763', '166', '186');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '4', 'Mag-Hyb');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '28', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '103', '10065');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('764', '166', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '28', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '103', '10066');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('765', '166', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '28', '74');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '103', '10067');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('766', '166', '74');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '28', '76');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '103', '10068');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('767', '166', '76');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '4', 'Mag-Hyb');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '28', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '103', '10069');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('768', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '28', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '43', 'ES IS');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '103', '10070');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('769', '166', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '28', '74');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '103', '10071');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('770', '166', '74');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '28', '145');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '103', '10072');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('771', '166', '145');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '28', '242');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '39', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '43', 'Std VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '103', '10073');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('772', '166', '242');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '4', 'Mag-Hyb');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '28', '102');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '103', '10074');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('773', '166', '102');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '28', '115');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '103', '10075');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('774', '166', '115');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '4', 'Mag-Hyb');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '28', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '103', '10076');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('775', '166', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '28', '109');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '43', 'ES IS');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '103', '10077');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('776', '166', '109');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '28', '112');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '103', '10078');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('777', '166', '112');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '28', '230');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '103', '10079');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('778', '166', '230');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '28', '377');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '39', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '43', 'Std VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '103', '10080');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('779', '166', '377');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '4', 'Mag-Hyb');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '28', '136');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '103', '10081');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('780', '166', '136');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '28', '144');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '103', '10082');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('781', '166', '144');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '28', '152');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '103', '10083');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('782', '166', '152');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '4', 'Mag-Hyb');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '28', '160');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '103', '10084');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('783', '166', '160');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '28', '164');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '43', 'ES IS');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '103', '10085');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('784', '166', '164');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '28', '168');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '43', 'Std IS');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '103', '10086');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('785', '166', '168');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '28', '270');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '103', '10087');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('786', '166', '270');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '28', '290');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '103', '10088');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('787', '166', '290');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '28', '420');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '43', 'ES VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '103', '10089');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('788', '166', '420');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '28', '484');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '39', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '43', 'Std VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '103', '10090');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('789', '166', '484');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '28', '216');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '103', '10091');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('790', '166', '216');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '28', '288');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '103', '10092');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('791', '166', '288');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '28', '44');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '103', '10093');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('792', '166', '44');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '28', '69');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '39', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '103', '10094');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('793', '166', '69');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '28', '63');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '103', '10095');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('794', '166', '63');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '3', '0.85');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '28', '88');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '39', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '103', '10096');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('795', '166', '88');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '28', '92');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '39', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '103', '10097');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('796', '166', '92');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '28', '165');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '39', '135');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '43', 'ES VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '103', '10098');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('797', '166', '165');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '28', '88');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '103', '10099');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('798', '166', '88');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '28', '138');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '39', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '103', '10100');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('799', '166', '138');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '28', '128');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '103', '10101');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('800', '166', '128');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '28', '168');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '39', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '103', '10102');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('801', '166', '168');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '28', '176');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '39', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '103', '10103');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('802', '166', '176');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '28', '310');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '39', '135');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '43', 'ES VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '103', '10104');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('803', '166', '310');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '28', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '103', '10105');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('804', '166', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '28', '76');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '103', '10106');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('805', '166', '76');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '28', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '39', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '103', '10107');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('806', '166', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '28', '180');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '39', '160');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '43', 'Std VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '103', '10108');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('807', '166', '180');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '28', '108');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '103', '10109');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('808', '166', '108');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '28', '108');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '103', '10110');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('809', '166', '108');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '28', '176');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '103', '10111');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('810', '166', '176');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '28', '216');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '103', '10112');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('811', '166', '216');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '28', '122');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '103', '10113');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('812', '166', '122');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '28', '122');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '103', '10114');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('813', '166', '122');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '28', '194');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '39', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '103', '10115');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('814', '166', '194');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '28', '220');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '39', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '103', '10116');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('815', '166', '220');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '28', '330');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '39', '160');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '43', 'Std VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '103', '10117');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('816', '166', '330');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '28', '202');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '103', '10118');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('817', '166', '202');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '28', '244');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '103', '10119');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('818', '166', '244');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '28', '244');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '39', '56');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '43', 'Std');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '103', '10120');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('819', '166', '244');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '28', '388');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '38', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '39', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '103', '10121');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('820', '166', '388');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '28', '69');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '103', '10122');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('821', '166', '69');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '3', '0.89');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '28', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '103', '10123');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('822', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '28', '62');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '103', '10124');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('823', '166', '62');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '28', '62');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '103', '10125');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('824', '166', '62');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '28', '64');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '103', '10126');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('825', '166', '64');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '28', '105');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '103', '10127');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('826', '166', '105');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '28', '205');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '39', '185');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '43', 'ES VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '103', '10128');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('827', '166', '205');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '28', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '103', '10129');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('828', '166', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '28', '173');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '103', '10130');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('829', '166', '173');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '28', '179');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '103', '10131');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('830', '166', '179');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '28', '220');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '103', '10132');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('831', '166', '220');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '28', '346');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '103', '10133');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('832', '166', '346');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '28', '123');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '103', '10134');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('833', '166', '123');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '28', '123');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '103', '10135');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('834', '166', '123');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '28', '207');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '103', '10136');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('835', '166', '207');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '28', '207');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '103', '10137');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('836', '166', '207');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '28', '380');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '39', '185');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '43', 'ES VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '103', '10138');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('837', '166', '380');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '28', '185');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '103', '10139');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('838', '166', '185');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '28', '210');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '103', '10140');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('839', '166', '210');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '4', 'Mag-ES/STD');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '28', '312');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '103', '10141');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('840', '166', '312');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '28', '312');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '103', '10142');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('841', '166', '312');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '28', '585');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '39', '185');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '43', 'ES VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '103', '10143');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('842', '166', '585');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '28', '246');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '103', '10144');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('843', '166', '246');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '28', '246');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '43', 'ES');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '103', '10145');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('844', '166', '246');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '28', '414');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '103', '10146');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('845', '166', '414');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '28', '414');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '103', '10147');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('846', '166', '414');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '28', '760');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '39', '185');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '43', 'ES VHO');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '103', '10148');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('847', '166', '760');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '28', '621');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '37', 'T12');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '43', 'ES HO');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '103', '10149');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('848', '166', '621');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '3', '0.87');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '28', '51');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '37', 'T10');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '103', '10150');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('849', '166', '51');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '3', '1.02');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '28', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '38', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '103', '10151');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('850', '166', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '3', '0.97');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '28', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '38', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '103', '10152');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('851', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '28', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '103', '10153');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('852', '166', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '28', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '103', '10154');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('853', '166', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '28', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '103', '10155');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('854', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '28', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '103', '10156');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('855', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '28', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '103', '10157');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('856', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '28', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '103', '10158');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('857', '166', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '28', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '103', '10159');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('858', '166', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '28', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '103', '10160');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('859', '166', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '28', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '103', '10161');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('860', '166', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '28', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '103', '10162');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('861', '166', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '28', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '103', '10163');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('862', '166', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '28', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '103', '10164');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('863', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '3', '0.92');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '4', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '28', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '103', '10165');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('864', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '28', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '103', '10166');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('865', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '28', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '103', '10167');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('866', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '28', '29');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '103', '10168');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('867', '166', '29');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '28', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '103', '10169');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('868', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '28', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '103', '10170');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('869', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '28', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '103', '10171');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('870', '166', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '28', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '103', '10172');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('871', '166', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '28', '41');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '103', '10173');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('872', '166', '41');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '28', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '103', '10174');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('873', '166', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '28', '47');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '103', '10175');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('874', '166', '47');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '28', '49');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '103', '10176');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('875', '166', '49');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '28', '52');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '103', '10177');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('876', '166', '52');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '28', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '103', '10178');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('877', '166', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '28', '57');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '103', '10179');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('878', '166', '57');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '28', '61');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '103', '10180');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('879', '166', '61');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '28', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '38', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '103', '10181');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('880', '166', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '28', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '103', '10182');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('881', '166', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '28', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '103', '10183');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('882', '166', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '28', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '103', '10184');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('883', '166', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '28', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '103', '10185');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('884', '166', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '28', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '103', '10186');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('885', '166', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '28', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '103', '10187');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('886', '166', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '28', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '103', '10188');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('887', '166', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '28', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '103', '10189');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('888', '166', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '28', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '103', '10190');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('889', '166', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '28', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '103', '10191');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('890', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '28', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '103', '10192');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('891', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '28', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '103', '10193');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('892', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '28', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '103', '10194');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('893', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '28', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '103', '10195');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('894', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '28', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '103', '10196');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('895', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '28', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '103', '10197');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('896', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '28', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '103', '10198');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('897', '166', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '28', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '103', '10199');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('898', '166', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '28', '44');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '103', '10200');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('899', '166', '44');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '28', '45');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '103', '10201');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('900', '166', '45');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '28', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '103', '10202');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('901', '166', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '28', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '103', '10203');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('902', '166', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '28', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '103', '10204');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('903', '166', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '28', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '103', '10205');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('904', '166', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '28', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '103', '10206');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('905', '166', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '28', '70');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '103', '10207');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('906', '166', '70');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '28', '62');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '103', '10208');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('907', '166', '62');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '28', '66');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '103', '10209');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('908', '166', '66');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '28', '67');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '103', '10210');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('909', '166', '67');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '28', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '103', '10211');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('910', '166', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '28', '84');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '103', '10212');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('911', '166', '84');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '28', '86');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '103', '10213');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('912', '166', '86');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '28', '87');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '103', '10214');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('913', '166', '87');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '28', '89');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '103', '10215');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('914', '166', '89');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '28', '134');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '38', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '103', '10216');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('915', '166', '134');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '28', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '103', '10217');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('916', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '28', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '103', '10218');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('917', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '28', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '103', '10219');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('918', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '28', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '103', '10220');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('919', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '28', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '103', '10221');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('920', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '28', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '103', '10222');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('921', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '28', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '103', '10223');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('922', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '28', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '103', '10224');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('923', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '28', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '103', '10225');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('924', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '28', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '103', '10226');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('925', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '28', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '103', '10227');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('926', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '28', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '103', '10228');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('927', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '28', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '103', '10229');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('928', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '28', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '103', '10230');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('929', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '28', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '103', '10231');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('930', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '28', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '103', '10232');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('931', '166', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '28', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '103', '10233');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('932', '166', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '28', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '103', '10234');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('933', '166', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '28', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '103', '10235');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('934', '166', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '28', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '103', '10236');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('935', '166', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '28', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '103', '10237');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('936', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '28', '38');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '103', '10238');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('937', '166', '38');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '28', '38');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '103', '10239');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('938', '166', '38');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '28', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '103', '10240');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('939', '166', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '28', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '103', '10241');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('940', '166', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '28', '41');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '103', '10242');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('941', '166', '41');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '28', '51');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '103', '10243');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('942', '166', '51');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '28', '52');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '103', '10244');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('943', '166', '52');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '28', '53');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '103', '10245');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('944', '166', '53');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '28', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '103', '10246');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('945', '166', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '28', '56');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '103', '10247');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('946', '166', '56');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '28', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '103', '10248');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('947', '166', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '28', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '103', '10249');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('948', '166', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '28', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '103', '10250');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('949', '166', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '28', '65');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '103', '10251');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('950', '166', '65');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '28', '70');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '103', '10252');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('951', '166', '70');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '28', '71');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '103', '10253');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('952', '166', '71');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '28', '79');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '103', '10254');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('953', '166', '79');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '28', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '103', '10255');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('954', '166', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '28', '76');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '103', '10256');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('955', '166', '76');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '28', '78');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '103', '10257');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('956', '166', '78');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '28', '89');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '103', '10258');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('957', '166', '89');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '28', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '103', '10259');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('958', '166', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '28', '92');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '103', '10260');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('959', '166', '92');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '28', '93');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '103', '10261');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('960', '166', '93');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '28', '93');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '103', '10262');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('961', '166', '93');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '28', '98');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '103', '10263');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('962', '166', '98');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '28', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '103', '10264');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('963', '166', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '28', '112');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '103', '10265');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('964', '166', '112');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '28', '102');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '103', '10266');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('965', '166', '102');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '28', '105');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '103', '10267');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('966', '166', '105');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '28', '112');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '103', '10268');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('967', '166', '112');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '28', '118');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '103', '10269');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('968', '166', '118');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '28', '118');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '103', '10270');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('969', '166', '118');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '28', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '103', '10271');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('970', '166', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '4', 'Mag-ES');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '28', '142');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '103', '10272');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('971', '166', '142');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '28', '151');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '103', '10273');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('972', '166', '151');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '28', '152');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '103', '10274');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('973', '166', '152');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '28', '148');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '40', '2 + 3');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '41', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '103', '10275');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('974', '166', '148');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '28', '189');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '40', '2 + 3');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '41', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '103', '10276');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('975', '166', '189');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '28', '156');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '103', '10277');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('976', '166', '156');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '28', '175');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '103', '10278');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('977', '166', '175');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '28', '182');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '103', '10279');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('978', '166', '182');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '28', '226');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '103', '10280');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('979', '166', '226');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '28', '204');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '103', '10281');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('980', '166', '204');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '28', '224');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '103', '10282');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('981', '166', '224');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '28', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '103', '10283');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('982', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '28', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '103', '10284');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('983', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '28', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '103', '10285');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('984', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '28', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '103', '10286');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('985', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '28', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '103', '10287');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('986', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '28', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '103', '10288');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('987', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '28', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '103', '10289');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('988', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '28', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '103', '10290');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('989', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '28', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '103', '10291');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('990', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '28', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '103', '10292');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('991', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '28', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '103', '10293');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('992', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '28', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '103', '10294');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('993', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '28', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '103', '10295');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('994', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '28', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '103', '10296');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('995', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '28', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '103', '10297');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('996', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '28', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '103', '10298');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('997', '166', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '28', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '103', '10299');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('998', '166', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '28', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '103', '10300');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('999', '166', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '28', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '103', '10301');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1000', '166', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '28', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '103', '10302');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1001', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '28', '38');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '103', '10303');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1002', '166', '38');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '28', '38');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '103', '10304');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1003', '166', '38');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '28', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '103', '10305');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1004', '166', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '28', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '103', '10306');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1005', '166', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '28', '41');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '103', '10307');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1006', '166', '41');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '28', '51');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '103', '10308');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1007', '166', '51');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '28', '52');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '103', '10309');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1008', '166', '52');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '28', '53');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '103', '10310');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1009', '166', '53');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '28', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '103', '10311');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1010', '166', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '28', '56');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '103', '10312');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1011', '166', '56');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '28', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '103', '10313');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1012', '166', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '28', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '103', '10314');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1013', '166', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '28', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '103', '10315');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1014', '166', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '28', '65');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '103', '10316');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1015', '166', '65');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '28', '70');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '103', '10317');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1016', '166', '70');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '28', '79');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '103', '10318');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1017', '166', '79');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '28', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '103', '10319');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1018', '166', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '28', '76');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '103', '10320');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1019', '166', '76');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '28', '78');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '103', '10321');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1020', '166', '78');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '28', '89');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '103', '10322');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1021', '166', '89');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '28', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '103', '10323');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1022', '166', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '28', '92');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '103', '10324');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1023', '166', '92');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '28', '93');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '103', '10325');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1024', '166', '93');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '28', '93');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '103', '10326');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1025', '166', '93');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '28', '98');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '103', '10327');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1026', '166', '98');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '28', '112');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '103', '10328');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1027', '166', '112');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '28', '102');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '103', '10329');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1028', '166', '102');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '28', '105');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '103', '10330');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1029', '166', '105');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '28', '112');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '103', '10331');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1030', '166', '112');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '28', '118');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '103', '10332');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1031', '166', '118');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '28', '118');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '103', '10333');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1032', '166', '118');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '28', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '103', '10334');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1033', '166', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '28', '151');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '103', '10335');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1034', '166', '151');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '28', '152');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '103', '10336');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1035', '166', '152');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '28', '148');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '40', '2 + 3');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '41', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '103', '10337');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1036', '166', '148');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '28', '189');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '40', '2 + 3');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '41', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '103', '10338');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1037', '166', '189');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '28', '156');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '103', '10339');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1038', '166', '156');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '28', '175');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '103', '10340');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1039', '166', '175');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '28', '182');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '103', '10341');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1040', '166', '182');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '28', '226');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '103', '10342');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1041', '166', '226');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '28', '204');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '103', '10343');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1042', '166', '204');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '28', '224');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '43', '2nd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '103', '10344');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1043', '166', '224');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '3', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '28', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '103', '10345');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1044', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '28', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '103', '10346');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1045', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '28', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '103', '10347');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1046', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '28', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '103', '10348');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1047', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '3', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '28', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '103', '10349');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1048', '166', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '28', '44');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '103', '10350');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1049', '166', '44');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '3', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '28', '45');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '103', '10351');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1050', '166', '45');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '28', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '103', '10352');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1051', '166', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '28', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '103', '10353');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1052', '166', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '28', '51');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '103', '10354');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1053', '166', '51');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '28', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '103', '10355');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1054', '166', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '3', '1.15');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '28', '64');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '103', '10356');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1055', '166', '64');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '3', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '28', '63');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '103', '10357');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1056', '166', '63');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '28', '66');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '103', '10358');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1057', '166', '66');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '3', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '28', '67');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '103', '10359');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1058', '166', '67');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '28', '73');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '103', '10360');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1059', '166', '73');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '28', '74');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '103', '10361');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1060', '166', '74');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '28', '77');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '103', '10362');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1061', '166', '77');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '28', '83');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '103', '10363');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1062', '166', '83');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '3', '1.15');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '28', '97');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '103', '10364');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1063', '166', '97');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '3', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '28', '79');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '103', '10365');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1064', '166', '79');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '3', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '28', '84');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '103', '10366');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1065', '166', '84');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '28', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '103', '10367');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1066', '166', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '3', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '28', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '103', '10368');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1067', '166', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '28', '94');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '103', '10369');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1068', '166', '94');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '28', '99');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '103', '10370');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1069', '166', '99');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '28', '102');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '103', '10371');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1070', '166', '102');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '28', '108');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '103', '10372');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1071', '166', '108');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '3', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '28', '135');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '40', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '103', '10373');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1072', '166', '135');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '28', '142');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '103', '10374');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1073', '166', '142');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '28', '153');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '40', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '103', '10375');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1074', '166', '153');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '28', '162');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '103', '10376');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1075', '166', '162');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '3', '0.78');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '28', '180');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '40', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '103', '10377');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1076', '166', '180');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '28', '188');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '103', '10378');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1077', '166', '188');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '28', '204');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '40', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '103', '10379');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1078', '166', '204');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '4', 'Elec-Prem');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '28', '216');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '43', '3rd Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '103', '10380');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1079', '166', '216');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '3', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '28', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '103', '10381');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1080', '166', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '3', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '28', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '39', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '103', '10382');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1081', '166', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '3', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '28', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '39', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '103', '10383');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1082', '166', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '3', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '28', '65');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '39', '65');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '103', '10384');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1083', '166', '65');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '3', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '28', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '103', '10385');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1084', '166', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '3', '0');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '28', '45');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '38', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '39', '45');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '43', '1st Gen');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '103', '10386');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1085', '166', '45');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '28', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '103', '10387');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1086', '166', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '28', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '103', '10388');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1087', '166', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '28', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '103', '10389');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1088', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '28', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '103', '10390');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1089', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '28', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '103', '10391');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1090', '166', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '28', '67');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '103', '10392');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1091', '166', '67');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '28', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '103', '10393');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1092', '166', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '28', '73');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '103', '10394');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1093', '166', '73');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '28', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '103', '10395');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1094', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '28', '106');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '103', '10396');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1095', '166', '106');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '28', '108');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '103', '10397');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1096', '166', '108');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '28', '126');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '103', '10398');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1097', '166', '126');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '28', '134');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '38', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '103', '10399');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1098', '166', '134');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '28', '49');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '39', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '103', '10400');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1099', '166', '49');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '28', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '39', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '103', '10401');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1100', '166', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '28', '57');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '39', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '103', '10402');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1101', '166', '57');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '28', '58');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '39', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '103', '10403');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1102', '166', '58');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '3', '1.03');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '28', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '39', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '103', '10404');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1103', '166', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '3', '1.18');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '28', '71');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '39', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '103', '10405');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1104', '166', '71');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '3', '0.88');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '28', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '39', '86');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '103', '10406');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1105', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '3', '0.8');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '28', '98');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '39', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '103', '10407');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1106', '166', '98');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '28', '109');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '39', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '103', '10408');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1107', '166', '109');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '28', '160');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '39', '86');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '103', '10409');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1108', '166', '160');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '28', '167');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '39', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '103', '10410');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1109', '166', '167');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '28', '219');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '39', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '103', '10411');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1110', '166', '219');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '28', '320');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '39', '86');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '43', 'Std HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '103', '10412');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1111', '166', '320');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '3', '0.9');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '28', '328');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '37', 'T8');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '38', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '39', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '103', '10413');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1112', '166', '328');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '28', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '38', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '39', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '103', '10414');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1113', '166', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '28', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '38', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '39', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '103', '10415');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1114', '166', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '28', '52');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '38', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '39', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '103', '10416');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1115', '166', '52');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '28', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '38', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '39', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '103', '10417');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1116', '166', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '28', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '38', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '39', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '103', '10418');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1117', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '28', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '38', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '39', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '103', '10419');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1118', '166', '48');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '28', '73');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '38', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '39', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '103', '10420');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1119', '166', '73');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '28', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '38', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '39', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '103', '10421');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1120', '166', '96');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '28', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '103', '10422');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1121', '166', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '28', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '103', '10423');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1122', '166', '33');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '28', '64');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '103', '10424');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1123', '166', '64');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '28', '97');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '103', '10425');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1124', '166', '97');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '28', '128');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '103', '10426');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1125', '166', '128');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '28', '192');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '103', '10427');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1126', '166', '192');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '28', '256');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '103', '10428');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1127', '166', '256');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '28', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '38', '58');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '39', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '103', '10429');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1128', '166', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '28', '78');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '38', '58');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '39', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '103', '10430');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1129', '166', '78');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '28', '118');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '38', '58');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '39', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '103', '10431');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1130', '166', '118');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '28', '156');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '38', '58');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '39', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '103', '10432');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1131', '166', '156');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '28', '234');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '38', '58');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '39', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '103', '10433');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1132', '166', '234');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '28', '312');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '37', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '38', '58');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '39', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '103', '10434');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1133', '166', '312');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '28', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '38', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '39', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '103', '10435');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1134', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '28', '52');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '38', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '39', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '103', '10436');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1135', '166', '52');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '28', '79');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '38', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '39', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '103', '10437');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1136', '166', '79');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '28', '104');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '38', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '39', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '103', '10438');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1137', '166', '104');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '28', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '38', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '103', '10439');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1138', '166', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '28', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '38', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '103', '10440');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1139', '166', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '28', '127');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '38', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '40', '1 + 2');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '103', '10441');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1140', '166', '127');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '28', '170');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '38', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '103', '10442');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1141', '166', '170');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '28', '255');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '38', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '103', '10443');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1142', '166', '255');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '28', '340');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '38', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '39', '39');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '103', '10444');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1143', '166', '340');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '28', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '39', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '103', '10445');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1144', '166', '59');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '28', '62');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '39', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '103', '10446');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1145', '166', '62');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '28', '117');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '39', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '103', '10447');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1146', '166', '117');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '28', '179');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '39', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '41', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '103', '10448');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1147', '166', '179');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '28', '234');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '39', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '41', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '103', '10449');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1148', '166', '234');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '28', '351');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '39', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '40', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '41', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '103', '10450');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1149', '166', '351');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '28', '468');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '38', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '39', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '40', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '41', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '103', '10451');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1150', '166', '468');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '3', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '4', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '28', '89');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '37', 'T5HO');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '38', '58');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '39', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '43', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '103', '10452');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '104', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1151', '166', '89');
INSERT INTO "tech"."TechID2Param" VALUES ('1152', '28', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1152', '39', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1152', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1152', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1152', '103', '10595');
INSERT INTO "tech"."TechID2Param" VALUES ('1152', '105', 'HPS');
INSERT INTO "tech"."TechID2Param" VALUES ('1152', '106', 'Reactor');
INSERT INTO "tech"."TechID2Param" VALUES ('1152', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1152', '166', '46');
INSERT INTO "tech"."TechID2Param" VALUES ('1153', '28', '66');
INSERT INTO "tech"."TechID2Param" VALUES ('1153', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1153', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1153', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1153', '103', '10596');
INSERT INTO "tech"."TechID2Param" VALUES ('1153', '105', 'HPS');
INSERT INTO "tech"."TechID2Param" VALUES ('1153', '106', 'Reactor');
INSERT INTO "tech"."TechID2Param" VALUES ('1153', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1153', '166', '66');
INSERT INTO "tech"."TechID2Param" VALUES ('1154', '28', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1154', '39', '70');
INSERT INTO "tech"."TechID2Param" VALUES ('1154', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1154', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1154', '103', '10597');
INSERT INTO "tech"."TechID2Param" VALUES ('1154', '105', 'HPS');
INSERT INTO "tech"."TechID2Param" VALUES ('1154', '106', 'Reactor');
INSERT INTO "tech"."TechID2Param" VALUES ('1154', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1154', '166', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1155', '28', '138');
INSERT INTO "tech"."TechID2Param" VALUES ('1155', '39', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1155', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1155', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1155', '103', '10598');
INSERT INTO "tech"."TechID2Param" VALUES ('1155', '105', 'HPS');
INSERT INTO "tech"."TechID2Param" VALUES ('1155', '106', 'Reactor');
INSERT INTO "tech"."TechID2Param" VALUES ('1155', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1155', '166', '138');
INSERT INTO "tech"."TechID2Param" VALUES ('1156', '28', '188');
INSERT INTO "tech"."TechID2Param" VALUES ('1156', '39', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1156', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1156', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1156', '103', '10599');
INSERT INTO "tech"."TechID2Param" VALUES ('1156', '105', 'HPS');
INSERT INTO "tech"."TechID2Param" VALUES ('1156', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1156', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1156', '166', '188');
INSERT INTO "tech"."TechID2Param" VALUES ('1157', '28', '250');
INSERT INTO "tech"."TechID2Param" VALUES ('1157', '39', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1157', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1157', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1157', '103', '10600');
INSERT INTO "tech"."TechID2Param" VALUES ('1157', '105', 'HPS');
INSERT INTO "tech"."TechID2Param" VALUES ('1157', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1157', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1157', '166', '250');
INSERT INTO "tech"."TechID2Param" VALUES ('1158', '28', '295');
INSERT INTO "tech"."TechID2Param" VALUES ('1158', '39', '250');
INSERT INTO "tech"."TechID2Param" VALUES ('1158', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1158', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1158', '103', '10601');
INSERT INTO "tech"."TechID2Param" VALUES ('1158', '105', 'HPS');
INSERT INTO "tech"."TechID2Param" VALUES ('1158', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1158', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1158', '166', '295');
INSERT INTO "tech"."TechID2Param" VALUES ('1159', '28', '365');
INSERT INTO "tech"."TechID2Param" VALUES ('1159', '39', '310');
INSERT INTO "tech"."TechID2Param" VALUES ('1159', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1159', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1159', '103', '10602');
INSERT INTO "tech"."TechID2Param" VALUES ('1159', '105', 'HPS');
INSERT INTO "tech"."TechID2Param" VALUES ('1159', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1159', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1159', '166', '365');
INSERT INTO "tech"."TechID2Param" VALUES ('1160', '28', '414');
INSERT INTO "tech"."TechID2Param" VALUES ('1160', '39', '360');
INSERT INTO "tech"."TechID2Param" VALUES ('1160', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1160', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1160', '103', '10603');
INSERT INTO "tech"."TechID2Param" VALUES ('1160', '105', 'HPS');
INSERT INTO "tech"."TechID2Param" VALUES ('1160', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1160', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1160', '166', '414');
INSERT INTO "tech"."TechID2Param" VALUES ('1161', '28', '465');
INSERT INTO "tech"."TechID2Param" VALUES ('1161', '39', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1161', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1161', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1161', '103', '10604');
INSERT INTO "tech"."TechID2Param" VALUES ('1161', '105', 'HPS');
INSERT INTO "tech"."TechID2Param" VALUES ('1161', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1161', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1161', '166', '465');
INSERT INTO "tech"."TechID2Param" VALUES ('1162', '28', '1100');
INSERT INTO "tech"."TechID2Param" VALUES ('1162', '39', '1000');
INSERT INTO "tech"."TechID2Param" VALUES ('1162', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1162', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1162', '103', '10605');
INSERT INTO "tech"."TechID2Param" VALUES ('1162', '105', 'HPS');
INSERT INTO "tech"."TechID2Param" VALUES ('1162', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1162', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1162', '166', '1100');
INSERT INTO "tech"."TechID2Param" VALUES ('1163', '28', '141');
INSERT INTO "tech"."TechID2Param" VALUES ('1163', '39', '125');
INSERT INTO "tech"."TechID2Param" VALUES ('1163', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1163', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1163', '103', '10606');
INSERT INTO "tech"."TechID2Param" VALUES ('1163', '105', 'PSMH');
INSERT INTO "tech"."TechID2Param" VALUES ('1163', '106', 'Reactor');
INSERT INTO "tech"."TechID2Param" VALUES ('1163', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1163', '166', '141');
INSERT INTO "tech"."TechID2Param" VALUES ('1164', '28', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1164', '39', '125');
INSERT INTO "tech"."TechID2Param" VALUES ('1164', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1164', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1164', '103', '10607');
INSERT INTO "tech"."TechID2Param" VALUES ('1164', '105', 'PSMH');
INSERT INTO "tech"."TechID2Param" VALUES ('1164', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1164', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1164', '166', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1165', '28', '208');
INSERT INTO "tech"."TechID2Param" VALUES ('1165', '39', '175');
INSERT INTO "tech"."TechID2Param" VALUES ('1165', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1165', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1165', '103', '10608');
INSERT INTO "tech"."TechID2Param" VALUES ('1165', '105', 'PSMH');
INSERT INTO "tech"."TechID2Param" VALUES ('1165', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1165', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1165', '166', '208');
INSERT INTO "tech"."TechID2Param" VALUES ('1166', '28', '232');
INSERT INTO "tech"."TechID2Param" VALUES ('1166', '39', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1166', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1166', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1166', '103', '10609');
INSERT INTO "tech"."TechID2Param" VALUES ('1166', '105', 'PSMH');
INSERT INTO "tech"."TechID2Param" VALUES ('1166', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1166', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1166', '166', '232');
INSERT INTO "tech"."TechID2Param" VALUES ('1167', '28', '288');
INSERT INTO "tech"."TechID2Param" VALUES ('1167', '39', '250');
INSERT INTO "tech"."TechID2Param" VALUES ('1167', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1167', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1167', '103', '10610');
INSERT INTO "tech"."TechID2Param" VALUES ('1167', '105', 'PSMH');
INSERT INTO "tech"."TechID2Param" VALUES ('1167', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1167', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1167', '166', '288');
INSERT INTO "tech"."TechID2Param" VALUES ('1168', '28', '365');
INSERT INTO "tech"."TechID2Param" VALUES ('1168', '39', '320');
INSERT INTO "tech"."TechID2Param" VALUES ('1168', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1168', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1168', '103', '10611');
INSERT INTO "tech"."TechID2Param" VALUES ('1168', '105', 'PSMH');
INSERT INTO "tech"."TechID2Param" VALUES ('1168', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1168', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1168', '166', '365');
INSERT INTO "tech"."TechID2Param" VALUES ('1169', '28', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1169', '39', '350');
INSERT INTO "tech"."TechID2Param" VALUES ('1169', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1169', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1169', '103', '10612');
INSERT INTO "tech"."TechID2Param" VALUES ('1169', '105', 'PSMH');
INSERT INTO "tech"."TechID2Param" VALUES ('1169', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1169', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1169', '166', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1170', '28', '456');
INSERT INTO "tech"."TechID2Param" VALUES ('1170', '39', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1170', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1170', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1170', '103', '10613');
INSERT INTO "tech"."TechID2Param" VALUES ('1170', '105', 'PSMH');
INSERT INTO "tech"."TechID2Param" VALUES ('1170', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1170', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1170', '166', '456');
INSERT INTO "tech"."TechID2Param" VALUES ('1171', '28', '506');
INSERT INTO "tech"."TechID2Param" VALUES ('1171', '39', '450');
INSERT INTO "tech"."TechID2Param" VALUES ('1171', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1171', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1171', '103', '10614');
INSERT INTO "tech"."TechID2Param" VALUES ('1171', '105', 'PSMH');
INSERT INTO "tech"."TechID2Param" VALUES ('1171', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1171', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1171', '166', '506');
INSERT INTO "tech"."TechID2Param" VALUES ('1172', '28', '818');
INSERT INTO "tech"."TechID2Param" VALUES ('1172', '39', '750');
INSERT INTO "tech"."TechID2Param" VALUES ('1172', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1172', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1172', '103', '10615');
INSERT INTO "tech"."TechID2Param" VALUES ('1172', '105', 'PSMH');
INSERT INTO "tech"."TechID2Param" VALUES ('1172', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1172', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1172', '166', '818');
INSERT INTO "tech"."TechID2Param" VALUES ('1173', '28', '940');
INSERT INTO "tech"."TechID2Param" VALUES ('1173', '39', '875');
INSERT INTO "tech"."TechID2Param" VALUES ('1173', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1173', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1173', '103', '10616');
INSERT INTO "tech"."TechID2Param" VALUES ('1173', '105', 'PSMH');
INSERT INTO "tech"."TechID2Param" VALUES ('1173', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1173', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1173', '166', '940');
INSERT INTO "tech"."TechID2Param" VALUES ('1174', '28', '1080');
INSERT INTO "tech"."TechID2Param" VALUES ('1174', '39', '1000');
INSERT INTO "tech"."TechID2Param" VALUES ('1174', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1174', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1174', '103', '10617');
INSERT INTO "tech"."TechID2Param" VALUES ('1174', '105', 'PSMH');
INSERT INTO "tech"."TechID2Param" VALUES ('1174', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1174', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1174', '166', '1080');
INSERT INTO "tech"."TechID2Param" VALUES ('1175', '28', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('1175', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1175', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1175', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1175', '103', '10618');
INSERT INTO "tech"."TechID2Param" VALUES ('1175', '105', 'MH');
INSERT INTO "tech"."TechID2Param" VALUES ('1175', '106', 'Reactor');
INSERT INTO "tech"."TechID2Param" VALUES ('1175', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1175', '166', '43');
INSERT INTO "tech"."TechID2Param" VALUES ('1176', '28', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('1176', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1176', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1176', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1176', '103', '10619');
INSERT INTO "tech"."TechID2Param" VALUES ('1176', '105', 'MH');
INSERT INTO "tech"."TechID2Param" VALUES ('1176', '106', 'Reactor');
INSERT INTO "tech"."TechID2Param" VALUES ('1176', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1176', '166', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('1177', '28', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1177', '39', '70');
INSERT INTO "tech"."TechID2Param" VALUES ('1177', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1177', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1177', '103', '10620');
INSERT INTO "tech"."TechID2Param" VALUES ('1177', '105', 'MH');
INSERT INTO "tech"."TechID2Param" VALUES ('1177', '106', 'Reactor');
INSERT INTO "tech"."TechID2Param" VALUES ('1177', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1177', '166', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1178', '28', '128');
INSERT INTO "tech"."TechID2Param" VALUES ('1178', '39', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1178', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1178', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1178', '103', '10621');
INSERT INTO "tech"."TechID2Param" VALUES ('1178', '105', 'MH');
INSERT INTO "tech"."TechID2Param" VALUES ('1178', '106', 'Reactor');
INSERT INTO "tech"."TechID2Param" VALUES ('1178', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1178', '166', '128');
INSERT INTO "tech"."TechID2Param" VALUES ('1179', '28', '190');
INSERT INTO "tech"."TechID2Param" VALUES ('1179', '39', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1179', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1179', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1179', '103', '10622');
INSERT INTO "tech"."TechID2Param" VALUES ('1179', '105', 'MH');
INSERT INTO "tech"."TechID2Param" VALUES ('1179', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1179', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1179', '166', '190');
INSERT INTO "tech"."TechID2Param" VALUES ('1180', '28', '215');
INSERT INTO "tech"."TechID2Param" VALUES ('1180', '39', '175');
INSERT INTO "tech"."TechID2Param" VALUES ('1180', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1180', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1180', '103', '10623');
INSERT INTO "tech"."TechID2Param" VALUES ('1180', '105', 'MH');
INSERT INTO "tech"."TechID2Param" VALUES ('1180', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1180', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1180', '166', '215');
INSERT INTO "tech"."TechID2Param" VALUES ('1181', '28', '295');
INSERT INTO "tech"."TechID2Param" VALUES ('1181', '39', '250');
INSERT INTO "tech"."TechID2Param" VALUES ('1181', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1181', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1181', '103', '10624');
INSERT INTO "tech"."TechID2Param" VALUES ('1181', '105', 'MH');
INSERT INTO "tech"."TechID2Param" VALUES ('1181', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1181', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1181', '166', '295');
INSERT INTO "tech"."TechID2Param" VALUES ('1182', '28', '458');
INSERT INTO "tech"."TechID2Param" VALUES ('1182', '39', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1182', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1182', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1182', '103', '10625');
INSERT INTO "tech"."TechID2Param" VALUES ('1182', '105', 'MH');
INSERT INTO "tech"."TechID2Param" VALUES ('1182', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1182', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1182', '166', '458');
INSERT INTO "tech"."TechID2Param" VALUES ('1183', '28', '916');
INSERT INTO "tech"."TechID2Param" VALUES ('1183', '39', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1183', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1183', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1183', '103', '10626');
INSERT INTO "tech"."TechID2Param" VALUES ('1183', '105', 'MH');
INSERT INTO "tech"."TechID2Param" VALUES ('1183', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1183', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1183', '166', '916');
INSERT INTO "tech"."TechID2Param" VALUES ('1184', '28', '817');
INSERT INTO "tech"."TechID2Param" VALUES ('1184', '39', '750');
INSERT INTO "tech"."TechID2Param" VALUES ('1184', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1184', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1184', '103', '10627');
INSERT INTO "tech"."TechID2Param" VALUES ('1184', '105', 'MH');
INSERT INTO "tech"."TechID2Param" VALUES ('1184', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1184', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1184', '166', '817');
INSERT INTO "tech"."TechID2Param" VALUES ('1185', '28', '1080');
INSERT INTO "tech"."TechID2Param" VALUES ('1185', '39', '1000');
INSERT INTO "tech"."TechID2Param" VALUES ('1185', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1185', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1185', '103', '10628');
INSERT INTO "tech"."TechID2Param" VALUES ('1185', '105', 'MH');
INSERT INTO "tech"."TechID2Param" VALUES ('1185', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1185', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1185', '166', '1080');
INSERT INTO "tech"."TechID2Param" VALUES ('1186', '28', '1610');
INSERT INTO "tech"."TechID2Param" VALUES ('1186', '39', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1186', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1186', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1186', '103', '10629');
INSERT INTO "tech"."TechID2Param" VALUES ('1186', '105', 'MH');
INSERT INTO "tech"."TechID2Param" VALUES ('1186', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1186', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1186', '166', '1610');
INSERT INTO "tech"."TechID2Param" VALUES ('1187', '28', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1187', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1187', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1187', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1187', '103', '10630');
INSERT INTO "tech"."TechID2Param" VALUES ('1187', '105', 'MV');
INSERT INTO "tech"."TechID2Param" VALUES ('1187', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1187', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1187', '166', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1188', '28', '74');
INSERT INTO "tech"."TechID2Param" VALUES ('1188', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1188', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1188', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1188', '103', '10631');
INSERT INTO "tech"."TechID2Param" VALUES ('1188', '105', 'MV');
INSERT INTO "tech"."TechID2Param" VALUES ('1188', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1188', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1188', '166', '74');
INSERT INTO "tech"."TechID2Param" VALUES ('1189', '28', '93');
INSERT INTO "tech"."TechID2Param" VALUES ('1189', '39', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('1189', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1189', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1189', '103', '10632');
INSERT INTO "tech"."TechID2Param" VALUES ('1189', '105', 'MV');
INSERT INTO "tech"."TechID2Param" VALUES ('1189', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1189', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1189', '166', '93');
INSERT INTO "tech"."TechID2Param" VALUES ('1190', '28', '125');
INSERT INTO "tech"."TechID2Param" VALUES ('1190', '39', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1190', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1190', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1190', '103', '10633');
INSERT INTO "tech"."TechID2Param" VALUES ('1190', '105', 'MV');
INSERT INTO "tech"."TechID2Param" VALUES ('1190', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1190', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1190', '166', '125');
INSERT INTO "tech"."TechID2Param" VALUES ('1191', '28', '205');
INSERT INTO "tech"."TechID2Param" VALUES ('1191', '39', '175');
INSERT INTO "tech"."TechID2Param" VALUES ('1191', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1191', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1191', '103', '10634');
INSERT INTO "tech"."TechID2Param" VALUES ('1191', '105', 'MV');
INSERT INTO "tech"."TechID2Param" VALUES ('1191', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1191', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1191', '166', '205');
INSERT INTO "tech"."TechID2Param" VALUES ('1192', '28', '290');
INSERT INTO "tech"."TechID2Param" VALUES ('1192', '39', '250');
INSERT INTO "tech"."TechID2Param" VALUES ('1192', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1192', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1192', '103', '10635');
INSERT INTO "tech"."TechID2Param" VALUES ('1192', '105', 'MV');
INSERT INTO "tech"."TechID2Param" VALUES ('1192', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1192', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1192', '166', '290');
INSERT INTO "tech"."TechID2Param" VALUES ('1193', '28', '455');
INSERT INTO "tech"."TechID2Param" VALUES ('1193', '39', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1193', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1193', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1193', '103', '10636');
INSERT INTO "tech"."TechID2Param" VALUES ('1193', '105', 'MV');
INSERT INTO "tech"."TechID2Param" VALUES ('1193', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1193', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1193', '166', '455');
INSERT INTO "tech"."TechID2Param" VALUES ('1194', '28', '780');
INSERT INTO "tech"."TechID2Param" VALUES ('1194', '39', '700');
INSERT INTO "tech"."TechID2Param" VALUES ('1194', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1194', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1194', '103', '10637');
INSERT INTO "tech"."TechID2Param" VALUES ('1194', '105', 'MV');
INSERT INTO "tech"."TechID2Param" VALUES ('1194', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1194', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1194', '166', '780');
INSERT INTO "tech"."TechID2Param" VALUES ('1195', '28', '910');
INSERT INTO "tech"."TechID2Param" VALUES ('1195', '39', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1195', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1195', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1195', '103', '10638');
INSERT INTO "tech"."TechID2Param" VALUES ('1195', '105', 'MV');
INSERT INTO "tech"."TechID2Param" VALUES ('1195', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1195', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1195', '166', '910');
INSERT INTO "tech"."TechID2Param" VALUES ('1196', '28', '1075');
INSERT INTO "tech"."TechID2Param" VALUES ('1196', '39', '1000');
INSERT INTO "tech"."TechID2Param" VALUES ('1196', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1196', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1196', '103', '10639');
INSERT INTO "tech"."TechID2Param" VALUES ('1196', '105', 'MV');
INSERT INTO "tech"."TechID2Param" VALUES ('1196', '106', 'Mag-CWA');
INSERT INTO "tech"."TechID2Param" VALUES ('1196', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1196', '166', '1075');
INSERT INTO "tech"."TechID2Param" VALUES ('1197', '25', 'CLF');
INSERT INTO "tech"."TechID2Param" VALUES ('1197', '28', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1197', '39', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1197', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1197', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1197', '103', '10735');
INSERT INTO "tech"."TechID2Param" VALUES ('1197', '107', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1197', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1197', '166', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1198', '25', 'CLF');
INSERT INTO "tech"."TechID2Param" VALUES ('1198', '28', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1198', '39', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1198', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1198', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1198', '103', '10736');
INSERT INTO "tech"."TechID2Param" VALUES ('1198', '107', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1198', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1198', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1199', '25', 'CLF');
INSERT INTO "tech"."TechID2Param" VALUES ('1199', '28', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1199', '39', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1199', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1199', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1199', '103', '10737');
INSERT INTO "tech"."TechID2Param" VALUES ('1199', '107', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1199', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1199', '166', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1200', '25', 'CLF');
INSERT INTO "tech"."TechID2Param" VALUES ('1200', '28', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1200', '39', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1200', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1200', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1200', '103', '10738');
INSERT INTO "tech"."TechID2Param" VALUES ('1200', '107', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1200', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1200', '166', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1201', '25', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1201', '28', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('1201', '39', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1201', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1201', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1201', '103', '10739');
INSERT INTO "tech"."TechID2Param" VALUES ('1201', '107', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1201', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1201', '166', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('1202', '25', 'T5');
INSERT INTO "tech"."TechID2Param" VALUES ('1202', '28', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1202', '39', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1202', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1202', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1202', '103', '10740');
INSERT INTO "tech"."TechID2Param" VALUES ('1202', '107', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1202', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1202', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1203', '25', 'CLF');
INSERT INTO "tech"."TechID2Param" VALUES ('1203', '28', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('1203', '39', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1203', '40', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1203', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1203', '103', '10741');
INSERT INTO "tech"."TechID2Param" VALUES ('1203', '107', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1203', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1203', '166', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('1204', '25', 'CLF');
INSERT INTO "tech"."TechID2Param" VALUES ('1204', '28', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1204', '39', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1204', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1204', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1204', '103', '10742');
INSERT INTO "tech"."TechID2Param" VALUES ('1204', '107', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1204', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1204', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1205', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1205', '28', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1205', '39', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1205', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1205', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1205', '103', '10743');
INSERT INTO "tech"."TechID2Param" VALUES ('1205', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1205', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1205', '166', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1206', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1206', '28', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1206', '39', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1206', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1206', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1206', '103', '10744');
INSERT INTO "tech"."TechID2Param" VALUES ('1206', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1206', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1206', '166', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1207', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1207', '28', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1207', '39', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1207', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1207', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1207', '103', '10745');
INSERT INTO "tech"."TechID2Param" VALUES ('1207', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1207', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1207', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1208', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1208', '28', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1208', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1208', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1208', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1208', '103', '10746');
INSERT INTO "tech"."TechID2Param" VALUES ('1208', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1208', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1208', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1209', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1209', '28', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1209', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1209', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1209', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1209', '103', '10747');
INSERT INTO "tech"."TechID2Param" VALUES ('1209', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1209', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1209', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1210', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1210', '28', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1210', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1210', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1210', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1210', '103', '10748');
INSERT INTO "tech"."TechID2Param" VALUES ('1210', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1210', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1210', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1211', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1211', '28', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1211', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1211', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1211', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1211', '103', '10749');
INSERT INTO "tech"."TechID2Param" VALUES ('1211', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1211', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1211', '166', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1212', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1212', '28', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1212', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1212', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1212', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1212', '103', '10750');
INSERT INTO "tech"."TechID2Param" VALUES ('1212', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1212', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1212', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1213', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1213', '28', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1213', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1213', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1213', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1213', '103', '10751');
INSERT INTO "tech"."TechID2Param" VALUES ('1213', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1213', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1213', '166', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1214', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1214', '28', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1214', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1214', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1214', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1214', '103', '10752');
INSERT INTO "tech"."TechID2Param" VALUES ('1214', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1214', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1214', '166', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1215', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1215', '28', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('1215', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1215', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1215', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1215', '103', '10753');
INSERT INTO "tech"."TechID2Param" VALUES ('1215', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1215', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1215', '166', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('1216', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1216', '28', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1216', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1216', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1216', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1216', '103', '10754');
INSERT INTO "tech"."TechID2Param" VALUES ('1216', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1216', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1216', '166', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1217', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1217', '28', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1217', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1217', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1217', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1217', '103', '10755');
INSERT INTO "tech"."TechID2Param" VALUES ('1217', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1217', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1217', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1218', '25', 'Incand');
INSERT INTO "tech"."TechID2Param" VALUES ('1218', '28', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1218', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1218', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1218', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1218', '103', '10756');
INSERT INTO "tech"."TechID2Param" VALUES ('1218', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1218', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1218', '166', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1219', '25', 'Hal_IR');
INSERT INTO "tech"."TechID2Param" VALUES ('1219', '28', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1219', '39', '7.5');
INSERT INTO "tech"."TechID2Param" VALUES ('1219', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1219', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1219', '103', '10757');
INSERT INTO "tech"."TechID2Param" VALUES ('1219', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1219', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1219', '166', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1220', '25', 'Hal_IR');
INSERT INTO "tech"."TechID2Param" VALUES ('1220', '28', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1220', '39', '7.5');
INSERT INTO "tech"."TechID2Param" VALUES ('1220', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1220', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1220', '103', '10758');
INSERT INTO "tech"."TechID2Param" VALUES ('1220', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1220', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1220', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1221', '25', 'Hal_IR');
INSERT INTO "tech"."TechID2Param" VALUES ('1221', '28', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1221', '39', '7.5');
INSERT INTO "tech"."TechID2Param" VALUES ('1221', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1221', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1221', '103', '10759');
INSERT INTO "tech"."TechID2Param" VALUES ('1221', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1221', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1221', '166', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1222', '25', 'Hal_IR');
INSERT INTO "tech"."TechID2Param" VALUES ('1222', '28', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1222', '39', '7.5');
INSERT INTO "tech"."TechID2Param" VALUES ('1222', '40', 'na');
INSERT INTO "tech"."TechID2Param" VALUES ('1222', '41', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1222', '103', '10760');
INSERT INTO "tech"."TechID2Param" VALUES ('1222', '107', 'none');
INSERT INTO "tech"."TechID2Param" VALUES ('1222', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1222', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1223', '25', 'LED');
INSERT INTO "tech"."TechID2Param" VALUES ('1223', '28', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1223', '39', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1223', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1223', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1223', '103', '10761');
INSERT INTO "tech"."TechID2Param" VALUES ('1223', '107', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1223', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1223', '166', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1224', '25', 'LED');
INSERT INTO "tech"."TechID2Param" VALUES ('1224', '28', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1224', '39', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1224', '40', '2');
INSERT INTO "tech"."TechID2Param" VALUES ('1224', '41', '1');
INSERT INTO "tech"."TechID2Param" VALUES ('1224', '103', '10762');
INSERT INTO "tech"."TechID2Param" VALUES ('1224', '107', 'Electronic');
INSERT INTO "tech"."TechID2Param" VALUES ('1224', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1224', '166', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1225', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1225', '103', '10660');
INSERT INTO "tech"."TechID2Param" VALUES ('1225', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1225', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1225', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1225', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1225', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1225', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1226', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1226', '103', '10661');
INSERT INTO "tech"."TechID2Param" VALUES ('1226', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1226', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1226', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1226', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1226', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1226', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1227', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1227', '103', '10662');
INSERT INTO "tech"."TechID2Param" VALUES ('1227', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1227', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1227', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1227', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1227', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1227', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1228', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1228', '103', '10663');
INSERT INTO "tech"."TechID2Param" VALUES ('1228', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1228', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1228', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1228', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1228', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1228', '166', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1229', '39', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1229', '103', '10664');
INSERT INTO "tech"."TechID2Param" VALUES ('1229', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1229', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1229', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1229', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1229', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1229', '166', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1230', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1230', '103', '10665');
INSERT INTO "tech"."TechID2Param" VALUES ('1230', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1230', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1230', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1230', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1230', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1230', '166', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1231', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1231', '103', '10666');
INSERT INTO "tech"."TechID2Param" VALUES ('1231', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1231', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1231', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1231', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1231', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1231', '166', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1232', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1232', '103', '10667');
INSERT INTO "tech"."TechID2Param" VALUES ('1232', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1232', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1232', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1232', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1232', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1232', '166', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1233', '39', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('1233', '103', '10668');
INSERT INTO "tech"."TechID2Param" VALUES ('1233', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1233', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1233', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1233', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1233', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1233', '166', '68');
INSERT INTO "tech"."TechID2Param" VALUES ('1234', '39', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1234', '103', '10669');
INSERT INTO "tech"."TechID2Param" VALUES ('1234', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1234', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1234', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1234', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1234', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1234', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1235', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1235', '103', '10670');
INSERT INTO "tech"."TechID2Param" VALUES ('1235', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1235', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1235', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1235', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1235', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1235', '166', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1236', '39', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1236', '103', '10671');
INSERT INTO "tech"."TechID2Param" VALUES ('1236', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1236', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1236', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1236', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1236', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1236', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1237', '39', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1237', '103', '10672');
INSERT INTO "tech"."TechID2Param" VALUES ('1237', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1237', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1237', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1237', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1237', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1237', '166', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1238', '39', '45');
INSERT INTO "tech"."TechID2Param" VALUES ('1238', '103', '10673');
INSERT INTO "tech"."TechID2Param" VALUES ('1238', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1238', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1238', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1238', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1238', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1238', '166', '45');
INSERT INTO "tech"."TechID2Param" VALUES ('1239', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1239', '103', '10674');
INSERT INTO "tech"."TechID2Param" VALUES ('1239', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1239', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1239', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1239', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1239', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1239', '166', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1240', '39', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1240', '103', '10675');
INSERT INTO "tech"."TechID2Param" VALUES ('1240', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1240', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1240', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1240', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1240', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1240', '166', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1241', '39', '52');
INSERT INTO "tech"."TechID2Param" VALUES ('1241', '103', '10676');
INSERT INTO "tech"."TechID2Param" VALUES ('1241', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1241', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1241', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1241', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1241', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1241', '166', '52');
INSERT INTO "tech"."TechID2Param" VALUES ('1242', '39', '53');
INSERT INTO "tech"."TechID2Param" VALUES ('1242', '103', '10677');
INSERT INTO "tech"."TechID2Param" VALUES ('1242', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1242', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1242', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1242', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1242', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1242', '166', '53');
INSERT INTO "tech"."TechID2Param" VALUES ('1243', '39', '53');
INSERT INTO "tech"."TechID2Param" VALUES ('1243', '103', '10678');
INSERT INTO "tech"."TechID2Param" VALUES ('1243', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1243', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1243', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1243', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1243', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1243', '166', '53');
INSERT INTO "tech"."TechID2Param" VALUES ('1244', '39', '104');
INSERT INTO "tech"."TechID2Param" VALUES ('1244', '103', '10679');
INSERT INTO "tech"."TechID2Param" VALUES ('1244', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1244', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1244', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1244', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1244', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1244', '166', '104');
INSERT INTO "tech"."TechID2Param" VALUES ('1245', '39', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1245', '103', '10680');
INSERT INTO "tech"."TechID2Param" VALUES ('1245', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1245', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1245', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1245', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1245', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1245', '166', '54');
INSERT INTO "tech"."TechID2Param" VALUES ('1246', '39', '108');
INSERT INTO "tech"."TechID2Param" VALUES ('1246', '103', '10681');
INSERT INTO "tech"."TechID2Param" VALUES ('1246', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1246', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1246', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1246', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1246', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1246', '166', '108');
INSERT INTO "tech"."TechID2Param" VALUES ('1247', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1247', '103', '10682');
INSERT INTO "tech"."TechID2Param" VALUES ('1247', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1247', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1247', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1247', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1247', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1247', '166', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1248', '39', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('1248', '103', '10683');
INSERT INTO "tech"."TechID2Param" VALUES ('1248', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1248', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1248', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1248', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1248', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1248', '166', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('1249', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1249', '103', '10684');
INSERT INTO "tech"."TechID2Param" VALUES ('1249', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1249', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1249', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1249', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1249', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1249', '166', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1250', '39', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('1250', '103', '10685');
INSERT INTO "tech"."TechID2Param" VALUES ('1250', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1250', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1250', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1250', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1250', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1250', '166', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('1251', '39', '180');
INSERT INTO "tech"."TechID2Param" VALUES ('1251', '103', '10686');
INSERT INTO "tech"."TechID2Param" VALUES ('1251', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1251', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1251', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1251', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1251', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1251', '166', '180');
INSERT INTO "tech"."TechID2Param" VALUES ('1252', '39', '240');
INSERT INTO "tech"."TechID2Param" VALUES ('1252', '103', '10687');
INSERT INTO "tech"."TechID2Param" VALUES ('1252', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1252', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1252', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1252', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1252', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1252', '166', '240');
INSERT INTO "tech"."TechID2Param" VALUES ('1253', '39', '300');
INSERT INTO "tech"."TechID2Param" VALUES ('1253', '103', '10688');
INSERT INTO "tech"."TechID2Param" VALUES ('1253', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1253', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1253', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1253', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1253', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1253', '166', '300');
INSERT INTO "tech"."TechID2Param" VALUES ('1254', '39', '65');
INSERT INTO "tech"."TechID2Param" VALUES ('1254', '103', '10689');
INSERT INTO "tech"."TechID2Param" VALUES ('1254', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1254', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1254', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1254', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1254', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1254', '166', '65');
INSERT INTO "tech"."TechID2Param" VALUES ('1255', '39', '130');
INSERT INTO "tech"."TechID2Param" VALUES ('1255', '103', '10690');
INSERT INTO "tech"."TechID2Param" VALUES ('1255', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1255', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1255', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1255', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1255', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1255', '166', '130');
INSERT INTO "tech"."TechID2Param" VALUES ('1256', '39', '67');
INSERT INTO "tech"."TechID2Param" VALUES ('1256', '103', '10691');
INSERT INTO "tech"."TechID2Param" VALUES ('1256', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1256', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1256', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1256', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1256', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1256', '166', '67');
INSERT INTO "tech"."TechID2Param" VALUES ('1257', '39', '134');
INSERT INTO "tech"."TechID2Param" VALUES ('1257', '103', '10692');
INSERT INTO "tech"."TechID2Param" VALUES ('1257', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1257', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1257', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1257', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1257', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1257', '166', '134');
INSERT INTO "tech"."TechID2Param" VALUES ('1258', '39', '201');
INSERT INTO "tech"."TechID2Param" VALUES ('1258', '103', '10693');
INSERT INTO "tech"."TechID2Param" VALUES ('1258', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1258', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1258', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1258', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1258', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1258', '166', '201');
INSERT INTO "tech"."TechID2Param" VALUES ('1259', '39', '69');
INSERT INTO "tech"."TechID2Param" VALUES ('1259', '103', '10694');
INSERT INTO "tech"."TechID2Param" VALUES ('1259', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1259', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1259', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1259', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1259', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1259', '166', '69');
INSERT INTO "tech"."TechID2Param" VALUES ('1260', '39', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('1260', '103', '10695');
INSERT INTO "tech"."TechID2Param" VALUES ('1260', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1260', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1260', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1260', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1260', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1260', '166', '72');
INSERT INTO "tech"."TechID2Param" VALUES ('1261', '39', '67');
INSERT INTO "tech"."TechID2Param" VALUES ('1261', '103', '10696');
INSERT INTO "tech"."TechID2Param" VALUES ('1261', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1261', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1261', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1261', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1261', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1261', '166', '67');
INSERT INTO "tech"."TechID2Param" VALUES ('1262', '39', '67');
INSERT INTO "tech"."TechID2Param" VALUES ('1262', '103', '10697');
INSERT INTO "tech"."TechID2Param" VALUES ('1262', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1262', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1262', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1262', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1262', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1262', '166', '67');
INSERT INTO "tech"."TechID2Param" VALUES ('1263', '39', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('1263', '103', '10698');
INSERT INTO "tech"."TechID2Param" VALUES ('1263', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1263', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1263', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1263', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1263', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1263', '166', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('1264', '39', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1264', '103', '10699');
INSERT INTO "tech"."TechID2Param" VALUES ('1264', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1264', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1264', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1264', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1264', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1264', '166', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1265', '39', '225');
INSERT INTO "tech"."TechID2Param" VALUES ('1265', '103', '10700');
INSERT INTO "tech"."TechID2Param" VALUES ('1265', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1265', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1265', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1265', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1265', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1265', '166', '225');
INSERT INTO "tech"."TechID2Param" VALUES ('1266', '39', '300');
INSERT INTO "tech"."TechID2Param" VALUES ('1266', '103', '10701');
INSERT INTO "tech"."TechID2Param" VALUES ('1266', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1266', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1266', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1266', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1266', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1266', '166', '300');
INSERT INTO "tech"."TechID2Param" VALUES ('1267', '39', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1267', '103', '10702');
INSERT INTO "tech"."TechID2Param" VALUES ('1267', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1267', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1267', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1267', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1267', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1267', '166', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1268', '39', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('1268', '103', '10703');
INSERT INTO "tech"."TechID2Param" VALUES ('1268', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1268', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1268', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1268', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1268', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1268', '166', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('1269', '39', '84');
INSERT INTO "tech"."TechID2Param" VALUES ('1269', '103', '10704');
INSERT INTO "tech"."TechID2Param" VALUES ('1269', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1269', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1269', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1269', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1269', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1269', '166', '84');
INSERT INTO "tech"."TechID2Param" VALUES ('1270', '39', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('1270', '103', '10705');
INSERT INTO "tech"."TechID2Param" VALUES ('1270', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1270', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1270', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1270', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1270', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1270', '166', '90');
INSERT INTO "tech"."TechID2Param" VALUES ('1271', '39', '180');
INSERT INTO "tech"."TechID2Param" VALUES ('1271', '103', '10706');
INSERT INTO "tech"."TechID2Param" VALUES ('1271', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1271', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1271', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1271', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1271', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1271', '166', '180');
INSERT INTO "tech"."TechID2Param" VALUES ('1272', '39', '270');
INSERT INTO "tech"."TechID2Param" VALUES ('1272', '103', '10707');
INSERT INTO "tech"."TechID2Param" VALUES ('1272', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1272', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1272', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1272', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1272', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1272', '166', '270');
INSERT INTO "tech"."TechID2Param" VALUES ('1273', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1273', '103', '10708');
INSERT INTO "tech"."TechID2Param" VALUES ('1273', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1273', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1273', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1273', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1273', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1273', '166', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1274', '39', '190');
INSERT INTO "tech"."TechID2Param" VALUES ('1274', '103', '10709');
INSERT INTO "tech"."TechID2Param" VALUES ('1274', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1274', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1274', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1274', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1274', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1274', '166', '190');
INSERT INTO "tech"."TechID2Param" VALUES ('1275', '39', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1275', '103', '10710');
INSERT INTO "tech"."TechID2Param" VALUES ('1275', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1275', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1275', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1275', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1275', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1275', '166', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1276', '39', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1276', '103', '10711');
INSERT INTO "tech"."TechID2Param" VALUES ('1276', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1276', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1276', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1276', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1276', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1276', '166', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1277', '39', '300');
INSERT INTO "tech"."TechID2Param" VALUES ('1277', '103', '10712');
INSERT INTO "tech"."TechID2Param" VALUES ('1277', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1277', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1277', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1277', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1277', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1277', '166', '300');
INSERT INTO "tech"."TechID2Param" VALUES ('1278', '39', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1278', '103', '10713');
INSERT INTO "tech"."TechID2Param" VALUES ('1278', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1278', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1278', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1278', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1278', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1278', '166', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1279', '39', '500');
INSERT INTO "tech"."TechID2Param" VALUES ('1279', '103', '10714');
INSERT INTO "tech"."TechID2Param" VALUES ('1279', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1279', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1279', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1279', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1279', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1279', '166', '500');
INSERT INTO "tech"."TechID2Param" VALUES ('1280', '39', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('1280', '103', '10715');
INSERT INTO "tech"."TechID2Param" VALUES ('1280', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1280', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1280', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1280', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1280', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1280', '166', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('1281', '39', '240');
INSERT INTO "tech"."TechID2Param" VALUES ('1281', '103', '10716');
INSERT INTO "tech"."TechID2Param" VALUES ('1281', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1281', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1281', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1281', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1281', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1281', '166', '240');
INSERT INTO "tech"."TechID2Param" VALUES ('1282', '39', '135');
INSERT INTO "tech"."TechID2Param" VALUES ('1282', '103', '10717');
INSERT INTO "tech"."TechID2Param" VALUES ('1282', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1282', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1282', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1282', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1282', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1282', '166', '135');
INSERT INTO "tech"."TechID2Param" VALUES ('1283', '39', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1283', '103', '10718');
INSERT INTO "tech"."TechID2Param" VALUES ('1283', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1283', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1283', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1283', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1283', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1283', '166', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1284', '39', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1284', '103', '10719');
INSERT INTO "tech"."TechID2Param" VALUES ('1284', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1284', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1284', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1284', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1284', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1284', '166', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1285', '39', '270');
INSERT INTO "tech"."TechID2Param" VALUES ('1285', '103', '10720');
INSERT INTO "tech"."TechID2Param" VALUES ('1285', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1285', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1285', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1285', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1285', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1285', '166', '270');
INSERT INTO "tech"."TechID2Param" VALUES ('1286', '39', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1286', '103', '10721');
INSERT INTO "tech"."TechID2Param" VALUES ('1286', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1286', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1286', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1286', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1286', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1286', '166', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1287', '39', '300');
INSERT INTO "tech"."TechID2Param" VALUES ('1287', '103', '10722');
INSERT INTO "tech"."TechID2Param" VALUES ('1287', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1287', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1287', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1287', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1287', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1287', '166', '300');
INSERT INTO "tech"."TechID2Param" VALUES ('1288', '39', '750');
INSERT INTO "tech"."TechID2Param" VALUES ('1288', '103', '10723');
INSERT INTO "tech"."TechID2Param" VALUES ('1288', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1288', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1288', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1288', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1288', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1288', '166', '750');
INSERT INTO "tech"."TechID2Param" VALUES ('1289', '39', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1289', '103', '10724');
INSERT INTO "tech"."TechID2Param" VALUES ('1289', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1289', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1289', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1289', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1289', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1289', '166', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1290', '39', '175');
INSERT INTO "tech"."TechID2Param" VALUES ('1290', '103', '10725');
INSERT INTO "tech"."TechID2Param" VALUES ('1290', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1290', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1290', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1290', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1290', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1290', '166', '175');
INSERT INTO "tech"."TechID2Param" VALUES ('1291', '39', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1291', '103', '10726');
INSERT INTO "tech"."TechID2Param" VALUES ('1291', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1291', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1291', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1291', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1291', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1291', '166', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1292', '39', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1292', '103', '10727');
INSERT INTO "tech"."TechID2Param" VALUES ('1292', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1292', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1292', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1292', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1292', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1292', '166', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1293', '39', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1293', '103', '10728');
INSERT INTO "tech"."TechID2Param" VALUES ('1293', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1293', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1293', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1293', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1293', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1293', '166', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1294', '39', '250');
INSERT INTO "tech"."TechID2Param" VALUES ('1294', '103', '10729');
INSERT INTO "tech"."TechID2Param" VALUES ('1294', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1294', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1294', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1294', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1294', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1294', '166', '250');
INSERT INTO "tech"."TechID2Param" VALUES ('1295', '39', '300');
INSERT INTO "tech"."TechID2Param" VALUES ('1295', '103', '10730');
INSERT INTO "tech"."TechID2Param" VALUES ('1295', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1295', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1295', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1295', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1295', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1295', '166', '300');
INSERT INTO "tech"."TechID2Param" VALUES ('1296', '39', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1296', '103', '10731');
INSERT INTO "tech"."TechID2Param" VALUES ('1296', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1296', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1296', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1296', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1296', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1296', '166', '400');
INSERT INTO "tech"."TechID2Param" VALUES ('1297', '39', '500');
INSERT INTO "tech"."TechID2Param" VALUES ('1297', '103', '10732');
INSERT INTO "tech"."TechID2Param" VALUES ('1297', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1297', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1297', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1297', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1297', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1297', '166', '500');
INSERT INTO "tech"."TechID2Param" VALUES ('1298', '39', '1000');
INSERT INTO "tech"."TechID2Param" VALUES ('1298', '103', '10733');
INSERT INTO "tech"."TechID2Param" VALUES ('1298', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1298', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1298', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1298', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1298', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1298', '166', '1000');
INSERT INTO "tech"."TechID2Param" VALUES ('1299', '39', '3.57');
INSERT INTO "tech"."TechID2Param" VALUES ('1299', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1299', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1299', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1299', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1299', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1299', '165', 'WattsRatio');
INSERT INTO "tech"."TechID2Param" VALUES ('1299', '166', '3.57');
INSERT INTO "tech"."TechID2Param" VALUES ('1300', '39', '3.53');
INSERT INTO "tech"."TechID2Param" VALUES ('1300', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1300', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1300', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1300', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1300', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1300', '165', 'WattsRatio');
INSERT INTO "tech"."TechID2Param" VALUES ('1300', '166', '3.53');
INSERT INTO "tech"."TechID2Param" VALUES ('1301', '39', '3.47');
INSERT INTO "tech"."TechID2Param" VALUES ('1301', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1301', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1301', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1301', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1301', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1301', '165', 'WattsRatio');
INSERT INTO "tech"."TechID2Param" VALUES ('1301', '166', '3.47');
INSERT INTO "tech"."TechID2Param" VALUES ('1302', '39', '4.09');
INSERT INTO "tech"."TechID2Param" VALUES ('1302', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1302', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1302', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1302', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1302', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1302', '165', 'WattsRatio');
INSERT INTO "tech"."TechID2Param" VALUES ('1302', '166', '4.09');
INSERT INTO "tech"."TechID2Param" VALUES ('1303', '39', '4.07');
INSERT INTO "tech"."TechID2Param" VALUES ('1303', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1303', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1303', '138', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1303', '139', '1500');
INSERT INTO "tech"."TechID2Param" VALUES ('1303', '152', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1303', '165', 'WattsRatio');
INSERT INTO "tech"."TechID2Param" VALUES ('1303', '166', '4.07');
INSERT INTO "tech"."TechID2Param" VALUES ('1304', '39', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1304', '103', '10455');
INSERT INTO "tech"."TechID2Param" VALUES ('1304', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1304', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1304', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1304', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1304', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1304', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1304', '166', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1305', '39', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1305', '103', '10456');
INSERT INTO "tech"."TechID2Param" VALUES ('1305', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1305', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1305', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1305', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1305', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1305', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1305', '166', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1306', '39', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('1306', '103', '10457');
INSERT INTO "tech"."TechID2Param" VALUES ('1306', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1306', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1306', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1306', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1306', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1306', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1306', '166', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('1307', '39', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1307', '103', '10458');
INSERT INTO "tech"."TechID2Param" VALUES ('1307', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1307', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1307', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1307', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1307', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1307', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1307', '166', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1308', '39', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1308', '103', '10459');
INSERT INTO "tech"."TechID2Param" VALUES ('1308', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1308', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1308', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1308', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1308', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1308', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1308', '166', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1309', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1309', '103', '10460');
INSERT INTO "tech"."TechID2Param" VALUES ('1309', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1309', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1309', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1309', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1309', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1309', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1309', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1310', '39', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('1310', '103', '10461');
INSERT INTO "tech"."TechID2Param" VALUES ('1310', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1310', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1310', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1310', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1310', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1310', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1310', '166', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('1311', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('1311', '103', '10462');
INSERT INTO "tech"."TechID2Param" VALUES ('1311', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1311', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1311', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1311', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1311', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1311', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1311', '166', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('1312', '39', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1312', '103', '10463');
INSERT INTO "tech"."TechID2Param" VALUES ('1312', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1312', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1312', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1312', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1312', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1312', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1312', '166', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1313', '39', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('1313', '103', '10464');
INSERT INTO "tech"."TechID2Param" VALUES ('1313', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1313', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1313', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1313', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1313', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1313', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1313', '166', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('1314', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1314', '103', '10465');
INSERT INTO "tech"."TechID2Param" VALUES ('1314', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1314', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1314', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1314', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1314', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1314', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1314', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1315', '39', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('1315', '103', '10466');
INSERT INTO "tech"."TechID2Param" VALUES ('1315', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1315', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1315', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1315', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1315', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1315', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1315', '166', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('1316', '39', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1316', '103', '10467');
INSERT INTO "tech"."TechID2Param" VALUES ('1316', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1316', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1316', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1316', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1316', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1316', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1316', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1317', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1317', '103', '10468');
INSERT INTO "tech"."TechID2Param" VALUES ('1317', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1317', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1317', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1317', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1317', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1317', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1317', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1318', '39', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1318', '103', '10469');
INSERT INTO "tech"."TechID2Param" VALUES ('1318', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1318', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1318', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1318', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1318', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1318', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1318', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1319', '39', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1319', '103', '10470');
INSERT INTO "tech"."TechID2Param" VALUES ('1319', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1319', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1319', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1319', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1319', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1319', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1319', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1320', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1320', '103', '10471');
INSERT INTO "tech"."TechID2Param" VALUES ('1320', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1320', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1320', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1320', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1320', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1320', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1320', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1321', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1321', '103', '10472');
INSERT INTO "tech"."TechID2Param" VALUES ('1321', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1321', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1321', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1321', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1321', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1321', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1321', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1322', '39', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1322', '103', '10473');
INSERT INTO "tech"."TechID2Param" VALUES ('1322', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1322', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1322', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1322', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1322', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1322', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1322', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1323', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1323', '103', '10474');
INSERT INTO "tech"."TechID2Param" VALUES ('1323', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1323', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1323', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1323', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1323', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1323', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1323', '166', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1324', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1324', '103', '10475');
INSERT INTO "tech"."TechID2Param" VALUES ('1324', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1324', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1324', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1324', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1324', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1324', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1324', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1325', '39', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('1325', '103', '10476');
INSERT INTO "tech"."TechID2Param" VALUES ('1325', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1325', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1325', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1325', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1325', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1325', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1325', '166', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('1326', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('1326', '103', '10477');
INSERT INTO "tech"."TechID2Param" VALUES ('1326', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1326', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1326', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1326', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1326', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1326', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1326', '166', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('1327', '39', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1327', '103', '10478');
INSERT INTO "tech"."TechID2Param" VALUES ('1327', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1327', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1327', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1327', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1327', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1327', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1327', '166', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1328', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1328', '103', '10479');
INSERT INTO "tech"."TechID2Param" VALUES ('1328', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1328', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1328', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1328', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1328', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1328', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1328', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1329', '39', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('1329', '103', '10480');
INSERT INTO "tech"."TechID2Param" VALUES ('1329', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1329', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1329', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1329', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1329', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1329', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1329', '166', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('1330', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1330', '103', '10481');
INSERT INTO "tech"."TechID2Param" VALUES ('1330', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1330', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1330', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1330', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1330', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1330', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1330', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1331', '39', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1331', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1331', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1331', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1331', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1331', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1331', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1331', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1331', '166', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1332', '39', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1332', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1332', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1332', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1332', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1332', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1332', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1332', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1332', '166', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1333', '39', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1333', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1333', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1333', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1333', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1333', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1333', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1333', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1333', '166', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1334', '39', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1334', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1334', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1334', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1334', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1334', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1334', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1334', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1334', '166', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1335', '39', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1335', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1335', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1335', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1335', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1335', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1335', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1335', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1335', '166', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1336', '39', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1336', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1336', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1336', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1336', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1336', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1336', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1336', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1336', '166', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1337', '39', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1337', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1337', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1337', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1337', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1337', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1337', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1337', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1337', '166', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1338', '39', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1338', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1338', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1338', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1338', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1338', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1338', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1338', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1338', '166', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1339', '39', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('1339', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1339', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1339', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1339', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1339', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1339', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1339', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1339', '166', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('1340', '39', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('1340', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1340', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1340', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1340', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1340', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1340', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1340', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1340', '166', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('1341', '39', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1341', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1341', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1341', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1341', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1341', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1341', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1341', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1341', '166', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1342', '39', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1342', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1342', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1342', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1342', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1342', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1342', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1342', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1342', '166', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1343', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1343', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1343', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1343', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1343', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1343', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1343', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1343', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1343', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1344', '39', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('1344', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1344', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1344', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1344', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1344', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1344', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1344', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1344', '166', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('1345', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('1345', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1345', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1345', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1345', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1345', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1345', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1345', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1345', '166', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('1346', '39', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1346', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1346', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1346', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1346', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1346', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1346', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1346', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1346', '166', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1347', '39', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('1347', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1347', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1347', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1347', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1347', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1347', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1347', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1347', '166', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('1348', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1348', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1348', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1348', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1348', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1348', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1348', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1348', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1348', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1349', '39', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1349', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1349', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1349', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1349', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1349', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1349', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1349', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1349', '166', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1350', '39', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1350', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1350', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1350', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1350', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1350', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1350', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1350', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1350', '166', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1351', '39', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('1351', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1351', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1351', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1351', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1351', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1351', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1351', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1351', '166', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('1352', '39', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1352', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1352', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1352', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1352', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1352', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1352', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1352', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1352', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1353', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1353', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1353', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1353', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1353', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1353', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1353', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1353', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1353', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1354', '39', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1354', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1354', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1354', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1354', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1354', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1354', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1354', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1354', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1355', '39', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1355', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1355', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1355', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1355', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1355', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1355', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1355', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1355', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1356', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1356', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1356', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1356', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1356', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1356', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1356', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1356', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1356', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1357', '39', '29');
INSERT INTO "tech"."TechID2Param" VALUES ('1357', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1357', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1357', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1357', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1357', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1357', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1357', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1357', '166', '29');
INSERT INTO "tech"."TechID2Param" VALUES ('1358', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1358', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1358', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1358', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1358', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1358', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1358', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1358', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1358', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1359', '39', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('1359', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1359', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1359', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1359', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1359', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1359', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1359', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1359', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('1360', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1360', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1360', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1360', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1360', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1360', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1360', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1360', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1360', '166', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1361', '39', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1361', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1361', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1361', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1361', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1361', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1361', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1361', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1361', '166', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1362', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1362', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1362', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1362', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1362', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1362', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1362', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1362', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1362', '166', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1363', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1363', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1363', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1363', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1363', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1363', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1363', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1363', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1363', '166', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1364', '39', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1364', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1364', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1364', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1364', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1364', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1364', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1364', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1364', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1365', '39', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1365', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1365', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1365', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1365', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1365', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1365', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1365', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1365', '166', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1366', '39', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1366', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1366', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1366', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1366', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1366', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1366', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1366', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1366', '166', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1367', '39', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1367', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1367', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1367', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1367', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1367', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1367', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1367', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1367', '166', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1368', '39', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1368', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1368', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1368', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1368', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1368', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1368', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1368', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1368', '166', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1369', '39', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1369', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1369', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1369', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1369', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1369', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1369', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1369', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1369', '166', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1370', '39', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1370', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1370', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1370', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1370', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1370', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1370', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1370', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1370', '166', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1371', '39', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1371', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1371', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1371', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1371', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1371', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1371', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1371', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1371', '166', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1372', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1372', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1372', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1372', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1372', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1372', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1372', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1372', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1372', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1373', '39', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1373', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1373', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1373', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1373', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1373', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1373', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1373', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1373', '166', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1374', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1374', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1374', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1374', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1374', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1374', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1374', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1374', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1374', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1375', '39', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1375', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1375', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1375', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1375', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1375', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1375', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1375', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1375', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1376', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1376', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1376', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1376', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1376', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1376', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1376', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1376', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1376', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1377', '39', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1377', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1377', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1377', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1377', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1377', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1377', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1377', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1377', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1378', '39', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1378', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1378', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1378', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1378', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1378', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1378', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1378', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1378', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1379', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1379', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1379', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1379', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1379', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1379', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1379', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1379', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1379', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1380', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1380', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1380', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1380', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1380', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1380', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1380', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1380', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1380', '166', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1381', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1381', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1381', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1381', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1381', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1381', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1381', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1381', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1381', '166', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1382', '39', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1382', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1382', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1382', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1382', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1382', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1382', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1382', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1382', '166', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1383', '39', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1383', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1383', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1383', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1383', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1383', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1383', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1383', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1383', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1384', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1384', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1384', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1384', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1384', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1384', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1384', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1384', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1384', '166', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1385', '39', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1385', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1385', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1385', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1385', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1385', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1385', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1385', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1385', '166', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1386', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1386', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1386', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1386', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1386', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1386', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1386', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1386', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1386', '166', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1387', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1387', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1387', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1387', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1387', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1387', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1387', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1387', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1387', '166', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1388', '39', '57');
INSERT INTO "tech"."TechID2Param" VALUES ('1388', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1388', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1388', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1388', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1388', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1388', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1388', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1388', '166', '57');
INSERT INTO "tech"."TechID2Param" VALUES ('1389', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1389', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1389', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1389', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1389', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1389', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1389', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1389', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1389', '166', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1390', '39', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('1390', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1390', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1390', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1390', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1390', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1390', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1390', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1390', '166', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('1391', '39', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1391', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1391', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1391', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1391', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1391', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1391', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1391', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1391', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1392', '39', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1392', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1392', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1392', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1392', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1392', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1392', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1392', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1392', '166', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1393', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1393', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1393', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1393', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1393', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1393', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1393', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1393', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1393', '166', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1394', '39', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('1394', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1394', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1394', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1394', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1394', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1394', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1394', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1394', '166', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('1395', '39', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('1395', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1395', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1395', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1395', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1395', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1395', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1395', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1395', '166', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('1396', '39', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1396', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1396', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1396', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1396', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1396', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1396', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1396', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1396', '166', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1397', '39', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1397', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1397', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1397', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1397', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1397', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1397', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1397', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1397', '166', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1398', '39', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1398', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1398', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1398', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1398', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1398', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1398', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1398', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1398', '166', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1399', '39', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1399', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1399', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1399', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1399', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1399', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1399', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1399', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1399', '166', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1400', '39', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1400', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1400', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1400', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1400', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1400', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1400', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1400', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1400', '166', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1401', '39', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1401', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1401', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1401', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1401', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1401', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1401', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1401', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1401', '166', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1402', '39', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1402', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1402', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1402', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1402', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1402', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1402', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1402', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1402', '166', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1403', '39', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1403', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1403', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1403', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1403', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1403', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1403', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1403', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1403', '166', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1404', '39', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('1404', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1404', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1404', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1404', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1404', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1404', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1404', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1404', '166', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('1405', '39', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('1405', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1405', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1405', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1405', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1405', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1405', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1405', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1405', '166', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('1406', '39', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1406', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1406', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1406', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1406', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1406', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1406', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1406', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1406', '166', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1407', '39', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1407', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1407', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1407', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1407', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1407', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1407', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1407', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1407', '166', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1408', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1408', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1408', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1408', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1408', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1408', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1408', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1408', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1408', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1409', '39', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('1409', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1409', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1409', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1409', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1409', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1409', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1409', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1409', '166', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('1410', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('1410', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1410', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1410', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1410', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1410', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1410', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1410', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1410', '166', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('1411', '39', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1411', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1411', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1411', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1411', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1411', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1411', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1411', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1411', '166', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1412', '39', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('1412', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1412', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1412', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1412', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1412', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1412', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1412', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1412', '166', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('1413', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1413', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1413', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1413', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1413', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1413', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1413', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1413', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1413', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1414', '39', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1414', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1414', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1414', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1414', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1414', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1414', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1414', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1414', '166', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1415', '39', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1415', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1415', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1415', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1415', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1415', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1415', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1415', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1415', '166', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1416', '39', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('1416', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1416', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1416', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1416', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1416', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1416', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1416', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1416', '166', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('1417', '39', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1417', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1417', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1417', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1417', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1417', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1417', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1417', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1417', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1418', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1418', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1418', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1418', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1418', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1418', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1418', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1418', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1418', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1419', '39', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1419', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1419', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1419', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1419', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1419', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1419', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1419', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1419', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1420', '39', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1420', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1420', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1420', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1420', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1420', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1420', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1420', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1420', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1421', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1421', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1421', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1421', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1421', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1421', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1421', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1421', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1421', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1422', '39', '29');
INSERT INTO "tech"."TechID2Param" VALUES ('1422', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1422', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1422', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1422', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1422', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1422', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1422', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1422', '166', '29');
INSERT INTO "tech"."TechID2Param" VALUES ('1423', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1423', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1423', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1423', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1423', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1423', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1423', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1423', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1423', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1424', '39', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('1424', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1424', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1424', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1424', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1424', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1424', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1424', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1424', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('1425', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1425', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1425', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1425', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1425', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1425', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1425', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1425', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1425', '166', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1426', '39', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1426', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1426', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1426', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1426', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1426', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1426', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1426', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1426', '166', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1427', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1427', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1427', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1427', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1427', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1427', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1427', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1427', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1427', '166', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1428', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1428', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1428', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1428', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1428', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1428', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1428', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1428', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1428', '166', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1429', '39', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1429', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1429', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1429', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1429', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1429', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1429', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1429', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1429', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1430', '39', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1430', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1430', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1430', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1430', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1430', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1430', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1430', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1430', '166', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1431', '39', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1431', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1431', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1431', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1431', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1431', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1431', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1431', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1431', '166', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1432', '39', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1432', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1432', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1432', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1432', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1432', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1432', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1432', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1432', '166', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1433', '39', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1433', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1433', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1433', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1433', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1433', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1433', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1433', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1433', '166', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1434', '39', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1434', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1434', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1434', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1434', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1434', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1434', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1434', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1434', '166', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1435', '39', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1435', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1435', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1435', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1435', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1435', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1435', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1435', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1435', '166', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1436', '39', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1436', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1436', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1436', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1436', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1436', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1436', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1436', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1436', '166', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1437', '39', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1437', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1437', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1437', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1437', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1437', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1437', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1437', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1437', '166', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1438', '39', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1438', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1438', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1438', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1438', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1438', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1438', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1438', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1438', '166', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1439', '39', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1439', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1439', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1439', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1439', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1439', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1439', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1439', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1439', '166', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1440', '39', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1440', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1440', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1440', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1440', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1440', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1440', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1440', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1440', '166', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1441', '39', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('1441', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1441', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1441', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1441', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1441', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1441', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1441', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1441', '166', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('1442', '39', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('1442', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1442', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1442', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1442', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1442', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1442', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1442', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1442', '166', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('1443', '39', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1443', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1443', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1443', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1443', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1443', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1443', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1443', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1443', '166', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1444', '39', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1444', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1444', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1444', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1444', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1444', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1444', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1444', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1444', '166', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1445', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1445', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1445', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1445', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1445', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1445', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1445', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1445', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1445', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1446', '39', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('1446', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1446', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1446', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1446', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1446', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1446', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1446', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1446', '166', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('1447', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('1447', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1447', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1447', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1447', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1447', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1447', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1447', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1447', '166', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('1448', '39', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1448', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1448', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1448', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1448', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1448', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1448', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1448', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1448', '166', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1449', '39', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('1449', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1449', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1449', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1449', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1449', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1449', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1449', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1449', '166', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('1450', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1450', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1450', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1450', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1450', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1450', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1450', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1450', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1450', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1451', '39', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1451', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1451', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1451', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1451', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1451', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1451', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1451', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1451', '166', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1452', '39', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1452', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1452', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1452', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1452', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1452', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1452', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1452', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1452', '166', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1453', '39', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('1453', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1453', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1453', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1453', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1453', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1453', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1453', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1453', '166', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('1454', '39', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1454', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1454', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1454', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1454', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1454', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1454', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1454', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1454', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1455', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1455', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1455', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1455', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1455', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1455', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1455', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1455', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1455', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1456', '39', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1456', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1456', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1456', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1456', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1456', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1456', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1456', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1456', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1457', '39', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1457', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1457', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1457', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1457', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1457', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1457', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1457', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1457', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1458', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1458', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1458', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1458', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1458', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1458', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1458', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1458', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1458', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1459', '39', '29');
INSERT INTO "tech"."TechID2Param" VALUES ('1459', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1459', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1459', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1459', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1459', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1459', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1459', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1459', '166', '29');
INSERT INTO "tech"."TechID2Param" VALUES ('1460', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1460', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1460', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1460', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1460', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1460', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1460', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1460', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1460', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1461', '39', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('1461', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1461', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1461', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1461', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1461', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1461', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1461', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1461', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('1462', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1462', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1462', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1462', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1462', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1462', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1462', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1462', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1462', '166', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1463', '39', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1463', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1463', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1463', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1463', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1463', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1463', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1463', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1463', '166', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1464', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1464', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1464', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1464', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1464', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1464', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1464', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1464', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1464', '166', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1465', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1465', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1465', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1465', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1465', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1465', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1465', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1465', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1465', '166', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1466', '39', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1466', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1466', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1466', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1466', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1466', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1466', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1466', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1466', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1467', '39', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1467', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1467', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1467', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1467', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1467', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1467', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1467', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1467', '166', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1468', '39', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1468', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1468', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1468', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1468', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1468', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1468', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1468', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1468', '166', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1469', '39', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1469', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1469', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1469', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1469', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1469', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1469', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1469', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1469', '166', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1470', '39', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1470', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1470', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1470', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1470', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1470', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1470', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1470', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1470', '166', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1471', '39', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1471', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1471', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1471', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1471', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1471', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1471', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1471', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1471', '166', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1472', '39', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1472', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1472', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1472', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1472', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1472', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1472', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1472', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1472', '166', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1473', '39', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1473', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1473', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1473', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1473', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1473', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1473', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1473', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1473', '166', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1474', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1474', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1474', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1474', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1474', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1474', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1474', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1474', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1474', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1475', '39', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1475', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1475', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1475', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1475', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1475', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1475', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1475', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1475', '166', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1476', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1476', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1476', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1476', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1476', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1476', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1476', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1476', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1476', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1477', '39', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1477', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1477', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1477', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1477', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1477', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1477', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1477', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1477', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1478', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1478', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1478', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1478', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1478', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1478', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1478', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1478', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1478', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1479', '39', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1479', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1479', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1479', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1479', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1479', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1479', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1479', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1479', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1480', '39', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1480', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1480', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1480', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1480', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1480', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1480', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1480', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1480', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1481', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1481', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1481', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1481', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1481', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1481', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1481', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1481', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1481', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1482', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1482', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1482', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1482', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1482', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1482', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1482', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1482', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1482', '166', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1483', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1483', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1483', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1483', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1483', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1483', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1483', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1483', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1483', '166', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1484', '39', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1484', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1484', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1484', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1484', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1484', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1484', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1484', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1484', '166', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1485', '39', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1485', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1485', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1485', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1485', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1485', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1485', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1485', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1485', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1486', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1486', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1486', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1486', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1486', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1486', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1486', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1486', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1486', '166', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1487', '39', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1487', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1487', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1487', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1487', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1487', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1487', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1487', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1487', '166', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1488', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1488', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1488', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1488', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1488', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1488', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1488', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1488', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1488', '166', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1489', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1489', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1489', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1489', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1489', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1489', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1489', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1489', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1489', '166', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1490', '39', '57');
INSERT INTO "tech"."TechID2Param" VALUES ('1490', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1490', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1490', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1490', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1490', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1490', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1490', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1490', '166', '57');
INSERT INTO "tech"."TechID2Param" VALUES ('1491', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1491', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1491', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1491', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1491', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1491', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1491', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1491', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1491', '166', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1492', '39', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('1492', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1492', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1492', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1492', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1492', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1492', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1492', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1492', '166', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('1493', '39', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1493', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1493', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1493', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1493', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1493', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1493', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1493', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1493', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1494', '39', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1494', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1494', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1494', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1494', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1494', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1494', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1494', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1494', '166', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1495', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1495', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1495', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1495', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1495', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1495', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1495', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1495', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1495', '166', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1496', '39', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('1496', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1496', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1496', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1496', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1496', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1496', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1496', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1496', '166', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('1497', '39', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('1497', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1497', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1497', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1497', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1497', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1497', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1497', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1497', '166', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('1498', '39', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1498', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1498', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1498', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1498', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1498', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1498', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1498', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1498', '166', '3');
INSERT INTO "tech"."TechID2Param" VALUES ('1499', '39', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1499', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1499', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1499', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1499', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1499', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1499', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1499', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1499', '166', '4');
INSERT INTO "tech"."TechID2Param" VALUES ('1500', '39', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1500', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1500', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1500', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1500', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1500', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1500', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1500', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1500', '166', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1501', '39', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1501', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1501', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1501', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1501', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1501', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1501', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1501', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1501', '166', '6');
INSERT INTO "tech"."TechID2Param" VALUES ('1502', '39', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1502', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1502', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1502', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1502', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1502', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1502', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1502', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1502', '166', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1503', '39', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1503', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1503', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1503', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1503', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1503', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1503', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1503', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1503', '166', '8');
INSERT INTO "tech"."TechID2Param" VALUES ('1504', '39', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1504', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1504', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1504', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1504', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1504', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1504', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1504', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1504', '166', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1505', '39', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1505', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1505', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1505', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1505', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1505', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1505', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1505', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1505', '166', '10');
INSERT INTO "tech"."TechID2Param" VALUES ('1506', '39', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('1506', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1506', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1506', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1506', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1506', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1506', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1506', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1506', '166', '11');
INSERT INTO "tech"."TechID2Param" VALUES ('1507', '39', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('1507', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1507', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1507', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1507', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1507', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1507', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1507', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1507', '166', '12');
INSERT INTO "tech"."TechID2Param" VALUES ('1508', '39', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1508', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1508', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1508', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1508', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1508', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1508', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1508', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1508', '166', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1509', '39', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1509', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1509', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1509', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1509', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1509', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1509', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1509', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1509', '166', '14');
INSERT INTO "tech"."TechID2Param" VALUES ('1510', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1510', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1510', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1510', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1510', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1510', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1510', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1510', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1510', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1511', '39', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('1511', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1511', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1511', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1511', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1511', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1511', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1511', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1511', '166', '16');
INSERT INTO "tech"."TechID2Param" VALUES ('1512', '39', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('1512', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1512', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1512', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1512', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1512', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1512', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1512', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1512', '166', '17');
INSERT INTO "tech"."TechID2Param" VALUES ('1513', '39', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1513', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1513', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1513', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1513', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1513', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1513', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1513', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1513', '166', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1514', '39', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('1514', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1514', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1514', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1514', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1514', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1514', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1514', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1514', '166', '19');
INSERT INTO "tech"."TechID2Param" VALUES ('1515', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1515', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1515', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1515', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1515', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1515', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1515', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1515', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1515', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1516', '39', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1516', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1516', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1516', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1516', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1516', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1516', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1516', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1516', '166', '21');
INSERT INTO "tech"."TechID2Param" VALUES ('1517', '39', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1517', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1517', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1517', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1517', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1517', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1517', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1517', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1517', '166', '22');
INSERT INTO "tech"."TechID2Param" VALUES ('1518', '39', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('1518', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1518', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1518', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1518', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1518', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1518', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1518', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1518', '166', '23');
INSERT INTO "tech"."TechID2Param" VALUES ('1519', '39', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1519', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1519', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1519', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1519', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1519', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1519', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1519', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1519', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1520', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1520', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1520', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1520', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1520', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1520', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1520', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1520', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1520', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1521', '39', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1521', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1521', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1521', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1521', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1521', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1521', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1521', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1521', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1522', '39', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1522', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1522', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1522', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1522', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1522', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1522', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1522', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1522', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1523', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1523', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1523', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1523', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1523', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1523', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1523', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1523', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1523', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1524', '39', '29');
INSERT INTO "tech"."TechID2Param" VALUES ('1524', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1524', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1524', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1524', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1524', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1524', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1524', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1524', '166', '29');
INSERT INTO "tech"."TechID2Param" VALUES ('1525', '39', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1525', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1525', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1525', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1525', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1525', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1525', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1525', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1525', '166', '30');
INSERT INTO "tech"."TechID2Param" VALUES ('1526', '39', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('1526', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1526', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1526', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1526', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1526', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1526', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1526', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1526', '166', '31');
INSERT INTO "tech"."TechID2Param" VALUES ('1527', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1527', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1527', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1527', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1527', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1527', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1527', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1527', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1527', '166', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1528', '39', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1528', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1528', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1528', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1528', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1528', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1528', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1528', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1528', '166', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1529', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1529', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1529', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1529', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1529', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1529', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1529', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1529', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1529', '166', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1530', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1530', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1530', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1530', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1530', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1530', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1530', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1530', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1530', '166', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1531', '39', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1531', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1531', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1531', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1531', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1531', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1531', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1531', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1531', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1532', '39', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1532', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1532', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1532', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1532', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1532', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1532', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1532', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1532', '166', '100');
INSERT INTO "tech"."TechID2Param" VALUES ('1533', '39', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1533', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1533', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1533', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1533', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1533', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1533', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1533', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1533', '166', '150');
INSERT INTO "tech"."TechID2Param" VALUES ('1534', '39', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1534', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1534', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1534', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1534', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1534', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1534', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1534', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1534', '166', '200');
INSERT INTO "tech"."TechID2Param" VALUES ('1535', '39', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1535', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1535', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1535', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1535', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1535', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1535', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1535', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1535', '166', '5');
INSERT INTO "tech"."TechID2Param" VALUES ('1536', '39', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1536', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1536', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1536', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1536', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1536', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1536', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1536', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1536', '166', '7');
INSERT INTO "tech"."TechID2Param" VALUES ('1537', '39', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1537', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1537', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1537', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1537', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1537', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1537', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1537', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1537', '166', '9');
INSERT INTO "tech"."TechID2Param" VALUES ('1538', '39', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1538', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1538', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1538', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1538', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1538', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1538', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1538', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1538', '166', '13');
INSERT INTO "tech"."TechID2Param" VALUES ('1539', '39', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1539', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1539', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1539', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1539', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1539', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1539', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1539', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1539', '166', '15');
INSERT INTO "tech"."TechID2Param" VALUES ('1540', '39', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1540', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1540', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1540', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1540', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1540', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1540', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1540', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1540', '166', '18');
INSERT INTO "tech"."TechID2Param" VALUES ('1541', '39', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1541', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1541', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1541', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1541', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1541', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1541', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1541', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1541', '166', '20');
INSERT INTO "tech"."TechID2Param" VALUES ('1542', '39', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1542', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1542', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1542', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1542', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1542', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1542', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1542', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1542', '166', '24');
INSERT INTO "tech"."TechID2Param" VALUES ('1543', '39', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1543', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1543', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1543', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1543', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1543', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1543', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1543', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1543', '166', '25');
INSERT INTO "tech"."TechID2Param" VALUES ('1544', '39', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1544', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1544', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1544', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1544', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1544', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1544', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1544', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1544', '166', '26');
INSERT INTO "tech"."TechID2Param" VALUES ('1545', '39', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1545', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1545', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1545', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1545', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1545', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1545', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1545', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1545', '166', '27');
INSERT INTO "tech"."TechID2Param" VALUES ('1546', '39', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1546', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1546', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1546', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1546', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1546', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1546', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1546', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1546', '166', '28');
INSERT INTO "tech"."TechID2Param" VALUES ('1547', '39', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1547', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1547', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1547', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1547', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1547', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1547', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1547', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1547', '166', '32');
INSERT INTO "tech"."TechID2Param" VALUES ('1548', '39', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1548', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1548', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1548', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1548', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1548', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1548', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1548', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1548', '166', '34');
INSERT INTO "tech"."TechID2Param" VALUES ('1549', '39', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1549', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1549', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1549', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1549', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1549', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1549', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1549', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1549', '166', '35');
INSERT INTO "tech"."TechID2Param" VALUES ('1550', '39', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1550', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1550', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1550', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1550', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1550', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1550', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1550', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1550', '166', '36');
INSERT INTO "tech"."TechID2Param" VALUES ('1551', '39', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1551', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1551', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1551', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1551', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1551', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1551', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1551', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1551', '166', '40');
INSERT INTO "tech"."TechID2Param" VALUES ('1552', '39', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1552', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1552', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1552', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1552', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1552', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1552', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1552', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1552', '166', '42');
INSERT INTO "tech"."TechID2Param" VALUES ('1553', '39', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1553', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1553', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1553', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1553', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1553', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1553', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1553', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1553', '166', '50');
INSERT INTO "tech"."TechID2Param" VALUES ('1554', '39', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1554', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1554', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1554', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1554', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1554', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1554', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1554', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1554', '166', '55');
INSERT INTO "tech"."TechID2Param" VALUES ('1555', '39', '57');
INSERT INTO "tech"."TechID2Param" VALUES ('1555', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1555', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1555', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1555', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1555', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1555', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1555', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1555', '166', '57');
INSERT INTO "tech"."TechID2Param" VALUES ('1556', '39', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1556', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1556', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1556', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1556', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1556', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1556', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1556', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1556', '166', '60');
INSERT INTO "tech"."TechID2Param" VALUES ('1557', '39', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('1557', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1557', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1557', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1557', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1557', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1557', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1557', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1557', '166', '75');
INSERT INTO "tech"."TechID2Param" VALUES ('1558', '39', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1558', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1558', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1558', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1558', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1558', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1558', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1558', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1558', '166', '80');
INSERT INTO "tech"."TechID2Param" VALUES ('1559', '39', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1559', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1559', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1559', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1559', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1559', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1559', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1559', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1559', '166', '85');
INSERT INTO "tech"."TechID2Param" VALUES ('1560', '39', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1560', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1560', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1560', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1560', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1560', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1560', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1560', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1560', '166', '95');
INSERT INTO "tech"."TechID2Param" VALUES ('1561', '39', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('1561', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1561', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1561', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1561', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1561', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1561', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1561', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1561', '166', '110');
INSERT INTO "tech"."TechID2Param" VALUES ('1562', '39', '120');
INSERT INTO "tech"."TechID2Param" VALUES ('1562', '103', '');
INSERT INTO "tech"."TechID2Param" VALUES ('1562', '118', 'Mag-STD');
INSERT INTO "tech"."TechID2Param" VALUES ('1562', '119', 'Standard');
INSERT INTO "tech"."TechID2Param" VALUES ('1562', '123', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1562', '137', 'N');
INSERT INTO "tech"."TechID2Param" VALUES ('1562', '138', 'Stadard');
INSERT INTO "tech"."TechID2Param" VALUES ('1562', '165', 'Watts');
INSERT INTO "tech"."TechID2Param" VALUES ('1562', '166', '120');

-- ----------------------------
-- Table structure for "tech"."Technology"
-- ----------------------------
DROP TABLE "tech"."Technology";
CREATE TABLE "tech"."Technology" (
"Index" int4 NOT NULL,
"TypeID" int4 NOT NULL,
"Name" varchar(255) NOT NULL,
"SrcCode" varchar(64),
"ClassCode" varchar(64),
"Description" varchar(255),
"State" varchar(64)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of Technology
-- ----------------------------
INSERT INTO "tech"."Technology" VALUES ('1', '1', 'dxAC-pkgS-lt65k-8.3', 'DEER2012', 'CAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('2', '1', 'dxAC-pkgS-lt65k-9.3', 'DEER2012', 'CAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('3', '1', 'dxAC-pkgS-lt65k-9.7', 'DEER2012', 'CAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('4', '1', 'dxAC-pkgS-lt65k-10', 'DEER2012', 'CAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('5', '1', 'dxAC-pkgS-lt65k-12', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('6', '1', 'dxAC-pkgS-lt65k-13', 'DEER2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('7', '1', 'dxAC-pkgS-lt65k-14', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('8', '1', 'dxAC-pkgS-lt65k-15', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('9', '1', 'dxAC-pkgS-lt65k-16', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('10', '1', 'dxAC-pkgS-lt65k-17', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('11', '1', 'dxAC-pkgS-lt65k-18', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('12', '1', 'dxAC-pkgS-lt65k-19', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('13', '1', 'dxAC-pkgS-lt65k-20', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('14', '1', 'dxAC-pkgS-lt65k-21', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('15', '1', 'dxAC-pkgS-lt65k-17.4Evap', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('16', '2', 'dxAC-pkgE-Air-65to75k-7.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('17', '2', 'dxAC-pkgE-Air-65to75k-8.9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('18', '2', 'dxAC-pkgE-Air-65to75k-9.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('19', '2', 'dxAC-pkgE-Air-65to75k-10.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('20', '2', 'dxAC-pkgE-Air-65to75k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('21', '2', 'dxAC-pkgE-Air-65to75k-11', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('22', '2', 'dxAC-pkgE-Air-65to75k-11.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('23', '2', 'dxAC-pkgE-Air-65to75k-12', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('24', '2', 'dxAC-pkgE-Air-76to134k-7.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('25', '2', 'dxAC-pkgE-Air-76to134k-8.9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('26', '2', 'dxAC-pkgE-Air-76to134k-9.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('27', '2', 'dxAC-pkgE-Air-76to134k-10.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('28', '2', 'dxAC-pkgE-Air-76to134k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('29', '2', 'dxAC-pkgE-Air-76to134k-11', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('30', '2', 'dxAC-pkgE-Air-76to134k-11.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('31', '2', 'dxAC-pkgE-Air-76to134k-12', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('32', '2', 'dxAC-pkgE-Air-135to239k-9.5', 'DEER2013', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('33', '2', 'dxAC-pkgE-Air-135to239k-11.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('34', '2', 'dxAC-pkgE-Air-135to239k-12', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('35', '2', 'dxAC-pkgE-Air-135to239k-7.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('36', '2', 'dxAC-pkgE-Air-135to239k-8.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('37', '2', 'dxAC-pkgE-Air-135to239k-9.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('38', '2', 'dxAC-pkgE-Air-135to239k-9.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('39', '2', 'dxAC-pkgE-Air-135to239k-10.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('40', '2', 'dxAC-pkgE-Air-135to239k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('41', '2', 'dxAC-pkgE-Air-240to759-9.3', 'DEER2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('42', '2', 'dxAC-pkgE-Air-240to759-9.8', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('43', '2', 'dxAC-pkgE-Air-240to759-10.5', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('44', '2', 'dxAC-pkgE-Air-240to759-10.8', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('45', '2', 'dxAC-pkgE-Air-gt760k-7.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('46', '2', 'dxAC-pkgE-Air-gt760k-8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('47', '2', 'dxAC-pkgE-Air-gt760k-9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('48', '2', 'dxAC-pkgE-Air-gt760k-9.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('49', '2', 'dxAC-pkgE-Air-gt760k-9.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('50', '2', 'dxAC-pkgE-Air-gt760k-10.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('51', '2', 'dxAC-pkgE-Evap-lt65k-9.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('52', '2', 'dxAC-pkgE-Evap-lt65k-12.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('53', '2', 'dxAC-pkgE-Evap-lt65k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('54', '2', 'dxAC-pkgE-Evap-65to75k-10.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('55', '2', 'dxAC-pkgE-Evap-65to75k-11.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('56', '2', 'dxAC-pkgE-Evap-65to75k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('57', '2', 'dxAC-pkgE-Evap-76to134k-10.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('58', '2', 'dxAC-pkgE-Evap-76to134k-11.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('59', '2', 'dxAC-pkgE-Evap-76to134k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('60', '2', 'dxAC-pkgE-Evap-135to239k-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('61', '2', 'dxAC-pkgE-Evap-135to239k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('62', '2', 'dxAC-pkgE-Evap-135to239k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('63', '2', 'dxAC-pkgE-Evap-240to759-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('64', '2', 'dxAC-pkgE-Evap-240to759-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('65', '2', 'dxAC-pkgE-Evap-240to759-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('66', '2', 'dxAC-pkgE-Evap-gt760k-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('67', '2', 'dxAC-pkgE-Evap-gt760k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('68', '2', 'dxAC-pkgE-Evap-gt760k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('69', '2', 'dxAC-pkgE-Water-lt65k-9.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('70', '2', 'dxAC-pkgE-Water-lt65k-12.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('71', '2', 'dxAC-pkgE-Water-lt65k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('72', '2', 'dxAC-pkgE-Water-65to75k-10.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('73', '2', 'dxAC-pkgE-Water-65to75k-11.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('74', '2', 'dxAC-pkgE-Water-65to75k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('75', '2', 'dxAC-pkgE-Water-76to134k-10.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('76', '2', 'dxAC-pkgE-Water-76to134k-11.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('77', '2', 'dxAC-pkgE-Water-76to134k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('78', '2', 'dxAC-pkgE-Water-135to239k-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('79', '2', 'dxAC-pkgE-Water-135to239k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('80', '2', 'dxAC-pkgE-Water-135to239k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('81', '2', 'dxAC-pkgE-Water-240to759-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('82', '2', 'dxAC-pkgE-Water-240to759-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('83', '2', 'dxAC-pkgE-Water-240to759-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('84', '2', 'dxAC-pkgE-Water-gt760k-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('85', '2', 'dxAC-pkgE-Water-gt760k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('86', '2', 'dxAC-pkgE-Water-gt760k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('87', '3', 'dxAC-VSC-lt65k-9.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('88', '3', 'dxAC-VSC-lt65k-12.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('89', '3', 'dxAC-VSC-lt65k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('90', '3', 'dxAC-VSC-65to75k-10.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('91', '3', 'dxAC-VSC-65to75k-11.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('92', '3', 'dxAC-VSC-65to75k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('93', '3', 'dxAC-VSC-76to134k-10.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('94', '3', 'dxAC-VSC-76to134k-11.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('95', '3', 'dxAC-VSC-76to134k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('96', '3', 'dxAC-VSC-135to239k-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('97', '3', 'dxAC-VSC-135to239k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('98', '3', 'dxAC-VSC-135to239k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('99', '3', 'dxAC-VSC-240to759-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('100', '3', 'dxAC-VSC-240to759-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('101', '3', 'dxAC-VSC-240to759-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('102', '3', 'dxAC-VSC-gt760k-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('103', '3', 'dxAC-VSC-gt760k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('104', '3', 'dxAC-VSC-gt760k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('105', '4', 'dxAC-spltS-Air-lt65k-8.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('106', '4', 'dxAC-spltS-Air-lt65k-9.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('107', '4', 'dxAC-spltS-Air-lt65k-10', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('108', '4', 'dxAC-spltS-Air-lt65k-12', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('109', '4', 'dxAC-spltS-Air-lt65k-13', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('110', '4', 'dxAC-spltS-Air-lt65k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('111', '4', 'dxAC-spltS-Air-lt65k-14.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('112', '4', 'dxAC-spltS-Air-lt65k-15', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('113', '4', 'dxAC-spltS-Air-lt65k-16', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('114', '4', 'dxAC-spltS-Air-lt65k-17', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('115', '4', 'dxAC-spltS-Air-lt65k-18', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('116', '4', 'dxAC-spltS-Air-lt65k-19', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('117', '4', 'dxAC-spltS-Air-lt65k-20', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('118', '4', 'dxAC-spltS-Air-lt65k-21', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('119', '4', 'dxAC-spltS-Evap-lt65k-17.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('120', '5', 'dxAC-spltE-Air-65to75k-7.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('121', '5', 'dxAC-spltE-Air-65to75k-8.9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('122', '5', 'dxAC-spltE-Air-65to75k-9.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('123', '5', 'dxAC-spltE-Air-65to75k-10.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('124', '5', 'dxAC-spltE-Air-65to75k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('125', '5', 'dxAC-spltE-Air-65to75k-11.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('126', '5', 'dxAC-spltE-Air-65to75k-12', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('127', '5', 'dxAC-spltE-Air-76to134k-7.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('128', '5', 'dxAC-spltE-Air-76to134k-8.9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('129', '5', 'dxAC-spltE-Air-76to134k-9.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('130', '5', 'dxAC-spltE-Air-76to134k-10.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('131', '5', 'dxAC-spltE-Air-76to134k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('132', '5', 'dxAC-spltE-Air-76to134k-11.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('133', '5', 'dxAC-spltE-Air-76to134k-12', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('134', '5', 'dxAC-spltE-Air-135to239k-7.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('135', '5', 'dxAC-spltE-Air-135to239k-8.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('136', '5', 'dxAC-spltE-Air-135to239k-9.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('137', '5', 'dxAC-spltE-Air-135to239k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('138', '5', 'dxAC-spltE-Air-135to239k-11.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('139', '5', 'dxAC-spltE-Air-135to239k-12', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('140', '5', 'dxAC-spltE-Air-240to759-7.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('141', '5', 'dxAC-spltE-Air-240to759-8.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('142', '5', 'dxAC-spltE-Air-240to759-9.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('143', '5', 'dxAC-spltE-Air-240to759-9.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('144', '5', 'dxAC-spltE-Air-240to759-10.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('145', '5', 'dxAC-spltE-Air-240to759-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('146', '5', 'dxAC-spltE-Air-gt760k-7.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('147', '5', 'dxAC-spltE-Air-gt760k-8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('148', '5', 'dxAC-spltE-Air-gt760k-9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('149', '5', 'dxAC-spltE-Air-gt760k-9.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('150', '5', 'dxAC-spltE-Air-gt760k-9.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('151', '5', 'dxAC-spltE-Air-gt760k-10.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('152', '5', 'dxAC-spltE-Evap-lt65k-9.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('153', '5', 'dxAC-spltE-Evap-lt65k-12.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('154', '5', 'dxAC-spltE-Evap-lt65k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('155', '5', 'dxAC-spltE-Evap-65to75k-10.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('156', '5', 'dxAC-spltE-Evap-65to75k-11.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('157', '5', 'dxAC-spltE-Evap-65to75k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('158', '5', 'dxAC-spltE-Evap-76to134k-10.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('159', '5', 'dxAC-spltE-Evap-76to134k-11.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('160', '5', 'dxAC-spltE-Evap-76to134k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('161', '5', 'dxAC-spltE-Evap-135to239k-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('162', '5', 'dxAC-spltE-Evap-135to239k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('163', '5', 'dxAC-spltE-Evap-135to239k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('164', '5', 'dxAC-spltE-Evap-240to759-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('165', '5', 'dxAC-spltE-Evap-240to759-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('166', '5', 'dxAC-spltE-Evap-240to759-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('167', '5', 'dxAC-spltE-Evap-gt760k-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('168', '5', 'dxAC-spltE-Evap-gt760k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('169', '5', 'dxAC-spltE-Evap-gt760k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('170', '5', 'dxAC-spltE-Water-lt65k-9.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('171', '5', 'dxAC-spltE-Water-lt65k-12.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('172', '5', 'dxAC-spltE-Water-lt65k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('173', '5', 'dxAC-spltE-Water-65to75k-10.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('174', '5', 'dxAC-spltE-Water-65to75k-11.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('175', '5', 'dxAC-spltE-Water-65to75k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('176', '5', 'dxAC-spltE-Water-76to134k-10.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('177', '5', 'dxAC-spltE-Water-76to134k-11.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('178', '5', 'dxAC-spltE-Water-76to134k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('179', '5', 'dxAC-spltE-Water-135to239k-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('180', '5', 'dxAC-spltE-Water-135to239k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('181', '5', 'dxAC-spltE-Water-135to239k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('182', '5', 'dxAC-spltE-Water-240to759-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('183', '5', 'dxAC-spltE-Water-240to759-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('184', '5', 'dxAC-spltE-Water-240to759-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('185', '5', 'dxAC-spltE-Water-gt760k-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('186', '5', 'dxAC-spltE-Water-gt760k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('187', '5', 'dxAC-spltE-Water-gt760k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('188', '6', 'dxAC-refgChg-highOvr-0.418', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('189', '6', 'dxAC-refgChg-typOvr-0.36', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('190', '6', 'dxAC-refgChg-highUnd-0.36', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('191', '6', 'dxAC-refgChg-typUnd-0.346', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('192', '6', 'dxAC-refgChg-std-0.31', 'DEER2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('193', '7', 'dxAC-RAC-lt6k-9.7-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('194', '7', 'dxAC-RAC-lt6k-9.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('195', '7', 'dxAC-RAC-lt6k-10.7-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('196', '7', 'dxAC-RAC-lt6k-10.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('197', '7', 'dxAC-RAC-lt6k-11.2-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('198', '7', 'dxAC-RAC-lt6k-11.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('199', '7', 'dxAC-RAC-lt6k-11.6-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('200', '7', 'dxAC-RAC-lt6k-11.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('201', '7', 'dxAC-RAC-6to8k-9.7-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('202', '7', 'dxAC-RAC-6to8k-9.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('203', '7', 'dxAC-RAC-6to8k-10.7-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('204', '7', 'dxAC-RAC-6to8k-10.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('205', '7', 'dxAC-RAC-6to8k-11.2-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('206', '7', 'dxAC-RAC-6to8k-11.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('207', '7', 'dxAC-RAC-6to8k-11.6-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('208', '7', 'dxAC-RAC-6to8k-11.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('209', '7', 'dxAC-RAC-8to14k-9.8-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('210', '7', 'dxAC-RAC-8to14k-9.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('211', '7', 'dxAC-RAC-8to14k-10.8-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('212', '7', 'dxAC-RAC-8to14k-10.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('213', '7', 'dxAC-RAC-8to14k-11.3-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('214', '7', 'dxAC-RAC-8to14k-11.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('215', '7', 'dxAC-RAC-8to14k-11.8-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('216', '7', 'dxAC-RAC-8to14k-11.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('217', '7', 'dxAC-RAC-14to20k-9.7-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('218', '7', 'dxAC-RAC-14to20k-9.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('219', '7', 'dxAC-RAC-14to20k-10.7-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('220', '7', 'dxAC-RAC-14to20k-10.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('221', '7', 'dxAC-RAC-14to20k-11.2-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('222', '7', 'dxAC-RAC-14to20k-11.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('223', '7', 'dxAC-RAC-14to20k-11.6-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('224', '7', 'dxAC-RAC-14to20k-11.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('225', '7', 'dxAC-RAC-gt20k-8.5-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('226', '7', 'dxAC-RAC-gt20k-8.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('227', '7', 'dxAC-RAC-gt20k-9.4-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('228', '7', 'dxAC-RAC-gt20k-9.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('229', '7', 'dxAC-RAC-gt20k-9.8-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('230', '7', 'dxAC-RAC-gt20k-9.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('231', '7', 'dxAC-RAC-gt20k-10.2-ES', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('232', '7', 'dxAC-RAC-gt20k-10.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('233', '8', 'dxAC-PTAC-lt7k-8.9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('234', '8', 'dxAC-PTAC-lt7k-11.0', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('235', '8', 'dxAC-PTAC-lt7k-13.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('236', '8', 'dxAC-PTAC-7to15k-8.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('237', '8', 'dxAC-PTAC-7to15k-10.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('238', '8', 'dxAC-PTAC-7to15k-12.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('239', '8', 'dxAC-PTAC-gt15k-7.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('240', '8', 'dxAC-PTAC-gt15k-9.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('241', '8', 'dxAC-PTAC-gt15k-11.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('242', '8', 'dxAC-PTAC-lt7k-8.9-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('243', '8', 'dxAC-PTAC-lt7k-9.4-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('244', '8', 'dxAC-PTAC-lt7k-11.3-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('245', '8', 'dxAC-PTAC-7to15k-8.2-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('246', '8', 'dxAC-PTAC-7to15k-8.6-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('247', '8', 'dxAC-PTAC-7to15k-10.3-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('248', '8', 'dxAC-PTAC-gt15k-7.6-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('249', '8', 'dxAC-PTAC-gt15k-7.7-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('250', '8', 'dxAC-PTAC-gt15k-9.2-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('251', '9', 'dxHP-pkgS-lt65k-8.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('252', '9', 'dxHP-pkgS-lt65k-9.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('253', '9', 'dxHP-pkgS-lt65k-9.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('254', '9', 'dxHP-pkgS-lt65k-10', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('255', '9', 'dxHP-pkgS-lt65k-12', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('256', '9', 'dxHP-pkgS-lt65k-13', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('257', '9', 'dxHP-pkgS-lt65k-14', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('258', '9', 'dxHP-pkgS-lt65k-14.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('259', '9', 'dxHP-pkgS-lt65k-15', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('260', '10', 'dxHP-pkgE-65to75k-7.7-2.25', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('261', '10', 'dxHP-pkgE-65to75k-8.9-2.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('262', '10', 'dxHP-pkgE-65to75k-8.9-3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('263', '10', 'dxHP-pkgE-65to75k-10.1-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('264', '10', 'dxHP-pkgE-65to75k-11-3.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('265', '10', 'dxHP-pkgE-65to75k-11.5-3.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('266', '10', 'dxHP-pkgE-76to134k-7.7-2.25', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('267', '10', 'dxHP-pkgE-76to134k-8.9-2.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('268', '10', 'dxHP-pkgE-76to134k-8.9-3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('269', '10', 'dxHP-pkgE-76to134k-10.1-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('270', '10', 'dxHP-pkgE-76to134k-11-3.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('271', '10', 'dxHP-pkgE-76to134k-11.5-3.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('272', '10', 'dxHP-pkgE-135to239k-7.7-2.25', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('273', '10', 'dxHP-pkgE-135to239k-8.5-2.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('274', '10', 'dxHP-pkgE-135to239k-8.5-2.9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('275', '10', 'dxHP-pkgE-135to239k-9.3-3.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('276', '10', 'dxHP-pkgE-135to239k-10.6-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('277', '10', 'dxHP-pkgE-135to239k-11.5-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('278', '10', 'dxHP-pkgE-240to759-7.7-2.25', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('279', '10', 'dxHP-pkgE-240to759-8.5-2.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('280', '10', 'dxHP-pkgE-240to759-8.5-2.9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('281', '10', 'dxHP-pkgE-240to759-9-3.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('282', '10', 'dxHP-pkgE-240to759-9.5-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('283', '10', 'dxHP-pkgE-240to759-11.5-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('284', '10', 'dxHP-pkgE-gt760k-7.7-2.25', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('285', '10', 'dxHP-pkgE-gt760k-8.2-2.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('286', '10', 'dxHP-pkgE-gt760k-8.2-2.9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('287', '10', 'dxHP-pkgE-gt760k-9-3.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('288', '10', 'dxHP-pkgE-gt760k-9.5-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('289', '10', 'dxHP-pkgE-gt760k-11.5-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('290', '11', 'dxHP-pkgS-lt65k-8.5-4.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('291', '11', 'dxHP-pkgS-lt65k-9.5-5.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('292', '11', 'dxHP-pkgS-lt65k-10-6.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('293', '11', 'dxHP-pkgS-lt65k-12-7.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('294', '11', 'dxHP-pkgS-lt65k-13-7.7', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('295', '11', 'dxHP-pkgS-lt65k-14-ge8.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('296', '11', 'dxHP-pkgS-lt65k-14.5-ge8.5', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('297', '11', 'dxHP-pkgS-lt65k-15-ge8.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('298', '11', 'dxHP-pkgS-lt65k-16-ge8.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('299', '11', 'dxHP-pkgS-lt65k-17-ge8.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('300', '11', 'dxHP-pkgS-lt65k-18-ge8.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('301', '11', 'dxHP-pkgS-lt65k-19-ge8.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('302', '11', 'dxHP-pkgS-lt65k-20-ge8.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('303', '11', 'dxHP-pkgS-lt65k-21-ge8.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('304', '12', 'dxHP-spltE-65to75k-7.7-2.25', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('305', '12', 'dxHP-spltE-65to75k-8.9-2.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('306', '12', 'dxHP-spltE-65to75k-8.9-3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('307', '12', 'dxHP-spltE-65to75k-10.1-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('308', '12', 'dxHP-spltE-65to75k-11-3.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('309', '12', 'dxHP-spltE-65to75k-11.5-3.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('310', '12', 'dxHP-spltE-76to134k-7.7-2.25', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('311', '12', 'dxHP-spltE-76to134k-8.9-2.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('312', '12', 'dxHP-spltE-76to134k-8.9-3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('313', '12', 'dxHP-spltE-76to134k-10.1-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('314', '12', 'dxHP-spltE-76to134k-11-3.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('315', '12', 'dxHP-spltE-76to134k-11.5-3.4', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('316', '12', 'dxHP-spltE-135to239k-7.7-2.25', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('317', '12', 'dxHP-spltE-135to239k-8.5-2.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('318', '12', 'dxHP-spltE-135to239k-8.5-2.9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('319', '12', 'dxHP-spltE-135to239k-9.3-3.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('320', '12', 'dxHP-spltE-135to239k-10.6-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('321', '12', 'dxHP-spltE-135to239k-11.5-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('322', '12', 'dxHP-spltE-240to759-7.7-2.25', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('323', '12', 'dxHP-spltE-240to759-8.5-2.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('324', '12', 'dxHP-spltE-240to759-8.5-2.9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('325', '12', 'dxHP-spltE-240to759-9-3.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('326', '12', 'dxHP-spltE-240to759-9.5-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('327', '12', 'dxHP-spltE-240to759-11.5-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('328', '12', 'dxHP-spltE-gt760k-7.7-2.25', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('329', '12', 'dxHP-spltE-gt760k-8.2-2.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('330', '12', 'dxHP-spltE-gt760k-8.2-2.9', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('331', '12', 'dxHP-spltE-gt760k-9-3.1', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('332', '12', 'dxHP-spltE-gt760k-9.5-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('333', '12', 'dxHP-spltE-gt760k-11.5-3.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('334', '13', 'dxHP-WS-lt17k-9.3-3.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('335', '13', 'dxHP-WS-lt17k-9.3-3.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('336', '13', 'dxHP-WS-lt17k-11.2-4.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('337', '13', 'dxHP-WS-lt17k-14-4.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('338', '13', 'dxHP-WS-17to65k-9.3-3.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('339', '13', 'dxHP-WS-17to65k-9.3-3.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('340', '13', 'dxHP-WS-17to65k-12-4.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('341', '13', 'dxHP-WS-17to65k-14-4.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('342', '13', 'dxHP-WS-65to134k-9.3-3.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('343', '13', 'dxHP-WS-65to134k-9.3-3.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('344', '13', 'dxHP-WS-65to134k-12-4.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('345', '13', 'dxHP-WS-65to134k-14-4.6', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('346', '13', 'dxHP-WS-gt135k-9.3-3.3', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('347', '13', 'dxHP-WS-gt135k-9.3-3.8', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('348', '13', 'dxHP-WS-gt135k-12-4.2', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('349', '14', 'dxHP-PT-lt7k-8.88', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('350', '14', 'dxHP-PT-lt7k-10.81', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('351', '14', 'dxHP-PT-lt7k-12.97', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('352', '14', 'dxHP-PT-7to15k-8.24', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('353', '14', 'dxHP-PT-7to15k-9.96', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('354', '14', 'dxHP-PT-7to15k-11.95', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('355', '14', 'dxHP-PT-gt15k-7.60', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('356', '14', 'dxHP-PT-gt15k-9.11', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('357', '14', 'dxHP-PT-gt15k-10.93', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('358', '14', 'dxHP-PT-lt7k-8.88-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('359', '14', 'dxHP-PT-lt7k-9.31-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('360', '14', 'dxHP-PT-lt7k-11.17-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('361', '14', 'dxHP-PT-7to15k-8.24-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('362', '14', 'dxHP-PT-7to15k-8.46-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('363', '14', 'dxHP-PT-7to15k-10.15-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('364', '14', 'dxHP-PT-gt15k-7.60-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('365', '14', 'dxHP-PT-gt15k-7.61-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('366', '14', 'dxHP-PT-gt15k-9.13-RQ', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('367', '18', 'CentChlr-lt150t-0.75', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('368', '18', 'CentChlr-lt150t-0.75-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('369', '18', 'CentChlr-lt150t-0.75-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('370', '18', 'CentChlr-lt150t-0.75-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('371', '18', 'CentChlr-lt150t-0.70', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('372', '18', 'CentChlr-lt150t-0.70-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('373', '18', 'CentChlr-lt150t-0.70-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('374', '18', 'CentChlr-lt150t-0.70-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('375', '18', 'CentChlr-lt150t-0.56', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('376', '18', 'CentChlr-lt150t-0.56-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('377', '18', 'CentChlr-lt150t-0.56-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('378', '18', 'CentChlr-lt150t-0.56-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('379', '18', 'CentChlr-150to300t-0.75', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('380', '18', 'CentChlr-150to300t-0.75-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('381', '18', 'CentChlr-150to300t-0.75-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('382', '18', 'CentChlr-150to300t-0.75-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('383', '18', 'CentChlr-150to300t-0.63', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('384', '18', 'CentChlr-150to300t-0.63-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('385', '18', 'CentChlr-150to300t-0.63-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('386', '18', 'CentChlr-150to300t-0.63-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('387', '18', 'CentChlr-150to300t-0.51', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('388', '18', 'CentChlr-150to300t-0.51-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('389', '18', 'CentChlr-150to300t-0.51-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('390', '18', 'CentChlr-150to300t-0.51-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('391', '18', 'CentChlr-ge300t-0.75', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('392', '18', 'CentChlr-ge300t-0.75-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('393', '18', 'CentChlr-ge300t-0.75-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('394', '18', 'CentChlr-ge300t-0.75-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('395', '18', 'CentChlr-ge300t-0.58', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('396', '18', 'CentChlr-ge300t-0.58-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('397', '18', 'CentChlr-ge300t-0.58-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('398', '18', 'CentChlr-ge300t-0.58-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('399', '18', 'CentChlr-ge300t-0.46', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('400', '18', 'CentChlr-ge300t-0.46-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('401', '18', 'CentChlr-ge300t-0.46-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('402', '18', 'CentChlr-ge300t-0.46-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('403', '19', 'NoFricCent-Water-lt150t-0.75', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('404', '19', 'NoFricCent-Water-lt150t-0.75-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('405', '19', 'NoFricCent-Water-lt150t-0.75-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('406', '19', 'NoFricCent-Water-lt150t-0.75-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('407', '19', 'NoFricCent-Water-lt150t-0.70', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('408', '19', 'NoFricCent-Water-lt150t-0.70-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('409', '19', 'NoFricCent-Water-lt150t-0.70-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('410', '19', 'NoFricCent-Water-lt150t-0.70-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('411', '19', 'NoFricCent-Water-lt150t-0.56', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('412', '19', 'NoFricCent-Water-lt150t-0.56-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('413', '19', 'NoFricCent-Water-lt150t-0.56-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('414', '19', 'NoFricCent-Water-lt150t-0.56-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('415', '19', 'NoFricCent-Water-150to300t-0.75', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('416', '19', 'NoFricCent-Water-150to300t-0.75-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('417', '19', 'NoFricCent-Water-150to300t-0.75-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('418', '19', 'NoFricCent-Water-150to300t-0.75-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('419', '19', 'NoFricCent-Water-150to300t-0.63', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('420', '19', 'NoFricCent-Water-150to300t-0.63-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('421', '19', 'NoFricCent-Water-150to300t-0.63-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('422', '19', 'NoFricCent-Water-150to300t-0.63-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('423', '19', 'NoFricCent-Water-150to300t-0.51', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('424', '19', 'NoFricCent-Water-150to300t-0.51-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('425', '19', 'NoFricCent-Water-150to300t-0.51-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('426', '19', 'NoFricCent-Water-150to300t-0.51-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('427', '19', 'NoFricCent-Water-ge300t-0.75', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('428', '19', 'NoFricCent-Water-ge300t-0.75-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('429', '19', 'NoFricCent-Water-ge300t-0.75-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('430', '19', 'NoFricCent-Water-ge300t-0.75-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('431', '19', 'NoFricCent-Water-ge300t-0.58', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('432', '19', 'NoFricCent-Water-ge300t-0.58-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('433', '19', 'NoFricCent-Water-ge300t-0.58-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('434', '19', 'NoFricCent-Water-ge300t-0.58-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('435', '19', 'NoFricCent-Water-ge300t-0.46', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('436', '19', 'NoFricCent-Water-ge300t-0.46-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('437', '19', 'NoFricCent-Water-ge300t-0.46-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('438', '19', 'NoFricCent-Water-ge300t-0.46-VS-CR', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('439', '19', 'NoFricCent-Air-lt150t-1.30', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('440', '19', 'NoFricCent-Air-lt150t-1.30-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('441', '19', 'NoFricCent-Air-lt150t-1.26', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('442', '19', 'NoFricCent-Air-lt150t-1.26-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('443', '19', 'NoFricCent-Air-lt150t-1.00', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('444', '19', 'NoFricCent-Air-lt150t-1.00-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('445', '19', 'NoFricCent-Air-150to300t-1.30', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('446', '19', 'NoFricCent-Air-150to300t-1.30-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('447', '19', 'NoFricCent-Air-150to300t-1.26', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('448', '19', 'NoFricCent-Air-150to300t-1.26-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('449', '19', 'NoFricCent-Air-150to300t-1.00', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('450', '19', 'NoFricCent-Air-150to300t-1.00-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('451', '19', 'NoFricCent-Air-ge300t-1.30', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('452', '19', 'NoFricCent-Air-ge300t-1.30-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('453', '19', 'NoFricCent-Air-ge300t-1.26', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('454', '19', 'NoFricCent-Air-ge300t-1.26-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('455', '19', 'NoFricCent-Air-ge300t-1.00', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('456', '19', 'NoFricCent-Air-ge300t-1.00-VS', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('457', '20', 'Recip-Air-ALL-1.01', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('458', '20', 'Recip-Air-ALL-1.26', 'DEER2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('459', '20', 'Recip-Water-ALL-0.67', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('460', '20', 'Recip-Water-ALL-0.84', 'DEER2012', 'code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('461', '21', 'Screw-Air-1.01', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('462', '21', 'Screw-Air-1.26', 'DEER2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('463', '21', 'Screw-Water-150to299t-0.57', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('464', '21', 'Screw-Water-150to299t-0.72', 'DEER2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('465', '21', 'Screw-Water-ge300t-0.51', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('466', '21', 'Screw-Water-ge300t-0.64', 'DEER2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('467', '21', 'Screw-Water-lt150t-0.63', 'DEER2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('468', '21', 'Screw-Water-lt150t-0.79', 'DEER2012', 'code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('469', '28', 'LC-FTC-lt2hp-F-C-F', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('470', '28', 'LC-FTC-lt2hp-F-C-O', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('471', '28', 'LC-FTC-lt2hp-F-C-L', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('472', '28', 'LC-FTC-ge2hp-F-C-F', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('473', '28', 'LC-FTC-ge2hp-F-C-O', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('474', '28', 'LC-FTC-ge2hp-F-C-L', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('475', '28', 'LC-FTC-lt2hp-T-R-F', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('476', '28', 'LC-FTC-lt2hp-T-R-O', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('477', '28', 'LC-FTC-lt2hp-T-R-L', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('478', '28', 'LC-FTC-ge2hp-T-R-F', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('479', '28', 'LC-FTC-ge2hp-T-R-O', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('480', '28', 'LC-FTC-ge2hp-T-R-L', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('481', '28', 'LC-FTC-lt2hp-T-V-F', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('482', '28', 'LC-FTC-lt2hp-T-V-O', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('483', '28', 'LC-FTC-lt2hp-T-V-L', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('484', '28', 'LC-FTC-ge2hp-T-V-F', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('485', '28', 'LC-FTC-ge2hp-T-V-O', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('486', '28', 'LC-FTC-ge2hp-T-V-L', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('487', '36', 'DuctSysR-0.12', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('488', '36', 'DuctSysR-0.15', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('489', '36', 'DuctSysR-0.24', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('490', '36', 'DuctSysR-0.4', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('491', '36', 'DuctSysR-0.25', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('492', '36', 'DuctSysR-0.35', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('493', '37', 'DuctSysC-0.18', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('494', '37', 'DuctSysC-0.4', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('495', '37', 'DuctSysC-0.28', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('496', '63', 'W-Boiler_AF-lt300k-0.845-Atm', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('497', '63', 'W-Boiler_AF-lt300k-0.8-Atm', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('498', '63', 'W-Boiler_AF-lt300k-0.845-fDraft', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('499', '63', 'W-Boiler_AF-lt300k-0.94-C-fDraft', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('500', '64', 'W-Boiler_Et-300to2500k-0.85-Atm', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('501', '64', 'W-Boiler_Et-300to2500k-0.75-Atm', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('502', '64', 'W-Boiler_Et-300to2500k-0.85-fDraft', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('503', '64', 'W-Boiler_Et-300to2500k-0.94-C-fDraft', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('504', '64', 'W-Boiler_Et-gt2500k-0.85-Atm', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('505', '64', 'W-Boiler_Et-gt2500k-0.85-fDraft', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('506', '64', 'W-Boiler_Et-gt2500k-0.75-Atm', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('507', '67', 'Stor_EF-Elec-030gal-0.95', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('508', '67', 'Stor_EF-Elec-040gal-0.94', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('509', '67', 'Stor_EF-Elec-050gal-0.93', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('510', '67', 'Stor_EF-Elec-060gal-0.92', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('511', '67', 'Stor_EF-Elec-075gal-0.91', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('512', '67', 'Stor_EF-Elec-030gal-0.89', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('513', '67', 'Stor_EF-Elec-040gal-0.88', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('514', '67', 'Stor_EF-Elec-050gal-0.86', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('515', '67', 'Stor_EF-Elec-060gal-0.85', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('516', '67', 'Stor_EF-Elec-075gal-0.83', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('517', '67', 'Stor_EF-Gas-030gal-0.62', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('518', '67', 'Stor_EF-Gas-030gal-0.65', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('519', '67', 'Stor_EF-Gas-030gal-0.7', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('520', '67', 'Stor_EF-Gas-040gal-0.62', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('521', '67', 'Stor_EF-Gas-040gal-0.67', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('522', '67', 'Stor_EF-Gas-040gal-0.7', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('523', '67', 'Stor_EF-Gas-050gal-0.62', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('524', '67', 'Stor_EF-Gas-050gal-0.67', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('525', '67', 'Stor_EF-Gas-050gal-0.7', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('526', '67', 'Stor_EF-Gas-060gal-0.62', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('527', '67', 'Stor_EF-Gas-060gal-0.66', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('528', '67', 'Stor_EF-Gas-060gal-0.7', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('529', '67', 'Stor_EF-Gas-075gal-0.62', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('530', '67', 'Stor_EF-Gas-075gal-0.66', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('531', '67', 'Stor_EF-Gas-075gal-0.7', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('532', '67', 'Stor_EF-Gas-030gal-0.61', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('533', '67', 'Stor_EF-Gas-040gal-0.59', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('534', '67', 'Stor_EF-Gas-050gal-0.57', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('535', '67', 'Stor_EF-Gas-060gal-0.56', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('536', '67', 'Stor_EF-Gas-075gal-0.53', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('537', '67', 'Stor_EF-Gas-030gal-0.57', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('538', '67', 'Stor_EF-Gas-040gal-0.57', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('539', '67', 'Stor_EF-Gas-075gal-0.48', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('540', '67', 'Stor_EF-Gas-0lt2-0', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('541', '68', 'Stor_Et-Elec-0.80-0.56', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('542', '68', 'Stor_Et-Elec-0.86-0.57', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('543', '71', 'S-Boiler_AF-lt300k-0.82-Atm', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('544', '71', 'S-Boiler_AF-lt300k-0.75-Atm', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('545', '71', 'S-Boiler_AF-lt300k-0.82-fDraft', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('546', '72', 'S-Boiler_Et-300to2500k-0.85-Atm', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('547', '72', 'S-Boiler_Et-300to2500k-0.85-fDraft', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('548', '72', 'S-Boiler_Et-300to2500k-0.75-Atm', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('549', '72', 'S-Boiler_Et-gt2500k-0.8-Atm', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('550', '72', 'S-Boiler_Et-gt2500k-0.8-fDraft', 'DEER 2012', 'Meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('551', '72', 'S-Boiler_Et-gt2500k-0.75-Atm', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('552', '73', 'Fenest-ManufWin-35-30-54', '', '', 'not a real tech, example only', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('553', '74', 'Fenest-SiteBuiltWin-35-30-54', '', '', 'not a real tech, example only', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('554', '76', 'WinFilm-82', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('555', '76', 'WinFilm-60', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('556', '76', 'WinFilm-35', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('557', '80', 'BldgShell-AttBlowIns-5', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('558', '80', 'BldgShell-AttBlowIns-7', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('559', '80', 'BldgShell-AttBlowIns-11', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('560', '80', 'BldgShell-AttBlowIns-13', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('561', '80', 'BldgShell-AttBlowIns-19', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('562', '80', 'BldgShell-AttBlowIns-30', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('563', '80', 'BldgShell-AttBlowIns-38', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('564', '80', 'BldgShell-AttBlowIns-49', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('565', '81', 'BldgShell-AttBatIns-5', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('566', '81', 'BldgShell-AttBatIns-7', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('567', '81', 'BldgShell-AttBatIns-11', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('568', '81', 'BldgShell-AttBatIns-13', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('569', '81', 'BldgShell-AttBatIns-19', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('570', '81', 'BldgShell-AttBatIns-30', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('571', '81', 'BldgShell-AttBatIns-38', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('572', '82', 'BldgShell-RigidRoofIns-49', '', '', 'xx inches, framing factor = 0.xx', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('573', '83', 'BldgShell-SprayRoofIns-R-0', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('574', '83', 'BldgShell-SprayRoofIns-R-11', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('575', '119', 'Ref_Storage-RefrigFrz-487kWhyr-16.5to25ft3-ES', 'DEER 2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('576', '119', 'Ref_Storage-RefrigFrz-573kWhyr-16.5to25ft3', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('577', '119', 'Ref_Storage-RefrigFrz-447kWhyr-8to16.5ft3-ES', 'DEER 2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('578', '119', 'Ref_Storage-RefrigFrz-518kWhyr-8to16.5ft3', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('579', '119', 'Ref_Storage-RefrigFrz-565kWhyr-23to31ft3-ES', 'DEER 2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('580', '119', 'Ref_Storage-RefrigFrz-665kWhyr-23to31ft3', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('581', '119', 'Ref_Storage-RefrigFrz-921kWhyr-23to31ft3', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('582', '119', 'Ref_Storage-RefrigFrz-620kWhyr-23to31ft3-ES', 'DEER 2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('583', '119', 'Ref_Storage-RefrigFrz-730kWhyr-23to31ft3', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('584', '119', 'Ref_Storage-RefrigFrz-821kWhyr-23to31ft3', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('585', '119', 'Ref_Storage-RefrigFrz-528kWhyr-15to23ft3-ES', 'DEER 2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('586', '119', 'Ref_Storage-RefrigFrz-620kWhyr-15to23ft3', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('587', '119', 'Ref_Storage-RefrigFrz-703kWhyr-15to23ft3', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('588', '119', 'Ref_Storage-RefrigFrz-543kWhyr-15to23ft3-ES', 'DEER 2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('589', '119', 'Ref_Storage-RefrigFrz-639kWhyr-15to23ft3', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('590', '119', 'Ref_Storage-RefrigFrz-835kWhyr-15to23ft3', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('591', '119', 'Ref_Storage-RefrigFrz-452kWhyr-20to25ft3-ES', 'DEER 2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('592', '119', 'Ref_Storage-RefrigFrz-532kWhyr-20to25ft3', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('593', '119', 'Ref_Storage-RefrigFrz-697kWhyr-20to25ft3', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('594', '119', 'Ref_Storage-RefrigFrz-399kWhyr-15to20ft3-ES', 'DEER 2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('595', '119', 'Ref_Storage-RefrigFrz-469kWhyr-15to20ft3', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('596', '119', 'Ref_Storage-RefrigFrz-652kWhyr-15to20ft3', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('597', '119', 'Ref_Storage-RefrigFrz-357kWhyr-10to15ft3-ES', 'DEER 2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('598', '119', 'Ref_Storage-RefrigFrz-420kWhyr-10to15ft3', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('599', '119', 'Ref_Storage-RefrigFrz-621kWhyr-10to15ft3', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('600', '121', 'Ref_Storage-Freezer-368kWhyr-man-ES', 'DEER 2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('601', '121', 'Ref_Storage-Freezer-642kWhyr-auto-ES', 'DEER 2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('602', '121', 'Ref_Storage-Freezer-409kWhyr-man-ES', 'DEER 2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('603', '121', 'Ref_Storage-Freezer-409kWhyr-man', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('604', '121', 'Ref_Storage-Freezer-713kWhyr-auto', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('605', '121', 'Ref_Storage-Freezer-708kWhyr-man', 'DEER 2012', 'Code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('606', '121', 'Ref_Storage-Freezer-700kWhyr-man', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('607', '121', 'Ref_Storage-Freezer-849kWhyr-auto', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('608', '121', 'Ref_Storage-Freezer-454kWhyr-man', 'DEER 2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('609', '133', 'Cook_equip-Griddle-2300-0.70', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('610', '134', 'Cook_equip-GrillTO-Elec-16-7', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('611', '135', 'Cook_equip-SteamLine-Elec-16-7', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('612', '138', 'FoodService-HoldBin-m20-18-7', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('613', '138', 'FoodService-HoldBin-m20-24-7', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('614', '138', 'FoodService-HoldBin-m33-18-7', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('615', '138', 'FoodService-HoldBin-m33-24-7', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('616', '139', 'Cook_equip-GrillTO-Elec-18-7', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('617', '139', 'Cook_equip-GrillTO-Elec-24-7', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('618', '140', 'FoodService-HoldCab-half-1.0ES', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('619', '140', 'FoodService-HoldCab-half-0.5ES', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('620', '140', 'FoodService-HoldCab-3q-1.0ES', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('621', '140', 'FoodService-HoldCab-3q-0.5ES', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('622', '140', 'FoodService-HoldCab-full-1.0ES', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('623', '140', 'FoodService-HoldCab-full-0.5ES', 'IOU work paper', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('624', '141', 'Ref_SelfCon-IceMach-t2-101to200', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('625', '141', 'Ref_SelfCon-IceMach-t2-201to300', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('626', '141', 'Ref_SelfCon-IceMach-t2-301to400', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('627', '141', 'Ref_SelfCon-IceMach-t2-401to500', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('628', '141', 'Ref_SelfCon-IceMach-t2-501to1000', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('629', '141', 'Ref_SelfCon-IceMach-t2-1001to1500', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('630', '141', 'Ref_SelfCon-IceMach-t2-gt1500', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('631', '141', 'Ref_SelfCon-IceMach-t3-101to200', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('632', '141', 'Ref_SelfCon-IceMach-t3-201to300', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('633', '141', 'Ref_SelfCon-IceMach-t3-301to400', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('634', '141', 'Ref_SelfCon-IceMach-t3-401to500', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('635', '141', 'Ref_SelfCon-IceMach-t3-501to1000', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('636', '141', 'Ref_SelfCon-IceMach-t3-1001to1500', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('637', '141', 'Ref_SelfCon-IceMach-t3-gt1500', '', '', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('638', '142', 'ClothesWash-CT2-Elec-Elec-3.5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('639', '142', 'ClothesWash-CT3-Elec-Elec-3.5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('640', '142', 'ClothesWash-CT2-Elec-Elec-2.65', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('641', '142', 'ClothesWash-CT3-Elec-Elec-2.65', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('642', '142', 'ClothesWash-Elec-Elec-3.5-1.26', 'DEER2012', 'code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('643', '142', 'ClothesWash-Elec-Elec-2.65-1.26', 'DEER2012', 'code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('644', '142', 'ClothesWash-Elec-Elec-3.5-0.78', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('645', '142', 'ClothesWash-Elec-Elec-2.65-0.78', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('646', '142', 'ClothesWash-CT2-Elec-Gas-3.5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('647', '142', 'ClothesWash-CT3-Elec-Gas-3.5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('648', '142', 'ClothesWash-CT2-Elec-Gas-2.65', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('649', '142', 'ClothesWash-CT3-Elec-Gas-2.65', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('650', '142', 'ClothesWash-Elec-Gas-3.5-1.26', 'DEER2012', 'code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('651', '142', 'ClothesWash-Elec-Gas-2.65-1.26', 'DEER2012', 'code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('652', '142', 'ClothesWash-Elec-Gas-3.5-0.78', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('653', '142', 'ClothesWash-Elec-Gas-2.65-0.78', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('654', '142', 'ClothesWash-CT2-Gas-Elec-3.5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('655', '142', 'ClothesWash-CT3-Gas-Elec-3.5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('656', '142', 'ClothesWash-CT2-Gas-Elec-2.65', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('657', '142', 'ClothesWash-CT3-Gas-Elec-2.65', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('658', '142', 'ClothesWash-Gas-Elec-3.5-1.26', 'DEER2012', 'code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('659', '142', 'ClothesWash-Gas-Elec-2.65-1.26', 'DEER2012', 'code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('660', '142', 'ClothesWash-Gas-Elec-3.5-0.78', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('661', '142', 'ClothesWash-Gas-Elec-2.65-0.78', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('662', '142', 'ClothesWash-CT2-Gas-Gas-3.5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('663', '142', 'ClothesWash-CT3-Gas-Gas-3.5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('664', '142', 'ClothesWash-CT2-Gas-Gas-2.65', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('665', '142', 'ClothesWash-CT3-Gas-Gas-2.65', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('666', '142', 'ClothesWash-Gas-Gas-3.5-1.26', 'DEER2012', 'code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('667', '142', 'ClothesWash-Gas-Gas-2.65-1.26', 'DEER2012', 'code', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('668', '142', 'ClothesWash-Gas-Gas-3.5-0.78', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('669', '142', 'ClothesWash-Gas-Gas-2.65-0.78', 'DEER2012', 'CustAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('670', '143', 'DishWash-Gas-ES1-160', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('671', '143', 'DishWash-Gas-ES2-160', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('672', '143', 'DishWash-Elec-ES1-160', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('673', '143', 'DishWash-Elec-ES2-160', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('674', '143', 'DishWash-Gas-160', 'DEER2012', 'custAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('675', '143', 'DishWash-Elec-160', 'DEER2012', 'custAve', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('676', '148', 'TV-10to25.4-L4.1', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('677', '148', 'TV-10to25.4-L5.1', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('678', '148', 'TV-10to25.4-T1', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('679', '148', 'TV-25.5to35-L4.1', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('680', '148', 'TV-25.5to35-L5.1', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('681', '148', 'TV-25.5to35-T1', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('682', '148', 'TV-36to39-L4.1', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('683', '148', 'TV-36to39-L5.1', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('684', '148', 'TV-36to39-T1', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('685', '148', 'TV-40to42-L4.1', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('686', '148', 'TV-40to42-L5.1', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('687', '148', 'TV-gt42-T1', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('688', '149', 'DesktopComp-le118-A-ES5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('689', '149', 'DesktopComp-gt119 -A-ES5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('690', '149', 'DesktopComp-gt148-A', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('691', '149', 'DesktopComp-le140-B-ES5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('692', '149', 'DesktopComp-gt141-B-ES5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('693', '149', 'DesktopComp-gt175-B', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('694', '149', 'DesktopComp-le167-C-ES5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('695', '149', 'DesktopComp-gt168-C-ES5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('696', '149', 'DesktopComp-gt209-C', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('697', '149', 'DesktopComp-le187-D-ES5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('698', '149', 'DesktopComp-gt188-D-ES5', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('699', '149', 'DesktopComp-gt234-D', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('700', '100', '18in15wT12SMg19w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('701', '100', '18in15wT12SMg36w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('702', '100', '24in20wT12SMg28w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('703', '100', '24in20wT12SMg56w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('704', '100', '24in20wT12SMg62w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('705', '100', '24in35wT12HOSMg62w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('706', '100', '24in35wT12HOSMg90w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('707', '100', '24in20wT12SMg112w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('708', '100', '24in20wT12SMg146w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('709', '100', '36in25wT12El26w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('710', '100', '36in30wT12El31w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('711', '100', '36in25wT12El50w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('712', '100', '36in30wT12El58w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('713', '100', '36in30wT12El116w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('714', '100', '36in25wT12ESMg33w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('715', '100', '36in25wT12SMg37w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('716', '100', '36in30wT12ESMg37w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('717', '100', '36in30wT12SMg41w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('718', '100', '36in25wT12SMg42w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('719', '100', '36in30wT12SMg46w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('720', '100', '36in50wT12HOSMg70w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('721', '100', '36in25wT12ESMg66w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('722', '100', '36in25wT12SMg73w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('723', '100', '36in30wT12ESMg74w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('724', '100', '36in30wT12SMg81w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('725', '100', '36in50wT12HOSMg114w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('726', '100', '36in25wT12SMg115w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('727', '100', '36in30wT122ESMg120w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('728', '100', '36in30wT12SMg127w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('729', '100', '36in30wT12ESMg148w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('730', '100', '36in30wT12SMg162w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('731', '100', '36in25wT12ESMg198w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('732', '100', '36in30wT12ESMg342w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('733', '100', '42in55wT12HOSMg135w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('734', '100', '42in55wT12HOSMg215w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('735', '100', '48in25wT12TISEl19w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('736', '100', '48in25wT12TISEl20w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('737', '100', '48in25wT12ISEl25w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('738', '100', '48in34wT12El32w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('739', '100', '48in39wT12TEl37w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('740', '100', '48in39wT12El46w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('741', '100', '48in34wT12ESMg36w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('742', '100', '48in34wT12HMg36w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('743', '100', '48in39wT12HMg41w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('744', '100', '48in34wT12ESMg43w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('745', '100', '48in34wT122ESMg43w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('746', '100', '48in30wT12SMg51w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 51W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('747', '100', '48in39wT12TSMg52w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 52W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('748', '100', '48in39wT12SMg60w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 60W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('749', '100', '48in55wT12HOSMg80w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('750', '100', '48in60wT12HOSMg85w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('751', '100', '48in110wT12VHOSMg135w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('752', '100', '48in100wT12RefESMg100w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('753', '100', '48in25wT12ISREl39w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('754', '100', '48in25wT12TISREl40w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('755', '100', '48in34wT12El60w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('756', '100', '48in39wT12El74w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('757', '100', '48in25wT12REl60w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('758', '100', '48in34wT12ESEl92w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('759', '100', '48in39wT12El120w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('760', '100', '48in25wT12REl80w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('761', '100', '48in34wT12ESEl120w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('762', '100', '48in39wT12El148w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('763', '100', '48in34wT12El186w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('764', '100', '48in34wT12HMg68w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('765', '100', '48in34wT12ESMg72w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('766', '100', '48in39wT12ESMg74w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('767', '100', '48in34wT122ESMg76w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('768', '100', '48in39wT12HMg80w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('769', '100', '48in30wT12SMg82w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 82W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('770', '100', '48in39wT12SMg84w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 84W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('771', '100', '48in60wT12HOSMg145w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('772', '100', '48in110wT12VHOSMg242w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('773', '100', '48in34wT12HMg102w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('774', '100', '48in34wT12ESMg115w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('775', '100', '48in39wT12HMg120w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('776', '100', '48in30wT12SMg133w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 133W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('777', '100', '48in39wT12SMg136w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 136W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('778', '100', '48in60wT12HOSMg230w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('779', '100', '48in110wT12VHOSMg377w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('780', '100', '48in34wT12HMg136w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('781', '100', '48in34wT12ESMg144w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('782', '100', '48in34wT12ESMg152w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('783', '100', '48in39wT12HMg160w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('784', '100', '48in30wT12SMg164w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('785', '100', '48in39wT12SMg168w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('786', '100', '48in55wT12HOSMg270w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('787', '100', '48in60wT12HOSMg290w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('788', '100', '48in95wT12VHOSMg420w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('789', '100', '48in110wT12VHOSMg484w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('790', '100', '48in34wT12ESMg216w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('791', '100', '48in34wT12ESMg288w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('792', '100', '60in50wT12El44w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('793', '100', '60in75wT12HOEl69w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('794', '100', '60in50wT12SMg63w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('795', '100', '60in75wT12HOESMg88w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('796', '100', '60in75wT12HOSMg92w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('797', '100', '60in135wT12VHOSMg165w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('798', '100', '60in50wT12El88w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('799', '100', '60in75wT12HOEl138w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('800', '100', '60in50wT12SMg128w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('801', '100', '60in75wT12HOSMg168w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('802', '100', '60in75wT12HOESMg176w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('803', '100', '60in135wT12VHOSMg310w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('804', '100', '72in55wT12ISEl68w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('805', '100', '72in55wT12SMg76w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('806', '100', '72in85wT12HOSMg120w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('807', '100', '72in160wT12VHOSMg180w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('808', '100', '72in55wT12ISEl108w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('809', '100', '72in55wT12El108w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('810', '100', '72in55wT12ISEl176w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('811', '100', '72in55wT12ISEl216w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('812', '100', '72in55wT12ESMg122w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('813', '100', '72in55wT12SMg122w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('814', '100', '72in85wT12HOESMg194w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('815', '100', '72in85wT12HOSMg220w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('816', '100', '72in160wT12VHOSMg330w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('817', '100', '72in55wT12SMg202w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('818', '100', '72in55wT12ESMg244w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('819', '100', '72in56wT12SMg244w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('820', '100', '72in85wT12HOESMg388w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('821', '100', '96in60wT12El69w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('822', '100', '96in95wT12HOEl80w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('823', '100', '96in60wT12ESMg62w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('824', '100', '96in60wT12SMg64w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 64W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('825', '100', '96in60wT12SMg75w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 75W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('826', '100', '96in95wT12HOSMg112w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 112W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('827', '100', '96in185wT12VHOSMg205w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('828', '100', '96in60wT12El110w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('829', '100', '96in95wT12HOEl173w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('830', '100', '96in60wT12El179w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('831', '100', '96in60wT12El220w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('832', '100', '96in95wT12HOEl346w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('833', '100', '96in60wT12ESMg123w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('834', '100', '96in60wT12SMg128w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 128W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('835', '100', '96in95wT12HOESMg207w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('836', '100', '96in95wT12HOSMg227w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 227W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('837', '100', '96in185wT12VHOSMg380w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('838', '100', '96in60wT12SMg203w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 203W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('839', '100', '96in60wT12ESMg210w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('840', '100', '96in95wT12HOESSMg319w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 319W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('841', '100', '96in95wT12HOSMg380w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 380W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('842', '100', '96in185wT12VHOSMg585w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('843', '100', '96in60wT12ESMg246w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('844', '100', '96in60wT12SMg256w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 256W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('845', '100', '96in95wT12HOESMg414w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('846', '100', '96in95wT12HOSMg454w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 454W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('847', '100', '96in185wT12VHOSMg760w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('848', '100', '96in95wT12HOSMg721w', 'DEER2012', 'meas', 'fixture Wattage based on ES magnetic ballast replacements; with no adjustment, fixture Wattage = 721W', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('849', '100', '48in40wT10SMg51w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('850', '100', '18in15wT8SMg19w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('851', '100', '18in15wT8SMg36w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('852', '100', '24in17wT8T3ISREl14w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('853', '100', '24in17wT8T4ISREl14w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('854', '100', '24in17wT8T2ISREl15w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('855', '100', '24in17wT8T4ISNEl15w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('856', '100', '24in17wT8RSREl15w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('857', '100', '24in17wT8T3ISNEl16w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('858', '100', '24in17wT8RSNEl16w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('859', '100', '24in17wT8T2RSNEl16w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('860', '100', '24in17wT8T2ISNEl17w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('861', '100', '24in17wT8T3RSNEl17w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('862', '100', '24in17wT8T4RSNEl17w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('863', '100', '24in17wT8ISNEl20w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('864', '100', '24in17wT8SMg24w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('865', '100', '24in17wT8T4ISREl28w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('866', '100', '24in17wT8RSREl28w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('867', '100', '24in17wT8ISREl29w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('868', '100', '24in17wT8T4ISNEl31w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('869', '100', '24in17wT8RSNEl31w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('870', '100', '24in17wT8ISNEl33w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('871', '100', '24in17wT8T4RSNEl34w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('872', '100', '24in17wT8RSREl41w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('873', '100', '24in17wT8ISREl43w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('874', '100', '24in17wT8ISNEl47w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('875', '100', '24in17wT8ISHEl49w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('876', '100', '24in17wT8RSNEl52w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('877', '100', '24in17wT8ISREl55w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('878', '100', '24in17wT8RSREl57w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('879', '100', '24in17wT8ISNEl61w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('880', '100', '24in17wT8RSNEl68w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('881', '100', '36in25wT8T3ISNEl22w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('882', '100', '36in25wT8T3ISREl22w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('883', '100', '36in25wT8T4ISNEl22w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('884', '100', '36in25wT8T4ISREl22w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('885', '100', '36in25wT8T4RSNEl22w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('886', '100', '36in25wT8T2ISNEl23w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('887', '100', '36in25wT8T2ISREl23w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('888', '100', '36in25wT8T2RSNEl23w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('889', '100', '36in25wT8RSREl23w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('890', '100', '36in25wT8T2ISHEl24w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('891', '100', '36in25wT8RSNEl24w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('892', '100', '36in25wT8T3RSNEl24w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('893', '100', '36in25wT8ISNEl26w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('894', '100', '36in25wT8RSHEl26w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('895', '100', '36in25wT8ISREl27w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('896', '100', '36in25wT8ISHEl28w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('897', '100', '36in25wT8RSREl42w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('898', '100', '36in25wT8T4ISREl43w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('899', '100', '36in25wT8T4ISNEl44w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('900', '100', '36in25wT8T4RSNEl45w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('901', '100', '36in25wT8ISNEl46w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('902', '100', '36in25wT8ISREl46w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('903', '100', '36in25wT8RSNEl46w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('904', '100', '36in25wT8ISHEl48w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('905', '100', '36in25wT8RSHEl50w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('906', '100', '36in25wT8RSVEl70w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('907', '100', '36in25wT8RSREl62w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('908', '100', '36in25wT8ISREl66w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('909', '100', '36in25wT8ISNEl67w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('910', '100', '36in25wT8RSNEl72w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('911', '100', '36in25wT8RSREl84w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('912', '100', '36in25wT8ISREl86w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('913', '100', '36in25wT8ISNEl87w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('914', '100', '36in25wT8RSNEl89w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('915', '100', '36in25wT8ISREl134w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('916', '100', '48in1g32wT8T3RSREl25w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('917', '100', '48in1g32wT8T2ISREl26w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('918', '100', '48in1g32wT8T3ISREl26w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('919', '100', '48in1g32wT8T4ISREl26w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('920', '100', '48in1g32wT8T4RSREl26w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('921', '100', '48in1g32wT8T2RSREl27w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('922', '100', '48in1g32wT8RSREl27w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('923', '100', '48in1g32wT8T4ISNEl28w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('924', '100', '48in1g32wT8T2ISNEl30w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('925', '100', '48in1g32wT8T3ISNEl30w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('926', '100', '48in1g32wT8T2RSNEl30w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('927', '100', '48in1g32wT8T4RSNEl30w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('928', '100', '48in1g32wT8ISNEl31w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('929', '100', '48in1g32wT8T3ISHEl31w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('930', '100', '48in1g32wT8T3RSNEl31w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('931', '100', '48in1g32wT8RSNEl32w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('932', '100', '48in1g32wT8T2ISHEl33w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('933', '100', '48in1g32wT8T3RSHEl33w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('934', '100', '48in1g32wT8T2RSHEl35w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('935', '100', '48in1g32wT8ESMg35w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('936', '100', '48in1g32wT8ISHEl36w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('937', '100', '48in1g32wT8T3ISVEl38w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('938', '100', '48in1g32wT8T4ISVEl38w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('939', '100', '48in1g32wT8RSHEl39w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('940', '100', '48in1g32wT8T2ISVEl40w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('941', '100', '48in1g32wT8ISVEl41w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('942', '100', '48in1g32wT8T4ISREl51w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('943', '100', '48in1g32wT8ISREl52w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('944', '100', '48in1g32wT8T4RSREl53w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('945', '100', '48in1g32wT8RSREl54w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('946', '100', '48in1g32wT8T4ISNEl56w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('947', '100', '48in1g32wT8ISNEl59w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('948', '100', '48in1g32wT8T4RSNEl59w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('949', '100', '48in1g32wT8RSNEl60w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('950', '100', '48in1g32wT8ISHEl65w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('951', '100', '48in1g32wT8RSHEl70w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('952', '100', '48in1g32wT8ESMg71w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('953', '100', '48in1g32wT8ISVEl79w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('954', '100', '48in1g32wT8RSVEl85w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('955', '100', '48in1g32wT8RSREl76w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('956', '100', '48in1g32wT8ISREl78w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('957', '100', '48in1g32wT8ISNEl89w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('958', '100', '48in1g32wT82ISNEl90w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('959', '100', '48in1g32wT82RSNEl92w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('960', '100', '48in1g32wT8ISHEl93w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('961', '100', '48in1g32wT8RSNEl93w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('962', '100', '48in1g32wT8RSHEl98w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('963', '100', '48in1g32wT8ESMg110w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('964', '100', '48in1g32wT8ISVEl112w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('965', '100', '48in1g32wT8ISREl102w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('966', '100', '48in1g32wT8RSREl105w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('967', '100', '48in1g32wT8ISNEl112w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('968', '100', '48in1g32wT82ISNEl118w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('969', '100', '48in1g32wT8RSNEl118w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('970', '100', '48in1g32wT82RSNEl120w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('971', '100', '48in1g32wT8ESMg142w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('972', '100', '48in1g32wT8ISVEl151w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('973', '100', '48in1g32wT82ISVEl152w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('974', '100', '48in1g32wT82ISNEl148w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('975', '100', '48in1g32wT82ISVEl189w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('976', '100', '48in1g32wT8ISREl156w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('977', '100', '48in1g32wT8ISNEl175w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('978', '100', '48in1g32wT8RSNEl182w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('979', '100', '48in1g32wT82ISVEl226w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('980', '100', '48in1g32wT8ISREl204w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('981', '100', '48in1g32wT8ISNEl224w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('982', '100', '48in2g32wT8T3RSREl25w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('983', '100', '48in2g32wT8T2ISREl26w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('984', '100', '48in2g32wT8T3ISREl26w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('985', '100', '48in2g32wT8T4ISREl26w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('986', '100', '48in2g32wT8T4RSREl26w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('987', '100', '48in2g32wT8T2RSREl27w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('988', '100', '48in2g32wT8RSREl27w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('989', '100', '48in2g32wT8T4ISNEl28w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('990', '100', '48in2g32wT8T2ISNEl30w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('991', '100', '48in2g32wT8T3ISNEl30w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('992', '100', '48in2g32wT8T2RSNEl30w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('993', '100', '48in2g32wT8T4RSNEl30w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('994', '100', '48in2g32wT8ISNEl31w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('995', '100', '48in2g32wT8T3ISHEl31w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('996', '100', '48in2g32wT8T3RSNEl31w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('997', '100', '48in2g32wT8RSNEl32w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('998', '100', '48in2g32wT8T2ISHEl33w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('999', '100', '48in2g32wT8T3RSHEl33w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1000', '100', '48in2g32wT8T2RSHEl35w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1001', '100', '48in2g32wT8ISHEl36w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1002', '100', '48in2g32wT8T3ISVEl38w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1003', '100', '48in2g32wT8T4ISVEl38w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1004', '100', '48in2g32wT8RSHEl39w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1005', '100', '48in2g32wT8T2ISVEl40w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1006', '100', '48in2g32wT8ISVEl41w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1007', '100', '48in2g32wT8T4ISREl51w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1008', '100', '48in2g32wT8ISREl52w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1009', '100', '48in2g32wT8T4RSREl53w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1010', '100', '48in2g32wT8RSREl54w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1011', '100', '48in2g32wT8T4ISTNEl56w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1012', '100', '48in2g32wT8ISNEl59w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1013', '100', '48in2g32wT8T4RSNEl59w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1014', '100', '48in2g32wT8RSNEl60w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1015', '100', '48in2g32wT8ISHEl65w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1016', '100', '48in2g32wT8RSHEl70w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1017', '100', '48in2g32wT8ISVEl79w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1018', '100', '48in2g32wT8RSVEl85w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1019', '100', '48in2g32wT8RSREl76w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1020', '100', '48in2g32wT8ISREl78w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1021', '100', '48in2g32wT8ISNEl89w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1022', '100', '48in2g32wT82ISNEl90w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1023', '100', '48in2g32wT82RSNEl92w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1024', '100', '48in2g32wT8ISHEl93w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1025', '100', '48in2g32wT8RSNEl93w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1026', '100', '48in2g32wT8RSHEl98w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1027', '100', '48in2g32wT8ISVEl112w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1028', '100', '48in2g32wT8ISREl102w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1029', '100', '48in2g32wT8RSREl105w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1030', '100', '48in2g32wT8ISNEl112w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1031', '100', '48in2g32wT82ISNEl118w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1032', '100', '48in2g32wT8RSNEl118w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1033', '100', '48in2g32wT82RSNEl120w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1034', '100', '48in2g32wT8ISVEl151w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1035', '100', '48in2g32wT82ISEl152w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1036', '100', '48in2g32wT82ISEl148w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1037', '100', '48in2g32wT82ISEl189w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1038', '100', '48in2g32wT8ISREl156w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1039', '100', '48in2g32wT8ISNEl175w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1040', '100', '48in2g32wT8RSNEl182w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1041', '100', '48in2g32wT82ISEl226w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1042', '100', '48in2g32wT8ISREl204w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1043', '100', '48in2g32wT8ISNEl224w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1044', '100', '48in3g30wT8ESPISREl24w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1045', '100', '48in3g32wT8PISREl25w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1046', '100', '48in3g30wT8ESPISNEl27w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1047', '100', '48in3g32wT8PISNEl28w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1048', '100', '48in3g28wT8PRSREl42w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1049', '100', '48in3g25wT8PRSNEl44w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1050', '100', '48in3g30wT8ESPISREl45w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1051', '100', '48in3g32wT8PISREl48w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1052', '100', '48in3g28wT8PRSNEl50w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1053', '100', '48in3g30wT8ESPISNEl51w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1054', '100', '48in3g32wT8PISNEl54w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1055', '100', '48in3g28wT8PRSVEl64w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1056', '100', '48in3g28wT8PRSREl63w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1057', '100', '48in3g25wT8PRSNEl66w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1058', '100', '48in3g30wT8ESPISREl67w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1059', '100', '48in3g32wT8PISREl73w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1060', '100', '48in3g28wT8PRSNEl74w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1061', '100', '48in3g30wT8ESPISNEl77w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1062', '100', '48in3g32wT8PISNEl83w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1063', '100', '48in3g28wT8PRSVEl97w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1064', '100', '48in3g25wT8PRSREl79w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1065', '100', '48in3g28wT8PRSREl84w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1066', '100', '48in3g25wT8PRSNEl90w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1067', '100', '48in3g30wT8ESPISREl90w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1068', '100', '48in3g32wT8PISREl94w', 'DEER2012', 'meas', '', 'Standard');
INSERT INTO "tech"."Technology" VALUES ('1069', '100', '48in3g28wT8PRSNEl99w', 'DEER2012', 'meas', 