/*
Navicat PGSQL Data Transfer

Source Server         : Local PostgresQL
Source Server Version : 90004
Source Host           : localhost:5432
Source Database       : deer_spt
Source Schema         : applic

Target Server Type    : PGSQL
Target Server Version : 90004
File Encoding         : 65001

Date: 2011-11-29 19:36:05
*/


-- ----------------------------
-- Sequence structure for "applic"."seq_SubSector"
-- ----------------------------
DROP SEQUENCE "applic"."seq_SubSector";
CREATE SEQUENCE "applic"."seq_SubSector"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9999
 START 47
 CACHE 1;

-- ----------------------------
-- Sequence structure for "applic"."seq2"
-- ----------------------------
DROP SEQUENCE "applic"."seq2";
CREATE SEQUENCE "applic"."seq2"
 INCREMENT 1
 MINVALUE 1
 MAXVALUE 9999
 START 166
 CACHE 1;

-- ----------------------------
-- Table structure for "applic"."BldgHVAC"
-- ----------------------------
DROP TABLE "applic"."BldgHVAC";
CREATE TABLE "applic"."BldgHVAC" (
"Code" varchar(6) NOT NULL,
"Sector" varchar(255),
"Description" varchar(255),
"Comment" varchar(255),
"Index" int2,
"Status" varchar(64)
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "applic"."BldgHVAC" IS 'Building HVAC type definitions';

-- ----------------------------
-- Records of BldgHVAC
-- ----------------------------
INSERT INTO "applic"."BldgHVAC" VALUES ('aGF', 'Ag', 'overhead gas furnace', 'used in green house measures', '40', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('All', 'CC', 'All applicable HVAC types', null, '98', 'Process');
INSERT INTO "applic"."BldgHVAC" VALUES ('Any', 'CC', 'Any HVAC type', 'Used for IE processing', '97', 'Process');
INSERT INTO "applic"."BldgHVAC" VALUES ('aRH', 'Ag', 'radiant heat', 'used in green house measures', '41', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cAll', 'Com', 'All applicable Commercial HVAC types', null, '20', 'Process');
INSERT INTO "applic"."BldgHVAC" VALUES ('cDDCT', 'Com', 'dual duct system', '', '36', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cDXEH', 'Com', 'split or packaged direct expansion unit with electric heat', '', '22', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cDXGF', 'Com', 'split or packaged direct expansion unit with gas furnace', '', '21', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cDXHP', 'Com', 'split or packaged direct expansion unit with heat pump', '', '23', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cEVAP', 'Com', 'evaporative cooling with separate gas furnace', '', '37', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cFPFC', 'Com', 'four pipe fan coil', '', '35', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cNCEH', 'Com', 'no cooling with electric heat', '', '25', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cNCGF', 'Com', 'no cooling with gas furnace', '', '26', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cPTAC', 'Com', 'packaged terminal air conditioner', '', '33', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cPTHP', 'Com', 'packaged terminal heat pump', '', '34', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cPVVE', 'Com', 'packaged variable air volume system with electric heat', '', '28', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cPVVG', 'Com', 'packaged variable air volume system with gas furnace', '', '27', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cSVVE', 'Com', 'built-up variable air volume system with electric reheat', '', '31', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cSVVG', 'Com', 'built-up variable air volume system with gas boiler', '', '29', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cUnc', 'Com', 'no HVAC (unconditioned)', '', '32', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cWLHP', 'Com', 'water loop heat pump', '', '24', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('cWtd', 'Com', 'standard weights applied to commercial HVAC types', null, '39', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('rAll', 'Res', 'All applicable Residential HVAC types', null, '6', 'Process');
INSERT INTO "applic"."BldgHVAC" VALUES ('rDXGF', 'Res', 'central AC with gas furnace', '', '1', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('rDXHP', 'Res', 'central heat pump with electric resistance backup', '', '4', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('rEVAP', 'Res', 'evaporative cooling with separate gas furnace', '', '5', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('rNCEH', 'Res', 'no cooling, electric baseboard heating', '', '3', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('rNCGF', 'Res', 'no cooling, gas furnace', '', '2', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('rWtd', 'Res', 'standard weights applied to residential HVAC types', null, '7', 'Standard');
INSERT INTO "applic"."BldgHVAC" VALUES ('Wtd', 'CC', 'typical, or weighted, HVAC type for the building type', '', '99', 'Standard');

-- ----------------------------
-- Table structure for "applic"."BldgVint"
-- ----------------------------
DROP TABLE "applic"."BldgVint";
CREATE TABLE "applic"."BldgVint" (
"Code" varchar(16) NOT NULL,
"Description" varchar(255) NOT NULL,
"Comment" varchar(255),
"Index" int2,
"Status" varchar(64)
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "applic"."BldgVint" IS 'Building vintage definitions';

-- ----------------------------
-- Records of BldgVint
-- ----------------------------
INSERT INTO "applic"."BldgVint" VALUES ('05', 'After 2005', 'used for DEER2005 impact only', '17', 'Legacy');
INSERT INTO "applic"."BldgVint" VALUES ('1975', 'Before 1978', 'existing building stock built before 1978', '1', 'Standard');
INSERT INTO "applic"."BldgVint" VALUES ('1985', '1978 - 1992', 'existing building stock built between 1978 and 1992', '2', 'Standard');
INSERT INTO "applic"."BldgVint" VALUES ('1996', '1993 - 2001', 'existing building stock built between 1993 and 2001', '3', 'Standard');
INSERT INTO "applic"."BldgVint" VALUES ('2003', '2002 - 2005', 'existing building stock built between 2002 and 2005', '4', 'Standard');
INSERT INTO "applic"."BldgVint" VALUES ('2007', '2006 - 2009', 'existing building stock built between 2006 and 2009', '5', 'Standard');
INSERT INTO "applic"."BldgVint" VALUES ('2011', '2010 - 2012', 'existing building stock built after 2009', '6', 'Standard');
INSERT INTO "applic"."BldgVint" VALUES ('Any', 'Any Vintage', 'for Interactive Effects processing', '0', 'Process');
INSERT INTO "applic"."BldgVint" VALUES ('Ex', 'Existing', 'weighted by vintage', '12', 'Standard');
INSERT INTO "applic"."BldgVint" VALUES ('MH00', 'MH: 1995 - 2005', 'mobile homes built between 1995 and 2005', '9', 'Standard');
INSERT INTO "applic"."BldgVint" VALUES ('MH06', 'MH: After 2005', 'mobile homes built after 2005', '10', 'Standard');
INSERT INTO "applic"."BldgVint" VALUES ('MH72', 'MH: Before 1976', 'mobile homes built before 1976', '7', 'Standard');
INSERT INTO "applic"."BldgVint" VALUES ('MH85', 'MH: 1976 - 1994', 'mobile homes built between 1976 and 1994', '8', 'Standard');
INSERT INTO "applic"."BldgVint" VALUES ('New', 'New', 'new construction', '11', 'Standard');
INSERT INTO "applic"."BldgVint" VALUES ('PGx', 'PGE Existing', 'weighted by era and by PGE building stock, use "Ex" with IOU=PGE and Location=IOU', '13', 'Legacy');
INSERT INTO "applic"."BldgVint" VALUES ('SCx', 'SCE Existing', 'weighted by era and by SCE building stock, use "Ex" with IOU=SCE and Location=IOU', '14', 'Legacy');
INSERT INTO "applic"."BldgVint" VALUES ('SDx', 'SDGE Existing', 'weighted by era and by SDGE building stock, use "Ex" with IOU=SDG and Location=IOU', '15', 'Legacy');
INSERT INTO "applic"."BldgVint" VALUES ('SGx', 'SCG Existing', 'weighted by era and by SCG building stock, use "Ex" with IOU=SCG and Location=IOU', '16', 'Legacy');

-- ----------------------------
-- Table structure for "applic"."IntMeasWtgDef"
-- ----------------------------
DROP TABLE "applic"."IntMeasWtgDef";
CREATE TABLE "applic"."IntMeasWtgDef" (
"WtID" int4,
"WtType" varchar(255),
"ApplicType" varchar(255),
"Label" varchar(255),
"Bldg" varchar(255),
"Vint" varchar(255),
"Loc" varchar(255),
"HVAC" varchar(255)
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "applic"."IntMeasWtgDef" IS 'Inter-Measure Weighting Definitions';

-- ----------------------------
-- Records of IntMeasWtgDef
-- ----------------------------

-- ----------------------------
-- Table structure for "applic"."IntMeasWts"
-- ----------------------------
DROP TABLE "applic"."IntMeasWts";
CREATE TABLE "applic"."IntMeasWts" (
"WtID" int4,
"Mult" varchar(255),
"Wt" float4
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "applic"."IntMeasWts" IS 'Inter-Measure Standard Weights';

-- ----------------------------
-- Records of IntMeasWts
-- ----------------------------

-- ----------------------------
-- Table structure for "applic"."Location"
-- ----------------------------
DROP TABLE "applic"."Location";
CREATE TABLE "applic"."Location" (
"Code" varchar(4) NOT NULL,
"Description" varchar(255),
"Comment" varchar(255),
"Index" int2,
"Status" varchar(32)
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "applic"."Location" IS 'T-24 Climate Zones and IOU Territories';

-- ----------------------------
-- Records of Location
-- ----------------------------
INSERT INTO "applic"."Location" VALUES ('Any', 'Any Location', 'for Interactive Effect processing', '18', 'Process');
INSERT INTO "applic"."Location" VALUES ('CA', 'California-Wide', 'All of California', '19', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ01', 'Arcata Area', 'Standard Title-24 climate zone', '1', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ02', 'Santa Rosa Area', 'Standard Title-24 climate zone', '2', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ03', 'Oakland Area', 'Standard Title-24 climate zone', '3', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ04', 'Sunnyvale Area', 'Standard Title-24 climate zone', '4', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ05', 'Santa Maria Area', 'Standard Title-24 climate zone', '5', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ06', 'Los Angeles Area', 'Standard Title-24 climate zone', '6', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ07', 'San Diego Area', 'Standard Title-24 climate zone', '7', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ08', 'El Toro Area', 'Standard Title-24 climate zone', '8', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ09', 'Pasadena Area', 'Standard Title-24 climate zone', '9', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ10', 'San Bernardino Area', 'Standard Title-24 climate zone', '10', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ11', 'Red Bluff Area', 'Standard Title-24 climate zone', '11', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ12', 'Sacramento Area', 'Standard Title-24 climate zone', '12', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ13', 'Fresno Area', 'Standard Title-24 climate zone', '13', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ14', 'China Lake Area', 'Standard Title-24 climate zone', '14', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ15', 'Blythe Area', 'Standard Title-24 climate zone', '15', 'Standard');
INSERT INTO "applic"."Location" VALUES ('CZ16', 'Mount Shasta Area', 'Standard Title-24 climate zone', '16', 'Standard');
INSERT INTO "applic"."Location" VALUES ('IOU', 'IOU Territory', 'All territory of the associated IOU', '17', 'Standard');
INSERT INTO "applic"."Location" VALUES ('PGE', 'All of PG&E Territory', 'All of PG&E territory; instead use IOU=PGE, Location=IOU', '20', 'Legacy');
INSERT INTO "applic"."Location" VALUES ('SCE', 'All of SCE Territory', 'All of SCE territory; instead use IOU=SCE, Location=IOU', '21', 'Legacy');
INSERT INTO "applic"."Location" VALUES ('SCG', 'All of SCG Territory', 'All of SCG territory; instead use IOU=SCG, Location=IOU', '23', 'Legacy');
INSERT INTO "applic"."Location" VALUES ('SDG', 'All of SDG&E Territory', 'All of SDG&E territory; instead use IOU=SDG, Location=IOU', '22', 'Legacy');

-- ----------------------------
-- Table structure for "applic"."Sector"
-- ----------------------------
DROP TABLE "applic"."Sector";
CREATE TABLE "applic"."Sector" (
"Index" int2 NOT NULL,
"Name" varchar(255) NOT NULL,
"Code" varchar(16) NOT NULL,
"Description" varchar(255)
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "applic"."Sector" IS 'aka Target Market Sectors (Ind, Res, Com, etc.)';

-- ----------------------------
-- Records of Sector
-- ----------------------------
INSERT INTO "applic"."Sector" VALUES ('4', 'Agricultural', 'Ag', 'Agricultural Facilities and Farms');
INSERT INTO "applic"."Sector" VALUES ('6', 'All', 'All', 'All Sectors served by the Utility');
INSERT INTO "applic"."Sector" VALUES ('5', 'Cross-Cutting', 'CC', 'Includes more than one sector');
INSERT INTO "applic"."Sector" VALUES ('1', 'Commercial', 'Com', 'Commercial');
INSERT INTO "applic"."Sector" VALUES ('3', 'Industrial', 'Ind', 'Industrial Facilities');
INSERT INTO "applic"."Sector" VALUES ('2', 'Residential', 'Res', 'Single Family, Apartment and Mobile Homes');

-- ----------------------------
-- Table structure for "applic"."SubSector"
-- ----------------------------
DROP TABLE "applic"."SubSector";
CREATE TABLE "applic"."SubSector" (
"Index" int4 DEFAULT nextval('"applic".seq2'::regclass) NOT NULL,
"Name" varchar(255) NOT NULL,
"Code" varchar(16) NOT NULL,
"SectorCode" varchar(16) NOT NULL,
"Comment" varchar(255),
"DEERbldg" bool,
"State" varchar(16)
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "applic"."SubSector" IS 'aka Building and Facility Types ';

-- ----------------------------
-- Records of SubSector
-- ----------------------------
INSERT INTO "applic"."SubSector" VALUES ('139', 'Livestock Farms', 'ALF', 'Ag', null, 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('138', 'All Subsectors', 'Any', 'CC', 'Any Building Type or Sub-sector', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('93', 'Agricultural Produce Farms', 'APF', 'Ag', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('96', 'Assembly', 'Asm', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('104', 'Health/Medical - Clinics', 'Cnc', 'Com', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('97', 'Data Center', 'Dat', 'Com', '', 'f', 'Proposed');
INSERT INTO "applic"."SubSector" VALUES ('135', 'Residential Mobile Home', 'DMo', 'Res', 'Double-Wide Mobile Home', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('98', 'Education - Community College', 'ECC', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('99', 'Education - Primary School', 'EPr', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('100', 'Education - Relocatable Classroom', 'ERC', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('101', 'Education - Secondary School', 'ESe', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('102', 'Education - University', 'EUn', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('94', 'Greenhouse', 'GHs', 'Ag', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('103', 'Grocery', 'Gro', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('105', 'Health/Medical - Hospital', 'Hsp', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('107', 'Lodging - Hotel', 'Htl', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('120', 'Transportation Equipment', 'IAT', 'Ind', 'Automobile, Trucks and other transportation Equipment', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('121', 'Manufacturing Beverage', 'IBM', 'Ind', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('124', 'Chemical Processing', 'ICP', 'Ind', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('123', 'Manufacturing Cement/Stone', 'ICS', 'Ind', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('125', 'Food Processing', 'IFP', 'Ind', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('127', 'Manufacturing Glass', 'IGM', 'Ind', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('126', 'Gas Production', 'IGP', 'Ind', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('131', 'Petroleum', 'IPe', 'Ind', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('132', 'Manufacturing Pharmaceutical', 'IPH', 'Ind', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('133', 'Manufacturing Plastics', 'IPM', 'Ind', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('122', 'Manufacturing Biotech', 'MBT', 'Ind', 'Manufacturing Biotech and Pharmaceuticals', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('128', 'Manufacturing Electronics', 'MCE', 'Ind', 'Manufacturing - Computing, Networking and Electronics', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('136', 'Residential Multi-family', 'MFm', 'Res', 'Residence in multi-family building', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('129', 'Manufacturing Light Industrial', 'MLI', 'Ind', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('130', 'Metal Production and Fabrication', 'MPF', 'Ind', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('108', 'Lodging - Motel', 'Mtl', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('106', 'Health/Medical - Nursing Home', 'Nrs', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('109', 'Office - Large', 'OfL', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('110', 'Office - Small', 'OfS', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('140', 'Residential', 'Res', 'Res', 'Weighted across all applicable residential buildig types', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('111', 'Restaurant - Fast-Food', 'RFF', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('112', 'Restaurant - Sit-Down', 'RSD', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('113', 'Retail - Multistory Large', 'Rt3', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('114', 'Retail - Single-Story Large', 'RtL', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('115', 'Retail - Small', 'RtS', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('116', 'Storage - Conditioned', 'SCn', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('137', 'Residential Single Family', 'SFm', 'Res', 'Single Family Detached', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('117', 'Storage - Unconditioned', 'SUn', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('118', 'Supermarket', 'Sup', 'Com', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('95', 'Vinyards and Processing', 'VPr', 'Ag', '', 'f', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('119', 'Warehouse - Refrigerated', 'WRf', 'Com', '', 't', 'Standard');
INSERT INTO "applic"."SubSector" VALUES ('134', 'Water Waste Treatment', 'WWT', 'Ind', '', 'f', 'Standard');

-- ----------------------------
-- View structure for "applic"."IntMeasWtg"
-- ----------------------------
CREATE OR REPLACE VIEW "applic"."IntMeasWtg" AS 
SELECT "IntMeasWtdDef"."WtID", "IntMeasWtdDef"."ApplicType", "IntMeasWtdDef"."Label", CASE WHEN (("IntMeasWtdDef"."ApplicType")::text = 'Bldg'::text) THEN "IntMeasWts"."Mult" ELSE "IntMeasWtdDef"."Bldg" END AS "AppBldg", CASE WHEN (("IntMeasWtdDef"."ApplicType")::text = 'Vint'::text) THEN "IntMeasWts"."Mult" ELSE "IntMeasWtdDef"."Vint" END AS "AppVint", CASE WHEN (("IntMeasWtdDef"."ApplicType")::text = 'Loc'::text) THEN "IntMeasWts"."Mult" ELSE "IntMeasWtdDef"."Loc" END AS "AppLoc", CASE WHEN (("IntMeasWtdDef"."ApplicType")::text = 'HVAC'::text) THEN "IntMeasWts"."Mult" ELSE "IntMeasWtdDef"."HVAC" END AS "AppHVAC", "IntMeasWts"."Wt" AS "Weight" FROM applic."IntMeasWtgDef" "IntMeasWtdDef", applic."IntMeasWts" WHERE ("IntMeasWts"."WtID" = "IntMeasWtdDef"."WtID") ORDER BY "IntMeasWtdDef"."WtID" LIMIT 1000;
COMMENT ON VIEW "applic"."IntMeasWtg" IS 'Combines the Inter-Measure Weighting Definition and the Inter-Measure Weights';

-- ----------------------------
-- Alter Sequences Owned By 
-- ----------------------------

-- ----------------------------
-- Indexes structure for table BldgHVAC
-- ----------------------------
CREATE UNIQUE INDEX "BldgHVAC_index" ON "applic"."BldgHVAC" USING btree ("Index");

-- ----------------------------
-- Primary Key structure for table "applic"."BldgHVAC"
-- ----------------------------
ALTER TABLE "applic"."BldgHVAC" ADD PRIMARY KEY ("Code");

-- ----------------------------
-- Indexes structure for table BldgVint
-- ----------------------------
CREATE UNIQUE INDEX "BldgVint_index" ON "applic"."BldgVint" USING btree ("Index");

-- ----------------------------
-- Primary Key structure for table "applic"."BldgVint"
-- ----------------------------
ALTER TABLE "applic"."BldgVint" ADD PRIMARY KEY ("Code");

-- ----------------------------
-- Indexes structure for table Location
-- ----------------------------
CREATE UNIQUE INDEX "BldgLoc_index" ON "applic"."Location" USING btree ("Index");

-- ----------------------------
-- Primary Key structure for table "applic"."Location"
-- ----------------------------
ALTER TABLE "applic"."Location" ADD PRIMARY KEY ("Code");

-- ----------------------------
-- Indexes structure for table Sector
-- ----------------------------
CREATE UNIQUE INDEX "Sector_index" ON "applic"."Sector" USING btree ("Index");

-- ----------------------------
-- Primary Key structure for table "applic"."Sector"
-- ----------------------------
ALTER TABLE "applic"."Sector" ADD PRIMARY KEY ("Code");

-- ----------------------------
-- Indexes structure for table SubSector
-- ----------------------------
CREATE UNIQUE INDEX "SubSector_index" ON "applic"."SubSector" USING btree ("Index");

-- ----------------------------
-- Primary Key structure for table "applic"."SubSector"
-- ----------------------------
ALTER TABLE "applic"."SubSector" ADD PRIMARY KEY ("Code");

-- ----------------------------
-- Foreign Key structure for table "applic"."SubSector"
-- ----------------------------
ALTER TABLE "applic"."SubSector" ADD FOREIGN KEY ("SectorCode") REFERENCES "applic"."Sector" ("Code") ON DELETE CASCADE ON UPDATE CASCADE;
