/*
Navicat PGSQL Data Transfer

Source Server         : Local PostgresQL
Source Server Version : 90004
Source Host           : localhost:5432
Source Database       : deer_spt
Source Schema         : spt

Target Server Type    : PGSQL
Target Server Version : 90004
File Encoding         : 65001

Date: 2011-11-29 19:37:11
*/


-- ----------------------------
-- Table structure for "spt"."InterfaceContent"
-- ----------------------------
DROP TABLE "spt"."InterfaceContent";
CREATE TABLE "spt"."InterfaceContent" (
"Name" varchar(127) NOT NULL,
"HTMLtext" varchar,
"version" varchar(32)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of InterfaceContent
-- ----------------------------
INSERT INTO "spt"."InterfaceContent" VALUES ('About', '<html><body>
<p>
This program was developed for the Energy Division of the California Pubilc Utilities Commission, under a contract with Itron, Inc. by JJH & Associates.
Program written by Paul Reeves using Delphi XE.
</p><p>
</p><p>
Question, comments or suggestions can be sent to: READIhelp@gmail.com
</p></body></html>', null);
INSERT INTO "spt"."InterfaceContent" VALUES ('Browse', '<html><body><p>
Browsing the database tables is often as simple as clicking on the appropriate tab near the top of the screen. 
Tables are automatically loaded at the time you click on the tab.  Loading tables typically takes only a few seconds.
</p><p>
All of the tables that are used to present the data share some common features:
</p><ul>
<li><div>Columns with a green background contain the "codes" that are referenced by other tables or IOU tracking data.</div></li>
<li><div>Columns can be resized by dragging the border of the title row to the left or right.</div></li>
<li><div>The width of a table will often expand as the main program screen is made larger.</div></li>
<li><div>If a column of interest can only be seen by scrolling the table to the right, you can grab the column title and move the column to the left. This will keep the column in view at all times.</div></li>
</ul><p>
<strong>Tree Views</strong>
</p><p>
The tables presented under the "Classification" heading are also displayed as "trees" that visually link the parent-child relationship of the data.  These trees are available in the following tabs:
</p><ul>
<li><div>Sector & Sub-sector</div></li>
<li><div>Use Category & Sub-category</div></li>
<li><div>Technology Group & Type</div></li>
</ul><p>
On these screens, you can make the tree section larger by dragging the left wall of the tree section further to the left. 
Use the tree''s right-click menu (aka "pop-up" menu) for more options, such as fully expanding or collapsing the tree. Clicking on any branch in the tree will cause the two 
tables to the left of the tree to highlight the rows of data that define that tree branch.
</p><p>
<strong>Support Tables</strong>
</p><p>
The Support Tables screen allows for a quick perusal of the many relatively simple tables in the SPT database. The tables are organized into groups on the left side of the screen. 
Click on one of the group headings to bring up the list of tables and press one of the table buttons to load the data. Information about each table includes: 
</p><ul>
<li><div><code>Table Name:    </code>the name of the table in the central database.</div></li>
<li><div><code>db Schema:     </code>the location of the table in the database. The "schema" is much like a directory and is used to store groups of related tables within the database.</div></li>
<li><div><code>Table Usage:   </code>a brief description of how the data is used.</div></li>
<li><div><code>SQL statement: </code>dislays the Standard Query Language code used to retrieve the data. For database developers, this can provide some insight into the table structure.</div></li>
</ul><p>
The data table itself is similar to the other tables: key fields are highlighted in green, the column widths are expandable and columns are able to be rearranged.
Tables can be filtered by specifying text in the edit box below the table.  The specified text will be searched for in the second and third columns of the table.  Two search criteria can be specified
with "and"; for example: "CFL and Outdoor" will return records that have both "CFL" and "Outdoor" in columns two or three.
<br></p>
</body></html>', null);
INSERT INTO "spt"."InterfaceContent" VALUES ('Download', '<html><body>

<p><strong>Save data Tables to your computer</strong> </p>

<p>All of the data associated with the tables in READI can be
downloaded to your computer by using the pop-up menu associated with tables. Right-click
the mouse over any table to bring up the table menu and select "Download
Table as CSV";. You will be prompted for a file name and location; the
default file name can be altered if needed. </p>

<p>The CSV file saved to your computer will contain all of the fields
associated with the database table, not just the fields displayed on-screen. If
the rows of the on-screen table are filtered, CSV file will also be filtered. </p>

<p><strong>Downloading Energy Impact data</strong> </p>

<p>As with the other tables, you can download the results associated with the
Energy Impact table by right-clicking and selecting the download option. This
process will download results for the current measure to a "CSV" formatted
text file on your computer. The program can also cycle through a list of
measures and download all of the associated energy impacts to a single
file. To download the energy impacts for an entire group of measures follow
these steps: </p>
<p>
<blockquote>
<ol>
<li>On the Measures tab, filter the measure list to a single technology group.</li>
<span style=''font-size:12.0pt''>
<ul>
<li>Go to the Measures tab; if necessary, reset the measure list so it includes the full list of measures (by pressing the reset arrows icon).</li>
<li>Use the measure tree to filter the measure list; be sure to double-click on the technology branch to apply the filter to the measure list. </li>
<li>Alternatively, you can left-click the mouse on the column title "Tech Group" or "Tech Type" in the Measure List and select a single entry.</li>
</ul></span>
<br>
<li>The measure list will now be filtered and will include a single value in the "Tech group" column. Whenever a single technology group is selected, 
the "Download Group Impacts" button is enabled.  If you want to download the energy impacts with the current list of measures, press 
the "Download Group Impacts" button.</li>
<br><br>
<li>The program will take you to the Energy Impacts tab and will reveal a number of options on the left side of the screen:</li>
<span style=''font-size:12.0pt''>
<ul>
<li><code>Include Extended Measure Info:</code> when this option is selected additional measure information fields are included with each energy impact record. </li>
<li><code>Append CSV file</code>: this option allows you to append the current energy impact records to an existing CSV file without multiple header lines.</li>
<li><code>IOU for Group Impacts</code>: The energy impact records are always filtered to a single IOU when downloading impacts for multiple measures. Choose
the IOU of interest from the pull-down list; keep in mind that the "All" selection filters the energy impacts records by "IOU" = "All" (it does not force the inclusion of all records).</li>
</ul></span>
<br>
<li>Finally, press the group download button and specify the file name.  The program will cycle through all measures in the list, load the energy impacts and write them to the specified file.</li>
</ol>
</blockquote></body></html>

', null);
INSERT INTO "spt"."InterfaceContent" VALUES ('EnergyImp', '<html><body>
<p>
To view the energy impacts associated with a measure, select the measure in the measure list and double-click on the row 
<i>(Or press the "View Energy Impacts" button at the top of the screen.)</i> 
</p><p>
The Energy Impacts screen initially contains two sections: details of one energy impact record at the top and a table with a list of all the applicability combinations at the bottom of the screen.
Similar to the Measure screen, you choose a particular energy impact by selecting a row from the Energy Impacts List.  Note: you can use the <b>Up</b> and <b>down</b> buttons located near the top-right of the screen to see more or less information about the selected energy impact.
</p><p><br>
<strong>Using the Energy Impacts Graph</strong>
</p><p>
Pressing the <b>Display Graph</b> button (top-right of screen) toggles the Energy Impacts graph on and off. If the graph window is already open, you can update the graph data by pressing the 
"Quick Update" or "Re-load Data" button at the top of the chart window.  The quick update option assumes the same applicability of building types, climate zones and other options.  The reload option clears all of the data
and examines the results set for the applicable building types, locations, vintages and HVAC types.  The advantage of the quick update (other than being faster) is that is does not reset any 
options and allows for an easier comparison with the previous results.  If the graph is not displaying data, or the data appears to be incomplete, press the "Re-load Data" button.
</p><p>
The Energy Impacts graph has a number of options and features that allow you to quickly review and compare the energy impacts for the selected measure.
</p><p><i> Graph Options:</i></p>
<ul>
<li><div><strong>X-axis</strong>: sets the x-axis of the graph to either all applicable locations or all applicable building types. If "Location" is chosen, the left and right arrows
or pull-down list can be used to choose the Building type.  Similarly, if "Bldg Type" is chosen, the arrows and pull-down list are used to choose the location.</div></li>
<li><div><strong>UES Values</strong>: the main graph series will be set to the selected energy type with the units described on the graph''s left axis.</div></li>
<li><div><strong>Baseline</strong>: sets the main graph series to savings based on comparison with "Pre-Existing" technology or the "Code/Standard Replacement" technology.</div></li>
<li><div><strong>Savings Type</strong>: sets the main graph series to whole-building or end-use impacts.  Note that not all measures have end-use impacts.</div></li>
<li><div><strong>Y-axis options</strong>: when "Fix the Y-axis" is checked, the graph will use the highest and lowest chart values encounted since the chart was "reloaded".  This allows 
the relative savings between building types, climate zones or even measures to be compared.  If "Y-axis Zero" is checked as well, the graph will include the zero impact value on the Y-axis scale.</div></li>
</ul><p>
</p><p><i> Chart Series:</i></p>
<ul>
<li><div><strong>IOU</strong>: Select the series to be plotted on the graph.  Keep in mind that the "All" series option will display the results for energy impacts where IOU = "All" or "Any"; 
this option does not force the display of all series.</div></li>
<li><div><strong>Building Vintage</strong>: Turn on or off the Existing and New building vintage results.  If more than one existing vintage is included in the table of energy imapcts
the specific existing vintage can be selected from the pull-down list below this control.</div></li>
<li><div><strong>HVAC Type</strong>: If more than one HVAC type is included in the table of energy imapcts the specific HVAC type can be selected from this pull-down list.</div></li>
</ul><p><br><strong>Downloading Energy Impacts to your computer</strong>
</p><p>
As with the other tables, you can download the results associated with the Energy Impact table by right-clicking and selecting the download option.  This process will download results
for a single measure.  For more options on downloading energy impact data, see the "Save Tables" help tab.
</p></body></html>

', null);
INSERT INTO "spt"."InterfaceContent" VALUES ('Issues', '<html><body>
<p>
8-November-2011: 
</p><ul>
<li><div>READI v0.98 initial version released.</div></li>
<li><div>Energy Impacts for a few HP and residential Insulation measures are not showing up; this will be resolved ASAP.</div></li>
<li><div>Extended measure information checkbox for Energy Impacts only enabled for Scaled+DirectIE measure types.   Issue has been resolved and will be available for all measure types in next update.</div></li>
<li><div>11/11/2011 8:52a: residential refrigerator and refrigerator recycling measure definition fixed: Measures were not previously being scaled, returning only the "per deltakWh" impacts.  
This fix to the measure definitions does not require an updated interface program.</div></li>
</ul><p></p>
<p>
12-November-2011: 
</p><ul>
<li><div>READI v0.99 required update released.</div></li>
<li><div>Update of energy impact chart allows for easier review and comparison of measures.</div></li>
<li><div>Therm impacts for Scaled measure definitions (not ScaledDirectIE) were not displayed correctly.  This affected residential dishwasher and refrigerator measures.  Issue is resolved with this release.</div></li>
</ul><p></p>
<p>
14-November-2011: 
</p><ul>
<li><div>READI v0.99.1 update released.</div></li>
<li><div>Prior to this date, not all HP measures were viewable.  This was corrected today so that the residential and commercial HP measures are now showing up in the measure list.  </div></li>
<li><div>Select linear fluorescent measure definitions were fixed to reflect the assumptions as described in the documentation (Nov2011_DEER-v400_MeasureDatabaseUpdate-2011-11-08.pdf). See comment field in the Measure 
Table to identify the specific measures.</div></li>
<li><div>Prior to this version, residential insulation measures were not viewable.  All residential insulation measures now showing up in measure list.  For some measures, impacts need to be scaled to be properly viewed on the chart (i.e. multiplied by 1000).  READI update v0.99.1 allows for display results to be 
scaled.</div></li>
</ul><p></p>
<p>
20-November-2011: 
</p><ul>
<li><div>READI v0.99.2 update released.</div></li>
<li><div>Residential Appliance Recycling measures have been updated with IOU-specific program measures that are "rolled-up" across residential building types based on the previous measures.  Refrigerator and freezer recycling measures are included for each of the applicable IOUs.  Measures for appliances in conditioned and unconditioned spaces, which are the basis for the rolled-up measures, are retained for informational purposes.</div></li>
<li><div>The missing SEER 15 commercial split-system heat pump measure is now viewable.  The SEER 14 commercial split system heat pump measure had an incorrect performance specification that has now been corrected.</div></li>
<li><div>Access to more SPT database tables added to the "Support Tables" section of READI. To properly view these tables, the latest READI version is needed.</div></li> 
<li>READI help screens updated and link fixed (there was a short period where the update link in the READI program itself pointed to an old or non-existent version of the program).</li>
</ul><p></p>
</body></html>
', null);
INSERT INTO "spt"."InterfaceContent" VALUES ('Measures', '<html><body>
<p>
Clicking on the "Measures" tab at the top of the screen will load the list of all DEER and non-DEER measures.  The data are presented in three main sections of the 
screen.  The table at the bottom of the screen has one row for each measure defined in the database, the top part of the screen contains details about the measure currently 
selected in the list while the tree to the left of the tables provides a simple means of sorting through the long list of measures.
</p><p>
<strong><i>Using the Classification Tree</i></strong>
</p><p>
The tree on the left side of the screen is the fastest way to navigate through the list of measures. The tree starts off by displaying  all of the technology <b>Use Categories and Sub-categories</b>.
These two classification fields describe how or where technologies are used.  These two fields are also part of the Measure List.  
</p><ul>
<li><div>When you select any branch on the Use Category tree (with a single mouse click), the measure list will scroll to the first measure that includes the selected classification.</div></li>
<li><div>When you double-click on any branch on the Use Category tree, the measure list will be filtered to only show measures that have the selected Use Category and Sub-category.</div></li>
<li><div>If you double-click on a top-level branch, the filtered measure list will include all Use Sub-categories of the selected Use Category.</div></li>
</ul><p>
When you double-click on a Use Category tree branch, the Use Category tree will be replaced with the <b>Technology Type</b> tree.   This tree will display all technology groups and 
types (or sub-groups) that are associated with the selected Use Category.  The new tree behaves much the same as the Use Category tree: you can click on a branch to scroll the measure list to the 
first measure with the selected technology type and you can double-click on a branch to filter the list to include only measures that include the selected technology types.
</p><ul>
<li><div>To choose a different Use Category, click on the "refresh" button at the top of the tree control.</div></li>
<li><div>From the Use Category tree, double-click the "All Use Categories" branch to sort the measure list based on technolgy type only. </div></li>
</ul><p>
</p><p>
<strong><i>Filter the Measure List</i></strong>
</p><p>
You can also narrow down the list of measures by filtering the Measure List directly.  Left click the mouse on the column titles of the measure list. If there is more than one 
value in the column a control will appear allowing you to choose any number of the values.  Do this to as many columns as needed to narrow the 
down the list of measures.  When filtering the classification columns (Use Category & Subcategory and Technology Group & Type) it is usually best to filter the 
higher-level properties first (i.e. the Use Category and the Technology Group).
</p><p>
<strong><i>Search the Measure List</i></strong>
</p><p>
You can also search for a measure using the control near the bottom of the screen.  First, click on the words to the right of the edit box to select the field that will be searched.  Next, enter any text into the edit box and press ENTER.  All measures with a Measure ID or Measure Description containing the specified text will remain in the measure list.  You can search based on two search strings by placing "and" between the two sets of words.  For example, entering "Res and CFL" into the edit box will return measures that contain both "Res" and "CFL" in the Measure ID or Measure Description.
</p><p>
<strong><i>Measure Energy Impacts</i></strong>
</p><p>
To view the energy impacts associated with a measure, select the measure in the list and double-click on the row.  You will be taken to the Energy Impacts screen where all of the energy impacts associated with the measure are listed.  For information on examining the Energy Impacts, see the <b>Energy Impacts</b> help screen.
</p><p>
</body></html>
', null);
INSERT INTO "spt"."InterfaceContent" VALUES ('Overview', '<html><body>
<p>
<strong>General Program Information</strong>
</p><p>
This remote database interface allows users to examine the Energy Division''s Ex-Ante database of measure information. The data resides on a CPUC server in an Energy Division maintained database.
All of the data presented by this program (including this help screen) are <strong><em>live</em></strong> and come from the central database in real-time. An internet connection, therefore, is required to use the program.
</p><p>
Viewing the data using this program is especially useful for tables that are not flat, but have relationships to other tables. The program will gather data from multiple tables to 
create a more comprehensive view of the data. Even relatively simple tables, such as "Subsectors" or "Technology Types", are more useful when linked to related tables.
</p><p>
With this program you can:
</p><ul>
<li><div>Browse and examine the ex-ante data tables.</div></li>
<li><div>Find existing DEER and non-DEER measure definitions. </div></li>
<li><div>Find and examine the Technologies that are used in the measure definitions.</div></li>
<li><div>Examine the deemed energy impacts associated with measures in tables and graphs.</div></li>
<li><div>Download data tables to your computer as CSV files.</div></li>
</ul><p>
This program requires an internet connection and the ability to use port 22 or port 5432 to connect to a PostgresQL database server.
Users who are authorized to propose additions to select tables must log-in with their credentials by double-clicking on the status bar on the bottom of the program screen.
<br></p>
</body></html>
', null);
INSERT INTO "spt"."InterfaceContent" VALUES ('Technologies', '<html><body>
<p>
<strong>Technologies</strong>
</p><p>
The "Technology Groups & Types" section of the Classification tab shows a table of <b>Technology Groups</b> and a table of <b>Technology Types</b>. The tech Types are a sub-category of tech Groups, as illustrated in the technology tree on the same page.  But the classification of technologies doesn''t actually stop with "Types".  Every technology type includes a definition of how that tech type is characterized.  A set of parameters is associated with each technology type that characterize the important aspects of the technology. 
</p><p>
The "Technologies" tab compiles information for a chosen technology type and displays information for all associated technologies.  Use the tree on the left side of the screen to choose a technology type.  The table at the top left of the technology screen lists all of the parameters used to describe the selected technology type. If a parameter with an associated list of options is highlighted in this table, the options will appear in the "Parameter Value List" table.
</p><p>
All of the defined technologies for the selected technology type are listed in the table at the bottom of the screen.  Each column of this table is a parameter that describes an aspect of the technology; required parameters have a <b>bold</b> column title.  Clicking on the column titles brings up controls that allow the table to be filtered. This becomes an important feature for technology types that have hundreds of associated technologies.
</p><p>
Click on the "Find Measures" button to find all measures that reference the selected list of technologies.  <b>Note</b>: the technology definitions are currently under development and not all measure definitions reference Technology definitions at this time.  Most lighting measures, however, including all of  the linear fluorescent fixture measures, utilize Technology IDs and can therefore be searched via their associated technologies.
</p><p>
(<i>to expand the technology list by hiding the parameter tables, double-click in the area around the technology table</i>)
</p>
</body></html>
', null);

-- ----------------------------
-- Table structure for "spt"."IOU"
-- ----------------------------
DROP TABLE "spt"."IOU";
CREATE TABLE "spt"."IOU" (
"Name" varchar(128) NOT NULL,
"Description" varchar(128) NOT NULL,
"Code" char(3) NOT NULL,
"Index" int2
)
WITH (OIDS=FALSE)

;
COMMENT ON TABLE "spt"."IOU" IS 'The 4 Investor-Owned Utilities';

-- ----------------------------
-- Records of IOU
-- ----------------------------
INSERT INTO "spt"."IOU" VALUES ('All', 'All IOUs', 'All', '0');
INSERT INTO "spt"."IOU" VALUES ('Any', 'Any IOU; for IE processing', 'Any', '6');
INSERT INTO "spt"."IOU" VALUES ('PG&E', 'Pacific Gas & Electric', 'PGE', '1');
INSERT INTO "spt"."IOU" VALUES ('SCE', 'Southern California Edison', 'SCE', '2');
INSERT INTO "spt"."IOU" VALUES ('SCG', 'Southern California Gas', 'SCG', '4');
INSERT INTO "spt"."IOU" VALUES ('SDG&E', 'San Diego Gas & Electric', 'SDG', '3');

-- ----------------------------
-- Table structure for "spt"."MajorVersion"
-- ----------------------------
DROP TABLE "spt"."MajorVersion";
CREATE TABLE "spt"."MajorVersion" (
"Code" varchar(255) NOT NULL,
"Description" varchar(255),
"Comment" varchar(255),
"Index" int2
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of MajorVersion
-- ----------------------------
INSERT INTO "spt"."MajorVersion" VALUES ('2010 Ex-Ante', 'non-DEER source', '2010 IOU workpaper based data', '5');
INSERT INTO "spt"."MajorVersion" VALUES ('2011 Ex-Ante', 'non-DEER source', '2011 IOU workpaper based data', '6');
INSERT INTO "spt"."MajorVersion" VALUES ('DEER 2005', 'official DEER 2005 release', 'includes code versions: 2005 T-24, 2005 Federal and 2005 T-20', '1');
INSERT INTO "spt"."MajorVersion" VALUES ('DEER 2008', 'official DEER 2005 release (v2.05)', 'includes code versions: 2005 T-24, 2005 Federal and 2005 T-20', '2');
INSERT INTO "spt"."MajorVersion" VALUES ('DEER 2009', 'DEER version 3.02, unofficial ', 'includes code versions: 2008 T-24, 2008 Federal and 2008 T-20', '3');
INSERT INTO "spt"."MajorVersion" VALUES ('DEER 2011', 'DEER 2011 updates for 2013-14', 'includes code versions: 2008 T-24, 2008 Federal and 2008 T-20', '4');

-- ----------------------------
-- Table structure for "spt"."ProjectStatus"
-- ----------------------------
DROP TABLE "spt"."ProjectStatus";
CREATE TABLE "spt"."ProjectStatus" (
"Code" varchar(255) NOT NULL,
"Description" varchar(255),
"Comment" varchar(255)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of ProjectStatus
-- ----------------------------

-- ----------------------------
-- Table structure for "spt"."RecordStatus"
-- ----------------------------
DROP TABLE "spt"."RecordStatus";
CREATE TABLE "spt"."RecordStatus" (
"Code" varchar(255) NOT NULL,
"Description" varchar(255)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of RecordStatus
-- ----------------------------
INSERT INTO "spt"."RecordStatus" VALUES ('Exclude', 'record is excluded from most views and not considered to be part of the official table contents');
INSERT INTO "spt"."RecordStatus" VALUES ('PropAccepted', 'record is a proposed addition that has been accepted as part of the official data set');
INSERT INTO "spt"."RecordStatus" VALUES ('PropPending', 'record is a proposed addition or change, not yet part of the official data pending review');
INSERT INTO "spt"."RecordStatus" VALUES ('PropRejected', 'record is a rejected proposed addition');
INSERT INTO "spt"."RecordStatus" VALUES ('Review', 'record is under review and is not yet in the official data');
INSERT INTO "spt"."RecordStatus" VALUES ('Standard', 'record will appear by default and is considered as part of the official contents of the table');

-- ----------------------------
-- Table structure for "spt"."sptviewer"
-- ----------------------------
DROP TABLE "spt"."sptviewer";
CREATE TABLE "spt"."sptviewer" (
"version" varchar(32),
"compindex" int2,
"index" int2 NOT NULL,
"comment" varchar(255),
"updateURL" varchar(255)
)
WITH (OIDS=FALSE)

;
COMMENT ON COLUMN "spt"."sptviewer"."comment" IS 'SPTviewer compatibility table';

-- ----------------------------
-- Records of sptviewer
-- ----------------------------
INSERT INTO "spt"."sptviewer" VALUES ('0.3', '1', '1', 'test only', null);
INSERT INTO "spt"."sptviewer" VALUES ('0.4', '2', '2', 'alpha test version', null);
INSERT INTO "spt"."sptviewer" VALUES ('0.44', '2', '3', 'testing ', null);
INSERT INTO "spt"."sptviewer" VALUES ('0.45', '2', '4', 'testing', null);
INSERT INTO "spt"."sptviewer" VALUES ('0.48', '3', '5', 'new NTGR format', 'http://deeresources.com/DEER2011/download/Latest-READI.zip');

-- ----------------------------
-- Table structure for "spt"."SupportTables"
-- ----------------------------
DROP TABLE "spt"."SupportTables";
CREATE TABLE "spt"."SupportTables" (
"Group" varchar(32) NOT NULL,
"Label" varchar(64) NOT NULL,
"TableName" varchar(64) NOT NULL,
"Schema" varchar(64) NOT NULL,
"Usage" varchar(255),
"SQL" varchar NOT NULL,
"FldWidth" varchar(255),
"FldAlign" varchar(255),
"FldFormat" varchar(255),
"Display" bool NOT NULL,
"AllowProposeNew" bool NOT NULL,
"AllowEditComment" bool NOT NULL,
"Order" int2 NOT NULL
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of SupportTables
-- ----------------------------
INSERT INTO "spt"."SupportTables" VALUES ('cpApplic', 'Building HVAC Type', 'BldgHVAC', 'applic', 'Used in the development and weighting of Energy Impacts', 'Select "Index", "Description", "Code", "Sector", "Comment", "Status" from applic."BldgHVAC" Order by "Index";
', '60,-1,60,120,80', 'C,L,C,C,L,C', 'I,N,C', 't', 'f', 'f', '2');
INSERT INTO "spt"."SupportTables" VALUES ('cpApplic', 'Building Vintage', 'BldgVint', 'applic', 'Used in the specification and development of Energy Impacts', 'Select "Index", "Description",  "Code", "Comment", "Status" from applic."BldgVint" Order by "Index";
', '60,140,60,-1,60', 'C,L,C,L,C', 'I,N,C', 't', 'f', 'f', '1');
INSERT INTO "spt"."SupportTables" VALUES ('cpApplic', 'IOU Names', 'IOU', 'spt', 'Used in tracking submittal, measure definitions and other tables to specify the associated IOU', 'Select "Index", "Code", "Description" from spt."IOU" Order by "Index";', '60,80,-1', 'C,C,L', 'I,C,N', 't', 'f', 'f', '3');
INSERT INTO "spt"."SupportTables" VALUES ('cpApplic', 'Location', 'Location', 'applic', 'Used in the tracking submittal and in the specification of Energy Impacts', 'Select "Index", "Description", "Code",  "Comment", "Status" from applic."Location" Order by "Index";
', '60,160,60,-1,60', 'C,L,C,L,L', 'I,N,C,N,N', 't', 'f', 'f', '0');
INSERT INTO "spt"."SupportTables" VALUES ('cpCostEff', 'EUL and RUL', 'EUL', 'costeff', 'The EUL/RUL Table', 'Select "Index", "EUL_ID", "Description", "EUL_Yrs", "RUL_Yrs", "Sector", "BldgType", "BldgLoc", "BasisType", "BasisValue", "BasisDegFactor", "defEFLH", "EUL_Max_Yrs",
           "Version", "VersionSrc" as "Version Source", "UseCategory","UseSubCat", "TechGroup", "TechType",  "Comment", "Status" from costeff."EUL" Order by "Index";
', '60,160,220', 'I,L,L,C,C,C,C,C,C,C,C,L,C,L,L,L,L,L,L', 'I,C,N', 't', 'f', 't', '1');
INSERT INTO "spt"."SupportTables" VALUES ('cpCostEff', 'GSIA', 'GSIA', 'costeff', 'Associated with a Measure through the Implemenation table, specifies how impacts and installations are adjusted.', 'Select "Index","GSIA_ID","Description","Version","VersionSrc","IOU","BldgType","BldgVint","IOUSubProg","ImplementerID","Sector",
           "UseCategory","UseSubCat","TechGroup","TechType","TechID","ProgDelivID","GSIAType","GSIAValue","DelInstSchID","Comment" from costeff."GSIA" Order by "Index";
', '60,180,160, 90', 'C,C', 'I,C,N', 'f', 'f', 'f', '2');
INSERT INTO "spt"."SupportTables" VALUES ('cpCostEff', 'NTG Ratio', 'NTGR', 'costeff', 'The Net-to-Gross Ratio Table', 'Select "Index", "NTG_ID", "NTGR_kWh" as "NTG(kWh)", "NTGR_kW" as "NTG(kW)", "NTGR_therm" as "NTG(therm)", "NTGR_cost" as "NTG(cost)", "Description", "BldgType", "BldgVint",
           "NTGqual" as "NTG Qualifier", "ProgDelivID" as "Implementation Delivery", "IOUProgram", "IOUSubProg",
           "Version", "VersionSrc" as "Version Source", "Sector", "UseCategory","UseSubCat", "TechGroup", "TechType",  "Comment", "Status" from costeff."NTGR" Order by "Index";
', null, null, null, 'f', 'f', 'f', '0');
INSERT INTO "spt"."SupportTables" VALUES ('cpImpacts', 'IE: Com-InLtg-CFL', 'Com-InLtg-CFL', 'ie', 'HVAC interactive effects table for Commercial Indoor Lighting: CFLs', 'SELECT "VersionSrc","IOU","BldgVint", "BldgType","BldgLoc", "BldgHVAC", "kWh/kWh", "kW/kW", "therm/kWh" FROM "ie"."Com-InLtg-CFL" ORDER BY "IOU","BldgVint", "BldgType","BldgLoc", "BldgHVAC";', '90,90,90,90,90,90,90,90,90', 'C,C,C,C,C,C,R,R,R', null, 't', 'f', 'f', '1');
INSERT INTO "spt"."SupportTables" VALUES ('cpImpacts', 'IE: Com-InLtg-Exit', 'Com-InLtg-Exit', 'ie', 'HVAC interactive effects table for Commercial Indoor Lighting: Exit Fixtures', 'SELECT "VersionSrc","IOU","BldgVint", "BldgType","BldgLoc", "BldgHVAC", "kWh/kWh", "kW/kW", "therm/kWh" FROM "ie"."Com-InLtg-Exit" ORDER BY "IOU","BldgVint", "BldgType","BldgLoc", "BldgHVAC";', '90,90,90,90,90,90,90,90,90', 'C,C,C,C,C,C,R,R,R', null, 't', 'f', 'f', '3');
INSERT INTO "spt"."SupportTables" VALUES ('cpImpacts', 'IE: Com-InLtg-LF', 'Com-InLtg-LF', 'ie', 'HVAC interactive effects table for Commercial Indoor Lighting: Linear Fluorescent Fixtures', 'SELECT "VersionSrc","IOU","BldgVint", "BldgType","BldgLoc", "BldgHVAC", "kWh/kWh", "kW/kW", "therm/kWh" FROM "ie"."Com-InLtg-LF" ORDER BY "IOU","BldgVint", "BldgType","BldgLoc", "BldgHVAC";', '90,90,90,90,90,90,90,90,90', 'C,C,C,C,C,C,R,R,R', null, 't', 'f', 'f', '2');
INSERT INTO "spt"."SupportTables" VALUES ('cpImpacts', 'Normalizing Units', 'NormUnits', 'tech', 'Associated with a technology type, used to normalize Energy Impacts and Technology costs.', 'Select "Index", "Code","Description", "Comment", "Status" from tech."NormUnit" Order by "Index";
', '60,90,190,-1,60', null, 'I,C,N', 't', 'f', 'f', '0');
INSERT INTO "spt"."SupportTables" VALUES ('cpImplement', 'Measure Application Type', 'MeasAppType', 'implement', 'Associated with Implementions, identifies the type of measure application.  Assigned measure application type must be supported by the measure definition (see "Supported Applications")', 'Select "Index", "Code", "Description", "Comment" from implement."MeasAppType" Order by "Index";', '60,80,150,-1', 'C,C,L,L', 'I,C,N', 't', 'f', 'f', '0');
INSERT INTO "spt"."SupportTables" VALUES ('cpMeasCost', 'Cost Adjust Types', 'CostAdjustType', 'costeff', 'Describes the various types of cost adjustment categories; can be specified in the Measure Cost records to attach cost adjustments by location.', 'Select "Index",  "Code", "Description", "Comment"  FROM costeff."CostAdjustType" Order by "Index";
', '60,100,240,140', 'C,C,L,L', 'I,C,N', 't', 'f', 'f', '3');
INSERT INTO "spt"."SupportTables" VALUES ('cpMeasCost', 'Cost Adjustments', 'CostAdjust', 'costeff', 'Used to adjust labor and material costs by location (Climate Zone) for various types of labor categories.  Look up is based on "AdjustType" + "Location"', 'Select * FROM costeff."CostAdjust" Order by "Index";', '60,110,110,90,90,90', 'C,L,L,C,C,R,R', 'I,N', 't', 'f', 'f', '2');
INSERT INTO "spt"."SupportTables" VALUES ('cpMeasCost', 'Labor Rates', 'LaborRate', 'costeff', 'Supports measure cost definitions that reference labor rates', 'Select "Code", "Sector", "BaseLaborRate","Application","Comment" from costeff."LaborRates" Order By "Index"', '160,80,60,240,-1', 'C,C,C,L,L', 'C,N', 't', 'f', 'f', '1');
INSERT INTO "spt"."SupportTables" VALUES ('cpMeasCost', 'Measure Costs', 'MeasureCost', 'costeff', 'material and installation costs associated with a measure definition', 'Select "Index", "MeasCostID", "Description", "NormUnit", "Version", "VersionSrc", "IOU", "BldgType", "BldgVint", "BldgLoc", "CostQualifier", "CostType", "GenCost", "LaborCost", "MatlCost", "InstallHrs", "LaborRate", "LocCostAdj", "Status", "Comment"  from costeff."MeasureCost" Order By "Index";', '60,160,220,90,120,120', 'C,L,L,C,L,L,', 'I,C,N', 't', 'f', 'f', '0');
INSERT INTO "spt"."SupportTables" VALUES ('cpMeasure', 'Measure Impact Type', 'MeasImpactType', 'meas', 'Identifies the type of measure.
', 'Select "Index", "Code", "Description", "Comment" from meas."MeasImpactType" Order by "Index";', '60,80,-1,90', 'C,C,L,L', 'I,C,N', 't', 'f', 'f', '0');
INSERT INTO "spt"."SupportTables" VALUES ('cpMeasure', 'Supported Applications', 'SupportedAppType', 'meas', 'Identifies the type of measure applications supported by the measure definition.', 'Select "Index", "Code", "Description", CAST("Comment" AS VARCHAR(255)) from meas."SupportedAppType" Order by "Index";', '60,90,-1,80', 'C,C,L,L', 'I,C,N', 't', 'f', 'f', '1');
INSERT INTO "spt"."SupportTables" VALUES ('cpOther', 'Version Source', 'VersionSrc', 'spt', 'Identifies the source for measure definitions, energy impacts, etc.', 'Select "Index", "Code", "Description", "Comment" from spt."VersionSrc" Order by "Index";', '60,100,270,-1', 'C,C,L,L', 'I,C,N', 't', 'f', 'f', '0');

-- ----------------------------
-- Table structure for "spt"."VersionSrc"
-- ----------------------------
DROP TABLE "spt"."VersionSrc";
CREATE TABLE "spt"."VersionSrc" (
"Code" varchar(255) NOT NULL,
"Description" varchar(255),
"Comment" varchar(255),
"Index" int2
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of VersionSrc
-- ----------------------------
INSERT INTO "spt"."VersionSrc" VALUES ('D05 v2.01', 'DEER 2005 official release', null, '1');
INSERT INTO "spt"."VersionSrc" VALUES ('D08 v2.05', 'DEER 2008 public version', 'includes code versions: 2005 T-24, 2005 Federal and 2005 T-20', '2');
INSERT INTO "spt"."VersionSrc" VALUES ('D08 v3.02', 'DEER 2008 update, not officially released', 'includes HVAC System weighting, basis for IE Tables', '3');
INSERT INTO "spt"."VersionSrc" VALUES ('D11 v4.00', 'DEER 201 update for 2013-14 planning', null, '4');
INSERT INTO "spt"."VersionSrc" VALUES ('IOU workpaper', 'ED approved IOU workpaper', null, '5');
INSERT INTO "spt"."VersionSrc" VALUES ('MV0405', 'Results of M&V for 2004-2005 program cycle', null, '6');
INSERT INTO "spt"."VersionSrc" VALUES ('MV0608', 'Results of M&V for 2006-2008 program cycle', null, '7');

-- ----------------------------
-- Alter Sequences Owned By 
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table "spt"."InterfaceContent"
-- ----------------------------
ALTER TABLE "spt"."InterfaceContent" ADD PRIMARY KEY ("Name");

-- ----------------------------
-- Indexes structure for table IOU
-- ----------------------------
CREATE INDEX "name" ON "spt"."IOU" USING btree ("Name");

-- ----------------------------
-- Primary Key structure for table "spt"."IOU"
-- ----------------------------
ALTER TABLE "spt"."IOU" ADD PRIMARY KEY ("Name");

-- ----------------------------
-- Primary Key structure for table "spt"."ProjectStatus"
-- ----------------------------
ALTER TABLE "spt"."ProjectStatus" ADD PRIMARY KEY ("Code");
